/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.paramgrid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ParameterSetGenerator {
    private int sizeOfParamVector = 100;
    private List<Double[]> params = new ArrayList<Double[]>();
    private Map<Integer, Double[]> map;

    public ParameterSetGenerator(Map<Integer, Double[]> map) {
        assert (map != null);
        assert (!map.isEmpty());
        this.map = map;
        this.sizeOfParamVector = map.size();
    }

    public List<Double[]> generate() {
        Double[] nextPnt = new Double[this.sizeOfParamVector];
        this.traverseTree(this.map, nextPnt, -1);
        return Collections.unmodifiableList(this.params);
    }

    private void traverseTree(Map<Integer, Double[]> map, Double[] nextPnt, int dimensionNum) {
        Double[] valuesOfCurrDimension;
        if (++dimensionNum == this.sizeOfParamVector) {
            Double[] paramSet = Arrays.copyOf(nextPnt, this.sizeOfParamVector);
            this.params.add(paramSet);
            return;
        }
        Double[] doubleArray = valuesOfCurrDimension = map.get(dimensionNum);
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            Double specificValue;
            nextPnt[dimensionNum] = specificValue = doubleArray[i];
            this.traverseTree(map, nextPnt, dimensionNum);
        }
    }
}

