/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.regressions.linear;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import org.apache.ignite.ml.dataset.DatasetBuilder;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.impl.DenseVector;
import org.apache.ignite.ml.nn.Activators;
import org.apache.ignite.ml.nn.MLPTrainer;
import org.apache.ignite.ml.nn.MultilayerPerceptron;
import org.apache.ignite.ml.nn.UpdatesStrategy;
import org.apache.ignite.ml.nn.architecture.MLPArchitecture;
import org.apache.ignite.ml.optimization.LossFunctions;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.preprocessing.developer.PatchedPreprocessor;
import org.apache.ignite.ml.regressions.linear.LinearRegressionModel;
import org.apache.ignite.ml.structures.LabeledVector;
import org.apache.ignite.ml.trainers.SingleLabelDatasetTrainer;
import org.jetbrains.annotations.NotNull;

public class LinearRegressionSGDTrainer<P extends Serializable>
extends SingleLabelDatasetTrainer<LinearRegressionModel> {
    private final UpdatesStrategy<? super MultilayerPerceptron, P> updatesStgy;
    private int maxIterations = 1000;
    private int batchSize = 10;
    private int locIterations = 100;
    private long seed = 1234L;

    public LinearRegressionSGDTrainer(UpdatesStrategy<? super MultilayerPerceptron, P> updatesStgy, int maxIterations, int batchSize, int locIterations, long seed) {
        this.updatesStgy = updatesStgy;
        this.maxIterations = maxIterations;
        this.batchSize = batchSize;
        this.locIterations = locIterations;
        this.seed = seed;
    }

    public LinearRegressionSGDTrainer(UpdatesStrategy<? super MultilayerPerceptron, P> updatesStgy) {
        this.updatesStgy = updatesStgy;
    }

    @Override
    public <K, V> LinearRegressionModel fitWithInitializedDeployingContext(DatasetBuilder<K, V> datasetBuilder, Preprocessor<K, V> extractor) {
        return this.updateModel((LinearRegressionModel)null, datasetBuilder, extractor);
    }

    @Override
    protected <K, V> LinearRegressionModel updateModel(LinearRegressionModel mdl, DatasetBuilder<K, V> datasetBuilder, Preprocessor<K, V> extractor) {
        assert (this.updatesStgy != null);
        IgniteFunction archSupplier = dataset -> {
            int cols = (Integer)dataset.compute(data -> {
                if (data.getFeatures() == null) {
                    return null;
                }
                return data.getFeatures().length / data.getRows();
            }, (a, b) -> {
                if (a == null) {
                    return b == null ? 0 : b;
                }
                if (b == null) {
                    return a;
                }
                return b;
            });
            MLPArchitecture architecture = new MLPArchitecture(cols);
            architecture = architecture.withAddedLayer(1, true, Activators.LINEAR);
            return architecture;
        };
        MLPTrainer trainer = new MLPTrainer(archSupplier, LossFunctions.MSE, this.updatesStgy, this.maxIterations, this.batchSize, this.locIterations, this.seed);
        IgniteFunction func = lv -> new LabeledVector<double[]>((Vector)lv.features(), new double[]{(Double)lv.label()});
        PatchedPreprocessor patchedPreprocessor = new PatchedPreprocessor(func, extractor);
        MultilayerPerceptron mlp = Optional.ofNullable(mdl).map(this::restoreMLPState).map(m -> trainer.update(m, datasetBuilder, patchedPreprocessor)).orElseGet(() -> (MultilayerPerceptron)trainer.fit(datasetBuilder, patchedPreprocessor));
        double[] p = mlp.parameters().getStorage().data();
        return new LinearRegressionModel(new DenseVector(Arrays.copyOf(p, p.length - 1)), p[p.length - 1]);
    }

    @NotNull
    private MultilayerPerceptron restoreMLPState(LinearRegressionModel mdl) {
        Vector weights = mdl.weights();
        double intercept = mdl.intercept();
        MLPArchitecture architecture1 = new MLPArchitecture(weights.size());
        MLPArchitecture architecture = architecture1 = architecture1.withAddedLayer(1, true, Activators.LINEAR);
        MultilayerPerceptron perceptron = new MultilayerPerceptron(architecture);
        Vector mlpState = weights.like(weights.size() + 1);
        weights.nonZeroes().forEach(ith -> mlpState.set(ith.index(), ith.get()));
        mlpState.set(mlpState.size() - 1, intercept);
        perceptron.setParameters(mlpState);
        return perceptron;
    }

    @Override
    public boolean isUpdateable(LinearRegressionModel mdl) {
        return true;
    }

    public LinearRegressionSGDTrainer<P> withMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
        return this;
    }

    public LinearRegressionSGDTrainer<P> withBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public LinearRegressionSGDTrainer<P> withLocIterations(int amountOfLocIterations) {
        this.locIterations = amountOfLocIterations;
        return this;
    }

    public LinearRegressionSGDTrainer<P> withSeed(long seed) {
        this.seed = seed;
        return this;
    }

    public UpdatesStrategy<? super MultilayerPerceptron, P> getUpdatesStgy() {
        return this.updatesStgy;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getLocIterations() {
        return this.locIterations;
    }

    public long getSeed() {
        return this.seed;
    }
}

