/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.recommendation;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.recommendation.ObjectSubjectPair;

public class RecommendationModel<O extends Serializable, S extends Serializable>
implements IgniteModel<ObjectSubjectPair<O, S>, Double> {
    private static final long serialVersionUID = -3664382168079054785L;
    private final Map<O, Vector> objMatrix;
    private final Map<S, Vector> subjMatrix;

    public RecommendationModel(Map<O, Vector> objMatrix, Map<S, Vector> subjMatrix) {
        this.objMatrix = Collections.unmodifiableMap(objMatrix);
        this.subjMatrix = Collections.unmodifiableMap(subjMatrix);
    }

    @Override
    public Double predict(ObjectSubjectPair<O, S> input) {
        Vector objVector = this.objMatrix.get(input.getObj());
        Vector subjVector = this.subjMatrix.get(input.getSubj());
        return objVector.dot(subjVector);
    }

    public Map<O, Vector> getObjMatrix() {
        return this.objMatrix;
    }

    public Map<S, Vector> getSubjMatrix() {
        return this.subjMatrix;
    }
}

