/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.pipeline;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.dataset.DatasetBuilder;
import org.apache.ignite.ml.dataset.feature.extractor.Vectorizer;
import org.apache.ignite.ml.dataset.impl.cache.CacheBasedDatasetBuilder;
import org.apache.ignite.ml.dataset.impl.local.LocalDatasetBuilder;
import org.apache.ignite.ml.environment.LearningEnvironment;
import org.apache.ignite.ml.environment.LearningEnvironmentBuilder;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.pipeline.PipelineMdl;
import org.apache.ignite.ml.preprocessing.PreprocessingTrainer;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.trainers.DatasetTrainer;

public class Pipeline<K, V, C extends Serializable, L>
implements Serializable {
    private Preprocessor<K, V> finalPreprocessor;
    private Vectorizer<K, V, C, L> vectorizer;
    private List<PreprocessingTrainer> preprocessingTrainers = new ArrayList<PreprocessingTrainer>();
    private DatasetTrainer finalStage;
    private LearningEnvironmentBuilder envBuilder = LearningEnvironmentBuilder.defaultBuilder();

    public Pipeline<K, V, C, L> addVectorizer(Vectorizer<K, V, C, L> vectorizer) {
        this.vectorizer = vectorizer;
        return this;
    }

    public Pipeline<K, V, C, L> addPreprocessingTrainer(PreprocessingTrainer preprocessingTrainer) {
        this.preprocessingTrainers.add(preprocessingTrainer);
        return this;
    }

    public Pipeline<K, V, C, L> addTrainer(DatasetTrainer trainer) {
        this.finalStage = trainer;
        return this;
    }

    public DatasetTrainer getTrainer() {
        return this.finalStage;
    }

    public PipelineMdl<K, V> fit(Ignite ignite, IgniteCache<K, V> cache) {
        CacheBasedDatasetBuilder<K, V> datasetBuilder = new CacheBasedDatasetBuilder<K, V>(ignite, cache);
        return this.fit(datasetBuilder);
    }

    public void setEnvironmentBuilder(LearningEnvironmentBuilder envBuilder) {
        this.envBuilder = envBuilder;
    }

    public PipelineMdl<K, V> fit(Map<K, V> data, int parts) {
        LocalDatasetBuilder<K, V> datasetBuilder = new LocalDatasetBuilder<K, V>(data, parts);
        return this.fit(datasetBuilder);
    }

    public PipelineMdl<K, V> fit(DatasetBuilder datasetBuilder) {
        if (this.finalStage == null) {
            throw new IllegalStateException("The Pipeline should be finished with the Training Stage.");
        }
        this.finalPreprocessor = this.vectorizer;
        this.preprocessingTrainers.forEach(e -> {
            this.finalPreprocessor = e.fit(this.envBuilder, datasetBuilder, this.finalPreprocessor);
        });
        LearningEnvironment env = LearningEnvironmentBuilder.defaultBuilder().buildForTrainer();
        env.initDeployingContext(this.finalPreprocessor);
        Object internalMdl = this.finalStage.fit(datasetBuilder, this.finalPreprocessor, env);
        return new PipelineMdl<K, V>().withPreprocessor(this.finalPreprocessor).withInternalMdl((IgniteModel<Vector, Double>)internalMdl);
    }

    public Preprocessor<K, V> getFinalPreprocessor() {
        return this.finalPreprocessor;
    }
}

