/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.distances;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.ignite.ml.math.distances.DistanceMeasure;
import org.apache.ignite.ml.math.exceptions.math.CardinalityException;
import org.apache.ignite.ml.math.functions.Functions;
import org.apache.ignite.ml.math.functions.IgniteDoubleFunction;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.util.MatrixUtil;

public class MinkowskiDistance
implements DistanceMeasure {
    private static final long serialVersionUID = 1717556319784040040L;
    private final double p;

    @JsonCreator
    public MinkowskiDistance(@JsonProperty(value="p") double p) {
        this.p = p;
    }

    public double getP() {
        return this.p;
    }

    @Override
    public double compute(Vector a, Vector b) throws CardinalityException {
        assert (a.size() == b.size());
        IgniteDoubleFunction fun = value -> Math.pow(Math.abs(value), this.p);
        Double result = MatrixUtil.localCopyOf(a).minus(b).foldMap(Functions.PLUS, fun, 0.0);
        return Math.pow(result, 1.0 / this.p);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinkowskiDistance that = (MinkowskiDistance)o;
        return Double.compare(that.p, this.p) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.p);
    }

    public String toString() {
        return "MinkowskiDistance{p=" + this.p + '}';
    }
}

