/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.knn.utils;

import java.io.Serializable;
import org.apache.ignite.ml.dataset.Dataset;
import org.apache.ignite.ml.dataset.DatasetBuilder;
import org.apache.ignite.ml.dataset.primitive.context.EmptyContext;
import org.apache.ignite.ml.environment.LearningEnvironment;
import org.apache.ignite.ml.environment.LearningEnvironmentBuilder;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.structures.LabeledVector;
import org.apache.ignite.ml.structures.LabeledVectorSet;
import org.apache.ignite.ml.structures.partition.LabeledDatasetPartitionDataBuilderOnHeap;
import org.jetbrains.annotations.Nullable;

public class KNNUtils {
    @Nullable
    public static <K, V, C extends Serializable> Dataset<EmptyContext, LabeledVectorSet<LabeledVector>> buildDataset(LearningEnvironmentBuilder envBuilder, DatasetBuilder<K, V> datasetBuilder, Preprocessor<K, V> vectorizer) {
        LearningEnvironment environment = envBuilder.buildForTrainer();
        environment.initDeployingContext(vectorizer);
        LabeledDatasetPartitionDataBuilderOnHeap partDataBuilder = new LabeledDatasetPartitionDataBuilderOnHeap(vectorizer);
        Dataset dataset = null;
        if (datasetBuilder != null) {
            dataset = datasetBuilder.build(envBuilder, (env, upstream, upstreamSize) -> new EmptyContext(), partDataBuilder, environment);
        }
        return dataset;
    }
}

