/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.inference;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.ignite.Ignite;
import org.apache.ignite.ml.IgniteModel;
import org.apache.ignite.ml.inference.Model;
import org.apache.ignite.ml.inference.ModelDescriptor;
import org.apache.ignite.ml.inference.ModelSignature;
import org.apache.ignite.ml.inference.builder.AsyncModelBuilder;
import org.apache.ignite.ml.inference.builder.SingleModelBuilder;
import org.apache.ignite.ml.inference.builder.SyncModelBuilder;
import org.apache.ignite.ml.inference.parser.IgniteModelParser;
import org.apache.ignite.ml.inference.reader.ModelStorageModelReader;
import org.apache.ignite.ml.inference.storage.descriptor.ModelDescriptorStorage;
import org.apache.ignite.ml.inference.storage.descriptor.ModelDescriptorStorageFactory;
import org.apache.ignite.ml.inference.storage.model.ModelStorage;
import org.apache.ignite.ml.inference.storage.model.ModelStorageFactory;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.util.Utils;
import org.jetbrains.annotations.NotNull;

public final class IgniteModelStorageUtil {
    private static final String IGNITE_MDL_FOLDER = "/ignite_models";

    private IgniteModelStorageUtil() {
    }

    public static <I extends Serializable, O extends Serializable> void saveModel(Ignite ignite, IgniteModel<I, O> mdl, String name) {
        IgniteModel<byte[], byte[]> mdlWrapper = IgniteModelStorageUtil.wrapIgniteModel(mdl);
        byte[] serializedMdl = Utils.serialize(mdlWrapper);
        UUID mdlId = UUID.randomUUID();
        IgniteModelStorageUtil.saveModelDescriptor(ignite, name, mdlId);
        try {
            IgniteModelStorageUtil.saveModelEntity(ignite, serializedMdl, mdlId);
        }
        catch (Exception e) {
            IgniteModelStorageUtil.removeModelEntity(ignite, mdlId);
            throw e;
        }
    }

    public static void removeModel(Ignite ignite, String name) {
        ModelDescriptor desc = IgniteModelStorageUtil.getModelDescriptor(ignite, name);
        if (desc == null) {
            return;
        }
        UUID mdlId = UUID.fromString(desc.getName());
        IgniteModelStorageUtil.removeModel(ignite, "/ignite_models/" + mdlId);
        IgniteModelStorageUtil.removeModelDescriptor(ignite, name);
    }

    public static <I extends Serializable, O extends Serializable> Model<I, O> getModel(Ignite ignite, String name) {
        return IgniteModelStorageUtil.getSyncModel(ignite, name, new SingleModelBuilder());
    }

    public static <I extends Serializable, O extends Serializable> Model<I, O> getSyncModel(Ignite ignite, String name, SyncModelBuilder mdlBldr) {
        ModelDescriptor desc = Objects.requireNonNull(IgniteModelStorageUtil.getModelDescriptor(ignite, name), "Model not found [name=" + name + "]");
        Object infMdl = mdlBldr.build(desc.getReader(), desc.getParser());
        return IgniteModelStorageUtil.unwrapIgniteSyncModel(infMdl);
    }

    public static Model<Vector, Future<Double>> getAsyncModel(Ignite ignite, String name, AsyncModelBuilder mdlBldr) {
        ModelDescriptor desc = Objects.requireNonNull(IgniteModelStorageUtil.getModelDescriptor(ignite, name), "Model not found [name=" + name + "]");
        Model<byte[], Future<byte[]>> infMdl = mdlBldr.build(desc.getReader(), desc.getParser());
        return IgniteModelStorageUtil.unwrapIgniteAsyncModel(infMdl);
    }

    private static void saveModelEntity(Ignite ignite, byte[] serializedMdl, UUID mdlId) {
        ModelStorage storage = new ModelStorageFactory().getModelStorage(ignite);
        storage.mkdirs(IGNITE_MDL_FOLDER);
        storage.putFile("/ignite_models/" + mdlId, serializedMdl, true);
    }

    private static void removeModelEntity(Ignite ignite, UUID mdlId) {
        ModelStorage storage = new ModelStorageFactory().getModelStorage(ignite);
        storage.remove("/ignite_models/" + mdlId);
    }

    private static void saveModelDescriptor(Ignite ignite, String name, UUID mdlId) {
        ModelDescriptorStorage descStorage = new ModelDescriptorStorageFactory().getModelDescriptorStorage(ignite);
        boolean saved = descStorage.putIfAbsent(name, new ModelDescriptor(mdlId.toString(), null, new ModelSignature(null, null, null), new ModelStorageModelReader("/ignite_models/" + mdlId), new IgniteModelParser<byte[], byte[]>()));
        if (!saved) {
            throw new IllegalArgumentException("Model descriptor with given name already exists [name=" + name + "]");
        }
    }

    private static void removeModelDescriptor(Ignite ignite, String name) {
        ModelDescriptorStorage descStorage = new ModelDescriptorStorageFactory().getModelDescriptorStorage(ignite);
        descStorage.remove(name);
    }

    private static ModelDescriptor getModelDescriptor(Ignite ignite, String name) {
        ModelDescriptorStorage descStorage = new ModelDescriptorStorageFactory().getModelDescriptorStorage(ignite);
        return descStorage.get(name);
    }

    private static <I extends Serializable, O extends Serializable> IgniteModel<byte[], byte[]> wrapIgniteModel(IgniteModel<I, O> mdl) {
        return input -> {
            Object deserializedInput = Utils.deserialize(input);
            Serializable output = (Serializable)mdl.predict(deserializedInput);
            return Utils.serialize(output);
        };
    }

    private static <I extends Serializable, O extends Serializable> Model<I, O> unwrapIgniteSyncModel(final Model<byte[], byte[]> mdl) {
        return new Model<I, O>(){

            @Override
            public O predict(I input) {
                byte[] serializedInput = Utils.serialize(input);
                byte[] serializedOutput = (byte[])mdl.predict(serializedInput);
                return Utils.deserialize(serializedOutput);
            }

            @Override
            public void close() {
                mdl.close();
            }
        };
    }

    private static Model<Vector, Future<Double>> unwrapIgniteAsyncModel(final Model<byte[], Future<byte[]>> mdl) {
        return new Model<Vector, Future<Double>>(){

            @Override
            public Future<Double> predict(Vector input) {
                byte[] serializedInput = Utils.serialize(input);
                Future serializedOutput = (Future)mdl.predict(serializedInput);
                return new FutureDeserializationWrapper<Double>(serializedOutput);
            }

            @Override
            public void close() {
                mdl.close();
            }
        };
    }

    private static class FutureDeserializationWrapper<T>
    implements Future<T> {
        private final Future<byte[]> delegate;

        public FutureDeserializationWrapper(Future<byte[]> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.delegate.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return Utils.deserialize(this.delegate.get());
        }

        @Override
        public T get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return Utils.deserialize(this.delegate.get(timeout, unit));
        }
    }
}

