/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.environment.parallelism;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.ignite.ml.environment.parallelism.ParallelismStrategy;
import org.apache.ignite.ml.environment.parallelism.Promise;
import org.apache.ignite.ml.math.functions.IgniteSupplier;
import org.jetbrains.annotations.NotNull;

public class NoParallelismStrategy
implements ParallelismStrategy {
    public static final ParallelismStrategy INSTANCE = new NoParallelismStrategy();

    private NoParallelismStrategy() {
    }

    @Override
    public int getParallelism() {
        return 1;
    }

    @Override
    public <T> Promise<T> submit(IgniteSupplier<T> task) {
        return new Stub(task.get());
    }

    public static class Stub<T>
    implements Promise<T> {
        private T res;

        public Stub(T res) {
            this.res = res;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.res;
        }

        @Override
        public T get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.res;
        }
    }
}

