/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.environment.deploy;

import java.io.Serializable;
import java.util.List;
import org.apache.ignite.ml.environment.deploy.DeployableObject;
import org.apache.ignite.ml.environment.deploy.DeployingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployingContextImpl
implements DeployingContext,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(DeployingContextImpl.class);
    private transient Class<?> preprocessorCls;
    private transient ClassLoader clientClsLdr;

    @Override
    public Class<?> userClass() {
        return this.preprocessorCls == null ? this.getClass() : this.preprocessorCls;
    }

    @Override
    public ClassLoader clientClassLoader() {
        return this.clientClsLdr == null ? this.getClass().getClassLoader() : this.clientClsLdr;
    }

    @Override
    public void initByClientObject(Object jobObj) {
        List<Object> deps;
        if (jobObj == null) {
            logger.warn("Attempt to initialize deploy context by null");
            return;
        }
        if (this.preprocessorCls != null) {
            logger.warn("Reinitialize deploying context [class=" + jobObj.getClass().getName() + "]");
        }
        Object objectToDeploy = jobObj;
        while (objectToDeploy instanceof DeployableObject && !(deps = ((DeployableObject)objectToDeploy).getDependencies()).isEmpty()) {
            objectToDeploy = deps.get(0);
        }
        assert (objectToDeploy != null);
        this.preprocessorCls = objectToDeploy.getClass();
        this.clientClsLdr = this.preprocessorCls.getClassLoader();
    }

    @Override
    public void init(DeployingContext other) {
        this.clientClsLdr = other.clientClassLoader();
        this.preprocessorCls = other.userClass();
    }
}

