/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.environment;

import java.io.Serializable;
import java.util.Random;
import org.apache.ignite.ml.environment.DefaultLearningEnvironmentBuilder;
import org.apache.ignite.ml.environment.LearningEnvironment;
import org.apache.ignite.ml.environment.logging.MLLogger;
import org.apache.ignite.ml.environment.parallelism.ParallelismStrategy;
import org.apache.ignite.ml.math.functions.IgniteFunction;

public interface LearningEnvironmentBuilder
extends Serializable {
    public LearningEnvironment buildForWorker(int var1);

    default public LearningEnvironment buildForTrainer() {
        return this.buildForWorker(-1);
    }

    public LearningEnvironmentBuilder withParallelismStrategyTypeDependency(IgniteFunction<Integer, ParallelismStrategy.Type> var1);

    default public LearningEnvironmentBuilder withParallelismStrategyType(ParallelismStrategy.Type stgyType) {
        return this.withParallelismStrategyTypeDependency(IgniteFunction.constant(stgyType));
    }

    public LearningEnvironmentBuilder withParallelismStrategyDependency(IgniteFunction<Integer, ParallelismStrategy> var1);

    default public <T extends ParallelismStrategy & Serializable> LearningEnvironmentBuilder withParallelismStrategy(T stgy) {
        return this.withParallelismStrategyDependency(IgniteFunction.constant(stgy));
    }

    public LearningEnvironmentBuilder withLoggingFactoryDependency(IgniteFunction<Integer, MLLogger.Factory> var1);

    default public <T extends MLLogger.Factory & Serializable> LearningEnvironmentBuilder withLoggingFactory(T loggingFactory) {
        return this.withLoggingFactoryDependency(IgniteFunction.constant(loggingFactory));
    }

    public LearningEnvironmentBuilder withRNGSeedDependency(IgniteFunction<Integer, Long> var1);

    default public LearningEnvironmentBuilder withRNGSeed(long seed) {
        return this.withRNGSeedDependency(IgniteFunction.constant(seed));
    }

    public LearningEnvironmentBuilder withRandomDependency(IgniteFunction<Integer, Random> var1);

    default public LearningEnvironmentBuilder withRandom(Random random) {
        return this.withRandomDependency(IgniteFunction.constant(random));
    }

    public LearningEnvironmentBuilder withDataTtl(long var1);

    public static LearningEnvironmentBuilder defaultBuilder() {
        return new DefaultLearningEnvironmentBuilder();
    }
}

