/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset.primitive.builder.data;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.dataset.primitive.data.SimpleLabeledDatasetData;
import org.apache.ignite.ml.environment.LearningEnvironment;
import org.apache.ignite.ml.preprocessing.Preprocessor;
import org.apache.ignite.ml.structures.LabeledVector;

public class SimpleLabeledDatasetDataBuilder<K, V, C extends Serializable>
implements PartitionDataBuilder<K, V, C, SimpleLabeledDatasetData> {
    private static final long serialVersionUID = 3678784980215216039L;
    private final Preprocessor<K, V> vectorizer;

    public SimpleLabeledDatasetDataBuilder(Preprocessor<K, V> vectorizer) {
        this.vectorizer = vectorizer;
    }

    @Override
    public SimpleLabeledDatasetData build(LearningEnvironment env, Iterator<UpstreamEntry<K, V>> upstreamData, long upstreamDataSize, C ctx) {
        int featureCols = -1;
        int lbCols = -1;
        double[] features = null;
        double[] labels = null;
        int ptr = 0;
        while (upstreamData.hasNext()) {
            UpstreamEntry<K, V> entry = upstreamData.next();
            LabeledVector labeledVector = (LabeledVector)this.vectorizer.apply(entry.getKey(), entry.getValue());
            Object featureRow = labeledVector.features();
            if (featureCols < 0) {
                featureCols = featureRow.size();
                features = new double[Math.toIntExact(upstreamDataSize * (long)featureCols)];
            } else assert (featureRow.size() == featureCols) : "Feature extractor must return exactly " + featureCols + " features";
            for (int i = 0; i < featureCols; ++i) {
                features[Math.toIntExact((long)((long)i * upstreamDataSize)) + ptr] = featureRow.get(i);
            }
            double[] lbRow = (double[])labeledVector.label();
            if (lbCols < 0) {
                lbCols = lbRow.length;
                labels = new double[Math.toIntExact(upstreamDataSize * (long)lbCols)];
            }
            assert (lbRow.length == lbCols) : "Label extractor must return exactly " + lbCols + " labels";
            for (int i = 0; i < lbCols; ++i) {
                labels[Math.toIntExact((long)((long)i * upstreamDataSize)) + ptr] = lbRow[i];
            }
            ++ptr;
        }
        return new SimpleLabeledDatasetData(features, labels, Math.toIntExact(upstreamDataSize));
    }
}

