/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset.impl.local;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.ml.dataset.DatasetBuilder;
import org.apache.ignite.ml.dataset.PartitionContextBuilder;
import org.apache.ignite.ml.dataset.PartitionDataBuilder;
import org.apache.ignite.ml.dataset.UpstreamEntry;
import org.apache.ignite.ml.dataset.UpstreamTransformer;
import org.apache.ignite.ml.dataset.UpstreamTransformerBuilder;
import org.apache.ignite.ml.dataset.impl.local.LocalDataset;
import org.apache.ignite.ml.environment.LearningEnvironment;
import org.apache.ignite.ml.environment.LearningEnvironmentBuilder;
import org.apache.ignite.ml.math.functions.IgniteFunction;
import org.apache.ignite.ml.util.Utils;

public class LocalDatasetBuilder<K, V>
implements DatasetBuilder<K, V> {
    private final Map<K, V> upstreamMap;
    private final int partitions;
    private final IgniteBiPredicate<K, V> filter;
    private final UpstreamTransformerBuilder upstreamTransformerBuilder;

    public LocalDatasetBuilder(Map<K, V> upstreamMap, int partitions) {
        this(upstreamMap, (IgniteBiPredicate & Serializable)(a, b) -> true, partitions);
    }

    public LocalDatasetBuilder(Map<K, V> upstreamMap, IgniteBiPredicate<K, V> filter, int partitions, UpstreamTransformerBuilder upstreamTransformerBuilder) {
        this.upstreamMap = upstreamMap;
        this.filter = filter;
        this.partitions = partitions;
        this.upstreamTransformerBuilder = upstreamTransformerBuilder;
    }

    public LocalDatasetBuilder(Map<K, V> upstreamMap, IgniteBiPredicate<K, V> filter, int partitions) {
        this(upstreamMap, filter, partitions, UpstreamTransformerBuilder.identity());
    }

    @Override
    public <C extends Serializable, D extends AutoCloseable> LocalDataset<C, D> build(LearningEnvironmentBuilder envBuilder, PartitionContextBuilder<K, V, C> partCtxBuilder, PartitionDataBuilder<K, V, C, D> partDataBuilder, LearningEnvironment learningEnvironment) {
        ArrayList ctxList = new ArrayList();
        ArrayList<Object> dataList = new ArrayList<Object>();
        ArrayList entriesList = new ArrayList();
        this.upstreamMap.entrySet().stream().filter(en -> this.filter.apply(en.getKey(), en.getValue())).map(en -> new UpstreamEntry(en.getKey(), en.getValue())).forEach(entriesList::add);
        int partSize = Math.max(1, entriesList.size() / this.partitions);
        Iterator firstKeysIter = entriesList.iterator();
        Iterator secondKeysIter = entriesList.iterator();
        Iterator thirdKeysIter = entriesList.iterator();
        int ptr = 0;
        List<LearningEnvironment> envs = IntStream.range(0, this.partitions).boxed().map(envBuilder::buildForWorker).collect(Collectors.toList());
        for (int part = 0; part < this.partitions; ++part) {
            int cntBeforeTransform = part == this.partitions - 1 ? entriesList.size() - ptr : Math.min(partSize, entriesList.size() - ptr);
            LearningEnvironment env = envs.get(part);
            UpstreamTransformer transformer1 = this.upstreamTransformerBuilder.build(env);
            UpstreamTransformer transformer2 = Utils.copy(transformer1);
            UpstreamTransformer transformer3 = Utils.copy(transformer1);
            int cnt = (int)transformer1.transform(Utils.asStream(new IteratorWindow(thirdKeysIter, k -> k, cntBeforeTransform))).count();
            Iterator iter = transformer2.transform(Utils.asStream(new IteratorWindow(firstKeysIter, k -> k, cntBeforeTransform)).map(x -> x)).iterator();
            Iterator convertedBack = Utils.asStream(iter).map(x -> x).iterator();
            Object ctx = cntBeforeTransform > 0 ? (Object)partCtxBuilder.build(env, convertedBack, (long)cnt) : null;
            Iterator iter1 = transformer3.transform(Utils.asStream(new IteratorWindow(secondKeysIter, k -> k, cntBeforeTransform))).iterator();
            Iterator convertedBack1 = Utils.asStream(iter1).map(x -> x).iterator();
            Object data = cntBeforeTransform > 0 ? (Object)partDataBuilder.build(env, convertedBack1, (long)cnt, ctx) : null;
            ctxList.add(ctx);
            dataList.add(data);
            ptr += cntBeforeTransform;
        }
        return new LocalDataset(envs, ctxList, dataList);
    }

    @Override
    public DatasetBuilder<K, V> withUpstreamTransformer(UpstreamTransformerBuilder builder) {
        return new LocalDatasetBuilder<K, V>(this.upstreamMap, this.filter, this.partitions, this.upstreamTransformerBuilder.andThen(builder));
    }

    @Override
    public DatasetBuilder<K, V> withFilter(IgniteBiPredicate<K, V> filterToAdd) {
        return new LocalDatasetBuilder<K, V>(this.upstreamMap, (IgniteBiPredicate & Serializable)(e1, e2) -> this.filter.apply(e1, e2) && filterToAdd.apply(e1, e2), this.partitions);
    }

    private static class IteratorWindow<K, T>
    implements Iterator<T> {
        private final Iterator<K> delegate;
        private final IgniteFunction<K, T> map;
        private final int cnt;
        private int ptr;

        IteratorWindow(Iterator<K> delegate, IgniteFunction<K, T> map, int cnt) {
            this.delegate = delegate;
            this.map = map;
            this.cnt = cnt;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext() && this.ptr < this.cnt;
        }

        @Override
        public T next() {
            ++this.ptr;
            return (T)this.map.apply(this.delegate.next());
        }
    }
}

