/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.dataset.feature.extractor.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.ml.dataset.feature.extractor.ExtractionUtils;
import org.apache.ignite.ml.environment.deploy.DeployableObject;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.primitives.vector.impl.SparseVector;

public final class BinaryObjectVectorizer<K>
extends ExtractionUtils.StringCoordVectorizer<K, BinaryObject>
implements DeployableObject {
    private static final long serialVersionUID = 2152161240934492838L;
    public static final String DEFAULT_VALUE = "DEFAULT";
    private HashMap<String, HashMap<Object, Double>> featureValMappings = new HashMap();

    public BinaryObjectVectorizer(String ... coords) {
        super(coords);
    }

    public BinaryObjectVectorizer withFeature(String coord, Mapping valuesMapping) {
        this.featureValMappings.put(coord, valuesMapping.toMap());
        return this;
    }

    protected Double feature(String coord, K key, BinaryObject value) {
        HashMap<Object, Double> mapping = this.featureValMappings.get(coord);
        if (mapping != null) {
            return mapping.get(coord);
        }
        Number val = (Number)value.field(coord);
        return val != null ? Double.valueOf(val.doubleValue()) : null;
    }

    @Override
    protected List<String> allCoords(K key, BinaryObject value) {
        return value.type().fieldNames().stream().filter(fname -> this.fieldIsDouble(value, (String)fname)).collect(Collectors.toList());
    }

    private boolean fieldIsDouble(BinaryObject value, String fname) {
        return value.type().fieldTypeName(fname).equals(BinaryUtils.fieldTypeName((int)6));
    }

    @Override
    protected Vector createVector(int size) {
        return new SparseVector(size);
    }

    @Override
    public List<Object> getDependencies() {
        return Collections.emptyList();
    }

    public static class Mapping {
        private HashMap<Object, Double> value = new HashMap();

        public static Mapping create() {
            return new Mapping();
        }

        public Mapping map(Object from, Double to) {
            this.value.put(from, to);
            return this;
        }

        public Mapping defaultValue(Double value) {
            this.value.put(BinaryObjectVectorizer.DEFAULT_VALUE, value);
            return this;
        }

        private HashMap<Object, Double> toMap() {
            if (!this.value.containsKey(BinaryObjectVectorizer.DEFAULT_VALUE)) {
                this.value.put(BinaryObjectVectorizer.DEFAULT_VALUE, null);
            }
            return this.value;
        }
    }
}

