/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.client;

import org.apache.ignite.internal.metastorage.common.OperationType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Operation {
    private final InnerOp upd;

    Operation(InnerOp upd) {
        this.upd = upd;
    }

    public InnerOp inner() {
        return this.upd;
    }

    public OperationType type() {
        return this.upd.type();
    }

    private static interface InnerOp {
        @Nullable
        public byte[] key();

        @NotNull
        public OperationType type();
    }

    private static class AbstractOp
    implements InnerOp {
        @Nullable
        private final byte[] key;
        @NotNull
        private final OperationType type;

        private AbstractOp(@Nullable byte[] key, OperationType type) {
            this.key = key;
            this.type = type;
        }

        @Override
        @Nullable
        public byte[] key() {
            return this.key;
        }

        @Override
        @NotNull
        public OperationType type() {
            return this.type;
        }
    }

    public static final class NoOp
    extends AbstractOp {
        NoOp() {
            super(null, OperationType.NO_OP);
        }
    }

    public static final class PutOp
    extends AbstractOp {
        private final byte[] val;

        PutOp(byte[] key, byte[] val) {
            super(key, OperationType.PUT);
            this.val = val;
        }

        public byte[] value() {
            return this.val;
        }
    }

    public static final class RemoveOp
    extends AbstractOp {
        RemoveOp(byte[] key) {
            super(key, OperationType.REMOVE);
        }
    }
}

