/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.client;

import java.util.Arrays;
import org.apache.ignite.internal.metastorage.client.Entry;
import org.apache.ignite.lang.ByteArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EntryImpl
implements Entry {
    @NotNull
    private final ByteArray key;
    @Nullable
    private final byte[] val;
    private final long rev;
    private final long updCntr;

    EntryImpl(@NotNull ByteArray key, @Nullable byte[] val, long rev, long updCntr) {
        this.key = key;
        this.val = val;
        this.rev = rev;
        this.updCntr = updCntr;
    }

    @Override
    @NotNull
    public ByteArray key() {
        return this.key;
    }

    @Override
    @Nullable
    public byte[] value() {
        return this.val;
    }

    @Override
    public long revision() {
        return this.rev;
    }

    @Override
    public long updateCounter() {
        return this.updCntr;
    }

    @Override
    public boolean tombstone() {
        return this.val == null && this.rev > 0L && this.updCntr > 0L;
    }

    @Override
    public boolean empty() {
        return this.val == null && this.rev == 0L && this.updCntr == 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntryImpl entry = (EntryImpl)o;
        if (this.rev != entry.rev) {
            return false;
        }
        if (this.updCntr != entry.updCntr) {
            return false;
        }
        if (!this.key.equals((Object)entry.key)) {
            return false;
        }
        return Arrays.equals(this.val, entry.val);
    }

    public int hashCode() {
        int res = this.key.hashCode();
        res = 31 * res + Arrays.hashCode(this.val);
        res = 31 * res + (int)(this.rev ^ this.rev >>> 32);
        res = 31 * res + (int)(this.updCntr ^ this.updCntr >>> 32);
        return res;
    }
}

