/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.client;

import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.apache.ignite.internal.metastorage.common.command.cursor.CursorCloseCommand;
import org.apache.ignite.internal.metastorage.common.command.cursor.CursorHasNextCommand;
import org.apache.ignite.internal.metastorage.common.command.cursor.CursorNextCommand;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.lang.IgniteLogger;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.raft.client.Command;
import org.apache.ignite.raft.client.service.RaftGroupService;
import org.jetbrains.annotations.NotNull;

public class CursorImpl<T>
implements Cursor<T> {
    private static final IgniteLogger LOG = IgniteLogger.forClass(CursorImpl.class);
    private final CompletableFuture<IgniteUuid> initOp;
    private final RaftGroupService metaStorageRaftGrpSvc;
    private final Iterator<T> it;
    private final Function<Object, T> fn;

    CursorImpl(RaftGroupService metaStorageRaftGrpSvc, CompletableFuture<IgniteUuid> initOp, Function<Object, T> fn) {
        this.metaStorageRaftGrpSvc = metaStorageRaftGrpSvc;
        this.initOp = initOp;
        this.it = new InnerIterator();
        this.fn = fn;
    }

    @NotNull
    public Iterator<T> iterator() {
        return this.it;
    }

    public void close() {
        try {
            ((CompletableFuture)this.initOp.thenCompose(cursorId -> this.metaStorageRaftGrpSvc.run((Command)new CursorCloseCommand(cursorId)))).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Unable to evaluate cursor close command", (Throwable)e);
            throw new IgniteInternalException((Throwable)e);
        }
    }

    public boolean hasNext() {
        return this.it.hasNext();
    }

    public T next() {
        return this.it.next();
    }

    private class InnerIterator
    implements Iterator<T> {
        private InnerIterator() {
        }

        @Override
        public boolean hasNext() {
            try {
                return (Boolean)((CompletableFuture)CursorImpl.this.initOp.thenCompose(cursorId -> CursorImpl.this.metaStorageRaftGrpSvc.run((Command)new CursorHasNextCommand(cursorId)))).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Unable to evaluate cursor hasNext command", (Throwable)e);
                throw new IgniteInternalException((Throwable)e);
            }
        }

        @Override
        public T next() {
            try {
                return ((CompletableFuture)((CompletableFuture)CursorImpl.this.initOp.thenCompose(cursorId -> CursorImpl.this.metaStorageRaftGrpSvc.run((Command)new CursorNextCommand(cursorId)))).thenApply(CursorImpl.this.fn)).get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error("Unable to evaluate cursor hasNext command", (Throwable)e);
                throw new IgniteInternalException((Throwable)e);
            }
        }
    }
}

