/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.client;

import org.apache.ignite.internal.metastorage.common.ConditionType;

public final class Condition {
    private final InnerCondition cond;

    Condition(InnerCondition cond) {
        this.cond = cond;
    }

    public InnerCondition inner() {
        return this.cond;
    }

    public ConditionType type() {
        return this.cond.type();
    }

    private static void validate(Enum<?> type) {
        if (type != null) {
            throw new IllegalStateException("Condition type " + type.name() + " is already defined.");
        }
    }

    private static interface InnerCondition {
        public byte[] key();

        public ConditionType type();
    }

    private static abstract class AbstractCondition
    implements InnerCondition {
        private final byte[] key;
        private ConditionType type;

        private AbstractCondition(byte[] key) {
            this.key = key;
        }

        @Override
        public byte[] key() {
            return this.key;
        }

        @Override
        public ConditionType type() {
            return this.type;
        }

        protected void type(ConditionType type) {
            this.type = type;
        }
    }

    public static final class ExistenceCondition
    extends AbstractCondition {
        ExistenceCondition(byte[] key) {
            super(key);
        }

        public Condition exists() {
            Condition.validate(this.type());
            this.type(ConditionType.KEY_EXISTS);
            return new Condition(this);
        }

        public Condition notExists() {
            Condition.validate(this.type());
            this.type(ConditionType.KEY_NOT_EXISTS);
            return new Condition(this);
        }
    }

    public static final class ValueCondition
    extends AbstractCondition {
        private byte[] val;

        ValueCondition(byte[] key) {
            super(key);
        }

        public byte[] value() {
            return this.val;
        }

        public Condition eq(byte[] val) {
            Condition.validate(this.type());
            this.type(ConditionType.VAL_EQUAL);
            this.val = val;
            return new Condition(this);
        }

        public Condition ne(byte[] val) {
            Condition.validate(this.type());
            this.type(ConditionType.VAL_NOT_EQUAL);
            this.val = val;
            return new Condition(this);
        }
    }

    public static final class RevisionCondition
    extends AbstractCondition {
        private long rev;

        RevisionCondition(byte[] key) {
            super(key);
        }

        public long revision() {
            return this.rev;
        }

        public Condition eq(long rev) {
            Condition.validate(this.type());
            this.type(ConditionType.REV_EQUAL);
            this.rev = rev;
            return new Condition(this);
        }

        public Condition ne(long rev) {
            Condition.validate(this.type());
            this.type(ConditionType.REV_NOT_EQUAL);
            this.rev = rev;
            return new Condition(this);
        }

        public Condition gt(long rev) {
            Condition.validate(this.type());
            this.type(ConditionType.REV_GREATER);
            this.rev = rev;
            return new Condition(this);
        }

        public Condition ge(long rev) {
            Condition.validate(this.type());
            this.type(ConditionType.REV_GREATER_OR_EQUAL);
            this.rev = rev;
            return new Condition(this);
        }

        public Condition lt(long rev) {
            Condition.validate(this.type());
            this.type(ConditionType.REV_LESS);
            this.rev = rev;
            return new Condition(this);
        }

        public Condition le(long rev) {
            Condition.validate(this.type());
            this.type(ConditionType.REV_LESS_OR_EQUAL);
            this.rev = rev;
            return new Condition(this);
        }
    }
}

