/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.loadtests.h2indexing;

import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.internal.util.snaptree.SnapTreeMap;

public class GridTreeBenchmark {
    private static final int PUTS = 8000000;
    private static final int THREADS = 8;
    private static final int ITERATIONS = 1000000;

    public static void main(String ... args) throws BrokenBarrierException, InterruptedException {
        GridTreeBenchmark.doTestMaps();
    }

    private static void doTestAtomicInt() throws BrokenBarrierException, InterruptedException {
        final AtomicInteger[] cnts = new AtomicInteger[8];
        for (int i = 0; i < cnts.length; ++i) {
            cnts[i] = new AtomicInteger();
        }
        Thread[] ths = new Thread[8];
        final CyclicBarrier barrier = new CyclicBarrier(9);
        final AtomicInteger cnt = new AtomicInteger();
        for (int i = 0; i < ths.length; ++i) {
            ths[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int idx = cnt.getAndIncrement();
                    AtomicInteger x = cnts[idx % cnts.length];
                    try {
                        barrier.await();
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                    for (int i = 0; i < 1000000; ++i) {
                        x.incrementAndGet();
                    }
                }
            });
            ths[i].start();
        }
        barrier.await();
        long start = System.currentTimeMillis();
        for (Thread t : ths) {
            t.join();
        }
        long time = System.currentTimeMillis() - start;
        System.out.println(time);
    }

    private static void doTestMaps() throws BrokenBarrierException, InterruptedException {
        final UUID[] data = GridTreeBenchmark.generate();
        final Map[] maps = new Map[4];
        for (int i = 0; i < maps.length; ++i) {
            maps[i] = new SnapTreeMap();
        }
        Thread[] ths = new Thread[8];
        final CyclicBarrier barrier = new CyclicBarrier(9);
        final AtomicInteger cnt = new AtomicInteger();
        for (int i = 0; i < ths.length; ++i) {
            ths[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int idx = cnt.getAndIncrement();
                    int off = idx * 1000000;
                    Map map = maps[idx % maps.length];
                    try {
                        barrier.await();
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                    for (int i = 0; i < 1000000; ++i) {
                        UUID id = data[off + i];
                        id = map.put(id, id);
                        assert (id == null);
                    }
                }
            });
            ths[i].start();
        }
        System.out.println("Sleep");
        Thread.sleep(10000L);
        System.out.println("Go");
        barrier.await();
        long start = System.currentTimeMillis();
        for (Thread t : ths) {
            t.join();
        }
        long time = System.currentTimeMillis() - start;
        System.out.println(time);
    }

    private static void doBenchmark() throws BrokenBarrierException, InterruptedException {
        int attemts = 20;
        int warmups = 10;
        long snapTreeTime = 0L;
        long skipListTime = 0L;
        for (int i = 0; i < attemts; ++i) {
            ConcurrentSkipListMap<UUID, UUID> skipList = new ConcurrentSkipListMap<UUID, UUID>();
            SnapTreeMap snapTree = new SnapTreeMap();
            UUID[] ids = GridTreeBenchmark.generate();
            boolean warmup = i < warmups;
            snapTreeTime += GridTreeBenchmark.doTest((ConcurrentNavigableMap<UUID, UUID>)snapTree, ids, warmup);
            skipListTime += GridTreeBenchmark.doTest(skipList, ids, warmup);
            assert (skipList.size() == snapTree.size());
            Iterator snapIt = snapTree.keySet().iterator();
            Iterator listIt = skipList.keySet().iterator();
            int len = skipList.size();
            for (int x = 0; x < len; ++x) {
                assert (snapIt.next() == listIt.next());
            }
            System.out.println(i + " ==================");
        }
        System.out.println("Avg for GridSnapTreeMap: " + snapTreeTime / (long)(attemts -= warmups) + " ms");
        System.out.println("Avg for ConcurrentSkipListMap: " + skipListTime / (long)attemts + " ms");
    }

    private static UUID[] generate() {
        UUID[] ids = new UUID[8000000];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = UUID.randomUUID();
        }
        return ids;
    }

    private static long doTest(final ConcurrentNavigableMap<UUID, UUID> tree, final UUID[] data, boolean warmup) throws BrokenBarrierException, InterruptedException {
        Thread[] ths = new Thread[8];
        final CyclicBarrier barrier = new CyclicBarrier(9);
        final AtomicInteger cnt = new AtomicInteger();
        for (int i = 0; i < ths.length; ++i) {
            ths[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int off = cnt.getAndIncrement() * 1000000;
                    try {
                        barrier.await();
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                    for (int i = 0; i < 1000000; ++i) {
                        UUID id = data[off + i];
                        id = tree.put(id, id);
                        assert (id == null);
                    }
                }
            });
            ths[i].start();
        }
        barrier.await();
        long start = System.currentTimeMillis();
        for (Thread t : ths) {
            t.join();
        }
        long time = System.currentTimeMillis() - start;
        if (!warmup) {
            System.out.println(tree.getClass().getSimpleName() + "  " + time + " ms");
            return time;
        }
        return 0L;
    }
}

