/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.loadtests.h2indexing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.marshaller.optimized.OptimizedMarshaller;
import org.apache.ignite.marshaller.Marshaller;

public class FetchingQueryCursorStressTest {
    private static final int NODE_CNT = 4;
    private static final int ENTRIES_CNT = 10000;
    private static final String CACHE_NAME = "cache";
    private static final int THREAD_CNT = 16;
    private static final AtomicLong CNT = new AtomicLong();
    private static final boolean VERBOSE = false;
    private static final long TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    public static final AtomicReference<Exception> error = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ArrayList<Thread> threads = new ArrayList<Thread>(17);
        try (Ignite ignite = FetchingQueryCursorStressTest.start();){
            IgniteCache cache = ignite.cache(CACHE_NAME);
            FetchingQueryCursorStressTest.loadData(ignite, (IgniteCache<Integer, Person>)cache);
            System.out.println("Loaded data: " + cache.size(new CachePeekMode[0]));
            for (int i = 0; i < 16; ++i) {
                threads.add(FetchingQueryCursorStressTest.startDaemon("qry-exec-" + i, new QueryExecutor((IgniteCache<Integer, Person>)cache, "Select * from Person")));
            }
            threads.add(FetchingQueryCursorStressTest.startDaemon("printer", new ThroughputPrinter()));
            Thread.sleep(TIMEOUT);
            for (Thread t : threads) {
                t.join();
            }
            if (error.get() != null) {
                throw error.get();
            }
        }
        finally {
            Ignition.stopAll((boolean)false);
        }
    }

    private static Thread startDaemon(String name, Runnable r) {
        Thread t = new Thread(r);
        t.setName(name);
        t.setDaemon(true);
        t.start();
        return t;
    }

    private static void loadData(Ignite ignite, IgniteCache<Integer, Person> cache) throws Exception {
        try (IgniteDataStreamer str = ignite.dataStreamer(cache.getName());){
            for (int id = 0; id < 10000; ++id) {
                str.addData((Object)id, (Object)new Person(id, "John" + id, "Doe"));
            }
        }
    }

    private static Ignite start() {
        int i;
        for (i = 0; i < 4; ++i) {
            Ignition.start((IgniteConfiguration)FetchingQueryCursorStressTest.config(i, false));
        }
        return Ignition.start((IgniteConfiguration)FetchingQueryCursorStressTest.config(i, true));
    }

    private static IgniteConfiguration config(int idx, boolean client) {
        IgniteConfiguration cfg = new IgniteConfiguration();
        cfg.setIgniteInstanceName("grid-" + idx);
        cfg.setClientMode(client);
        CacheConfiguration ccfg = new CacheConfiguration();
        ccfg.setName(CACHE_NAME);
        ccfg.setIndexedTypes(new Class[]{Integer.class, Person.class});
        cfg.setMarshaller((Marshaller)new OptimizedMarshaller());
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        cfg.setLocalHost("127.0.0.1");
        return cfg;
    }

    private static class ThroughputPrinter
    implements Runnable {
        private ThroughputPrinter() {
        }

        @Override
        public void run() {
            while (error.get() == null) {
                long before = CNT.get();
                long beforeTime = System.currentTimeMillis();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                long after = CNT.get();
                long afterTime = System.currentTimeMillis();
                double res = 1000.0 * (double)(after - before) / (double)(afterTime - beforeTime);
                System.out.println((long)res + " ops/sec");
            }
        }
    }

    private static class QueryExecutor
    implements Runnable {
        private final IgniteCache<Integer, Person> cache;
        private final String query;

        public QueryExecutor(IgniteCache<Integer, Person> cache, String query) {
            this.cache = cache;
            this.query = query;
        }

        @Override
        public void run() {
            System.out.println("Executor started: " + Thread.currentThread().getName());
            try {
                while (error.get() == null && !Thread.currentThread().isInterrupted()) {
                    long start = System.nanoTime();
                    SqlFieldsQuery qry = new SqlFieldsQuery(this.query);
                    HashSet<Integer> extIds = new HashSet<Integer>();
                    for (List next : this.cache.query((Query)qry)) {
                        extIds.add((Integer)next.get(0));
                    }
                    long dur = (System.nanoTime() - start) / 1000000L;
                    CNT.incrementAndGet();
                }
            }
            catch (CacheException ex) {
                error.compareAndSet(null, (Exception)((Object)ex));
            }
        }
    }

    private static class Person
    implements Serializable {
        private static final long serialVersionUID = 0L;
        @QuerySqlField
        private int id;
        @QuerySqlField
        private String firstName;
        @QuerySqlField
        private String lastName;

        public Person(int id, String firstName, String lastName) {
            this.id = id;
            this.firstName = firstName;
            this.lastName = lastName;
        }
    }
}

