/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityKey;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.query.h2.sql.AbstractH2CompareQueryTest;
import org.apache.ignite.internal.util.typedef.X;

public class H2CompareBigQueryTest
extends AbstractH2CompareQueryTest {
    private static final int ROOT_ORDER_CNT = 1000;
    private static final int DATES_CNT = 5;
    private String bigQry = this.getBigQry();
    private static IgniteCache<Integer, CustOrder> cacheCustOrd;
    private static IgniteCache<Object, ReplaceOrder> cacheReplOrd;
    private static IgniteCache<Object, OrderParams> cacheOrdParam;
    private static IgniteCache<Object, Cancel> cacheCancel;
    private static IgniteCache<Object, Exec> cacheExec;

    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration("custord", CacheMode.PARTITIONED, Integer.class, CustOrder.class), this.cacheConfiguration("replord", CacheMode.PARTITIONED, this.useColocatedData() ? AffinityKey.class : Integer.class, ReplaceOrder.class), this.cacheConfiguration("ordparam", CacheMode.PARTITIONED, this.useColocatedData() ? AffinityKey.class : Integer.class, OrderParams.class), this.cacheConfiguration("cancel", CacheMode.PARTITIONED, this.useColocatedData() ? AffinityKey.class : Integer.class, Cancel.class), this.cacheConfiguration("exec", CacheMode.REPLICATED, this.useColocatedData() ? AffinityKey.class : Integer.class, Exec.class)});
        return cfg;
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        cacheCustOrd = null;
        cacheReplOrd = null;
        cacheOrdParam = null;
        cacheCancel = null;
        cacheExec = null;
    }

    private String getBigQry() {
        String res = "";
        InputStreamReader isr = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("bigQuery.sql"));
        try (BufferedReader reader = new BufferedReader(isr);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("--")) continue;
                res = res + line + '\n';
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            H2CompareBigQueryTest.fail();
        }
        return res;
    }

    private boolean useColocatedData() {
        return !this.distributedJoins();
    }

    protected boolean distributedJoins() {
        return false;
    }

    @Override
    protected void createCaches() {
        cacheCustOrd = ignite.cache("custord");
        cacheReplOrd = ignite.cache("replord");
        cacheOrdParam = ignite.cache("ordparam");
        cacheCancel = ignite.cache("cancel");
        cacheExec = ignite.cache("exec");
    }

    @Override
    protected void initCacheAndDbData() throws SQLException {
        final AtomicInteger idGen = new AtomicInteger();
        final ArrayList<Integer> rootOrderIds = new ArrayList<Integer>(){
            {
                for (int i = 0; i < 1000; ++i) {
                    this.add(idGen.incrementAndGet());
                }
            }
        };
        final Date curDate = new Date(new java.util.Date().getTime());
        final ArrayList<Date> dates = new ArrayList<Date>(){
            {
                for (int i = 0; i < 5; ++i) {
                    this.add(new Date(curDate.getTime() - (long)(i * 24 * 60 * 60 * 1000)));
                }
            }
        };
        final ArrayList<CustOrder> orders = new ArrayList<CustOrder>(){
            {
                Iterator i$ = rootOrderIds.iterator();
                while (i$.hasNext()) {
                    int rootOrderId = (Integer)i$.next();
                    for (int i = 0; i < rootOrderId % 5; ++i) {
                        int orderId = idGen.incrementAndGet();
                        CustOrder order = new CustOrder(orderId, rootOrderId, (Date)dates.get(orderId % dates.size()), orderId % 2 == 0 ? "CUSTOM" : "OTHER", orderId);
                        this.add(order);
                        cacheCustOrd.put((Object)order.orderId, (Object)order);
                        H2CompareBigQueryTest.this.insertInDb(order);
                    }
                }
            }
        };
        ArrayList<OrderParams> params = new ArrayList<OrderParams>(){
            {
                for (CustOrder o : orders) {
                    OrderParams op = new OrderParams(idGen.incrementAndGet(), o.orderId, o.date, o.orderId % 2 == 0 ? "Algo 1" : "Algo 2");
                    this.add(op);
                    cacheOrdParam.put(op.key(H2CompareBigQueryTest.this.useColocatedData()), (Object)op);
                    H2CompareBigQueryTest.this.insertInDb(op);
                }
            }
        };
        ArrayList<ReplaceOrder> replaces = new ArrayList<ReplaceOrder>(){
            {
                for (CustOrder o : orders) {
                    if (o.orderId % 7 != 0) continue;
                    ReplaceOrder replace = new ReplaceOrder(idGen.incrementAndGet(), o.orderId, o.rootOrderId, o.alias, new Date(o.date.getTime() + 43200000L), o.orderId);
                    this.add(replace);
                    cacheReplOrd.put(replace.key(H2CompareBigQueryTest.this.useColocatedData()), (Object)replace);
                    H2CompareBigQueryTest.this.insertInDb(replace);
                }
            }
        };
        ArrayList<Cancel> cancels = new ArrayList<Cancel>(){
            {
                for (CustOrder o : orders) {
                    if (o.orderId % 9 != 0) continue;
                    Cancel c = new Cancel(idGen.incrementAndGet(), o.orderId, new Date(o.date.getTime() + 43200000L));
                    this.add(c);
                    cacheCancel.put(c.key(H2CompareBigQueryTest.this.useColocatedData()), (Object)c);
                    H2CompareBigQueryTest.this.insertInDb(c);
                }
            }
        };
        ArrayList<Exec> execs = new ArrayList<Exec>(){
            {
                Iterator i$ = rootOrderIds.iterator();
                while (i$.hasNext()) {
                    int rootOrderId = (Integer)i$.next();
                    int execShares = 10000 + rootOrderId;
                    int price = 1000 + rootOrderId;
                    int latsMkt = 3000 + rootOrderId;
                    Exec exec = new Exec(idGen.incrementAndGet(), rootOrderId, (Date)dates.get(rootOrderId % dates.size()), execShares, price, latsMkt);
                    this.add(exec);
                    cacheExec.put(exec.key(H2CompareBigQueryTest.this.useColocatedData()), (Object)exec);
                    H2CompareBigQueryTest.this.insertInDb(exec);
                }
            }
        };
    }

    @Override
    protected void checkAllDataEquals() throws Exception {
        this.compareQueryRes0(cacheCustOrd, "select _key, _val, date, orderId, rootOrderId, alias, archSeq, origOrderId from \"custord\".CustOrder", new Object[0]);
        this.compareQueryRes0(cacheReplOrd, "select _key, _val, id, date, orderId, rootOrderId, alias, archSeq, refOrderId from \"replord\".ReplaceOrder", new Object[0]);
        this.compareQueryRes0(cacheOrdParam, "select _key, _val, id, date, orderId, parentAlgo from \"ordparam\".OrderParams\n", new Object[0]);
        this.compareQueryRes0(cacheCancel, "select _key, _val, id, date, refOrderId from \"cancel\".Cancel\n", new Object[0]);
        this.compareQueryRes0(cacheExec, "select _key, _val, date, rootOrderId, execShares, price, lastMkt from \"exec\".Exec\n", new Object[0]);
    }

    public void testBigQuery() throws Exception {
        X.println();
        X.println((String)this.bigQry, (Object[])new Object[0]);
        X.println();
        X.println((String)("   Plan: \n" + cacheCustOrd.query((Query)new SqlFieldsQuery("EXPLAIN " + this.bigQry).setDistributedJoins(this.distributedJoins())).getAll()), (Object[])new Object[0]);
        List<List<?>> res = H2CompareBigQueryTest.compareQueryRes0(cacheCustOrd, this.bigQry, this.distributedJoins(), new Object[0], AbstractH2CompareQueryTest.Ordering.RANDOM);
        X.println((String)("   Result size: " + res.size()), (Object[])new Object[0]);
        H2CompareBigQueryTest.assertTrue((!res.isEmpty() ? 1 : 0) != 0);
    }

    @Override
    protected Statement initializeH2Schema() throws SQLException {
        Statement st = super.initializeH2Schema();
        st.execute("CREATE SCHEMA \"custord\"");
        st.execute("CREATE SCHEMA \"replord\"");
        st.execute("CREATE SCHEMA \"ordparam\"");
        st.execute("CREATE SCHEMA \"cancel\"");
        st.execute("CREATE SCHEMA \"exec\"");
        String keyType = this.useColocatedData() ? "other" : "int";
        st.execute("create table \"custord\".CustOrder  (  _key int not null,  _val other not null,  orderId int unique,  rootOrderId int,  origOrderId int,  archSeq int,  date Date,   alias varchar(255)  )");
        st.execute("create table \"replord\".ReplaceOrder  (  _key " + keyType + " not null," + "  _val other not null," + "  id int unique," + "  orderId int ," + "  rootOrderId int," + "  refOrderId int," + "  archSeq int," + "  date Date, " + "  alias varchar(255)" + "  )");
        st.execute("create table \"ordparam\".OrderParams  (  _key " + keyType + " not null," + "  _val other not null," + "  id int unique," + "  orderId int ," + "  date Date, " + "  parentAlgo varchar(255)" + "  )");
        st.execute("create table \"cancel\".Cancel  (  _key " + keyType + " not null," + "  _val other not null," + "  id int unique," + "  date Date, " + "  refOrderId int" + "  )");
        st.execute("create table \"exec\".Exec  (  _key " + keyType + " not null," + "  _val other not null," + "  rootOrderId int unique," + "  date Date, " + "  execShares int," + "  price int," + "  lastMkt int" + "  )");
        conn.commit();
        return st;
    }

    private void insertInDb(CustOrder o) throws SQLException {
        try (PreparedStatement st = conn.prepareStatement("insert into \"custord\".CustOrder (_key, _val, orderId, rootOrderId, date, alias, archSeq, origOrderId) values(?, ?, ?, ?, ?, ?, ?, ?)");){
            int i = 0;
            st.setObject(++i, o.orderId);
            st.setObject(++i, o);
            st.setObject(++i, o.orderId);
            st.setObject(++i, o.rootOrderId);
            st.setObject(++i, o.date);
            st.setObject(++i, o.alias);
            st.setObject(++i, o.archSeq);
            st.setObject(++i, o.origOrderId);
            st.executeUpdate();
        }
    }

    private void insertInDb(ReplaceOrder o) throws SQLException {
        try (PreparedStatement st = conn.prepareStatement("insert into \"replord\".ReplaceOrder (_key, _val, id, orderId, rootOrderId, date, alias, archSeq, refOrderId) values(?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            int i = 0;
            st.setObject(++i, o.key(this.useColocatedData()));
            st.setObject(++i, o);
            st.setObject(++i, o.id);
            st.setObject(++i, o.orderId);
            st.setObject(++i, o.rootOrderId);
            st.setObject(++i, o.date);
            st.setObject(++i, o.alias);
            st.setObject(++i, o.archSeq);
            st.setObject(++i, o.refOrderId);
            st.executeUpdate();
        }
    }

    private void insertInDb(OrderParams o) throws SQLException {
        try (PreparedStatement st = conn.prepareStatement("insert into \"ordparam\".OrderParams (_key, _val, id, date, orderId, parentAlgo) values(?, ?, ?, ?, ?, ?)");){
            int i = 0;
            st.setObject(++i, o.key(this.useColocatedData()));
            st.setObject(++i, o);
            st.setObject(++i, o.id);
            st.setObject(++i, o.date);
            st.setObject(++i, o.orderId);
            st.setObject(++i, o.parentAlgo);
            st.executeUpdate();
        }
    }

    private void insertInDb(Cancel o) throws SQLException {
        try (PreparedStatement st = conn.prepareStatement("insert into \"cancel\".Cancel (_key, _val, id, date, refOrderId) values(?, ?, ?, ?, ?)");){
            int i = 0;
            st.setObject(++i, o.key(this.useColocatedData()));
            st.setObject(++i, o);
            st.setObject(++i, o.id);
            st.setObject(++i, o.date);
            st.setObject(++i, o.refOrderId);
            st.executeUpdate();
        }
    }

    private void insertInDb(Exec o) throws SQLException {
        try (PreparedStatement st = conn.prepareStatement("insert into \"exec\".Exec (_key, _val, date, rootOrderId, execShares, price, lastMkt) values(?, ?, ?, ?, ?, ?, ?)");){
            int i = 0;
            st.setObject(++i, o.key(this.useColocatedData()));
            st.setObject(++i, o);
            st.setObject(++i, o.date);
            st.setObject(++i, o.rootOrderId);
            st.setObject(++i, o.execShares);
            st.setObject(++i, o.price);
            st.setObject(++i, o.lastMkt);
            st.executeUpdate();
        }
    }

    static class Exec
    implements Serializable {
        @QuerySqlField
        private int id;
        @QuerySqlField(index=true)
        private int rootOrderId;
        @QuerySqlField
        private Date date;
        @QuerySqlField
        private int execShares;
        @QuerySqlField
        private int price;
        @QuerySqlField
        private int lastMkt;

        Exec(int id, int rootOrderId, Date date, int execShares, int price, int lastMkt) {
            this.id = id;
            this.rootOrderId = rootOrderId;
            this.date = date;
            this.execShares = execShares;
            this.price = price;
            this.lastMkt = lastMkt;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Exec && this.id == ((Exec)o).id;
        }

        public int hashCode() {
            return this.id;
        }

        public Object key(boolean useColocatedData) {
            return useColocatedData ? new AffinityKey((Object)this.id, (Object)this.rootOrderId) : Integer.valueOf(this.id);
        }
    }

    static class Cancel
    implements Serializable {
        @QuerySqlField(index=true)
        private int id;
        @QuerySqlField(index=true)
        private int refOrderId;
        @QuerySqlField
        private Date date;

        Cancel(int id, int refOrderId, Date date) {
            this.id = id;
            this.refOrderId = refOrderId;
            this.date = date;
        }

        public Object key(boolean useColocatedData) {
            return useColocatedData ? new AffinityKey((Object)this.id, (Object)this.refOrderId) : Integer.valueOf(this.id);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Cancel && this.id == ((Cancel)o).id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    static class OrderParams
    implements Serializable {
        @QuerySqlField(index=true)
        private int id;
        @QuerySqlField(index=true)
        private int orderId;
        @QuerySqlField
        private Date date;
        @QuerySqlField
        private String parentAlgo = "CUSTOM_ALGO";

        OrderParams(int id, int orderId, Date date, String parentAlgo) {
            this.id = id;
            this.orderId = orderId;
            this.date = date;
            this.parentAlgo = parentAlgo;
        }

        public Object key(boolean useColocatedData) {
            return useColocatedData ? new AffinityKey((Object)this.id, (Object)this.orderId) : Integer.valueOf(this.id);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof OrderParams && this.id == ((OrderParams)o).id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    static class ReplaceOrder
    implements Serializable {
        @QuerySqlField(index=true)
        private int id;
        @QuerySqlField(index=true)
        private int orderId;
        @QuerySqlField
        private int rootOrderId;
        @QuerySqlField
        private int refOrderId;
        @QuerySqlField
        private Date date;
        @QuerySqlField
        private String alias = "CUSTOM";
        @QuerySqlField
        private int archSeq = 111;

        ReplaceOrder(int id, int orderId, int rootOrderId, String alias, Date date, int refOrderId) {
            this.id = id;
            this.orderId = orderId;
            this.rootOrderId = rootOrderId;
            this.refOrderId = refOrderId;
            this.date = date;
            this.alias = alias;
        }

        public Object key(boolean useColocatedData) {
            return useColocatedData ? new AffinityKey((Object)this.id, (Object)this.orderId) : Integer.valueOf(this.id);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof ReplaceOrder && this.id == ((ReplaceOrder)o).id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    static class CustOrder
    implements Serializable {
        @QuerySqlField(index=true)
        private int orderId;
        @QuerySqlField
        private int rootOrderId;
        @QuerySqlField
        private int origOrderId;
        @QuerySqlField
        private Date date;
        @QuerySqlField
        private String alias = "CUSTOM";
        @QuerySqlField
        private int archSeq = 11;

        CustOrder(int orderId, int rootOrderId, Date date, String alias, int origOrderId) {
            this.orderId = orderId;
            this.rootOrderId = rootOrderId;
            this.origOrderId = origOrderId;
            this.date = date;
            this.alias = alias;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof CustOrder && this.orderId == ((CustOrder)o).orderId;
        }

        public int hashCode() {
            return this.orderId;
        }
    }
}

