/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlCreateIndex;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDropIndex;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlJoin;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSelect;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSubquery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.jetbrains.annotations.NotNull;

public class GridQueryParsingTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);
    private static Ignite ignite;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(igniteInstanceName);
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        disco.setIpFinder(ipFinder);
        c.setDiscoverySpi((DiscoverySpi)disco);
        c.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration("default", "SCH1", String.class, Person.class), this.cacheConfiguration("addr", "SCH2", String.class, Address.class)});
        return c;
    }

    private CacheConfiguration cacheConfiguration(@NotNull String name, String sqlSchema, Class<?> clsK, Class<?> clsV) {
        CacheConfiguration cc = GridQueryParsingTest.defaultCacheConfiguration();
        cc.setName(name);
        cc.setCacheMode(CacheMode.PARTITIONED);
        cc.setAtomicityMode(CacheAtomicityMode.ATOMIC);
        cc.setNearConfiguration(null);
        cc.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cc.setRebalanceMode(CacheRebalanceMode.SYNC);
        cc.setSqlSchema(sqlSchema);
        cc.setSqlFunctionClasses(new Class[]{GridQueryParsingTest.class});
        cc.setIndexedTypes(new Class[]{clsK, clsV});
        return cc;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        ignite = this.startGrid();
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        ignite = null;
        super.afterTestsStopped();
    }

    public void testParseSelectAndUnion() throws Exception {
        this.checkQuery("select 1 from Person p where addrIds in ((1,2,3), (3,4,5))");
        this.checkQuery("select 1 from Person p where addrId in ((1,))");
        this.checkQuery("select 1 from Person p where p.addrId in (select a.id from sch2.Address a)");
        this.checkQuery("select 1 from Person p where exists(select 1 from sch2.Address a where p.addrId = a.id)");
        this.checkQuery("select 42");
        this.checkQuery("select ()");
        this.checkQuery("select (1)");
        this.checkQuery("select (1 + 1)");
        this.checkQuery("select (1,)");
        this.checkQuery("select (?)");
        this.checkQuery("select (?,)");
        this.checkQuery("select (1, 2)");
        this.checkQuery("select (?, ? + 1, 2 + 2) as z");
        this.checkQuery("select (1,(1,(1,(1,(1,?)))))");
        this.checkQuery("select (select 1)");
        this.checkQuery("select (select 1, select ?)");
        this.checkQuery("select ((select 1), select ? + ?)");
        this.checkQuery("select CURRENT_DATE");
        this.checkQuery("select CURRENT_DATE()");
        this.checkQuery("select extract(year from ?)");
        this.checkQuery("select convert(?, timestamp)");
        this.checkQuery("select * from table(id bigint = 1)");
        this.checkQuery("select * from table(id bigint = (1))");
        this.checkQuery("select * from table(id bigint = (1,))");
        this.checkQuery("select * from table(id bigint = (1,), name varchar = 'asd')");
        this.checkQuery("select * from table(id bigint = (1,2), name varchar = 'asd')");
        this.checkQuery("select * from table(id bigint = (1,2), name varchar = ('asd',))");
        this.checkQuery("select * from table(id bigint = (1,2), name varchar = ?)");
        this.checkQuery("select * from table(id bigint = (1,2), name varchar = (?,))");
        this.checkQuery("select * from table(id bigint = ?, name varchar = ('abc', 'def', 100, ?)) t");
        this.checkQuery("select ? limit ? offset ?");
        this.checkQuery("select cool1()");
        this.checkQuery("select cool1() z");
        this.checkQuery("select b,a from table0('aaa', 100)");
        this.checkQuery("select * from table0('aaa', 100)");
        this.checkQuery("select * from table0('aaa', 100) t0");
        this.checkQuery("select x.a, y.b from table0('aaa', 100) x natural join table0('bbb', 100) y");
        this.checkQuery("select * from table0('aaa', 100) x join table0('bbb', 100) y on x.a=y.a and x.b = 1");
        this.checkQuery("select * from table0('aaa', 100) x left join table0('bbb', 100) y on x.a=y.a and x.b = 1");
        this.checkQuery("select * from table0('aaa', 100) x left join table0('bbb', 100) y on x.a=y.a where x.b = 1");
        this.checkQuery("select * from table0('aaa', 100) x left join table0('bbb', 100) y where x.b = 1");
        this.checkQuery("select avg(old) from Person left join sch2.Address on Person.addrId = Address.id where lower(Address.street) = lower(?)");
        this.checkQuery("select avg(old) from sch1.Person join sch2.Address on Person.addrId = Address.id where lower(Address.street) = lower(?)");
        this.checkQuery("select avg(old) from Person left join sch2.Address where Person.addrId = Address.id and lower(Address.street) = lower(?)");
        this.checkQuery("select avg(old) from Person right join sch2.Address where Person.addrId = Address.id and lower(Address.street) = lower(?)");
        this.checkQuery("select avg(old) from Person, sch2.Address where Person.addrId = Address.id and lower(Address.street) = lower(?)");
        this.checkQuery("select name, name, date, date d from Person");
        this.checkQuery("select distinct name, date from Person");
        this.checkQuery("select * from Person p");
        this.checkQuery("select * from Person");
        this.checkQuery("select distinct * from Person");
        this.checkQuery("select p.name, date from Person p");
        this.checkQuery("select * from Person p, sch2.Address a");
        this.checkQuery("select * from Person, sch2.Address");
        this.checkQuery("select p.* from Person p, sch2.Address a");
        this.checkQuery("select person.* from Person, sch2.Address a");
        this.checkQuery("select p.*, street from Person p, sch2.Address a");
        this.checkQuery("select p.name, a.street from Person p, sch2.Address a");
        this.checkQuery("select p.name, a.street from sch2.Address a, Person p");
        this.checkQuery("select distinct p.name, a.street from Person p, sch2.Address a");
        this.checkQuery("select distinct name, street from Person, sch2.Address group by old");
        this.checkQuery("select distinct name, street from Person, sch2.Address");
        this.checkQuery("select p1.name, a2.street from Person p1, sch2.Address a1, Person p2, sch2.Address a2");
        this.checkQuery("select p.name n, a.street s from Person p, sch2.Address a");
        this.checkQuery("select p.name, 1 as i, 'aaa' s from Person p");
        this.checkQuery("select p.name + 'a', 1 * 3 as i, 'aaa' s, -p.old, -p.old as old from Person p");
        this.checkQuery("select p.name || 'a' + p.name, (p.old * 3) % p.old - p.old / p.old, p.name = 'aaa',  p.name is p.name, p.old > 0, p.old >= 0, p.old < 0, p.old <= 0, p.old <> 0, p.old is not p.old,  p.old is null, p.old is not null  from Person p");
        this.checkQuery("select p.name from Person p where name <> 'ivan'");
        this.checkQuery("select p.name from Person p where name like 'i%'");
        this.checkQuery("select p.name from Person p where name regexp 'i%'");
        this.checkQuery("select p.name from Person p, sch2.Address a where p.name <> 'ivan' and a.id > 10 or not (a.id = 100)");
        this.checkQuery("select case p.name when 'a' then 1 when 'a' then 2 end as a from Person p");
        this.checkQuery("select case p.name when 'a' then 1 when 'a' then 2 else -1 end as a from Person p");
        this.checkQuery("select abs(p.old)  from Person p");
        this.checkQuery("select cast(p.old as numeric(10, 2)) from Person p");
        this.checkQuery("select cast(p.old as numeric(10, 2)) z from Person p");
        this.checkQuery("select cast(p.old as numeric(10, 2)) as z from Person p");
        this.checkQuery("select * from Person p where p.name in ('a', 'b', '_' + RAND())");
        this.checkQuery("select * from Person p where p.name in ('a', 'b', 'c')");
        this.checkQuery("select * from Person p where p.name in (select a.street from sch2.Address a)");
        this.checkQuery("select (select a.street from sch2.Address a where a.id = p.addrId) from Person p");
        this.checkQuery("select p.name, ? from Person p where name regexp ? and p.old < ?");
        this.checkQuery("select count(*) as a from Person having a > 10");
        this.checkQuery("select count(*) as a, count(p.*), count(p.name) from Person p");
        this.checkQuery("select count(distinct p.name) from Person p");
        this.checkQuery("select name, count(*) cnt from Person group by name order by cnt desc limit 10");
        this.checkQuery("select p.name, avg(p.old), max(p.old) from Person p group by p.name");
        this.checkQuery("select p.name n, avg(p.old) a, max(p.old) m from Person p group by p.name");
        this.checkQuery("select p.name n, avg(p.old) a, max(p.old) m from Person p group by n");
        this.checkQuery("select p.name n, avg(p.old) a, max(p.old) m from Person p group by p.addrId, p.name");
        this.checkQuery("select p.name n, avg(p.old) a, max(p.old) m from Person p group by p.name, p.addrId");
        this.checkQuery("select p.name n, max(p.old) + min(p.old) / count(distinct p.old) from Person p group by p.name");
        this.checkQuery("select p.name n, max(p.old) maxOld, min(p.old) minOld from Person p group by p.name having maxOld > 10 and min(p.old) < 1");
        this.checkQuery("select p.name n, avg(p.old) a, max(p.old) m from Person p group by p.name order by n");
        this.checkQuery("select p.name n, avg(p.old) a, max(p.old) m from Person p group by p.name order by p.name");
        this.checkQuery("select p.name n, avg(p.old) a, max(p.old) m from Person p group by p.name order by p.name, m");
        this.checkQuery("select p.name n, avg(p.old) a, max(p.old) m from Person p group by p.name order by p.name, max(p.old) desc");
        this.checkQuery("select p.name n, avg(p.old) a, max(p.old) m from Person p group by p.name order by p.name nulls first");
        this.checkQuery("select p.name n, avg(p.old) a, max(p.old) m from Person p group by p.name order by p.name nulls last");
        this.checkQuery("select p.name n from Person p order by p.old + 10");
        this.checkQuery("select p.name n from Person p order by p.old + 10, p.name");
        this.checkQuery("select p.name n from Person p order by p.old + 10, p.name desc");
        this.checkQuery("select p.name n from Person p, (select a.street from sch2.Address a where a.street is not null) ");
        this.checkQuery("select street from Person p, (select a.street from sch2.Address a where a.street is not null) ");
        this.checkQuery("select addr.street from Person p, (select a.street from sch2.Address a where a.street is not null) addr");
        this.checkQuery("select p.name n from sch1.Person p order by p.old + 10");
        this.checkQuery("select case when p.name is null then 'Vasya' end x from sch1.Person p");
        this.checkQuery("select case when p.name like 'V%' then 'Vasya' else 'Other' end x from sch1.Person p");
        this.checkQuery("select case when upper(p.name) = 'VASYA' then 'Vasya' when p.name is not null then p.name else 'Other' end x from sch1.Person p");
        this.checkQuery("select case p.name when 'Vasya' then 1 end z from sch1.Person p");
        this.checkQuery("select case p.name when 'Vasya' then 1 when 'Petya' then 2 end z from sch1.Person p");
        this.checkQuery("select case p.name when 'Vasya' then 1 when 'Petya' then 2 else 3 end z from sch1.Person p");
        this.checkQuery("select case p.name when 'Vasya' then 1 else 3 end z from sch1.Person p");
        this.checkQuery("select count(*) as a from Person union select count(*) as a from sch2.Address");
        this.checkQuery("select old, count(*) as a from Person group by old union select 1, count(*) as a from sch2.Address");
        this.checkQuery("select name from Person MINUS select street from sch2.Address");
        this.checkQuery("select name from Person EXCEPT select street from sch2.Address");
        this.checkQuery("select name from Person INTERSECT select street from sch2.Address");
        this.checkQuery("select name from Person UNION select street from sch2.Address limit 5");
        this.checkQuery("select name from Person UNION select street from sch2.Address limit ?");
        this.checkQuery("select name from Person UNION select street from sch2.Address limit ? offset ?");
        this.checkQuery("(select name from Person limit 4) UNION (select street from sch2.Address limit 1) limit ? offset ?");
        this.checkQuery("(select 2 a) union all (select 1) order by 1");
        this.checkQuery("(select 2 a) union all (select 1) order by a desc nulls first limit ? offset ?");
        this.checkQuery("select public.\"#\".\"@\" from (select 1 as \"@\") \"#\"");
        this.checkQuery("select \"#\".\"@\" from (select 1 as \"@\") \"#\"");
        this.checkQuery("select \"@\" from (select 1 as \"@\") \"#\"");
        this.checkQuery("select sch1.\"#\".old from sch1.Person \"#\"");
        this.checkQuery("select sch1.\"#\".old from Person \"#\"");
        this.checkQuery("select \"#\".old from Person \"#\"");
        this.checkQuery("select old from Person \"#\"");
        this.checkQuery("select \"#\".* from Person \"#\"");
    }

    public void testUseIndexHints() throws Exception {
        this.checkQuery("select * from Person use index (\"PERSON_NAME_IDX\")");
        this.checkQuery("select * from Person use index (\"PERSON_PARENTNAME_IDX\")");
        this.checkQuery("select * from Person use index (\"PERSON_NAME_IDX\", \"PERSON_PARENTNAME_IDX\")");
        this.checkQuery("select * from Person use index ()");
        this.checkQuery("select * from Person p use index (\"PERSON_NAME_IDX\")");
        this.checkQuery("select * from Person p use index (\"PERSON_PARENTNAME_IDX\")");
        this.checkQuery("select * from Person p use index (\"PERSON_NAME_IDX\", \"PERSON_PARENTNAME_IDX\")");
        this.checkQuery("select * from Person p use index ()");
    }

    public void testParseTableFilter() throws Exception {
        Object prepared = this.parse("select Person.old, p1.old, p1.addrId from Person, Person p1 where exists(select 1 from sch2.Address a where a.id = p1.addrId)");
        GridSqlSelect select = (GridSqlSelect)new GridSqlQueryParser(false).parse(prepared);
        GridSqlJoin join = (GridSqlJoin)select.from();
        GridSqlTable tbl1 = (GridSqlTable)join.leftTable();
        GridSqlAlias tbl2Alias = (GridSqlAlias)join.rightTable();
        GridSqlTable tbl2 = (GridSqlTable)tbl2Alias.child();
        GridQueryParsingTest.assertNotSame((Object)tbl1, (Object)tbl2);
        GridQueryParsingTest.assertNotNull((Object)tbl1.dataTable());
        GridQueryParsingTest.assertNotNull((Object)tbl2.dataTable());
        GridQueryParsingTest.assertSame((Object)tbl1.dataTable(), (Object)tbl2.dataTable());
        GridSqlColumn col1 = (GridSqlColumn)select.column(0);
        GridSqlColumn col2 = (GridSqlColumn)select.column(1);
        GridQueryParsingTest.assertSame((Object)tbl1, (Object)col1.expressionInFrom());
        GridQueryParsingTest.assertSame((Object)tbl2Alias, (Object)col2.expressionInFrom());
        GridSqlAst exists = select.where();
        GridSqlSubquery subqry = (GridSqlSubquery)exists.child();
        GridSqlSelect subSelect = (GridSqlSelect)subqry.child();
        GridSqlColumn p1AddrIdCol = (GridSqlColumn)select.column(2);
        GridQueryParsingTest.assertEquals((String)"ADDRID", (String)p1AddrIdCol.column().getName());
        GridQueryParsingTest.assertSame((Object)tbl2Alias, (Object)p1AddrIdCol.expressionInFrom());
        GridSqlColumn p1AddrIdColExists = (GridSqlColumn)subSelect.where().child(1);
        GridQueryParsingTest.assertEquals((String)"ADDRID", (String)p1AddrIdCol.column().getName());
        GridQueryParsingTest.assertSame((Object)tbl2Alias, (Object)p1AddrIdColExists.expressionInFrom());
    }

    public void testParseMerge() throws Exception {
        this.checkQuery("merge into Person(old, name) values(5, 'John')");
        this.checkQuery("merge into Person(name) values(DEFAULT)");
        this.checkQuery("merge into Person(name) values(DEFAULT), (null)");
        this.checkQuery("merge into Person(name, parentName) values(DEFAULT, null), (?, ?)");
        this.checkQuery("merge into Person(old, name) values(5, 'John',), (6, 'Jack')");
        this.checkQuery("merge into Person(old, name) values(5 * 3, DEFAULT,)");
        this.checkQuery("merge into Person(old, name) values(ABS(-8), 'Max')");
        this.checkQuery("merge into Person(old, name) values(5, 'Jane'), (DEFAULT, DEFAULT), (6, 'Jill')");
        this.checkQuery("merge into Person(old, name, parentName) values(8 * 7, DEFAULT, 'Unknown')");
        this.checkQuery("merge into Person(old, name, parentName) values(2016 - 1828, CONCAT('Leo', 'Tolstoy'), CONCAT(?, 'Tolstoy')),(?, 'AlexanderPushkin', null),(ABS(1821 - 2016), CONCAT('Fyodor', null, UPPER(CONCAT(SQRT(?), 'dostoevsky'))), DEFAULT)");
        this.checkQuery("merge into Person(date, old, name, parentName, addrId) values ('20160112', 1233, 'Ivan Ivanov', 'Peter Ivanov', 123)");
        this.checkQuery("merge into Person(date, old, name, parentName, addrId) values (CURRENT_DATE(), RAND(), ASCII('Hi'), INSERT('Leo Tolstoy', 4, 4, 'Max'), ASCII('HI'))");
        this.checkQuery("merge into Person(date, old, name, parentName, addrId) values (TRUNCATE(TIMESTAMP '2015-12-31 23:59:59'), POWER(3,12), NULL, DEFAULT, DEFAULT)");
        this.checkQuery("merge into Person(old, name) select ASCII(parentName), INSERT(parentName, 4, 4, 'Max') from Person where date='2011-03-12'");
        this.checkQuery("merge into Person(old, name) select old, parentName from Person");
        this.checkQuery("merge into Person(old, name) select old, parentName from Person where old > 5");
        this.checkQuery("merge into Person(old, name) select 5, 'John'");
        this.checkQuery("merge into Person(old, name) select p1.old, 'Name' from person p1 join person p2 on p2.name = p1.parentName where p2.old > 30");
        this.checkQuery("merge into Person(old) select 5 from Person UNION select street from sch2.Address limit ? offset ?");
    }

    public void testParseInsert() throws Exception {
        this.checkQuery("insert into Person(old, name) values(5, 'John')");
        this.checkQuery("insert into Person(name) values(DEFAULT)");
        this.checkQuery("insert into Person default values");
        this.checkQuery("insert into Person() values()");
        this.checkQuery("insert into Person(name) values(DEFAULT), (null)");
        this.checkQuery("insert into Person(name) values(DEFAULT),");
        this.checkQuery("insert into Person(name, parentName) values(DEFAULT, null), (?, ?)");
        this.checkQuery("insert into Person(old, name) values(5, 'John',), (6, 'Jack')");
        this.checkQuery("insert into Person(old, name) values(5 * 3, DEFAULT,)");
        this.checkQuery("insert into Person(old, name) values(ABS(-8), 'Max')");
        this.checkQuery("insert into Person(old, name) values(5, 'Jane'), (DEFAULT, DEFAULT), (6, 'Jill')");
        this.checkQuery("insert into Person(old, name, parentName) values(8 * 7, DEFAULT, 'Unknown')");
        this.checkQuery("insert into Person(old, name, parentName) values(2016 - 1828, CONCAT('Leo', 'Tolstoy'), CONCAT(?, 'Tolstoy')),(?, 'AlexanderPushkin', null),(ABS(1821 - 2016), CONCAT('Fyodor', null, UPPER(CONCAT(SQRT(?), 'dostoevsky'))), DEFAULT),");
        this.checkQuery("insert into Person(date, old, name, parentName, addrId) values ('20160112', 1233, 'Ivan Ivanov', 'Peter Ivanov', 123)");
        this.checkQuery("insert into Person(date, old, name, parentName, addrId) values (CURRENT_DATE(), RAND(), ASCII('Hi'), INSERT('Leo Tolstoy', 4, 4, 'Max'), ASCII('HI'))");
        this.checkQuery("insert into Person(date, old, name, parentName, addrId) values (TRUNCATE(TIMESTAMP '2015-12-31 23:59:59'), POWER(3,12), NULL, DEFAULT, DEFAULT)");
        this.checkQuery("insert into Person SET old = 5, name = 'John'");
        this.checkQuery("insert into Person SET name = CONCAT('Fyodor', null, UPPER(CONCAT(SQRT(?), 'dostoevsky'))), old = select (5, 6)");
        this.checkQuery("insert into Person(old, name) select ASCII(parentName), INSERT(parentName, 4, 4, 'Max') from Person where date='2011-03-12'");
        this.checkQuery("insert into Person(old, name) select old, parentName from Person");
        this.checkQuery("insert into Person(old, name) direct sorted select old, parentName from Person");
        this.checkQuery("insert into Person(old, name) sorted select old, parentName from Person where old > 5");
        this.checkQuery("insert into Person(old, name) select 5, 'John'");
        this.checkQuery("insert into Person(old, name) select p1.old, 'Name' from person p1 join person p2 on p2.name = p1.parentName where p2.old > 30");
        this.checkQuery("insert into Person(old) select 5 from Person UNION select street from sch2.Address limit ? offset ?");
    }

    public void testParseDelete() throws Exception {
        this.checkQuery("delete from Person");
        this.checkQuery("delete from Person p where p.old > ?");
        this.checkQuery("delete from Person where old in (select (40, 41, 42))");
        this.checkQuery("delete top 5 from Person where old in (select (40, 41, 42))");
        this.checkQuery("delete top ? from Person where old > 5 and length(name) < ?");
        this.checkQuery("delete from Person where name in ('Ivan', 'Peter') limit 20");
        this.checkQuery("delete from Person where name in ('Ivan', ?) limit ?");
    }

    public void testParseUpdate() throws Exception {
        this.checkQuery("update Person set name='Peter'");
        this.checkQuery("update Person per set name='Peter', old = 5");
        this.checkQuery("update Person p set name='Peter' limit 20");
        this.checkQuery("update Person p set name='Peter', old = length('zzz') limit 20");
        this.checkQuery("update Person p set name=DEFAULT, old = null limit ?");
        this.checkQuery("update Person p set name=? where old >= ? and old < ? limit ?");
        this.checkQuery("update Person p set name=(select a.Street from sch2.Address a where a.id=p.addrId), old = (select 42) where old = sqrt(?)");
        this.checkQuery("update Person p set (name, old) = (select 'Peter', 42)");
        this.checkQuery("update Person p set (name, old) = (select street, id from sch2.Address where id > 5 and id <= ?)");
    }

    public void testParseCreateIndex() throws Exception {
        this.assertCreateIndexEquals(GridQueryParsingTest.buildCreateIndex(null, "Person", "sch1", false, QueryIndexType.SORTED, "name", true), "create index on Person (name)");
        this.assertCreateIndexEquals(GridQueryParsingTest.buildCreateIndex("idx", "Person", "sch1", false, QueryIndexType.SORTED, "name", true), "create index idx on Person (name ASC)");
        this.assertCreateIndexEquals(GridQueryParsingTest.buildCreateIndex("idx", "Person", "sch1", false, QueryIndexType.GEOSPATIAL, "name", true), "create spatial index sch1.idx on sch1.Person (name ASC)");
        this.assertCreateIndexEquals(GridQueryParsingTest.buildCreateIndex("idx", "Person", "sch1", true, QueryIndexType.SORTED, "name", true), "create index if not exists sch1.idx on sch1.Person (name)");
        this.assertCreateIndexEquals(GridQueryParsingTest.buildCreateIndex("idx", "Person", "sch1", true, QueryIndexType.SORTED, "name", false), "create index if not exists idx on sch1.Person (name dEsC)");
        this.assertCreateIndexEquals(GridQueryParsingTest.buildCreateIndex("idx", "Person", "sch1", true, QueryIndexType.GEOSPATIAL, "old", true, "name", false), "create spatial index if not exists idx on Person (old, name desc)");
        this.assertParseThrows("create index if not exists sch2.idx on sch1.Person (name)", DbException.class, "Schema name must match");
        this.assertParseThrows("create hash index if not exists idx on Person (name)", IgniteSQLException.class, "Only SPATIAL modifier is supported for CREATE INDEX");
        this.assertParseThrows("create unique index if not exists idx on Person (name)", IgniteSQLException.class, "Only SPATIAL modifier is supported for CREATE INDEX");
        this.assertParseThrows("create primary key on Person (name)", IgniteSQLException.class, "Only SPATIAL modifier is supported for CREATE INDEX");
        this.assertParseThrows("create primary key hash on Person (name)", IgniteSQLException.class, "Only SPATIAL modifier is supported for CREATE INDEX");
        this.assertParseThrows("create index on Person (name nulls first)", IgniteSQLException.class, "NULLS FIRST and NULLS LAST modifiers are not supported for index columns");
        this.assertParseThrows("create index on Person (name desc nulls last)", IgniteSQLException.class, "NULLS FIRST and NULLS LAST modifiers are not supported for index columns");
    }

    public void testParseDropIndex() throws Exception {
        this.assertDropIndexEquals(GridQueryParsingTest.buildDropIndex("idx", "sch1", false), "drop index idx");
        this.assertDropIndexEquals(GridQueryParsingTest.buildDropIndex("idx", "sch1", true), "drop index if exists idx");
        this.assertDropIndexEquals(GridQueryParsingTest.buildDropIndex("idx", "sch1", true), "drop index if exists sch1.idx");
        this.assertDropIndexEquals(GridQueryParsingTest.buildDropIndex("idx", "sch1", false), "drop index sch1.idx");
        this.assertParseThrows("drop index schema2.", DbException.class, null);
        this.assertParseThrows("drop index", DbException.class, null);
        this.assertParseThrows("drop index if exists", DbException.class, null);
        this.assertParseThrows("drop index if exists schema2.", DbException.class, null);
    }

    private void assertParseThrows(final String sql, Class<? extends Exception> exCls, String msg) {
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Prepared p = GridQueryParsingTest.this.parse(sql);
                return new GridSqlQueryParser(false).parse(p);
            }
        }, exCls, (String)msg);
    }

    private void assertCreateIndexEquals(GridSqlCreateIndex exp, String sql) throws Exception {
        Object prepared = this.parse(sql);
        GridSqlStatement stmt = new GridSqlQueryParser(false).parse(prepared);
        GridQueryParsingTest.assertTrue((boolean)(stmt instanceof GridSqlCreateIndex));
        GridQueryParsingTest.assertCreateIndexEquals(exp, (GridSqlCreateIndex)stmt);
    }

    private void assertDropIndexEquals(GridSqlDropIndex exp, String sql) throws Exception {
        Object prepared = this.parse(sql);
        GridSqlStatement stmt = new GridSqlQueryParser(false).parse(prepared);
        GridQueryParsingTest.assertTrue((boolean)(stmt instanceof GridSqlDropIndex));
        GridQueryParsingTest.assertDropIndexEquals(exp, (GridSqlDropIndex)stmt);
    }

    private static void assertDropIndexEquals(GridSqlDropIndex exp, GridSqlDropIndex actual) {
        GridQueryParsingTest.assertEqualsIgnoreCase(exp.name(), actual.name());
        GridQueryParsingTest.assertEqualsIgnoreCase(exp.schemaName(), actual.schemaName());
        GridQueryParsingTest.assertEquals((boolean)exp.ifExists(), (boolean)actual.ifExists());
    }

    private static GridSqlDropIndex buildDropIndex(String name, String schema, boolean ifExists) {
        GridSqlDropIndex res = new GridSqlDropIndex();
        res.name(name);
        res.schemaName(schema);
        res.ifExists(ifExists);
        return res;
    }

    private static void assertCreateIndexEquals(GridSqlCreateIndex exp, GridSqlCreateIndex actual) {
        GridQueryParsingTest.assertEquals((boolean)exp.ifNotExists(), (boolean)actual.ifNotExists());
        GridQueryParsingTest.assertEqualsIgnoreCase(exp.schemaName(), actual.schemaName());
        GridQueryParsingTest.assertEqualsIgnoreCase(exp.tableName(), actual.tableName());
        GridQueryParsingTest.assertEqualsIgnoreCase(exp.index().getName(), actual.index().getName());
        Iterator expFldsIt = exp.index().getFields().entrySet().iterator();
        Iterator actualFldsIt = actual.index().getFields().entrySet().iterator();
        while (expFldsIt.hasNext()) {
            GridQueryParsingTest.assertTrue((boolean)actualFldsIt.hasNext());
            Map.Entry expEntry = expFldsIt.next();
            Map.Entry actualEntry = actualFldsIt.next();
            GridQueryParsingTest.assertEqualsIgnoreCase((String)expEntry.getKey(), (String)actualEntry.getKey());
            GridQueryParsingTest.assertEquals(expEntry.getValue(), actualEntry.getValue());
        }
        GridQueryParsingTest.assertFalse((boolean)actualFldsIt.hasNext());
        GridQueryParsingTest.assertEquals((Object)exp.index().getIndexType(), (Object)actual.index().getIndexType());
    }

    private static void assertEqualsIgnoreCase(String exp, String actual) {
        GridQueryParsingTest.assertEquals((exp == null ? 1 : 0) != 0, (actual == null ? 1 : 0) != 0);
        if (exp != null) {
            GridQueryParsingTest.assertTrue((boolean)exp.equalsIgnoreCase(actual));
        }
    }

    private static GridSqlCreateIndex buildCreateIndex(String name, String tblName, String schemaName, boolean ifNotExists, QueryIndexType type, Object ... flds) {
        QueryIndex idx = new QueryIndex();
        idx.setName(name);
        assert (!F.isEmpty((Object[])flds) && flds.length % 2 == 0);
        LinkedHashMap<String, Boolean> trueFlds = new LinkedHashMap<String, Boolean>();
        for (int i = 0; i < flds.length / 2; ++i) {
            trueFlds.put((String)flds[i * 2], (Boolean)flds[i * 2 + 1]);
        }
        idx.setFields(trueFlds);
        idx.setIndexType(type);
        GridSqlCreateIndex res = new GridSqlCreateIndex();
        res.schemaName(schemaName);
        res.tableName(tblName);
        res.ifNotExists(ifNotExists);
        res.index(idx);
        return res;
    }

    private JdbcConnection connection() throws Exception {
        GridKernalContext ctx = ((IgniteEx)ignite).context();
        GridQueryProcessor qryProcessor = ctx.query();
        IgniteH2Indexing idx = (IgniteH2Indexing)U.field((Object)qryProcessor, (String)"idx");
        return (JdbcConnection)idx.connectionForSpace("default");
    }

    private <T extends Prepared> T parse(String sql) throws Exception {
        Session ses = (Session)this.connection().getSession();
        return (T)ses.prepare(sql);
    }

    private void assertSqlEquals(String sql1, String sql2) {
        String nsql1 = GridQueryParsingTest.normalizeSql(sql1);
        String nsql2 = GridQueryParsingTest.normalizeSql(sql2);
        GridQueryParsingTest.assertEquals((String)nsql1, (String)nsql2);
    }

    private static String normalizeSql(String sql) {
        return sql.toLowerCase().replaceAll("/\\*(?:.|\r|\n)*?\\*/", " ").replaceAll("\\s*on\\s+1\\s*=\\s*1\\s*", " on true ").replaceAll("\\s+", " ").replaceAll("\\( +", "(").replaceAll(" +\\)", ")").trim();
    }

    private void checkQuery(String qry) throws Exception {
        Object prepared = this.parse(qry);
        GridSqlStatement gQry = new GridSqlQueryParser(false).parse(prepared);
        String res = gQry.getSQL();
        System.out.println(GridQueryParsingTest.normalizeSql(res));
        this.assertSqlEquals((String)U.firstNotNull((Object[])new String[]{prepared.getPlanSQL(), prepared.getSQL()}), res);
    }

    @QuerySqlFunction
    public static int cool1() {
        return 1;
    }

    @QuerySqlFunction
    public static ResultSet table0(Connection c, String a, int b) throws SQLException {
        return c.createStatement().executeQuery("select '" + a + "' as a, " + b + " as b");
    }

    public static class Address
    implements Serializable {
        @QuerySqlField(index=true)
        public int id;
        @QuerySqlField(index=true)
        public int streetNumber;
        @QuerySqlField(index=true)
        public String street = "Nevskiy";
    }

    public static class Person
    implements Serializable {
        @QuerySqlField(index=true)
        public Date date = new Date(System.currentTimeMillis());
        @QuerySqlField(index=true)
        public String name = "Ivan";
        @QuerySqlField(index=true)
        public String parentName;
        @QuerySqlField(index=true)
        public int addrId;
        @QuerySqlField
        public Integer[] addrIds;
        @QuerySqlField(index=true)
        public int old;
    }
}

