/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityKey;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.query.h2.sql.AbstractH2CompareQueryTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testsuites.IgniteIgnore;

public class BaseH2CompareQueryTest
extends AbstractH2CompareQueryTest {
    public static final int ORG_CNT = 30;
    public static final int ADDR_CNT = 10;
    public static final int PERS_CNT = 50;
    public static final int PROD_CNT = 100;
    public static final int PURCH_CNT = 500;
    private static IgniteCache<Integer, Organization> cacheOrg;
    private static IgniteCache<AffinityKey, Person> cachePers;
    private static IgniteCache<AffinityKey, Purchase> cachePurch;
    private static IgniteCache<Integer, Product> cacheProd;
    private static IgniteCache<Integer, Address> cacheAddr;

    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration("org", CacheMode.PARTITIONED, Integer.class, Organization.class), this.cacheConfiguration("pers", CacheMode.PARTITIONED, AffinityKey.class, Person.class), this.cacheConfiguration("purch", CacheMode.PARTITIONED, AffinityKey.class, Purchase.class), this.cacheConfiguration("prod", CacheMode.REPLICATED, Integer.class, Product.class), this.cacheConfiguration("addr", CacheMode.REPLICATED, Integer.class, Address.class)});
        return cfg;
    }

    @Override
    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        cacheOrg = null;
        cachePers = null;
        cachePurch = null;
        cacheProd = null;
        cacheAddr = null;
    }

    @Override
    protected void createCaches() {
        cacheOrg = this.jcache(ignite, this.cacheConfiguration("org", CacheMode.PARTITIONED, Integer.class, Organization.class), "org", Integer.class, Organization.class);
        cachePers = ignite.cache("pers");
        cachePurch = ignite.cache("purch");
        cacheProd = ignite.cache("prod");
        cacheAddr = ignite.cache("addr");
    }

    @Override
    protected void initCacheAndDbData() throws SQLException {
        int i;
        int idGen = 0;
        ArrayList<Organization> organizations = new ArrayList<Organization>();
        for (int i2 = 0; i2 < 30; ++i2) {
            int id = idGen++;
            Organization org = new Organization(id, "Org" + id);
            organizations.add(org);
            cacheOrg.put((Object)org.id, (Object)org);
            this.insertInDb(org);
        }
        ArrayList<Address> addreses = new ArrayList<Address>();
        for (int i3 = 0; i3 < 10; ++i3) {
            int id = idGen++;
            Address addr = new Address(id, "Addr" + id);
            addreses.add(addr);
            cacheAddr.put((Object)addr.id, (Object)addr);
            this.insertInDb(addr);
        }
        ArrayList<Person> persons = new ArrayList<Person>();
        for (int i4 = 0; i4 < 50; ++i4) {
            int id = idGen++;
            Person person = new Person(id, (Organization)organizations.get(i4 % organizations.size()), "name" + id, "lastName" + id, (double)id * 100.0, (Address)addreses.get(i4 % addreses.size()));
            if (id == organizations.size() + 1) {
                person.lastName = null;
            }
            persons.add(person);
            cachePers.put(person.key(), (Object)person);
            this.insertInDb(person);
        }
        ArrayList<Product> products = new ArrayList<Product>();
        for (i = 0; i < 100; ++i) {
            int id = idGen++;
            Product product = new Product(id, "Product" + id, id * 1000);
            products.add(product);
            cacheProd.put((Object)product.id, (Object)product);
            this.insertInDb(product);
        }
        for (i = 0; i < 500; ++i) {
            int id = idGen++;
            Person person = (Person)persons.get(i % persons.size());
            Purchase purchase = new Purchase(id, (Product)products.get(i % products.size()), person.orgId, person);
            cachePurch.put(purchase.key(), (Object)purchase);
            this.insertInDb(purchase);
        }
    }

    @Override
    protected void checkAllDataEquals() throws Exception {
        this.compareQueryRes0(cacheOrg, "select _key, _val, id, name from \"org\".Organization", new Object[0]);
        this.compareQueryRes0(cachePers, "select _key, _val, id, firstName, lastName, orgId, salary from \"pers\".Person", new Object[0]);
        this.compareQueryRes0(cachePurch, "select _key, _val, id, personId, productId, organizationId from \"purch\".Purchase", new Object[0]);
        this.compareQueryRes0(cacheProd, "select _key, _val, id, name, price from \"prod\".Product", new Object[0]);
    }

    public void testSelectStar() {
        BaseH2CompareQueryTest.assertEquals((int)1, (int)cachePers.query((Query)new SqlQuery(Person.class, "\t\r\n  select  \n*\t from Person limit 1")).getAll().size());
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                cachePers.query((Query)new SqlQuery(Person.class, "SELECT firstName from PERSON"));
                return null;
            }
        }, CacheException.class, null);
    }

    public void testInvalidQuery() throws Exception {
        final SqlFieldsQuery sql = new SqlFieldsQuery("SELECT firstName from Person where id <> ? and orgId <> ?");
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                cachePers.query((Query)sql.setArgs(new Object[]{3}));
                return null;
            }
        }, IgniteException.class, (String)"Invalid number of query parameters.");
    }

    @IgniteIgnore(value="https://issues.apache.org/jira/browse/IGNITE-705", forceFailure=true)
    public void testAllExamples() throws Exception {
        String addStreet = "Addr301";
        List<List<?>> res = this.compareQueryRes0(cachePers, "select avg(old) from \"pers\".Person left join \"addr\".Address  on Person.addrId = Address.id where lower(Address.street) = lower(?)", "Addr301");
        BaseH2CompareQueryTest.assertNotSame((Object)0, res);
        this.compareQueryRes0(cachePers, "select avg(old) from \"pers\".Person join \"addr\".Address on Person.addrId = Address.id where lower(Address.street) = lower(?)", "Addr301");
        this.compareQueryRes0(cachePers, "select avg(old) from \"pers\".Person left join \"addr\".Address where Person.addrId = Address.id and lower(Address.street) = lower(?)", "Addr301");
        this.compareQueryRes0(cachePers, "select avg(old) from \"pers\".Person, \"addr\".Address where Person.addrId = Address.id and lower(Address.street) = lower(?)", "Addr301");
        this.compareQueryRes0(cachePers, "select firstName, date from \"pers\".Person", new Object[0]);
        this.compareQueryRes0(cachePers, "select distinct firstName, date from \"pers\".Person", new Object[0]);
        String star = " _key, _val, id, firstName, lastName, orgId, salary, addrId, old, date ";
        this.compareQueryRes0(cachePers, "select  _key, _val, id, firstName, lastName, orgId, salary, addrId, old, date  from \"pers\".Person p", new Object[0]);
        this.compareQueryRes0(cachePers, "select  _key, _val, id, firstName, lastName, orgId, salary, addrId, old, date  from \"pers\".Person", new Object[0]);
        this.compareQueryRes0(cachePers, "select distinct  _key, _val, id, firstName, lastName, orgId, salary, addrId, old, date  from \"pers\".Person", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName, date from \"pers\".Person p", new Object[0]);
        this.compareQueryRes0(cachePers, "select p._key, p._val, p.id, p.firstName, p.lastName, p.orgId, p.salary, p.addrId, p.old,  p.date, a._key, a._val, a.id, a.street from \"pers\".Person p, \"addr\".Address a", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName, a.street from \"pers\".Person p, \"addr\".Address a", new Object[0]);
        this.compareQueryRes0(cachePers, "select distinct p.firstName, a.street from \"pers\".Person p, \"addr\".Address a", new Object[0]);
        this.compareQueryRes0(cachePers, "select distinct firstName, street from \"pers\".Person, \"addr\".Address group by firstName, street ", new Object[0]);
        this.compareQueryRes0(cachePers, "select distinct firstName, street from \"pers\".Person, \"addr\".Address", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName, 1 as i, 'aaa' s from \"pers\".Person p", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName from \"pers\".Person p where firstName <> 'ivan'", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName from \"pers\".Person p where firstName like 'i%'", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName from \"pers\".Person p where firstName regexp 'i%'", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName from \"pers\".Person p, \"addr\".Address a where p.firstName <> 'ivan' and a.id > 10 or not (a.id = 100)", new Object[0]);
        this.compareQueryRes0(cachePers, "select case p.firstName when 'a' then 1 when 'a' then 2 end as a from \"pers\".Person p", new Object[0]);
        this.compareQueryRes0(cachePers, "select case p.firstName when 'a' then 1 when 'a' then 2 else -1 end as a from \"pers\".Person p", new Object[0]);
        this.compareQueryRes0(cachePers, "select abs(p.old) from \"pers\".Person p", new Object[0]);
        this.compareQueryRes0(cachePers, "select cast(p.old as numeric(10, 2)) from \"pers\".Person p", new Object[0]);
        this.compareQueryRes0(cachePers, "select cast(p.old as numeric(10, 2)) z from \"pers\".Person p", new Object[0]);
        this.compareQueryRes0(cachePers, "select cast(p.old as numeric(10, 2)) as z from \"pers\".Person p", new Object[0]);
        this.compareQueryRes0(cachePers, "select  _key, _val, id, firstName, lastName, orgId, salary, addrId, old, date  from \"pers\".Person p where p.firstName in ('a', 'b', 'c')", new Object[0]);
        this.compareQueryRes0(cachePers, "select  _key, _val, id, firstName, lastName, orgId, salary, addrId, old, date  from \"pers\".Person p where p.firstName in (select a.street from \"addr\".Address a)", new Object[0]);
        this.compareQueryRes0(cachePers, "select (select a.street from \"addr\".Address a where a.id = p.addrId) from \"pers\".Person p", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName, ? from \"pers\".Person p where firstName regexp ? and p.old < ?", 10, "Iv*n", 40);
        this.compareQueryRes0(cachePers, "select count(*) as a from \"pers\".Person", new Object[0]);
        this.compareQueryRes0(cachePers, "select count(*) as a, count(p.*), count(p.firstName) from \"pers\".Person p", new Object[0]);
        this.compareQueryRes0(cachePers, "select count(distinct p.firstName) from \"pers\".Person p", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName, avg(p.old), max(p.old) from \"pers\".Person p group by p.firstName", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName n, avg(p.old) a, max(p.old) m from \"pers\".Person p group by p.firstName", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName n, avg(p.old) a, max(p.old) m from \"pers\".Person p group by n", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName n, avg(p.old) a, max(p.old) m from \"pers\".Person p group by p.addrId, p.firstName", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName n, avg(p.old) a, max(p.old) m from \"pers\".Person p group by p.firstName, p.addrId", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName n, max(p.old) + min(p.old) / count(distinct p.old) from \"pers\".Person p group by p.firstName", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName n, max(p.old) maxOld, min(p.old) minOld from \"pers\".Person p group by p.firstName having maxOld > 10 and min(p.old) < 1", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName n, avg(p.old) a, max(p.old) m from \"pers\".Person p group by p.firstName order by n", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName n, avg(p.old) a, max(p.old) m from \"pers\".Person p group by p.firstName order by p.firstName", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName n, avg(p.old) a, max(p.old) m from \"pers\".Person p group by p.firstName order by p.firstName, m", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName n, avg(p.old) a, max(p.old) m from \"pers\".Person p group by p.firstName order by p.firstName, max(p.old) desc", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName n, avg(p.old) a, max(p.old) m from \"pers\".Person p group by p.firstName order by p.firstName nulls first", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName n, avg(p.old) a, max(p.old) m from \"pers\".Person p group by p.firstName order by p.firstName nulls last", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName n from \"pers\".Person p order by p.old + 10", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName n from \"pers\".Person p order by p.old + 10, p.firstName", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName n from \"pers\".Person p order by p.old + 10, p.firstName desc", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName n from \"pers\".Person p, (select a.street from \"addr\".Address a where a.street is not null)", new Object[0]);
        this.compareQueryRes0(cachePers, "select street from \"pers\".Person p, (select a.street from \"addr\".Address a where a.street is not null) ", new Object[0]);
        this.compareQueryRes0(cachePers, "select addr.street from \"pers\".Person p, (select a.street from \"addr\".Address a where a.street is not null) addr", new Object[0]);
        this.compareQueryRes0(cachePers, "select p.firstName n from \"pers\".Person p order by p.old + 10", new Object[0]);
        this.compareQueryRes0(cachePers, "select 'foo' as bar union select 'foo' as bar", new Object[0]);
        this.compareQueryRes0(cachePers, "select 'foo' as bar union all select 'foo' as bar", new Object[0]);
    }

    public void testParamSubstitution() throws Exception {
        this.compareQueryRes0(cachePers, "select ? from \"pers\".Person", "Some arg");
    }

    public void testAggregateOrderBy() throws SQLException {
        this.compareOrderedQueryRes0(cachePers, "select firstName name, count(*) cnt from \"pers\".Person group by name order by cnt, name desc", new Object[0]);
    }

    public void testNullParamSubstitution() throws Exception {
        List<List<?>> rs1 = this.compareQueryRes0(cachePers, "select ? from \"pers\".Person", null);
        BaseH2CompareQueryTest.assertFalse((boolean)rs1.isEmpty());
    }

    public void testUnion() throws SQLException {
        String base = "select _val v from \"pers\".Person";
        this.compareQueryRes0(cachePers, base + " union all " + base, new Object[0]);
        this.compareQueryRes0(cachePers, base + " union " + base, new Object[0]);
        base = "select firstName||lastName name, salary from \"pers\".Person";
        BaseH2CompareQueryTest.assertEquals((int)100, (int)this.compareOrderedQueryRes0(cachePers, base + " union all " + base + " order by salary desc", new Object[0]).size());
        BaseH2CompareQueryTest.assertEquals((int)50, (int)this.compareOrderedQueryRes0(cachePers, base + " union " + base + " order by salary desc", new Object[0]).size());
    }

    public void testEmptyResult() throws Exception {
        this.compareQueryRes0(cachePers, "select id from \"pers\".Person where 0 = 1", new Object[0]);
    }

    public void testSqlQueryWithAggregation() throws Exception {
        this.compareQueryRes0(cachePers, "select avg(salary) from \"pers\".Person, \"org\".Organization where Person.orgId = Organization.id and lower(Organization.name) = lower(?)", "Org1");
    }

    public void testSqlFieldsQuery() throws Exception {
        this.compareQueryRes0(cachePers, "select concat(firstName, ' ', lastName) from \"pers\".Person", new Object[0]);
    }

    public void testSqlFieldsQueryWithJoin() throws Exception {
        this.compareQueryRes0(cachePers, "select concat(firstName, ' ', lastName), Organization.name from \"pers\".Person, \"org\".Organization where Person.orgId = Organization.id", new Object[0]);
    }

    public void testOrdered() throws Exception {
        this.compareOrderedQueryRes0(cachePers, "select firstName, lastName from \"pers\".Person order by lastName, firstName", new Object[0]);
    }

    public void testSimpleJoin() throws Exception {
        this.compareQueryRes0(cachePers, String.format("select id, firstName, lastName  from \"%s\".Person  where Person.id = ?", cachePers.getName()), 3);
        this.compareQueryRes0(cachePers, "select pe.firstName  from \"pers\".Person pe join \"purch\".Purchase pu on pe.id = pu.personId   where pe.id = ?", 3);
    }

    public void testSimpleReplicatedSelect() throws Exception {
        this.compareQueryRes0(cacheProd, "select id, name from \"prod\".Product", new Object[0]);
    }

    public void testCrossCache() throws Exception {
        this.compareQueryRes0(cachePers, "select firstName, lastName  from \"pers\".Person, \"purch\".Purchase  where Person.id = Purchase.personId", new Object[0]);
        this.compareQueryRes0(cachePers, "select concat(firstName, ' ', lastName), Product.name   from \"pers\".Person, \"purch\".Purchase, \"prod\".Product   where Person.id = Purchase.personId and Purchase.productId = Product.id  group by Product.id", new Object[0]);
        this.compareQueryRes0(cachePers, "select concat(firstName, ' ', lastName), count (Product.id)   from \"pers\".Person, \"purch\".Purchase, \"prod\".Product   where Person.id = Purchase.personId and Purchase.productId = Product.id  group by Product.id", new Object[0]);
    }

    @Override
    protected Statement initializeH2Schema() throws SQLException {
        Statement st = super.initializeH2Schema();
        st.execute("CREATE SCHEMA \"org\"");
        st.execute("CREATE SCHEMA \"pers\"");
        st.execute("CREATE SCHEMA \"prod\"");
        st.execute("CREATE SCHEMA \"purch\"");
        st.execute("CREATE SCHEMA \"addr\"");
        st.execute("create table \"org\".ORGANIZATION  (_key int not null,  _val other not null,  id int unique,  name varchar(255))");
        st.execute("create table \"pers\".PERSON  (_key other not null ,   _val other not null ,  id int unique,   firstName varchar(255),   lastName varchar(255),  orgId int not null,  salary double,  addrId int,  old int,  date Date )");
        st.execute("create table \"prod\".PRODUCT  (_key int not null ,   _val other not null ,  id int unique,   name varchar(255),   price int)");
        st.execute("create table \"purch\".PURCHASE  (_key other not null ,   _val other not null ,  id int unique,   personId int,   organizationId int,   productId int)");
        st.execute("create table \"addr\".ADDRESS  (_key int not null ,   _val other not null ,  id int unique,   street varchar(255))");
        conn.commit();
        return st;
    }

    private void insertInDb(Organization org) throws SQLException {
        try (PreparedStatement st = conn.prepareStatement("insert into \"org\".ORGANIZATION (_key, _val, id, name) values(?, ?, ?, ?)");){
            st.setObject(1, org.id);
            st.setObject(2, org);
            st.setObject(3, org.id);
            st.setObject(4, org.name);
            st.executeUpdate();
        }
    }

    private void insertInDb(Person p) throws SQLException {
        try (PreparedStatement st = conn.prepareStatement("insert into \"pers\".PERSON (_key, _val, id, firstName, lastName, orgId, salary, addrId, old, date) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            st.setObject(1, p.key());
            st.setObject(2, p);
            st.setObject(3, p.id);
            st.setObject(4, p.firstName);
            st.setObject(5, p.lastName);
            st.setObject(6, p.orgId);
            st.setObject(7, p.salary);
            st.setObject(8, p.addrId);
            st.setObject(9, p.old);
            st.setObject(10, p.date);
            st.executeUpdate();
        }
    }

    private void insertInDb(Product p) throws SQLException {
        try (PreparedStatement st = conn.prepareStatement("insert into \"prod\".PRODUCT (_key, _val, id, name, price) values(?, ?, ?, ?, ?)");){
            st.setObject(1, p.id);
            st.setObject(2, p);
            st.setObject(3, p.id);
            st.setObject(4, p.name);
            st.setObject(5, p.price);
            st.executeUpdate();
        }
    }

    private void insertInDb(Purchase p) throws SQLException {
        try (PreparedStatement st = conn.prepareStatement("insert into \"purch\".PURCHASE (_key, _val, id, personId, productId, organizationId) values(?, ?, ?, ?, ?, ?)");){
            st.setObject(1, p.key());
            st.setObject(2, p);
            st.setObject(3, p.id);
            st.setObject(4, p.personId);
            st.setObject(5, p.productId);
            st.setObject(6, p.organizationId);
            st.executeUpdate();
        }
    }

    private void insertInDb(Address a) throws SQLException {
        try (PreparedStatement st = conn.prepareStatement("insert into \"addr\".ADDRESS (_key, _val, id, street) values(?, ?, ?, ?)");){
            st.setObject(1, a.id);
            st.setObject(2, a);
            st.setObject(3, a.id);
            st.setObject(4, a.street);
            st.executeUpdate();
        }
    }

    @QuerySqlFunction
    public static int cool1() {
        return 1;
    }

    @QuerySqlFunction
    public static ResultSet table0(Connection c, String a, int b) throws SQLException {
        return c.createStatement().executeQuery("select '" + a + "' as a, " + b + " as b");
    }

    private static class Address
    implements Serializable {
        @QuerySqlField(index=true)
        private int id;
        @QuerySqlField(index=true)
        private String street;

        Address(int id, String street) {
            this.id = id;
            this.street = street;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Address && this.id == ((Address)o).id;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return "Address [id=" + this.id + ", street=" + this.street + ']';
        }
    }

    private static class Purchase
    implements Serializable {
        @QuerySqlField(index=true)
        private int id;
        @QuerySqlField
        private int productId;
        @QuerySqlField
        private int personId;
        @QuerySqlField
        private int organizationId;

        Purchase(int id, Product product, int organizationId, Person person) {
            this.id = id;
            this.productId = product.id;
            this.personId = person.id;
            this.organizationId = organizationId;
        }

        public AffinityKey<Integer> key() {
            return new AffinityKey((Object)this.id, (Object)this.organizationId);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Purchase && this.id == ((Purchase)o).id;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return "Purchase [id=" + this.id + ", productId=" + this.productId + ", personId=" + this.personId + ']';
        }
    }

    private static class Product
    implements Serializable {
        @QuerySqlField(index=true)
        private int id;
        @QuerySqlField
        private String name;
        @QuerySqlField
        private int price;

        Product(int id, String name, int price) {
            this.id = id;
            this.name = name;
            this.price = price;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Product && this.id == ((Product)o).id;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return "Product [id=" + this.id + ", name=" + this.name + ", price=" + this.price + ']';
        }
    }

    private static class Organization
    implements Serializable {
        @QuerySqlField(index=true)
        private int id;
        @QuerySqlField(index=true)
        private String name;

        Organization(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Organization && this.id == ((Organization)o).id;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return "Organization [id=" + this.id + ", name=" + this.name + ']';
        }
    }

    private static class Person
    implements Serializable {
        @QuerySqlField(index=true)
        private int id;
        @QuerySqlField(index=true)
        private int orgId;
        @QuerySqlField
        private String firstName;
        @QuerySqlField
        private String lastName;
        @QuerySqlField(index=true)
        private double salary;
        @QuerySqlField(index=true)
        private int addrId;
        @QuerySqlField(index=true)
        public Date date = new Date(System.currentTimeMillis());
        @QuerySqlField(index=true)
        public int old = 17;

        Person(int id, Organization org, String firstName, String lastName, double salary, Address addr) {
            this.id = id;
            this.firstName = firstName;
            this.lastName = lastName;
            this.salary = salary;
            this.orgId = org.id;
            this.addrId = addr.id;
        }

        public AffinityKey<Integer> key() {
            return new AffinityKey((Object)this.id, (Object)this.orgId);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Person && this.id == ((Person)o).id;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return "Person [firstName=" + this.firstName + ", lastName=" + this.lastName + ", id=" + this.id + ", orgId=" + this.orgId + ", salary=" + this.salary + ", addrId=" + this.addrId + ']';
        }
    }
}

