/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowFactory;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2TreeIndex;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.value.Value;
import org.h2.value.ValueLong;
import org.h2.value.ValueString;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;
import org.jetbrains.annotations.Nullable;

public class GridH2TableSelfTest
extends GridCommonAbstractTest {
    private static final long MAX_X = 2000L;
    private static final String DB_URL = "jdbc:h2:mem:gg_table_engine;MULTI_THREADED=1;OPTIMIZE_REUSE_RESULTS=0;QUERY_CACHE_SIZE=0;RECOMPILE_ALWAYS=1";
    private static final String CREATE_TABLE_SQL = "CREATE TABLE T(ID UUID, T TIMESTAMP, STR VARCHAR, X BIGINT)";
    private static final String PK_NAME = "__GG_PK_";
    private static final String HASH = "__GG_HASH";
    private static final String STR_IDX_NAME = "__GG_IDX_";
    private static final String NON_UNIQUE_IDX_NAME = "__GG_IDX_";
    private static final String SCAN_IDX_NAME = "__SCAN_";
    private Connection conn;
    private GridH2Table tbl;

    protected void beforeTest() throws Exception {
    }

    protected void afterTest() throws Exception {
        this.conn.close();
        this.conn = null;
        this.tbl = null;
    }

    private GridH2Row row(UUID id, long t, String str, long x) {
        return GridH2RowFactory.create((Value[])new Value[]{ValueUuid.get((long)id.getMostSignificantBits(), (long)id.getLeastSignificantBits()), ValueTimestamp.get((Timestamp)new Timestamp(t)), ValueString.get((String)str), ValueLong.get((long)x)});
    }

    public void testTable() throws Exception {
        long x = 2000L;
        Random rnd = new Random();
        while (x-- > 0L) {
            UUID id = UUID.randomUUID();
            GridH2Row row = this.row(id, System.currentTimeMillis(), rnd.nextBoolean() ? id.toString() : UUID.randomUUID().toString(), rnd.nextInt(100));
            this.tbl.doUpdate(row, false);
        }
        GridH2TableSelfTest.assertEquals((long)2000L, (long)this.tbl.getRowCountApproximation());
        GridH2TableSelfTest.assertEquals((long)2000L, (long)this.tbl.getRowCount(null));
        for (GridH2IndexBase idx : this.tbl.indexes()) {
            GridH2TableSelfTest.assertEquals((long)2000L, (long)idx.getRowCountApproximation());
            GridH2TableSelfTest.assertEquals((long)2000L, (long)idx.getRowCount(null));
        }
        this.checkOrdered((GridH2TreeIndex)this.tbl.indexes().get(0), (Comparator<? super GridH2Row>)new Comparator<SearchRow>(){

            @Override
            public int compare(SearchRow o1, SearchRow o2) {
                UUID id1 = (UUID)o1.getValue(0).getObject();
                UUID id2 = (UUID)o2.getValue(0).getObject();
                return id1.compareTo(id2);
            }
        });
        this.checkOrdered((GridH2TreeIndex)this.tbl.indexes().get(1), (Comparator<? super GridH2Row>)new Comparator<SearchRow>(){

            @Override
            public int compare(SearchRow o1, SearchRow o2) {
                Long x1 = (Long)o1.getValue(3).getObject();
                Long x2 = (Long)o2.getValue(3).getObject();
                int c = x2.compareTo(x1);
                if (c != 0) {
                    return c;
                }
                Timestamp t1 = (Timestamp)o1.getValue(1).getObject();
                Timestamp t2 = (Timestamp)o2.getValue(1).getObject();
                return t1.compareTo(t2);
            }
        });
        this.checkOrdered((GridH2TreeIndex)this.tbl.indexes().get(2), (Comparator<? super GridH2Row>)new Comparator<SearchRow>(){

            @Override
            public int compare(SearchRow o1, SearchRow o2) {
                String s1 = (String)o1.getValue(2).getObject();
                String s2 = (String)o2.getValue(2).getObject();
                return s2.compareTo(s1);
            }
        });
        ArrayList idxs = this.tbl.indexes();
        this.checkIndexesConsistent(idxs, null);
        UUID id = UUID.randomUUID();
        UUID id2 = UUID.randomUUID();
        GridH2TableSelfTest.assertTrue((boolean)this.tbl.doUpdate(this.row(id, System.currentTimeMillis(), id.toString(), rnd.nextInt(100)), false));
        GridH2TableSelfTest.assertTrue((boolean)this.tbl.doUpdate(this.row(id2, System.currentTimeMillis(), id2.toString(), rnd.nextInt(100)), false));
        this.checkQueryPlan(this.conn, "SELECT * FROM T", SCAN_IDX_NAME);
        this.checkQueryPlan(this.conn, "SELECT * FROM T WHERE ID IS NULL", PK_NAME);
        this.checkQueryPlan(this.conn, "SELECT * FROM T WHERE ID = RANDOM_UUID()", PK_NAME);
        this.checkQueryPlan(this.conn, "SELECT * FROM T WHERE ID > RANDOM_UUID()", PK_NAME);
        this.checkQueryPlan(this.conn, "SELECT * FROM T ORDER BY ID", PK_NAME);
        this.checkQueryPlan(this.conn, "SELECT * FROM T WHERE STR IS NULL", "__GG_IDX_");
        this.checkQueryPlan(this.conn, "SELECT * FROM T WHERE STR = 'aaaa'", "__GG_IDX_");
        this.checkQueryPlan(this.conn, "SELECT * FROM T WHERE STR > 'aaaa'", "__GG_IDX_");
        this.checkQueryPlan(this.conn, "SELECT * FROM T ORDER BY STR DESC", "__GG_IDX_");
        this.checkQueryPlan(this.conn, "SELECT * FROM T WHERE X IS NULL", "__GG_IDX_");
        this.checkQueryPlan(this.conn, "SELECT * FROM T WHERE X = 10000", "__GG_IDX_");
        this.checkQueryPlan(this.conn, "SELECT * FROM T WHERE X > 10000", "__GG_IDX_");
        this.checkQueryPlan(this.conn, "SELECT * FROM T ORDER BY X DESC", "__GG_IDX_");
        this.checkQueryPlan(this.conn, "SELECT * FROM T ORDER BY X DESC, T", "__GG_IDX_");
        this.checkQueryPlan(this.conn, "SELECT * FROM T ORDER BY T, X DESC", SCAN_IDX_NAME);
        Statement s = this.conn.createStatement();
        ResultSet rs = s.executeQuery("select id from t where x between 0 and 100");
        int i = 0;
        while (rs.next()) {
            ++i;
        }
        GridH2TableSelfTest.assertEquals((long)2002L, (long)i);
        rs = s.executeQuery("select id from t where t is not null");
        i = 0;
        while (rs.next()) {
            ++i;
        }
        GridH2TableSelfTest.assertEquals((long)2002L, (long)i);
        int cnt = 10 + rnd.nextInt(25);
        long t = System.currentTimeMillis();
        for (i = 0; i < cnt; ++i) {
            id = UUID.randomUUID();
            GridH2TableSelfTest.assertTrue((boolean)this.tbl.doUpdate(this.row(id, t, id.toString(), 51L), false));
        }
        rs = s.executeQuery("select x, id from t where x = 51 limit " + cnt);
        i = 0;
        while (rs.next()) {
            GridH2TableSelfTest.assertEquals((int)51, (int)rs.getInt(1));
            ++i;
        }
        GridH2TableSelfTest.assertEquals((int)cnt, (int)i);
    }

    public void testRangeQuery() throws Exception {
        int rows = 3000;
        int xs = 37;
        long t = System.currentTimeMillis();
        Random rnd = new Random();
        for (int i = 0; i < rows; ++i) {
            UUID id = UUID.randomUUID();
            GridH2Row row = this.row(id, t++, id.toString(), rnd.nextInt(xs));
            GridH2TableSelfTest.assertTrue((boolean)this.tbl.doUpdate(row, false));
        }
        PreparedStatement ps = this.conn.prepareStatement("select count(*) from t where x = ?");
        int cnt = 0;
        for (int x = 0; x < xs; ++x) {
            ps.setInt(1, x);
            ResultSet rs = ps.executeQuery();
            GridH2TableSelfTest.assertTrue((boolean)rs.next());
            cnt += rs.getInt(1);
        }
        GridH2TableSelfTest.assertEquals((int)rows, (int)cnt);
    }

    public void testDataLoss() throws Exception {
        ResultSet rs;
        int threads = 37;
        int iterations = 15000;
        final AtomicInteger cntr = new AtomicInteger();
        final UUID[] ids = new UUID[555000];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = UUID.randomUUID();
        }
        final long t = System.currentTimeMillis();
        final AtomicInteger deleted = new AtomicInteger();
        this.multithreaded(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                GridH2Row row;
                int x;
                UUID id;
                int i;
                Random rnd = new Random();
                int offset = cntr.getAndIncrement() * 15000;
                UUID uUID = ids[offset];
                synchronized (uUID) {
                    for (i = 0; i < 15000; ++i) {
                        id = ids[offset + i];
                        x = rnd.nextInt(50);
                        row = GridH2TableSelfTest.this.row(id, t, id.toString(), x);
                        TestCase.assertTrue((boolean)GridH2TableSelfTest.this.tbl.doUpdate(row, false));
                    }
                }
                offset = (offset + 15000) % ids.length;
                uUID = ids[offset];
                synchronized (uUID) {
                    for (i = 0; i < 15000; i += 2) {
                        id = ids[offset + i];
                        x = rnd.nextInt(50);
                        row = GridH2TableSelfTest.this.row(id, t, id.toString(), x);
                        if (!GridH2TableSelfTest.this.tbl.doUpdate(row, true)) continue;
                        deleted.incrementAndGet();
                    }
                }
                return null;
            }
        }, 37);
        GridH2TableSelfTest.assertTrue((deleted.get() > 0 ? 1 : 0) != 0);
        PreparedStatement p = this.conn.prepareStatement("select count(*) from t where id = ?");
        for (int i = 1; i < ids.length; i += 2) {
            p.setObject(1, ids[i]);
            rs = p.executeQuery();
            GridH2TableSelfTest.assertTrue((boolean)rs.next());
            GridH2TableSelfTest.assertEquals((int)1, (int)rs.getInt(1));
        }
        Statement s = this.conn.createStatement();
        rs = s.executeQuery("select count(*) from t");
        GridH2TableSelfTest.assertTrue((boolean)rs.next());
        GridH2TableSelfTest.assertEquals((int)(ids.length - deleted.get()), (int)rs.getInt(1));
    }

    public void testIndexFindFirstOrLast() throws Exception {
        Index index = (Index)this.tbl.getIndexes().get(2);
        GridH2TableSelfTest.assertTrue((boolean)(index instanceof GridH2TreeIndex));
        GridH2TableSelfTest.assertTrue((boolean)index.canGetFirstOrLast());
        Cursor cursor = index.findFirstOrLast(null, true);
        GridH2TableSelfTest.assertFalse((boolean)cursor.next());
        GridH2TableSelfTest.assertNull((Object)cursor.get());
        cursor = index.findFirstOrLast(null, false);
        GridH2TableSelfTest.assertFalse((boolean)cursor.next());
        GridH2TableSelfTest.assertNull((Object)cursor.get());
        int rows = 100;
        long t = System.currentTimeMillis();
        Random rnd = new Random();
        UUID min = null;
        UUID max = null;
        for (int i = 0; i < rows; ++i) {
            UUID id = UUID.randomUUID();
            if (min == null || id.compareTo(min) < 0) {
                min = id;
            }
            if (max == null || id.compareTo(max) > 0) {
                max = id;
            }
            GridH2Row row = this.row(id, t++, id.toString(), rnd.nextInt(100));
            ((GridH2TreeIndex)index).put(row);
        }
        cursor = index.findFirstOrLast(null, true);
        GridH2TableSelfTest.assertTrue((boolean)cursor.next());
        GridH2TableSelfTest.assertEquals((Object)min, (Object)cursor.get().getValue(0).getObject());
        GridH2TableSelfTest.assertFalse((boolean)cursor.next());
        cursor = index.findFirstOrLast(null, false);
        GridH2TableSelfTest.assertTrue((boolean)cursor.next());
        GridH2TableSelfTest.assertEquals((Object)max, (Object)cursor.get().getValue(0).getObject());
        GridH2TableSelfTest.assertFalse((boolean)cursor.next());
    }

    private void checkQueryPlan(Connection conn, String sql, String search) throws SQLException {
        try (Statement s = conn.createStatement();
             ResultSet r = s.executeQuery("EXPLAIN ANALYZE " + sql);){
            GridH2TableSelfTest.assertTrue((boolean)r.next());
            String plan = r.getString(1);
            GridH2TableSelfTest.assertTrue((String)("Execution plan for '" + sql + "' query should contain '" + search + "'"), (boolean)plan.contains(search));
        }
    }

    private Set<Row> checkIndexesConsistent(ArrayList<Index> idxs, @Nullable Set<Row> rowSet) throws IgniteCheckedException {
        for (Index idx : idxs) {
            if (!(idx instanceof GridH2TreeIndex)) continue;
            HashSet<Row> set = new HashSet<Row>();
            GridCursor cursor = ((GridH2TreeIndex)idx).rows();
            while (cursor.next()) {
                GridH2TableSelfTest.assertTrue((boolean)set.add((Row)cursor.get()));
            }
            if (rowSet == null || rowSet.isEmpty()) {
                rowSet = set;
                continue;
            }
            GridH2TableSelfTest.assertEquals(rowSet, set);
        }
        return rowSet;
    }

    private void checkOrdered(ArrayList<Index> idxs) throws IgniteCheckedException {
        for (Index idx : idxs) {
            if (!(idx instanceof GridH2TreeIndex)) continue;
            GridH2TreeIndex h2Idx = (GridH2TreeIndex)idx;
            this.checkOrdered(h2Idx, (Comparator<? super GridH2Row>)h2Idx);
        }
    }

    private void checkOrdered(GridH2TreeIndex idx, Comparator<? super GridH2Row> cmp) throws IgniteCheckedException {
        GridCursor cursor = idx.rows();
        GridH2Row min = null;
        while (cursor.next()) {
            GridH2Row row = (GridH2Row)cursor.get();
            System.out.println(row);
            GridH2TableSelfTest.assertNotNull((Object)row);
            GridH2TableSelfTest.assertFalse((String)("Incorrect row order in index: " + idx + "\n min: " + min + "\n row: " + row), (min != null && cmp.compare(min, (GridH2Row)row) > 0 ? 1 : 0) != 0);
            min = row;
        }
    }
}

