/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.UUID;
import junit.framework.TestCase;
import org.apache.commons.io.Charsets;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.MemoryPolicyConfiguration;
import org.apache.ignite.internal.mem.DirectMemoryProvider;
import org.apache.ignite.internal.mem.unsafe.UnsafeMemoryProvider;
import org.apache.ignite.internal.pagemem.impl.PageMemoryNoStoreImpl;
import org.apache.ignite.internal.processors.cache.database.MemoryMetricsImpl;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexHelper;
import org.apache.ignite.logger.java.JavaLogger;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

public class InlineIndexHelperTest
extends TestCase {
    private static final int CACHE_ID = 42;
    private static final int PAGE_SIZE = 1024;
    private static final long MB = 1024L;
    private static final int CPUS = Runtime.getRuntime().availableProcessors();

    public void testConvert() {
        byte[] bytes = InlineIndexHelper.trimUTF8((byte[])"00\u20ac\u20ac".getBytes(Charsets.UTF_8), (int)7);
        InlineIndexHelperTest.assertEquals((int)5, (int)bytes.length);
        String s = new String(bytes);
        InlineIndexHelperTest.assertEquals((int)3, (int)s.length());
        bytes = InlineIndexHelper.trimUTF8((byte[])"aaaaaa".getBytes(Charsets.UTF_8), (int)4);
        InlineIndexHelperTest.assertEquals((int)4, (int)bytes.length);
    }

    public void testStringCut() {
        byte[] bytes = InlineIndexHelper.trimUTF8((byte[])"\u20ac\u20ac".getBytes(Charsets.UTF_8), (int)2);
        InlineIndexHelperTest.assertNull((Object)bytes);
    }

    public void testRelyOnCompare() {
        InlineIndexHelper ha = new InlineIndexHelper(13, 0, 0);
        InlineIndexHelperTest.assertFalse((boolean)this.getRes(ha, "aabb", "aabb"));
        InlineIndexHelperTest.assertTrue((boolean)this.getRes(ha, "aabb", "aac"));
        InlineIndexHelperTest.assertTrue((boolean)this.getRes(ha, "aabb", "aaa"));
        InlineIndexHelperTest.assertTrue((boolean)this.getRes(ha, "aabb", "aaaaaa"));
        InlineIndexHelperTest.assertFalse((boolean)this.getRes(ha, "aaa", "aaaaaa"));
        InlineIndexHelperTest.assertTrue((boolean)this.getRes(ha, "a", null));
        InlineIndexHelperTest.assertTrue((boolean)this.getRes(ha, null, "a"));
        InlineIndexHelperTest.assertTrue((boolean)this.getRes(ha, null, null));
    }

    public void testRelyOnCompareBytes() {
        InlineIndexHelper ha = new InlineIndexHelper(12, 0, 0);
        InlineIndexHelperTest.assertFalse((boolean)this.getResBytes(ha, new byte[]{1, 2, 3, 4}, new byte[]{1, 2, 3, 4}));
        InlineIndexHelperTest.assertTrue((boolean)this.getResBytes(ha, new byte[]{1, 2, 2, 2}, new byte[]{1, 1, 2}));
        InlineIndexHelperTest.assertTrue((boolean)this.getResBytes(ha, new byte[]{1, 1, 1, 2}, new byte[]{1, 1, 2}));
        InlineIndexHelperTest.assertTrue((boolean)this.getResBytes(ha, new byte[]{1, 2}, new byte[]{1, 1, 1}));
        InlineIndexHelperTest.assertFalse((boolean)this.getResBytes(ha, new byte[]{1, 1}, new byte[]{1, 1, 2}));
        InlineIndexHelperTest.assertTrue((boolean)this.getResBytes(ha, new byte[]{1, 2, 3, 4}, null));
        InlineIndexHelperTest.assertTrue((boolean)this.getResBytes(ha, null, new byte[]{1, 2, 3, 4}));
        InlineIndexHelperTest.assertTrue((boolean)this.getResBytes(ha, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringTruncate() throws Exception {
        MemoryPolicyConfiguration plcCfg = new MemoryPolicyConfiguration().setMaxSize(0x100000L);
        JavaLogger log = new JavaLogger();
        PageMemoryNoStoreImpl pageMem = new PageMemoryNoStoreImpl((IgniteLogger)log, (DirectMemoryProvider)new UnsafeMemoryProvider((IgniteLogger)log), null, 1024, plcCfg, new MemoryMetricsImpl(plcCfg), false);
        pageMem.start();
        long pageId = 0L;
        long page = 0L;
        try {
            pageId = pageMem.allocatePage(42, 1, (byte)1);
            page = pageMem.acquirePage(42, pageId);
            long pageAddr = pageMem.readLock(42, pageId, page);
            int off = 0;
            InlineIndexHelper ih = new InlineIndexHelper(13, 1, 0);
            ih.put(pageAddr, off, ValueString.get((String)"aaaaaaa"), 8);
            InlineIndexHelperTest.assertFalse((boolean)ih.isValueFull(pageAddr, off));
            InlineIndexHelperTest.assertEquals((String)"aaaaa", (String)ih.get(pageAddr, off, 8).getString());
            ih.put(pageAddr, off, ValueString.get((String)"aaa"), 8);
            InlineIndexHelperTest.assertTrue((boolean)ih.isValueFull(pageAddr, off));
            InlineIndexHelperTest.assertEquals((String)"aaa", (String)ih.get(pageAddr, off, 8).getString());
        }
        finally {
            if (page != 0L) {
                pageMem.releasePage(42, pageId, page);
            }
            pageMem.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBytes() throws Exception {
        MemoryPolicyConfiguration plcCfg = new MemoryPolicyConfiguration().setMaxSize(0x100000L);
        JavaLogger log = new JavaLogger();
        PageMemoryNoStoreImpl pageMem = new PageMemoryNoStoreImpl((IgniteLogger)log, (DirectMemoryProvider)new UnsafeMemoryProvider((IgniteLogger)log), null, 1024, plcCfg, new MemoryMetricsImpl(plcCfg), false);
        pageMem.start();
        long pageId = 0L;
        long page = 0L;
        try {
            pageId = pageMem.allocatePage(42, 1, (byte)1);
            page = pageMem.acquirePage(42, pageId);
            long pageAddr = pageMem.readLock(42, pageId, page);
            int off = 0;
            InlineIndexHelper ih = new InlineIndexHelper(12, 1, 0);
            ih.put(pageAddr, off, (Value)ValueBytes.get((byte[])new byte[]{1, 2, 3, 4, 5}), 6);
            InlineIndexHelperTest.assertFalse((boolean)ih.isValueFull(pageAddr, off));
            InlineIndexHelperTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3}, ih.get(pageAddr, off, 8).getBytes()));
            ih.put(pageAddr, off, (Value)ValueBytes.get((byte[])new byte[]{1, 2, 3, 4, 5}), 8);
            InlineIndexHelperTest.assertTrue((boolean)ih.isValueFull(pageAddr, off));
            InlineIndexHelperTest.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3, 4, 5}, ih.get(pageAddr, off, 8).getBytes()));
        }
        finally {
            if (page != 0L) {
                pageMem.releasePage(42, pageId, page);
            }
            pageMem.stop();
        }
    }

    public void testNull() throws Exception {
        this.testPutGet((Value)ValueInt.get((int)-1), (Value)ValueNull.INSTANCE, (Value)ValueInt.get((int)3));
    }

    public void testBoolean() throws Exception {
        this.testPutGet((Value)ValueBoolean.get((boolean)true), (Value)ValueBoolean.get((boolean)false), (Value)ValueBoolean.get((boolean)true));
    }

    public void testByte() throws Exception {
        this.testPutGet((Value)ValueByte.get((byte)-1), (Value)ValueByte.get((byte)2), (Value)ValueByte.get((byte)3));
    }

    public void testShort() throws Exception {
        this.testPutGet((Value)ValueShort.get((short)-32000), (Value)ValueShort.get((short)2), (Value)ValueShort.get((short)3));
    }

    public void testInt() throws Exception {
        this.testPutGet((Value)ValueInt.get((int)-1), (Value)ValueInt.get((int)2), (Value)ValueInt.get((int)3));
    }

    public void testLong() throws Exception {
        this.testPutGet((Value)ValueLong.get((long)-1L), (Value)ValueLong.get((long)2L), (Value)ValueLong.get((long)3L));
    }

    public void testFloat() throws Exception {
        this.testPutGet((Value)ValueFloat.get((float)1.1f), (Value)ValueFloat.get((float)2.2f), (Value)ValueFloat.get((float)1.1f));
    }

    public void testDouble() throws Exception {
        this.testPutGet((Value)ValueDouble.get((double)1.1f), (Value)ValueDouble.get((double)2.2f), (Value)ValueDouble.get((double)1.1f));
    }

    public void testDate() throws Exception {
        this.testPutGet((Value)ValueDate.get((Date)Date.valueOf("2017-02-20")), (Value)ValueDate.get((Date)Date.valueOf("2017-02-21")), (Value)ValueDate.get((Date)Date.valueOf("2017-02-19")));
    }

    public void testTime() throws Exception {
        this.testPutGet((Value)ValueTime.get((Time)Time.valueOf("10:01:01")), (Value)ValueTime.get((Time)Time.valueOf("11:02:02")), (Value)ValueTime.get((Time)Time.valueOf("12:03:03")));
    }

    public void testTimestamp() throws Exception {
        this.testPutGet((Value)ValueTimestamp.get((Timestamp)Timestamp.valueOf("2017-02-20 10:01:01")), (Value)ValueTimestamp.get((Timestamp)Timestamp.valueOf("2017-02-20 10:01:01")), (Value)ValueTimestamp.get((Timestamp)Timestamp.valueOf("2017-02-20 10:01:01")));
    }

    public void testUUID() throws Exception {
        this.testPutGet((Value)ValueUuid.get((String)UUID.randomUUID().toString()), (Value)ValueUuid.get((String)UUID.randomUUID().toString()), (Value)ValueUuid.get((String)UUID.randomUUID().toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPutGet(Value v1, Value v2, Value v3) throws Exception {
        MemoryPolicyConfiguration plcCfg = new MemoryPolicyConfiguration().setMaxSize(0x100000L);
        JavaLogger log = new JavaLogger();
        PageMemoryNoStoreImpl pageMem = new PageMemoryNoStoreImpl((IgniteLogger)log, (DirectMemoryProvider)new UnsafeMemoryProvider((IgniteLogger)log), null, 1024, plcCfg, new MemoryMetricsImpl(plcCfg), false);
        pageMem.start();
        long pageId = 0L;
        long page = 0L;
        try {
            pageId = pageMem.allocatePage(42, 1, (byte)1);
            page = pageMem.acquirePage(42, pageId);
            long pageAddr = pageMem.readLock(42, pageId, page);
            int off = 0;
            int max = 255;
            InlineIndexHelper ih = new InlineIndexHelper(v1.getType(), 1, 0);
            off += ih.put(pageAddr, off, v1, max - off);
            off += ih.put(pageAddr, off, v2, max - off);
            off += ih.put(pageAddr, off, v3, max - off);
            Value v11 = ih.get(pageAddr, 0, max);
            Value v22 = ih.get(pageAddr, ih.fullSize(pageAddr, 0), max);
            InlineIndexHelperTest.assertEquals((Object)v1.getObject(), (Object)v11.getObject());
            InlineIndexHelperTest.assertEquals((Object)v2.getObject(), (Object)v22.getObject());
        }
        finally {
            if (page != 0L) {
                pageMem.releasePage(42, pageId, page);
            }
            pageMem.stop();
        }
    }

    private boolean getRes(InlineIndexHelper ha, String s1, String s2) {
        ValueNull v1 = s1 == null ? ValueNull.INSTANCE : ValueString.get((String)s1);
        ValueNull v2 = s2 == null ? ValueNull.INSTANCE : ValueString.get((String)s2);
        int c = v1.compareTypeSafe((Value)v2, CompareMode.getInstance((String)"DEFAULT_", (int)0));
        return ha.canRelyOnCompare(c, (Value)v1, (Value)v2);
    }

    private boolean getResBytes(InlineIndexHelper ha, byte[] b1, byte[] b2) {
        ValueNull v1 = b1 == null ? ValueNull.INSTANCE : ValueBytes.get((byte[])b1);
        ValueNull v2 = b2 == null ? ValueNull.INSTANCE : ValueBytes.get((byte[])b2);
        int c = v1.compareTypeSafe((Value)v2, CompareMode.getInstance((String)"DEFAULT_", (int)0));
        return ha.canRelyOnCompare(c, (Value)v1, (Value)v2);
    }
}

