/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.GridQueryFieldsResult;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.apache.ignite.spi.IgniteSpiCloseableIterator;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.testframework.GridStringLogger;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.h2.util.JdbcUtils;
import org.jetbrains.annotations.Nullable;

public abstract class GridIndexingSpiAbstractSelfTest
extends GridCommonAbstractTest {
    private static final TextIndex textIdx = new TextIndex(F.asList((Object)"txt"));
    private static final LinkedHashMap<String, String> fieldsAA = new LinkedHashMap();
    private static final LinkedHashMap<String, String> fieldsAB = new LinkedHashMap();
    private static final LinkedHashMap<String, String> fieldsBA = new LinkedHashMap();
    private IgniteEx ignite0;
    private static TypeDesc typeAA;
    private static TypeDesc typeAB;
    private static TypeDesc typeBA;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setMarshaller((Marshaller)new BinaryMarshaller());
        return cfg;
    }

    protected void beforeTest() throws Exception {
        this.ignite0 = this.startGrid(0);
    }

    private CacheConfiguration cacheACfg() {
        CacheConfiguration cfg = new CacheConfiguration("default");
        cfg.setName("A");
        QueryEntity eA = new QueryEntity(Integer.class.getName(), "A");
        eA.setFields(fieldsAA);
        QueryEntity eB = new QueryEntity(Integer.class.getName(), "B");
        eB.setFields(fieldsAB);
        ArrayList<QueryEntity> list = new ArrayList<QueryEntity>(2);
        list.add(eA);
        list.add(eB);
        QueryIndex idx = new QueryIndex("txt");
        idx.setIndexType(QueryIndexType.FULLTEXT);
        eB.setIndexes(Collections.singleton(idx));
        cfg.setQueryEntities(list);
        return cfg;
    }

    private CacheConfiguration cacheBCfg() {
        CacheConfiguration cfg = new CacheConfiguration("default");
        cfg.setName("B");
        QueryEntity eA = new QueryEntity(Integer.class.getName(), "A");
        eA.setFields(fieldsBA);
        cfg.setQueryEntities(Collections.singleton(eA));
        return cfg;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    private BinaryObjectBuilder aa(String typeName, long id, String name, int age) {
        BinaryObjectBuilder aBuilder = this.ignite0.binary().builder(typeName).setField("id", (Object)id).setField("name", (Object)name).setField("age", (Object)age);
        return aBuilder;
    }

    private BinaryObjectBuilder ab(long id, String name, int age, String txt) {
        BinaryObjectBuilder aBuilder = this.aa("B", id, name, age);
        aBuilder.setField("txt", (Object)txt);
        return aBuilder;
    }

    private BinaryObjectBuilder ba(long id, String name, int age, boolean sex) {
        BinaryObjectBuilder builder = this.aa("A", id, name, age);
        builder.setField("sex", (Object)sex);
        return builder;
    }

    private BinaryObjectImpl value(IgniteBiTuple<Integer, BinaryObjectImpl> row) throws IgniteSpiException {
        return (BinaryObjectImpl)row.get2();
    }

    private IgniteH2Indexing getIndexing() {
        return (IgniteH2Indexing)U.field((Object)this.ignite0.context().query(), (String)"idx");
    }

    protected boolean offheap() {
        return false;
    }

    private KeyCacheObject key(int key) {
        return new TestCacheObject(key);
    }

    public void testSpi() throws Exception {
        IgniteH2Indexing spi = this.getIndexing();
        GridIndexingSpiAbstractSelfTest.assertEquals((long)-1L, (long)spi.size(typeAA.space(), typeAA.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)-1L, (long)spi.size(typeAB.space(), typeAB.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)-1L, (long)spi.size(typeBA.space(), typeBA.name()));
        IgniteCache cacheA = this.ignite0.createCache(this.cacheACfg());
        GridIndexingSpiAbstractSelfTest.assertEquals((long)0L, (long)spi.size(typeAA.space(), typeAA.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)0L, (long)spi.size(typeAB.space(), typeAB.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)-1L, (long)spi.size(typeBA.space(), typeBA.name()));
        IgniteCache cacheB = this.ignite0.createCache(this.cacheBCfg());
        GridIndexingSpiAbstractSelfTest.assertEquals((long)0L, (long)spi.size(typeAA.space(), typeAA.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)0L, (long)spi.size(typeAB.space(), typeAB.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)0L, (long)spi.size(typeBA.space(), typeBA.name()));
        GridIndexingSpiAbstractSelfTest.assertFalse((boolean)spi.queryLocalSql(typeAA.space(), "select * from A.A", null, Collections.emptySet(), typeAA.name(), null, null).hasNext());
        GridIndexingSpiAbstractSelfTest.assertFalse((boolean)spi.queryLocalSql(typeAB.space(), "select * from A.B", null, Collections.emptySet(), typeAB.name(), null, null).hasNext());
        GridIndexingSpiAbstractSelfTest.assertFalse((boolean)spi.queryLocalSql(typeBA.space(), "select * from B.A", null, Collections.emptySet(), typeBA.name(), null, null).hasNext());
        GridIndexingSpiAbstractSelfTest.assertFalse((boolean)spi.queryLocalSql(typeBA.space(), "select * from B.A, A.B, A.A", null, Collections.emptySet(), typeBA.name(), null, null).hasNext());
        try {
            spi.queryLocalSql(typeBA.space(), "select aa.*, ab.*, ba.* from A.A aa, A.B ab, B.A ba", null, Collections.emptySet(), typeBA.name(), null, null).hasNext();
            GridIndexingSpiAbstractSelfTest.fail((String)"Enumerations of aliases in select block must be prohibited");
        }
        catch (IgniteCheckedException igniteCheckedException) {
            // empty catch block
        }
        GridIndexingSpiAbstractSelfTest.assertFalse((boolean)spi.queryLocalSql(typeAB.space(), "select ab.* from A.B ab", null, Collections.emptySet(), typeAB.name(), null, null).hasNext());
        GridIndexingSpiAbstractSelfTest.assertFalse((boolean)spi.queryLocalSql(typeBA.space(), "select   ba.*   from B.A  as ba", null, Collections.emptySet(), typeBA.name(), null, null).hasNext());
        cacheA.put((Object)1, (Object)this.aa("A", 1L, "Vasya", 10).build());
        GridIndexingSpiAbstractSelfTest.assertEquals((long)1L, (long)spi.size(typeAA.space(), typeAA.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)0L, (long)spi.size(typeAB.space(), typeAB.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)0L, (long)spi.size(typeBA.space(), typeBA.name()));
        cacheA.put((Object)1, (Object)this.ab(1L, "Vasya", 20, "Some text about Vasya goes here.").build());
        GridIndexingSpiAbstractSelfTest.assertEquals((long)0L, (long)spi.size(typeAA.space(), typeAA.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)1L, (long)spi.size(typeAB.space(), typeAB.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)0L, (long)spi.size(typeBA.space(), typeBA.name()));
        cacheB.put((Object)1, (Object)this.ba(2L, "Petya", 25, true).build());
        GridIndexingSpiAbstractSelfTest.assertEquals((long)0L, (long)spi.size(typeAA.space(), typeAA.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)1L, (long)spi.size(typeAB.space(), typeAB.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)1L, (long)spi.size(typeBA.space(), typeBA.name()));
        cacheB.put((Object)1, (Object)this.ba(2L, "Kolya", 25, true).build());
        GridIndexingSpiAbstractSelfTest.assertEquals((long)0L, (long)spi.size(typeAA.space(), typeAA.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)1L, (long)spi.size(typeAB.space(), typeAB.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)1L, (long)spi.size(typeBA.space(), typeBA.name()));
        cacheA.put((Object)2, (Object)this.aa("A", 2L, "Valera", 19).build());
        GridIndexingSpiAbstractSelfTest.assertEquals((long)1L, (long)spi.size(typeAA.space(), typeAA.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)1L, (long)spi.size(typeAB.space(), typeAB.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)1L, (long)spi.size(typeBA.space(), typeBA.name()));
        cacheA.put((Object)3, (Object)this.aa("A", 3L, "Borya", 18).build());
        GridIndexingSpiAbstractSelfTest.assertEquals((long)2L, (long)spi.size(typeAA.space(), typeAA.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)1L, (long)spi.size(typeAB.space(), typeAB.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)1L, (long)spi.size(typeBA.space(), typeBA.name()));
        cacheA.put((Object)4, (Object)this.ab(4L, "Vitalya", 20, "Very Good guy").build());
        GridIndexingSpiAbstractSelfTest.assertEquals((long)2L, (long)spi.size(typeAA.space(), typeAA.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)2L, (long)spi.size(typeAB.space(), typeAB.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)1L, (long)spi.size(typeBA.space(), typeBA.name()));
        GridCloseableIterator res = spi.queryLocalSql(typeAA.space(), "from a order by age", null, Collections.emptySet(), typeAA.name(), null, null);
        GridIndexingSpiAbstractSelfTest.assertTrue((boolean)res.hasNext());
        GridIndexingSpiAbstractSelfTest.assertEquals((Object)this.aa("A", 3L, "Borya", 18).build(), (Object)this.value((IgniteBiTuple<Integer, BinaryObjectImpl>)((IgniteBiTuple)res.next())));
        GridIndexingSpiAbstractSelfTest.assertTrue((boolean)res.hasNext());
        GridIndexingSpiAbstractSelfTest.assertEquals((Object)this.aa("A", 2L, "Valera", 19).build(), (Object)this.value((IgniteBiTuple<Integer, BinaryObjectImpl>)((IgniteBiTuple)res.next())));
        GridIndexingSpiAbstractSelfTest.assertFalse((boolean)res.hasNext());
        res = spi.queryLocalSql(typeAA.space(), "select aa.* from a aa order by aa.age", null, Collections.emptySet(), typeAA.name(), null, null);
        GridIndexingSpiAbstractSelfTest.assertTrue((boolean)res.hasNext());
        GridIndexingSpiAbstractSelfTest.assertEquals((Object)this.aa("A", 3L, "Borya", 18).build(), (Object)this.value((IgniteBiTuple<Integer, BinaryObjectImpl>)((IgniteBiTuple)res.next())));
        GridIndexingSpiAbstractSelfTest.assertTrue((boolean)res.hasNext());
        GridIndexingSpiAbstractSelfTest.assertEquals((Object)this.aa("A", 2L, "Valera", 19).build(), (Object)this.value((IgniteBiTuple<Integer, BinaryObjectImpl>)((IgniteBiTuple)res.next())));
        GridIndexingSpiAbstractSelfTest.assertFalse((boolean)res.hasNext());
        res = spi.queryLocalSql(typeAB.space(), "from b order by name", null, Collections.emptySet(), typeAB.name(), null, null);
        GridIndexingSpiAbstractSelfTest.assertTrue((boolean)res.hasNext());
        GridIndexingSpiAbstractSelfTest.assertEquals((Object)this.ab(1L, "Vasya", 20, "Some text about Vasya goes here.").build(), (Object)this.value((IgniteBiTuple<Integer, BinaryObjectImpl>)((IgniteBiTuple)res.next())));
        GridIndexingSpiAbstractSelfTest.assertTrue((boolean)res.hasNext());
        GridIndexingSpiAbstractSelfTest.assertEquals((Object)this.ab(4L, "Vitalya", 20, "Very Good guy").build(), (Object)this.value((IgniteBiTuple<Integer, BinaryObjectImpl>)((IgniteBiTuple)res.next())));
        GridIndexingSpiAbstractSelfTest.assertFalse((boolean)res.hasNext());
        res = spi.queryLocalSql(typeAB.space(), "select bb.* from b as bb order by bb.name", null, Collections.emptySet(), typeAB.name(), null, null);
        GridIndexingSpiAbstractSelfTest.assertTrue((boolean)res.hasNext());
        GridIndexingSpiAbstractSelfTest.assertEquals((Object)this.ab(1L, "Vasya", 20, "Some text about Vasya goes here.").build(), (Object)this.value((IgniteBiTuple<Integer, BinaryObjectImpl>)((IgniteBiTuple)res.next())));
        GridIndexingSpiAbstractSelfTest.assertTrue((boolean)res.hasNext());
        GridIndexingSpiAbstractSelfTest.assertEquals((Object)this.ab(4L, "Vitalya", 20, "Very Good guy").build(), (Object)this.value((IgniteBiTuple<Integer, BinaryObjectImpl>)((IgniteBiTuple)res.next())));
        GridIndexingSpiAbstractSelfTest.assertFalse((boolean)res.hasNext());
        res = spi.queryLocalSql(typeBA.space(), "from a", null, Collections.emptySet(), typeBA.name(), null, null);
        GridIndexingSpiAbstractSelfTest.assertTrue((boolean)res.hasNext());
        GridIndexingSpiAbstractSelfTest.assertEquals((Object)this.ba(2L, "Kolya", 25, true).build(), (Object)this.value((IgniteBiTuple<Integer, BinaryObjectImpl>)((IgniteBiTuple)res.next())));
        GridIndexingSpiAbstractSelfTest.assertFalse((boolean)res.hasNext());
        GridCloseableIterator txtRes = spi.queryLocalText(typeAB.space(), "good", typeAB.name(), null);
        GridIndexingSpiAbstractSelfTest.assertTrue((boolean)txtRes.hasNext());
        GridIndexingSpiAbstractSelfTest.assertEquals((Object)this.ab(4L, "Vitalya", 20, "Very Good guy").build(), (Object)this.value((IgniteBiTuple<Integer, BinaryObjectImpl>)((IgniteBiTuple)txtRes.next())));
        GridIndexingSpiAbstractSelfTest.assertFalse((boolean)txtRes.hasNext());
        GridQueryFieldsResult fieldsRes = spi.queryLocalSqlFields("A", "select a.a.name n1, a.a.age a1, b.a.name n2, b.a.age a2 from a.a, b.a where a.a.id = b.a.id ", Collections.emptySet(), null, false, 0, null);
        String[] aliases = new String[]{"N1", "A1", "N2", "A2"};
        Object[] vals = new Object[]{"Valera", 19, "Kolya", 25};
        IgniteSpiCloseableIterator it = fieldsRes.iterator();
        GridIndexingSpiAbstractSelfTest.assertTrue((boolean)it.hasNext());
        List fields = (List)it.next();
        GridIndexingSpiAbstractSelfTest.assertEquals((int)4, (int)fields.size());
        int i = 0;
        for (Object f : fields) {
            GridIndexingSpiAbstractSelfTest.assertEquals((String)aliases[i], (String)((GridQueryFieldMetadata)fieldsRes.metaData().get(i)).fieldName());
            GridIndexingSpiAbstractSelfTest.assertEquals((Object)vals[i++], f);
        }
        GridIndexingSpiAbstractSelfTest.assertFalse((boolean)it.hasNext());
        cacheA.remove((Object)2);
        GridIndexingSpiAbstractSelfTest.assertEquals((long)1L, (long)spi.size(typeAA.space(), typeAA.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)2L, (long)spi.size(typeAB.space(), typeAB.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)1L, (long)spi.size(typeBA.space(), typeBA.name()));
        cacheB.remove((Object)1);
        GridIndexingSpiAbstractSelfTest.assertEquals((long)1L, (long)spi.size(typeAA.space(), typeAA.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)2L, (long)spi.size(typeAB.space(), typeAB.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)0L, (long)spi.size(typeBA.space(), typeBA.name()));
        spi.unregisterType(typeAA.space(), typeAA.name());
        GridIndexingSpiAbstractSelfTest.assertEquals((long)-1L, (long)spi.size(typeAA.space(), typeAA.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)2L, (long)spi.size(typeAB.space(), typeAB.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)0L, (long)spi.size(typeBA.space(), typeBA.name()));
        spi.unregisterType(typeAB.space(), typeAB.name());
        GridIndexingSpiAbstractSelfTest.assertEquals((long)-1L, (long)spi.size(typeAA.space(), typeAA.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)-1L, (long)spi.size(typeAB.space(), typeAB.name()));
        GridIndexingSpiAbstractSelfTest.assertEquals((long)0L, (long)spi.size(typeBA.space(), typeBA.name()));
        spi.unregisterType(typeBA.space(), typeBA.name());
        GridIndexingSpiAbstractSelfTest.assertEquals((long)-1L, (long)spi.size(typeAA.space(), typeAA.name()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLongQueries() throws Exception {
        IgniteH2Indexing spi = this.getIndexing();
        this.ignite0.createCache(this.cacheACfg());
        long longQryExecTime = 3000L;
        GridStringLogger log = new GridStringLogger(false, this.log);
        IgniteLogger oldLog = (IgniteLogger)GridTestUtils.getFieldValue((Object)spi, (String[])new String[]{"log"});
        try {
            String res;
            long now;
            GridTestUtils.setFieldValue((Object)spi, (String)"log", (Object)log);
            String sql = "select sum(x) FROM SYSTEM_RANGE(?, ?)";
            long time = now = U.currentTimeMillis();
            long range = 1000000L;
            while (now - time <= longQryExecTime * 3L / 2L) {
                time = now;
                res = spi.queryLocalSqlFields("A", sql, Arrays.asList(1, range *= 3L), null, false, 0, null);
                assert (res.iterator().hasNext());
                now = U.currentTimeMillis();
            }
            res = log.toString();
            GridIndexingSpiAbstractSelfTest.assertTrue((boolean)res.contains("/* PUBLIC.RANGE_INDEX */"));
        }
        finally {
            GridTestUtils.setFieldValue((Object)spi, (String)"log", (Object)oldLog);
        }
    }

    static {
        fieldsAA.put("id", Long.class.getName());
        fieldsAA.put("name", String.class.getName());
        fieldsAA.put("age", Integer.class.getName());
        fieldsAB.putAll(fieldsAA);
        fieldsAB.put("txt", String.class.getName());
        fieldsBA.putAll(fieldsAA);
        fieldsBA.put("sex", Boolean.class.getName());
        typeAA = new TypeDesc("A", "A", Collections.emptyMap(), null);
        typeAB = new TypeDesc("A", "B", Collections.emptyMap(), textIdx);
        typeBA = new TypeDesc("B", "A", Collections.emptyMap(), null);
    }

    private static class TestCacheObject
    implements KeyCacheObject {
        private Object val;
        private int part;

        private TestCacheObject(Object val) {
            this.val = val;
        }

        public void onAckReceived() {
        }

        @Nullable
        public <T> T value(CacheObjectContext ctx, boolean cpy) {
            return (T)this.val;
        }

        public int partition() {
            return this.part;
        }

        public void partition(int part) {
            this.part = part;
        }

        public byte[] valueBytes(CacheObjectContext ctx) throws IgniteCheckedException {
            return JdbcUtils.serialize((Object)this.val, null);
        }

        public boolean putValue(ByteBuffer buf) throws IgniteCheckedException {
            return false;
        }

        public int putValue(long addr) throws IgniteCheckedException {
            return 0;
        }

        public boolean putValue(ByteBuffer buf, int off, int len) throws IgniteCheckedException {
            return false;
        }

        public int valueBytesLength(CacheObjectContext ctx) throws IgniteCheckedException {
            return 0;
        }

        public byte cacheObjectType() {
            throw new UnsupportedOperationException();
        }

        public boolean isPlatformType() {
            return true;
        }

        public KeyCacheObject copy(int part) {
            return this;
        }

        public CacheObject prepareForCache(CacheObjectContext ctx) {
            throw new UnsupportedOperationException();
        }

        public void finishUnmarshal(CacheObjectContext ctx, ClassLoader ldr) throws IgniteCheckedException {
            throw new UnsupportedOperationException();
        }

        public void prepareMarshal(CacheObjectContext ctx) throws IgniteCheckedException {
            throw new UnsupportedOperationException();
        }

        public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
            throw new UnsupportedOperationException();
        }

        public boolean readFrom(ByteBuffer buf, MessageReader reader) {
            throw new UnsupportedOperationException();
        }

        public short directType() {
            throw new UnsupportedOperationException();
        }

        public byte fieldsCount() {
            throw new UnsupportedOperationException();
        }

        public boolean internal() {
            return false;
        }
    }

    private static class TypeDesc
    implements GridQueryTypeDescriptor {
        private final String name;
        private final String space;
        private final Map<String, Class<?>> valFields;
        private final GridQueryIndexDescriptor textIdx;

        private TypeDesc(String space, String name, Map<String, Class<?>> valFields, GridQueryIndexDescriptor textIdx) {
            this.name = name;
            this.space = space;
            this.valFields = Collections.unmodifiableMap(valFields);
            this.textIdx = textIdx;
        }

        public String affinityKey() {
            return null;
        }

        public String name() {
            return this.name;
        }

        public String tableName() {
            return null;
        }

        String space() {
            return this.space;
        }

        public Map<String, Class<?>> fields() {
            return this.valFields;
        }

        public GridQueryProperty property(final String name) {
            return new GridQueryProperty(){

                public Object value(Object key, Object val) throws IgniteCheckedException {
                    return TypeDesc.this.value(name, key, val);
                }

                public void setValue(Object key, Object val, Object propVal) throws IgniteCheckedException {
                    throw new UnsupportedOperationException();
                }

                public String name() {
                    return name;
                }

                public Class<?> type() {
                    return Object.class;
                }

                public boolean key() {
                    return false;
                }

                public GridQueryProperty parent() {
                    return null;
                }
            };
        }

        public <T> T value(String field, Object key, Object val) throws IgniteSpiException {
            assert (!F.isEmpty((String)field));
            assert (key instanceof Integer);
            Map m = (Map)val;
            if (m.containsKey(field)) {
                return (T)m.get(field);
            }
            return null;
        }

        public void setValue(String field, Object key, Object val, Object propVal) throws IgniteCheckedException {
            assert (!F.isEmpty((String)field));
            assert (key instanceof Integer);
            Map m = (Map)val;
            m.put(field, propVal);
        }

        public Map<String, GridQueryIndexDescriptor> indexes() {
            return Collections.emptyMap();
        }

        public GridQueryIndexDescriptor textIndex() {
            return this.textIdx;
        }

        public Class<?> valueClass() {
            return Object.class;
        }

        public Class<?> keyClass() {
            return Integer.class;
        }

        public String keyTypeName() {
            return null;
        }

        public String valueTypeName() {
            return null;
        }

        public boolean valueTextIndex() {
            return this.textIdx == null;
        }

        public int typeId() {
            return 0;
        }

        public String keyFieldName() {
            return null;
        }

        public String valueFieldName() {
            return null;
        }
    }

    private static class TextIndex
    implements GridQueryIndexDescriptor {
        private final Collection<String> fields;

        private TextIndex(Collection<String> fields) {
            this.fields = Collections.unmodifiableCollection(fields);
        }

        public String name() {
            return null;
        }

        public Collection<String> fields() {
            return this.fields;
        }

        public boolean descending(String field) {
            return false;
        }

        public QueryIndexType type() {
            return QueryIndexType.FULLTEXT;
        }

        public int inlineSize() {
            return 0;
        }
    }
}

