/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.query.h2.twostep.GridMergeIndex;
import org.apache.ignite.internal.util.GridRandom;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.testsuites.IgniteIgnore;
import org.springframework.util.StringUtils;

public class IgniteSqlSplitterSelfTest
extends GridCommonAbstractTest {
    private static final int CLIENT = 7;
    private static final TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheKeyConfiguration keyCfg = new CacheKeyConfiguration(TestKey.class.getName(), "affKey");
        cfg.setCacheKeyConfiguration(new CacheKeyConfiguration[]{keyCfg});
        cfg.setPeerClassLoadingEnabled(false);
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        disco.setIpFinder(ipFinder);
        cfg.setDiscoverySpi((DiscoverySpi)disco);
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(3, false);
        Ignition.setClientMode((boolean)true);
        try {
            this.startGrid(7);
        }
        finally {
            Ignition.setClientMode((boolean)false);
        }
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
    }

    private static CacheConfiguration cacheConfig(String name, boolean partitioned, Class<?> ... idxTypes) {
        return new CacheConfiguration("default").setName(name).setCacheMode(partitioned ? CacheMode.PARTITIONED : CacheMode.REPLICATED).setAtomicityMode(CacheAtomicityMode.ATOMIC).setBackups(1).setIndexedTypes((Class[])idxTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOffsetLimit() throws Exception {
        IgniteCache c = this.ignite(0).getOrCreateCache(IgniteSqlSplitterSelfTest.cacheConfig("ints", true, Integer.class, Integer.class));
        try {
            this.awaitPartitionMapExchange();
            ArrayList<Integer> res = new ArrayList<Integer>();
            GridRandom rnd = new GridRandom();
            for (int i = 0; i < 10; ++i) {
                int val = rnd.nextInt(100);
                c.put((Object)i, (Object)val);
                res.add(val);
            }
            Collections.sort(res);
            String qry = "select _val from Integer order by _val ";
            this.assertEqualsCollections(res, IgniteSqlSplitterSelfTest.columnQuery(c, qry, new Object[0]));
            this.assertEqualsCollections(res.subList(0, 0), IgniteSqlSplitterSelfTest.columnQuery(c, qry + "limit ?", 0));
            this.assertEqualsCollections(res.subList(0, 3), IgniteSqlSplitterSelfTest.columnQuery(c, qry + "limit ?", 3));
            this.assertEqualsCollections(res.subList(0, 9), IgniteSqlSplitterSelfTest.columnQuery(c, qry + "limit ? offset ?", 9, 0));
            this.assertEqualsCollections(res.subList(3, 7), IgniteSqlSplitterSelfTest.columnQuery(c, qry + "limit ? offset ?", 4, 3));
            this.assertEqualsCollections(res.subList(7, 9), IgniteSqlSplitterSelfTest.columnQuery(c, qry + "limit ? offset ?", 2, 7));
            this.assertEqualsCollections(res.subList(8, 10), IgniteSqlSplitterSelfTest.columnQuery(c, qry + "limit ? offset ?", 2, 8));
            this.assertEqualsCollections(res.subList(9, 10), IgniteSqlSplitterSelfTest.columnQuery(c, qry + "limit ? offset ?", 1, 9));
            this.assertEqualsCollections(res.subList(10, 10), IgniteSqlSplitterSelfTest.columnQuery(c, qry + "limit ? offset ?", 1, 10));
            this.assertEqualsCollections(res.subList(9, 10), IgniteSqlSplitterSelfTest.columnQuery(c, qry + "limit ? offset abs(-(4 + ?))", 1, 5));
        }
        finally {
            c.destroy();
        }
    }

    public void testReplicatedTablesUsingPartitionedCache() {
        this.doTestReplicatedTablesUsingPartitionedCache(1, false, false);
    }

    public void testReplicatedTablesUsingPartitionedCacheSegmented() {
        this.doTestReplicatedTablesUsingPartitionedCache(5, false, false);
    }

    public void testReplicatedTablesUsingPartitionedCacheClient() {
        this.doTestReplicatedTablesUsingPartitionedCache(1, true, false);
    }

    public void testReplicatedTablesUsingPartitionedCacheSegmentedClient() {
        this.doTestReplicatedTablesUsingPartitionedCache(5, true, false);
    }

    public void testReplicatedTablesUsingPartitionedCacheRO() {
        this.doTestReplicatedTablesUsingPartitionedCache(1, false, true);
    }

    public void testReplicatedTablesUsingPartitionedCacheSegmentedRO() {
        this.doTestReplicatedTablesUsingPartitionedCache(5, false, true);
    }

    public void testReplicatedTablesUsingPartitionedCacheClientRO() {
        this.doTestReplicatedTablesUsingPartitionedCache(1, true, true);
    }

    public void testReplicatedTablesUsingPartitionedCacheSegmentedClientRO() {
        this.doTestReplicatedTablesUsingPartitionedCache(5, true, true);
    }

    private SqlFieldsQuery query(String sql, boolean replicatedOnly) {
        SqlFieldsQuery qry = new SqlFieldsQuery(sql);
        if (replicatedOnly) {
            qry.setReplicatedOnly(true);
        }
        return qry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestReplicatedTablesUsingPartitionedCache(int segments, boolean client, boolean replicatedOnlyFlag) {
        IgniteCache p = this.ignite(client ? 7 : 0).getOrCreateCache(IgniteSqlSplitterSelfTest.cacheConfig("p", true, Integer.class, Value.class).setQueryParallelism(segments));
        IgniteCache r = this.ignite(client ? 7 : 0).getOrCreateCache(IgniteSqlSplitterSelfTest.cacheConfig("r", false, Integer.class, Value.class));
        try {
            int cnt = 1000;
            for (int i = 0; i < cnt; ++i) {
                r.put((Object)i, (Object)new Value(i, -i));
            }
            IgniteSqlSplitterSelfTest.assertEquals((int)cnt, (int)p.query((Query)this.query("select 1 from \"r\".Value", replicatedOnlyFlag)).getAll().size());
            List res = p.query((Query)this.query("select count(1) from \"r\".Value", replicatedOnlyFlag)).getAll();
            IgniteSqlSplitterSelfTest.assertEquals((int)1, (int)res.size());
            IgniteSqlSplitterSelfTest.assertEquals((int)cnt, (int)((Number)((List)res.get(0)).get(0)).intValue());
        }
        finally {
            p.destroy();
            r.destroy();
        }
    }

    public void testPartitionedTablesUsingReplicatedCache() {
        this.doTestPartitionedTablesUsingReplicatedCache(1, false);
    }

    public void testPartitionedTablesUsingReplicatedCacheSegmented() {
        this.doTestPartitionedTablesUsingReplicatedCache(7, false);
    }

    public void testPartitionedTablesUsingReplicatedCacheClient() {
        this.doTestPartitionedTablesUsingReplicatedCache(1, true);
    }

    public void testPartitionedTablesUsingReplicatedCacheSegmentedClient() {
        this.doTestPartitionedTablesUsingReplicatedCache(7, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestPartitionedTablesUsingReplicatedCache(int segments, boolean client) {
        IgniteCache p = this.ignite(client ? 7 : 0).getOrCreateCache(IgniteSqlSplitterSelfTest.cacheConfig("p", true, Integer.class, Value.class).setQueryParallelism(segments));
        IgniteCache r = this.ignite(client ? 7 : 0).getOrCreateCache(IgniteSqlSplitterSelfTest.cacheConfig("r", false, Integer.class, Value.class));
        try {
            int cnt = 1000;
            for (int i = 0; i < cnt; ++i) {
                p.put((Object)i, (Object)new Value(i, -i));
            }
            IgniteSqlSplitterSelfTest.assertEquals((int)cnt, (int)r.query((Query)new SqlFieldsQuery("select 1 from \"p\".Value")).getAll().size());
            List res = r.query((Query)new SqlFieldsQuery("select count(1) from \"p\".Value")).getAll();
            IgniteSqlSplitterSelfTest.assertEquals((int)1, (int)res.size());
            IgniteSqlSplitterSelfTest.assertEquals((int)cnt, (int)((Number)((List)res.get(0)).get(0)).intValue());
        }
        finally {
            p.destroy();
            r.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedJoinFromReplicatedCache() throws InterruptedException {
        CacheConfiguration ccfg1 = IgniteSqlSplitterSelfTest.cacheConfig("pers", true, Integer.class, Person2.class);
        CacheConfiguration ccfg2 = IgniteSqlSplitterSelfTest.cacheConfig("org", true, Integer.class, Organization.class);
        CacheConfiguration ccfg3 = IgniteSqlSplitterSelfTest.cacheConfig("orgRepl", false, Integer.class, Organization.class);
        IgniteCache c1 = this.ignite(0).getOrCreateCache(ccfg1);
        IgniteCache c2 = this.ignite(0).getOrCreateCache(ccfg2);
        IgniteCache c3 = this.ignite(0).getOrCreateCache(ccfg3);
        try {
            this.awaitPartitionMapExchange();
            this.doTestDistributedJoins(c3, (IgniteCache<Integer, Person2>)c1, (IgniteCache<Integer, Organization>)c2, 300, 2000, 5, false);
            this.doTestDistributedJoins(c3, (IgniteCache<Integer, Person2>)c1, (IgniteCache<Integer, Organization>)c2, 300, 2000, 5, true);
        }
        finally {
            c1.destroy();
            c2.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExists() {
        IgniteCache x = this.ignite(0).getOrCreateCache(IgniteSqlSplitterSelfTest.cacheConfig("x", true, Integer.class, Person2.class));
        IgniteCache y = this.ignite(0).getOrCreateCache(IgniteSqlSplitterSelfTest.cacheConfig("y", true, Integer.class, Person2.class));
        try {
            GridRandom rnd = new GridRandom();
            HashSet<Integer> intersects = new HashSet<Integer>();
            for (int i = 0; i < 3000; ++i) {
                int r = rnd.nextInt(3);
                if (r != 0) {
                    x.put((Object)i, (Object)new Person2(i, "pers_x_" + i));
                }
                if (r != 1) {
                    y.put((Object)i, (Object)new Person2(i, "pers_y_" + i));
                }
                if (r != 2) continue;
                intersects.add(i);
            }
            IgniteSqlSplitterSelfTest.assertFalse((boolean)intersects.isEmpty());
            List res = x.query((Query)new SqlFieldsQuery("select _key from \"x\".Person2 px where exists(select 1 from \"y\".Person2 py where px._key = py._key)")).getAll();
            IgniteSqlSplitterSelfTest.assertEquals((int)intersects.size(), (int)res.size());
            for (List row : res) {
                IgniteSqlSplitterSelfTest.assertTrue((boolean)intersects.contains(row.get(0)));
            }
        }
        finally {
            x.destroy();
            y.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSortedMergeIndex() throws Exception {
        IgniteCache c = this.ignite(0).getOrCreateCache(IgniteSqlSplitterSelfTest.cacheConfig("v", true, Integer.class, Value.class));
        try {
            GridTestUtils.setFieldValue(null, GridMergeIndex.class, (String)"PREFETCH_SIZE", (Object)8);
            GridRandom rnd = new GridRandom();
            int cnt = 1000;
            for (int i = 0; i < cnt; ++i) {
                c.put((Object)i, (Object)new Value(rnd.nextInt(5) == 0 ? null : Integer.valueOf(rnd.nextInt(100)), rnd.nextInt(8) == 0 ? null : Integer.valueOf(rnd.nextInt(2000))));
            }
            List plan = c.query((Query)new SqlFieldsQuery("explain select snd from Value order by fst desc")).getAll();
            String rdcPlan = (String)((List)plan.get(1)).get(0);
            IgniteSqlSplitterSelfTest.assertTrue((boolean)rdcPlan.contains("merge_sorted"));
            IgniteSqlSplitterSelfTest.assertTrue((boolean)rdcPlan.contains("/* index sorted */"));
            plan = c.query((Query)new SqlFieldsQuery("explain select snd from Value")).getAll();
            rdcPlan = (String)((List)plan.get(1)).get(0);
            IgniteSqlSplitterSelfTest.assertTrue((boolean)rdcPlan.contains("merge_scan"));
            IgniteSqlSplitterSelfTest.assertFalse((boolean)rdcPlan.contains("/* index sorted */"));
            for (int i = 0; i < 10; ++i) {
                X.println((String)(" --> " + i), (Object[])new Object[0]);
                List res = c.query((Query)new SqlFieldsQuery("select fst from Value order by fst").setPageSize(5)).getAll();
                IgniteSqlSplitterSelfTest.assertEquals((int)cnt, (int)res.size());
                Integer p = null;
                for (List row : res) {
                    Integer x = (Integer)row.get(0);
                    if (x == null) continue;
                    if (p != null) {
                        IgniteSqlSplitterSelfTest.assertTrue((String)(x + " >= " + p), (x >= p ? 1 : 0) != 0);
                    }
                    p = x;
                }
            }
        }
        finally {
            GridTestUtils.setFieldValue(null, GridMergeIndex.class, (String)"PREFETCH_SIZE", (Object)1024);
            c.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGroupIndexOperations() throws Exception {
        IgniteCache c = this.ignite(0).getOrCreateCache(IgniteSqlSplitterSelfTest.cacheConfig("grp", false, Integer.class, GroupIndexTestValue.class));
        try {
            this.awaitPartitionMapExchange();
            String qry = "select 1 from GroupIndexTestValue ";
            String plan = IgniteSqlSplitterSelfTest.columnQuery(c, "explain " + qry + "where a = 1 and b > 0", new Object[0]).get(0).toString();
            this.info("Plan: " + plan);
            IgniteSqlSplitterSelfTest.assertTrue((String)("_explain: " + plan), (boolean)plan.toLowerCase().contains("grpidx"));
            List list = F.asList((Object[])new GroupIndexTestValue[]{new GroupIndexTestValue(0, 0), new GroupIndexTestValue(0, 5), new GroupIndexTestValue(1, 1), new GroupIndexTestValue(1, 3), new GroupIndexTestValue(2, -1), new GroupIndexTestValue(2, 2)});
            for (int i = 0; i < list.size(); ++i) {
                c.put((Object)i, list.get(i));
            }
            IgniteSqlSplitterSelfTest.assertEquals((int)1, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a = 1 and b = 1", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)0, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a = 1 and b = 2", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)1, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a = 1 and b = 3", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a = 1 and b < 4", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a = 1 and b <= 3", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)1, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a = 1 and b < 3", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a = 1 and b > 0", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)1, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a = 1 and b > 1", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a = 1 and b >= 1", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)4, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a > 0", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)4, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a >= 1", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)4, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where b > 0", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)4, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where b >= 1", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)4, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a < 2", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)4, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a <= 1", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)4, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where b < 3", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)5, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where b <= 3", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)3, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a > 0 and b > 0", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a > 0 and b >= 2", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)3, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a >= 1 and b > 0", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a >= 1 and b >= 2", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)3, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a > 0 and b < 3", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a > 0 and b <= 1", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)3, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a >= 1 and b < 3", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a >= 1 and b <= 1", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a < 2 and b < 3", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a < 2 and b <= 1", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a <= 1 and b < 3", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a <= 1 and b <= 1", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)3, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a < 2 and b > 0", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a < 2 and b >= 3", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)3, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a <= 1 and b > 0", new Object[0]).size());
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)IgniteSqlSplitterSelfTest.columnQuery(c, qry + "where a <= 1 and b >= 3", new Object[0]).size());
        }
        finally {
            c.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUseIndexHints() {
        CacheConfiguration ccfg = IgniteSqlSplitterSelfTest.cacheConfig("pers", true, Integer.class, Person2.class);
        IgniteCache c = this.ignite(0).getOrCreateCache(ccfg);
        try {
            String select = "select 1 from Person2 use index (\"PERSON2_ORGID_IDX\") where name = '' and orgId = 1";
            String plan = c.query((Query)new SqlFieldsQuery("explain " + select)).getAll().toString();
            X.println((String)("Plan: \n" + plan), (Object[])new Object[0]);
            IgniteSqlSplitterSelfTest.assertTrue((boolean)plan.contains("USE INDEX (PERSON2_ORGID_IDX)"));
            IgniteSqlSplitterSelfTest.assertTrue((boolean)plan.contains("/* \"pers\".PERSON2_ORGID_IDX:"));
            select = "select 1 from Person2 use index (\"PERSON2_NAME_IDX\") where name = '' and orgId = 1";
            plan = c.query((Query)new SqlFieldsQuery("explain " + select)).getAll().toString();
            X.println((String)("Plan: \n" + plan), (Object[])new Object[0]);
            IgniteSqlSplitterSelfTest.assertTrue((boolean)plan.contains("USE INDEX (PERSON2_NAME_IDX)"));
            IgniteSqlSplitterSelfTest.assertTrue((boolean)plan.contains("/* \"pers\".PERSON2_NAME_IDX:"));
        }
        finally {
            c.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedJoins() throws Exception {
        CacheConfiguration ccfg1 = IgniteSqlSplitterSelfTest.cacheConfig("pers", true, Integer.class, Person2.class);
        CacheConfiguration ccfg2 = IgniteSqlSplitterSelfTest.cacheConfig("org", true, Integer.class, Organization.class);
        IgniteCache c1 = this.ignite(0).getOrCreateCache(ccfg1);
        IgniteCache c2 = this.ignite(0).getOrCreateCache(ccfg2);
        try {
            this.awaitPartitionMapExchange();
            this.doTestDistributedJoins(c2, (IgniteCache<Integer, Person2>)c1, (IgniteCache<Integer, Organization>)c2, 30, 100, 1000, false);
            this.doTestDistributedJoins(c2, (IgniteCache<Integer, Person2>)c1, (IgniteCache<Integer, Organization>)c2, 30, 100, 1000, true);
            this.doTestDistributedJoins(c2, (IgniteCache<Integer, Person2>)c1, (IgniteCache<Integer, Organization>)c2, 3, 10, 3, false);
            this.doTestDistributedJoins(c2, (IgniteCache<Integer, Person2>)c1, (IgniteCache<Integer, Organization>)c2, 3, 10, 3, true);
            this.doTestDistributedJoins(c2, (IgniteCache<Integer, Person2>)c1, (IgniteCache<Integer, Organization>)c2, 300, 2000, 5, false);
            this.doTestDistributedJoins(c2, (IgniteCache<Integer, Person2>)c1, (IgniteCache<Integer, Organization>)c2, 300, 2000, 5, true);
        }
        finally {
            c1.destroy();
            c2.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedJoinsUnion() throws Exception {
        CacheConfiguration ccfg1 = IgniteSqlSplitterSelfTest.cacheConfig("pers", true, Integer.class, Person2.class);
        CacheConfiguration ccfg2 = IgniteSqlSplitterSelfTest.cacheConfig("org", true, Integer.class, Organization.class);
        IgniteCache c1 = this.ignite(0).getOrCreateCache(ccfg1);
        IgniteCache c2 = this.ignite(0).getOrCreateCache(ccfg2);
        try {
            c2.put((Object)1, (Object)new Organization("o1"));
            c2.put((Object)2, (Object)new Organization("o2"));
            c1.put((Object)3, (Object)new Person2(1, "p1"));
            c1.put((Object)4, (Object)new Person2(2, "p2"));
            c1.put((Object)5, (Object)new Person2(3, "p3"));
            String select = "select o.name n1, p.name n2 from Person2 p, \"org\".Organization o where p.orgId = o._key and o._key=1 union select o.name n1, p.name n2 from Person2 p, \"org\".Organization o where p.orgId = o._key and o._key=2";
            String plan = c1.query((Query)new SqlFieldsQuery("explain " + select).setDistributedJoins(true).setEnforceJoinOrder(true)).getAll().toString();
            X.println((String)("Plan : " + plan), (Object[])new Object[0]);
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)StringUtils.countOccurrencesOf((String)plan, (String)"batched"));
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)StringUtils.countOccurrencesOf((String)plan, (String)"batched:unicast"));
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)c1.query((Query)new SqlFieldsQuery(select).setDistributedJoins(true).setEnforceJoinOrder(false)).getAll().size());
            select = "select * from (" + select + ")";
            plan = c1.query((Query)new SqlFieldsQuery("explain " + select).setDistributedJoins(true).setEnforceJoinOrder(true)).getAll().toString();
            X.println((String)("Plan : " + plan), (Object[])new Object[0]);
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)StringUtils.countOccurrencesOf((String)plan, (String)"batched"));
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)StringUtils.countOccurrencesOf((String)plan, (String)"batched:unicast"));
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)c1.query((Query)new SqlFieldsQuery(select).setDistributedJoins(true).setEnforceJoinOrder(false)).getAll().size());
        }
        finally {
            c1.destroy();
            c2.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedJoinsUnionPartitionedReplicated() throws Exception {
        CacheConfiguration ccfg1 = IgniteSqlSplitterSelfTest.cacheConfig("pers", true, Integer.class, Person2.class);
        CacheConfiguration ccfg2 = IgniteSqlSplitterSelfTest.cacheConfig("org", false, Integer.class, Organization.class);
        IgniteCache c1 = this.ignite(0).getOrCreateCache(ccfg1);
        IgniteCache c2 = this.ignite(0).getOrCreateCache(ccfg2);
        try {
            c2.put((Object)1, (Object)new Organization("o1"));
            c2.put((Object)2, (Object)new Organization("o2"));
            c1.put((Object)3, (Object)new Person2(1, "p1"));
            c1.put((Object)4, (Object)new Person2(2, "p2"));
            c1.put((Object)5, (Object)new Person2(3, "p3"));
            String select0 = "select o.name n1, p.name n2 from \"pers\".Person2 p, \"org\".Organization o where p.orgId = o._key and o._key=1 union select o.name n1, p.name n2 from \"org\".Organization o, \"pers\".Person2 p where p.orgId = o._key and o._key=2";
            String plan = (String)((List)c1.query((Query)new SqlFieldsQuery("explain " + select0).setDistributedJoins(true)).getAll().get(0)).get(0);
            X.println((String)("Plan: " + plan), (Object[])new Object[0]);
            IgniteSqlSplitterSelfTest.assertEquals((int)0, (int)StringUtils.countOccurrencesOf((String)plan, (String)"batched"));
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)c1.query((Query)new SqlFieldsQuery(select0).setDistributedJoins(true)).getAll().size());
            String select = "select * from (" + select0 + ")";
            plan = (String)((List)c1.query((Query)new SqlFieldsQuery("explain " + select).setDistributedJoins(true)).getAll().get(0)).get(0);
            X.println((String)("Plan : " + plan), (Object[])new Object[0]);
            IgniteSqlSplitterSelfTest.assertEquals((int)0, (int)StringUtils.countOccurrencesOf((String)plan, (String)"batched"));
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)c1.query((Query)new SqlFieldsQuery(select).setDistributedJoins(true)).getAll().size());
            String select1 = "select o.name n1, p.name n2 from \"pers\".Person2 p, \"org\".Organization o where p.orgId = o._key and o._key=1 union select * from (select o.name n1, p.name n2 from \"org\".Organization o, \"pers\".Person2 p where p.orgId = o._key and o._key=2)";
            plan = (String)((List)c1.query((Query)new SqlFieldsQuery("explain " + select1).setDistributedJoins(true)).getAll().get(0)).get(0);
            X.println((String)("Plan: " + plan), (Object[])new Object[0]);
            IgniteSqlSplitterSelfTest.assertEquals((int)0, (int)StringUtils.countOccurrencesOf((String)plan, (String)"batched"));
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)c1.query((Query)new SqlFieldsQuery(select).setDistributedJoins(true)).getAll().size());
            select = "select * from (" + select1 + ")";
            plan = (String)((List)c1.query((Query)new SqlFieldsQuery("explain " + select).setDistributedJoins(true)).getAll().get(0)).get(0);
            X.println((String)("Plan : " + plan), (Object[])new Object[0]);
            IgniteSqlSplitterSelfTest.assertEquals((int)0, (int)StringUtils.countOccurrencesOf((String)plan, (String)"batched"));
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)c1.query((Query)new SqlFieldsQuery(select).setDistributedJoins(true)).getAll().size());
        }
        finally {
            c1.destroy();
            c2.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedJoinsPlan() throws Exception {
        ArrayList<IgniteCache> caches = new ArrayList<IgniteCache>();
        IgniteCache persPart = this.ignite(0).createCache(IgniteSqlSplitterSelfTest.cacheConfig("persPart", true, Integer.class, Person2.class));
        caches.add(persPart);
        IgniteCache persPartAff = this.ignite(0).createCache(IgniteSqlSplitterSelfTest.cacheConfig("persPartAff", true, TestKey.class, Person2.class));
        caches.add(persPartAff);
        IgniteCache orgPart = this.ignite(0).createCache(IgniteSqlSplitterSelfTest.cacheConfig("orgPart", true, Integer.class, Organization.class));
        caches.add(orgPart);
        IgniteCache orgPartAff = this.ignite(0).createCache(IgniteSqlSplitterSelfTest.cacheConfig("orgPartAff", true, TestKey.class, Organization.class));
        caches.add(orgPartAff);
        IgniteCache orgRepl = this.ignite(0).createCache(IgniteSqlSplitterSelfTest.cacheConfig("orgRepl", false, Integer.class, Organization.class));
        caches.add(orgRepl);
        IgniteCache orgRepl2 = this.ignite(0).createCache(IgniteSqlSplitterSelfTest.cacheConfig("orgRepl2", false, Integer.class, Organization.class));
        caches.add(orgRepl2);
        try {
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, true, 1, "select p._key k1, o._key k2 from \"persPart\".Person2 p, \"orgPart\".Organization o where p.orgId = o._key", "batched:unicast");
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 1, "select p._key k1, o._key k2 from \"persPart\".Person2 p, \"orgPartAff\".Organization o where p.orgId = o.affKey", "batched:unicast");
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 1, "select p._key k1, o._key k2 from \"persPart\".Person2 p, \"orgPart\".Organization o where p.orgId = o._key", "batched:unicast");
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 1, "select p._key k1, o._key k2 from \"persPart\".Person2 p inner join \"orgPart\".Organization o on p.orgId = o._key", "batched:unicast");
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 1, "select p._key k1, o._key k2 from \"persPart\".Person2 p left outer join \"orgPart\".Organization o on p.orgId = o._key", "batched:unicast");
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, true, 1, "select p._key k1, o._key k2 from \"orgPart\".Organization o, \"persPart\".Person2 p where p.orgId = o._key", "batched:broadcast");
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, true, 1, "select p._key k1, o._key k2 from \"orgPartAff\".Organization o, \"persPart\".Person2 p where p.orgId = o.affKey", "batched:broadcast");
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, true, 0, "select p._key k1, o._key k2 from \"persPart\".Person2 p, \"orgRepl\".Organization o where p.orgId = o._key", new String[0]);
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 0, "select p._key k1, o._key k2 from \"persPart\".Person2 p, \"orgRepl\".Organization o where p.orgId = o._key", new String[0]);
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 0, "select p._key k1, o._key k2 from \"persPart\".Person2 p, (select _key, _val, * from \"orgRepl\".Organization) o where p.orgId = o._key", new String[0]);
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 0, "select p._key k1, o._key k2 from (select _key, _val, * from \"orgRepl\".Organization) o, \"persPart\".Person2 p where p.orgId = o._key", new String[0]);
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 0, "select p._key k1, o._key k2 from \"persPart\".Person2 p inner join \"orgRepl\".Organization o on p.orgId = o._key", new String[0]);
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 0, "select p._key k1, o._key k2 from \"persPart\".Person2 p left outer join \"orgRepl\".Organization o on p.orgId = o._key", new String[0]);
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 0, "select p._key k1, o._key k2 from \"orgRepl\".Organization o, \"persPart\".Person2 p where p.orgId = o._key", new String[0]);
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 0, "select p._key k1, o._key k2 from \"orgRepl\".Organization o inner join \"persPart\".Person2 p on p.orgId = o._key", new String[0]);
            this.checkNoBatchedJoin((IgniteCache<Object, Object>)persPart, "select p._key k1, o._key k2 ", "\"persPart\".Person2 p", "\"orgPart\".Organization o", "where p._key = o._key", true);
            this.checkNoBatchedJoin((IgniteCache<Object, Object>)persPart, "select p._key k1, o._key k2 ", "\"persPart\".Person2 p", "\"orgRepl\".Organization o", "where p._key = o._key", true);
            this.checkNoBatchedJoin((IgniteCache<Object, Object>)persPartAff, "select p._key k1, o._key k2 ", "\"persPartAff\".Person2 p", "\"orgPart\".Organization o", "where p.affKey = o._key", true);
            this.checkNoBatchedJoin((IgniteCache<Object, Object>)persPartAff, "select p._key k1, o._key k2 ", "\"persPartAff\".Person2 p", "\"orgRepl\".Organization o", "where p.affKey = o._key", true);
            String sql = "select * from (select o1._key k1, o2._key k2 from \"orgRepl\".Organization o1, \"orgRepl2\".Organization o2 where o1._key > o2._key) o, \"persPart\".Person2 p where p.orgId = o.k1";
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 0, sql, new String[0]);
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, true, 0, sql, new String[0]);
            sql = "select o.k1, p1._key k2, p2._key k3 from (select o1._key k1, o2._key k2 from \"orgRepl\".Organization o1, \"orgRepl2\".Organization o2 where o1._key > o2._key) o, \"persPartAff\".Person2 p1, \"persPart\".Person2 p2 where p1._key=p2._key and p2.orgId = o.k1";
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 0, sql, "persPartAff", "persPart", "orgRepl");
            this.checkQueryFails((IgniteCache<Object, Object>)persPart, sql, true);
            sql = "select o.ok, p._key from (select o1._key ok, p1._key pk from \"orgRepl\".Organization o1, \"persPart\".Person2 p1 where o1._key = p1.orgId) o, \"persPartAff\".Person2 p where p._key=o.ok";
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 1, sql, "FROM \"persPart\"", "INNER JOIN \"orgRepl\"", "INNER JOIN \"persPartAff\"", "batched:unicast");
            this.checkQueryFails((IgniteCache<Object, Object>)persPart, sql, true);
            sql = "select p1._key k1, p2._key k2, o._key k3 from \"persPartAff\".Person2 p1, \"persPart\".Person2 p2, \"orgPart\".Organization o where p1.affKey=p2._key and p2.orgId = o._key";
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, true, 2, sql, "batched:unicast", "batched:unicast");
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 2, sql, "batched:unicast", "batched:unicast");
            sql = "select p1._key k1, p2._key k2, o._key k3 from \"persPartAff\".Person2 p1, \"persPart\".Person2 p2, \"orgPart\".Organization o where p1.affKey > p2._key and p2.orgId = o._key";
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, true, 2, sql, "batched:broadcast", "batched:unicast");
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 2, sql, "batched:broadcast", "batched:unicast");
            sql = "select p1._key k1, p2._key k2, o._key k3 from \"persPartAff\".Person2 p1, \"persPart\".Person2 p2, \"orgRepl\".Organization o where p1.affKey=p2._key and p2.orgId = o._key";
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, true, 0, sql, new String[0]);
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 0, sql, new String[0]);
            sql = "select p1._key k1, p2._key k2, o._key k3 from \"persPartAff\".Person2 p1, \"persPart\".Person2 p2, \"orgRepl\".Organization o where p1._key=p2.name and p2.orgId = o._key";
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 1, sql, "batched:unicast");
            sql = "select p1._key k1, p2._key k2, o._key k3 from \"persPartAff\".Person2 p1, \"persPart\".Person2 p2, \"orgRepl\".Organization o where p1._key=p2._key and p2.orgId = o._key";
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 0, sql, new String[0]);
            sql = "select p1._key k1, p2._key k2, o._key k3 from \"orgRepl\".Organization o, \"persPartAff\".Person2 p1, \"persPart\".Person2 p2 where p1._key=p2.name and p2.orgId = o._key";
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 1, sql, "batched:unicast");
            sql = "select p1._key k1, p2._key k2, o._key k3 from \"orgRepl\".Organization o, \"persPartAff\".Person2 p1, \"persPart\".Person2 p2 where p1._key=p2._key and p2.orgId = o._key";
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 0, sql, new String[0]);
            sql = "select p1._key k1, p2._key k2, o._key k3 from (select _key, _val, * from \"orgRepl\".Organization) o, \"persPartAff\".Person2 p1, \"persPart\".Person2 p2 where p1._key=p2.name and p2.orgId = o._key";
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 1, sql, "batched:unicast");
            sql = "select p1._key k1, p2._key k2, o._key k3 from (select _key, _val, * from \"orgRepl\".Organization) o, \"persPartAff\".Person2 p1, \"persPart\".Person2 p2 where p1._key=p2._key and p2.orgId = o._key";
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, false, 0, sql, new String[0]);
        }
        finally {
            for (IgniteCache cache : caches) {
                this.ignite(0).destroyCache(cache.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedJoinsEnforceReplicatedNotLast() throws Exception {
        ArrayList<IgniteCache> caches = new ArrayList<IgniteCache>();
        IgniteCache persPart = this.ignite(0).createCache(IgniteSqlSplitterSelfTest.cacheConfig("persPart", true, Integer.class, Person2.class));
        caches.add(persPart);
        IgniteCache persPartAff = this.ignite(0).createCache(IgniteSqlSplitterSelfTest.cacheConfig("persPartAff", true, TestKey.class, Person2.class));
        caches.add(persPartAff);
        IgniteCache orgRepl = this.ignite(0).createCache(IgniteSqlSplitterSelfTest.cacheConfig("orgRepl", false, Integer.class, Organization.class));
        caches.add(orgRepl);
        try {
            this.checkQueryFails((IgniteCache<Object, Object>)persPart, "select p1._key k1, p2._key k2, o._key k3 from \"orgRepl\".Organization o, \"persPartAff\".Person2 p1, \"persPart\".Person2 p2 where p1._key=p2._key and p2.orgId = o._key", true);
            this.checkQueryFails((IgniteCache<Object, Object>)persPart, "select p1._key k1, p2._key k2, o._key k3 from \"persPartAff\".Person2 p1, \"orgRepl\".Organization o, \"persPart\".Person2 p2 where p1._key=p2._key and p2.orgId = o._key", true);
            this.checkQueryFails((IgniteCache<Object, Object>)persPart, "select p1._key k1, p2._key k2, o._key k3 from \"persPartAff\".Person2 p1, (select * from \"orgRepl\".Organization) o, \"persPart\".Person2 p2 where p1._key=p2._key and p2.orgId = o._key", true);
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, true, 0, "select p._key k1, o._key k2 from \"orgRepl\".Organization o, \"persPart\".Person2 p", new String[0]);
            this.checkQueryPlan((IgniteCache<Object, Object>)persPart, true, 0, "select p._key k1, o._key k2 from \"orgRepl\".Organization o, \"persPart\".Person2 p union select p._key k1, o._key k2 from \"persPart\".Person2 p, \"orgRepl\".Organization o", new String[0]);
        }
        finally {
            for (IgniteCache cache : caches) {
                this.ignite(0).destroyCache(cache.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIndexSegmentation() throws Exception {
        CacheConfiguration ccfg1 = IgniteSqlSplitterSelfTest.cacheConfig("pers", true, Integer.class, Person2.class).setQueryParallelism(4);
        CacheConfiguration ccfg2 = IgniteSqlSplitterSelfTest.cacheConfig("org", true, Integer.class, Organization.class).setQueryParallelism(4);
        IgniteCache c1 = this.ignite(0).getOrCreateCache(ccfg1);
        IgniteCache c2 = this.ignite(0).getOrCreateCache(ccfg2);
        try {
            c2.put((Object)1, (Object)new Organization("o1"));
            c2.put((Object)2, (Object)new Organization("o2"));
            c1.put((Object)3, (Object)new Person2(1, "p1"));
            c1.put((Object)4, (Object)new Person2(2, "p2"));
            c1.put((Object)5, (Object)new Person2(3, "p3"));
            String select0 = "select o.name n1, p.name n2 from \"pers\".Person2 p, \"org\".Organization o where p.orgId = o._key and o._key=1";
            this.checkQueryPlan((IgniteCache<Object, Object>)c1, true, 1, new SqlFieldsQuery(select0), new String[0]);
            this.checkQueryPlan((IgniteCache<Object, Object>)c1, true, 1, new SqlFieldsQuery(select0).setLocal(true), new String[0]);
        }
        finally {
            c1.destroy();
            c2.destroy();
        }
    }

    public void testReplicationCacheIndexSegmentationFailure() throws Exception {
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                CacheConfiguration ccfg = IgniteSqlSplitterSelfTest.cacheConfig("org", false, new Class[]{Integer.class, Organization.class}).setQueryParallelism(4);
                IgniteCache c = IgniteSqlSplitterSelfTest.this.ignite(0).createCache(ccfg);
                return null;
            }
        }, CacheException.class, (String)" Segmented indices are supported for PARTITIONED mode only.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIndexSegmentationPartitionedReplicated() throws Exception {
        CacheConfiguration ccfg1 = IgniteSqlSplitterSelfTest.cacheConfig("pers", true, Integer.class, Person2.class).setQueryParallelism(4);
        CacheConfiguration ccfg2 = IgniteSqlSplitterSelfTest.cacheConfig("org", false, Integer.class, Organization.class);
        IgniteCache c1 = this.ignite(0).getOrCreateCache(ccfg1);
        IgniteCache c2 = this.ignite(0).getOrCreateCache(ccfg2);
        try {
            c2.put((Object)1, (Object)new Organization("o1"));
            c2.put((Object)2, (Object)new Organization("o2"));
            c1.put((Object)3, (Object)new Person2(1, "p1"));
            c1.put((Object)4, (Object)new Person2(2, "p2"));
            c1.put((Object)5, (Object)new Person2(3, "p3"));
            String select0 = "select o.name n1, p.name n2 from \"pers\".Person2 p, \"org\".Organization o where p.orgId = o._key";
            SqlFieldsQuery qry = new SqlFieldsQuery(select0);
            qry.setDistributedJoins(true);
            List results = c1.query((Query)qry).getAll();
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)results.size());
            select0 = select0 + " order by n2 desc";
            qry = new SqlFieldsQuery(select0);
            qry.setDistributedJoins(true);
            results = c1.query((Query)qry).getAll();
            IgniteSqlSplitterSelfTest.assertEquals((int)2, (int)results.size());
            IgniteSqlSplitterSelfTest.assertEquals((Object)"p2", ((List)results.get(0)).get(1));
            IgniteSqlSplitterSelfTest.assertEquals((Object)"p1", ((List)results.get(1)).get(1));
            select0 = "select p.name from \"pers\".Person2 p, (select max(_key) orgId from \"org\".Organization) o where p.orgId = o.orgId";
            X.println((String)("Plan: \n" + c1.query((Query)new SqlFieldsQuery("explain " + select0).setDistributedJoins(true)).getAll()), (Object[])new Object[0]);
            qry = new SqlFieldsQuery(select0);
            qry.setDistributedJoins(true);
            results = c1.query((Query)qry).getAll();
            IgniteSqlSplitterSelfTest.assertEquals((int)1, (int)results.size());
            IgniteSqlSplitterSelfTest.assertEquals((Object)"p2", ((List)results.get(0)).get(0));
        }
        finally {
            c1.destroy();
            c2.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIndexWithDifferentSegmentationLevelsFailure() throws Exception {
        CacheConfiguration ccfg1 = IgniteSqlSplitterSelfTest.cacheConfig("pers", true, Integer.class, Person2.class).setQueryParallelism(4);
        CacheConfiguration ccfg2 = IgniteSqlSplitterSelfTest.cacheConfig("org", true, Integer.class, Organization.class).setQueryParallelism(3);
        final IgniteCache c1 = this.ignite(0).getOrCreateCache(ccfg1);
        IgniteCache c2 = this.ignite(0).getOrCreateCache(ccfg2);
        try {
            c2.put((Object)1, (Object)new Organization("o1"));
            c2.put((Object)2, (Object)new Organization("o2"));
            c1.put((Object)3, (Object)new Person2(1, "p1"));
            c1.put((Object)4, (Object)new Person2(2, "p2"));
            c1.put((Object)5, (Object)new Person2(3, "p3"));
            String select0 = "select o.name n1, p.name n2 from \"pers\".Person2 p, \"org\".Organization o where p.orgId = o._key and o._key=1";
            final SqlFieldsQuery qry = new SqlFieldsQuery(select0);
            qry.setDistributedJoins(true);
            GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    c1.query((Query)qry);
                    return null;
                }
            }, CacheException.class, (String)"Using indexes with different parallelism levels in same query is forbidden.");
        }
        finally {
            c1.destroy();
            c2.destroy();
        }
    }

    private void checkQueryFails(final IgniteCache<Object, Object> cache, String sql, boolean enforceJoinOrder) {
        final SqlFieldsQuery qry = new SqlFieldsQuery(sql);
        qry.setDistributedJoins(true);
        qry.setEnforceJoinOrder(enforceJoinOrder);
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                cache.query((Query)qry);
                return null;
            }
        }, CacheException.class, null);
    }

    private void checkNoBatchedJoin(IgniteCache<Object, Object> cache, String select, String cache1, String cache2, String where, boolean testEnforceJoinOrder) {
        this.checkQueryPlan(cache, false, 0, select + "from " + cache1 + "," + cache2 + " " + where, new String[0]);
        this.checkQueryPlan(cache, false, 0, select + "from " + cache2 + "," + cache1 + " " + where, new String[0]);
        if (testEnforceJoinOrder) {
            this.checkQueryPlan(cache, true, 0, select + "from " + cache1 + "," + cache2 + " " + where, new String[0]);
            this.checkQueryPlan(cache, true, 0, select + "from " + cache2 + "," + cache1 + " " + where, new String[0]);
        }
    }

    private void checkQueryPlan(IgniteCache<Object, Object> cache, boolean enforceJoinOrder, int expBatchedJoins, String sql, String ... expText) {
        this.checkQueryPlan(cache, enforceJoinOrder, expBatchedJoins, new SqlFieldsQuery(sql), expText);
        sql = "select * from (" + sql + ")";
        this.checkQueryPlan(cache, enforceJoinOrder, expBatchedJoins, new SqlFieldsQuery(sql), expText);
        sql = "select * from (" + sql + ")";
        this.checkQueryPlan(cache, enforceJoinOrder, expBatchedJoins, new SqlFieldsQuery(sql), expText);
    }

    private void checkQueryPlan(IgniteCache<Object, Object> cache, boolean enforceJoinOrder, int expBatchedJoins, SqlFieldsQuery qry, String ... expText) {
        qry.setEnforceJoinOrder(enforceJoinOrder);
        qry.setDistributedJoins(true);
        String plan = this.queryPlan(cache, qry);
        this.log.info("\n  Plan:\n" + plan);
        IgniteSqlSplitterSelfTest.assertEquals((String)("Unexpected number of batched joins in plan [plan=" + plan + ", qry=" + qry + ']'), (int)expBatchedJoins, (int)StringUtils.countOccurrencesOf((String)plan, (String)"batched"));
        int startIdx = 0;
        for (String exp : expText) {
            int idx = plan.indexOf(exp, startIdx);
            if (idx == -1) {
                IgniteSqlSplitterSelfTest.fail((String)("Plan does not contain expected string [startIdx=" + startIdx + ", plan=" + plan + ", exp=" + exp + ']'));
            }
            startIdx = idx + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHaving() {
        IgniteCache c = this.ignite(0).getOrCreateCache(IgniteSqlSplitterSelfTest.cacheConfig("having", true, Integer.class, Integer.class));
        try {
            GridRandom rnd = new GridRandom();
            HashMap<Integer, AtomicLong> cntMap = new HashMap<Integer, AtomicLong>();
            for (int i = 0; i < 1000; ++i) {
                int v = (int)(50.0 * rnd.nextGaussian());
                c.put((Object)i, (Object)v);
                AtomicLong cnt = (AtomicLong)cntMap.get(v);
                if (cnt == null) {
                    cnt = new AtomicLong();
                    cntMap.put(v, cnt);
                }
                cnt.incrementAndGet();
            }
            IgniteSqlSplitterSelfTest.assertTrue((cntMap.size() > 10 ? 1 : 0) != 0);
            String sqlQry = "select _val, count(*) cnt from Integer group by _val having cnt > ?";
            X.println((String)("Plan: " + c.query((Query)new SqlFieldsQuery("explain " + sqlQry).setArgs(new Object[]{0})).getAll()), (Object[])new Object[0]);
            for (int i = -1; i <= 1001; i += 10) {
                List res = c.query((Query)new SqlFieldsQuery(sqlQry).setArgs(new Object[]{i})).getAll();
                for (List row : res) {
                    int v = (Integer)row.get(0);
                    long cnt = (Long)row.get(1);
                    IgniteSqlSplitterSelfTest.assertTrue((String)(cnt + " > " + i), (cnt > (long)i ? 1 : 0) != 0);
                    IgniteSqlSplitterSelfTest.assertEquals((long)((AtomicLong)cntMap.get(v)).longValue(), (long)cnt);
                }
            }
        }
        finally {
            c.destroy();
        }
    }

    private void doTestDistributedJoins(IgniteCache<?, ?> qryCache, IgniteCache<Integer, Person2> c1, IgniteCache<Integer, Organization> c2, int orgs, int persons, int pageSize, boolean enforceJoinOrder) {
        IgniteSqlSplitterSelfTest.assertEquals((int)0, (int)c1.size(new CachePeekMode[]{CachePeekMode.ALL}));
        IgniteSqlSplitterSelfTest.assertEquals((int)0, (int)c2.size(new CachePeekMode[]{CachePeekMode.ALL}));
        int key = 0;
        for (int i = 0; i < orgs; ++i) {
            Organization o = new Organization();
            o.name = "Org" + i;
            c2.put((Object)key++, (Object)o);
        }
        GridRandom rnd = new GridRandom();
        for (int i = 0; i < persons; ++i) {
            Person2 p = new Person2();
            p.name = "Person" + i;
            p.orgId = rnd.nextInt(orgs);
            c1.put((Object)key++, (Object)p);
        }
        String select = "select count(*) from \"org\".Organization o, \"pers\".Person2 p where p.orgId = o._key";
        String plan = (String)((List)qryCache.query((Query)new SqlFieldsQuery("explain " + select).setDistributedJoins(true).setEnforceJoinOrder(enforceJoinOrder).setPageSize(pageSize)).getAll().get(0)).get(0);
        X.println((String)("Plan : " + plan), (Object[])new Object[0]);
        if (enforceJoinOrder) {
            IgniteSqlSplitterSelfTest.assertTrue((String)plan, (boolean)plan.contains("batched:broadcast"));
        } else {
            IgniteSqlSplitterSelfTest.assertTrue((String)plan, (boolean)plan.contains("batched:unicast"));
        }
        IgniteSqlSplitterSelfTest.assertEquals((Object)persons, ((List)qryCache.query((Query)new SqlFieldsQuery(select).setDistributedJoins(true).setEnforceJoinOrder(enforceJoinOrder).setPageSize(pageSize)).getAll().get(0)).get(0));
        c1.clear();
        c2.clear();
        IgniteSqlSplitterSelfTest.assertEquals((int)0, (int)c1.size(new CachePeekMode[]{CachePeekMode.ALL}));
        IgniteSqlSplitterSelfTest.assertEquals((Object)0L, ((List)c1.query((Query)new SqlFieldsQuery(select).setDistributedJoins(true).setEnforceJoinOrder(enforceJoinOrder).setPageSize(pageSize)).getAll().get(0)).get(0));
    }

    private static <X> List<X> columnQuery(IgniteCache<?, ?> c, String qry, Object ... args) {
        return IgniteSqlSplitterSelfTest.column(0, c.query((Query)new SqlFieldsQuery(qry).setArgs(args)).getAll());
    }

    private static <X> List<X> column(int idx, List<List<?>> rows) {
        ArrayList res = new ArrayList(rows.size());
        for (List<?> row : rows) {
            res.add(row.get(idx));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @IgniteIgnore(value="https://issues.apache.org/jira/browse/IGNITE-1886", forceFailure=true)
    public void testFunctionNpe() {
        IgniteCache userCache = this.ignite(0).createCache(IgniteSqlSplitterSelfTest.cacheConfig("UserCache", true, Integer.class, User.class));
        IgniteCache userOrderCache = this.ignite(0).createCache(IgniteSqlSplitterSelfTest.cacheConfig("UserOrderCache", true, Integer.class, UserOrder.class));
        IgniteCache orderGoodCache = this.ignite(0).createCache(IgniteSqlSplitterSelfTest.cacheConfig("OrderGoodCache", true, Integer.class, OrderGood.class));
        try {
            String sql = "SELECT a.* FROM (SELECT CASE WHEN u.id < 100 THEN u.id ELSE ug.id END id FROM \"UserCache\".User u, UserOrder ug WHERE u.id = ug.userId) a, (SELECT CASE WHEN og.goodId < 5 THEN 100 ELSE og.goodId END id FROM UserOrder ug, \"OrderGoodCache\".OrderGood og WHERE ug.id = og.orderId) b WHERE a.id = b.id";
            userOrderCache.query((Query)new SqlFieldsQuery(sql)).getAll();
        }
        finally {
            userCache.destroy();
            userOrderCache.destroy();
            orderGoodCache.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImplicitJoinConditionGeneration() {
        IgniteCache p = this.ignite(0).createCache(IgniteSqlSplitterSelfTest.cacheConfig("P", true, Integer.class, Person.class));
        IgniteCache d = this.ignite(0).createCache(IgniteSqlSplitterSelfTest.cacheConfig("D", true, Integer.class, Department.class));
        IgniteCache o = this.ignite(0).createCache(IgniteSqlSplitterSelfTest.cacheConfig("O", true, Integer.class, Org.class));
        try {
            this.info("Plan: " + p.query((Query)new SqlFieldsQuery("explain select P.Person.*,dep.*,org.* from P.Person inner join D.Department dep ON dep.id=P.Person.depId left join O.Org org ON org.id=dep.orgId")).getAll());
            IgniteSqlSplitterSelfTest.assertEquals((int)0, (int)p.query((Query)new SqlFieldsQuery("select P.Person.*,dep.*,org.* from P.Person inner join D.Department dep ON dep.id=P.Person.depId left join O.Org org ON org.id=dep.orgId")).getAll().size());
        }
        finally {
            p.destroy();
            d.destroy();
            o.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedAggregates() throws Exception {
        String cacheName = "ints";
        IgniteCache cache = this.ignite(0).getOrCreateCache(IgniteSqlSplitterSelfTest.cacheConfig("ints", true, Integer.class, Value.class));
        AffinityKeyGenerator node0KeyGen = new AffinityKeyGenerator(this.ignite(0), "ints");
        AffinityKeyGenerator node1KeyGen = new AffinityKeyGenerator(this.ignite(1), "ints");
        AffinityKeyGenerator node2KeyGen = new AffinityKeyGenerator(this.ignite(2), "ints");
        try {
            this.awaitPartitionMapExchange();
            cache.put((Object)node0KeyGen.next(), (Object)new Value(1, 3));
            cache.put((Object)node1KeyGen.next(), (Object)new Value(1, 3));
            cache.put((Object)node2KeyGen.next(), (Object)new Value(1, 3));
            cache.put((Object)node0KeyGen.next(), (Object)new Value(2, 1));
            cache.put((Object)node1KeyGen.next(), (Object)new Value(2, 2));
            cache.put((Object)node2KeyGen.next(), (Object)new Value(2, 3));
            cache.put((Object)node0KeyGen.next(), (Object)new Value(3, 1));
            cache.put((Object)node0KeyGen.next(), (Object)new Value(3, 1));
            cache.put((Object)node0KeyGen.next(), (Object)new Value(3, 2));
            cache.put((Object)node1KeyGen.next(), (Object)new Value(3, 1));
            cache.put((Object)node1KeyGen.next(), (Object)new Value(3, 2));
            cache.put((Object)node2KeyGen.next(), (Object)new Value(3, 2));
            cache.put((Object)node0KeyGen.next(), (Object)new Value(4, 2));
            cache.put((Object)node1KeyGen.next(), (Object)new Value(5, 2));
            cache.put((Object)node2KeyGen.next(), (Object)new Value(6, 2));
            this.checkSimpleQueryWithAggr((IgniteCache<Integer, Value>)cache);
            this.checkSimpleQueryWithDistinctAggr((IgniteCache<Integer, Value>)cache);
            this.checkQueryWithGroupsAndAggrs((IgniteCache<Integer, Value>)cache);
            this.checkQueryWithGroupsAndDistinctAggr((IgniteCache<Integer, Value>)cache);
            this.checkSimpleQueryWithAggrMixed((IgniteCache<Integer, Value>)cache);
            this.checkQueryWithGroupsAndAggrMixed((IgniteCache<Integer, Value>)cache);
        }
        finally {
            cache.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCollocatedAggregates() throws Exception {
        String cacheName = "ints";
        IgniteCache cache = this.ignite(0).getOrCreateCache(IgniteSqlSplitterSelfTest.cacheConfig("ints", true, Integer.class, Value.class));
        AffinityKeyGenerator node0KeyGen = new AffinityKeyGenerator(this.ignite(0), "ints");
        AffinityKeyGenerator node1KeyGen = new AffinityKeyGenerator(this.ignite(1), "ints");
        AffinityKeyGenerator node2KeyGen = new AffinityKeyGenerator(this.ignite(2), "ints");
        try {
            this.awaitPartitionMapExchange();
            cache.put((Object)node0KeyGen.next(), (Object)new Value(1, 3));
            cache.put((Object)node0KeyGen.next(), (Object)new Value(1, 3));
            cache.put((Object)node0KeyGen.next(), (Object)new Value(1, 3));
            cache.put((Object)node1KeyGen.next(), (Object)new Value(2, 1));
            cache.put((Object)node1KeyGen.next(), (Object)new Value(2, 2));
            cache.put((Object)node1KeyGen.next(), (Object)new Value(2, 3));
            cache.put((Object)node2KeyGen.next(), (Object)new Value(3, 1));
            cache.put((Object)node2KeyGen.next(), (Object)new Value(3, 1));
            cache.put((Object)node2KeyGen.next(), (Object)new Value(3, 2));
            cache.put((Object)node2KeyGen.next(), (Object)new Value(3, 1));
            cache.put((Object)node2KeyGen.next(), (Object)new Value(3, 2));
            cache.put((Object)node2KeyGen.next(), (Object)new Value(3, 2));
            cache.put((Object)node0KeyGen.next(), (Object)new Value(4, 2));
            cache.put((Object)node1KeyGen.next(), (Object)new Value(5, 2));
            cache.put((Object)node2KeyGen.next(), (Object)new Value(6, 2));
            this.checkQueryWithGroupsAndAggrs((IgniteCache<Integer, Value>)cache);
            this.checkQueryWithGroupsAndDistinctAggr((IgniteCache<Integer, Value>)cache);
            this.checkQueryWithGroupsAndAggrMixed((IgniteCache<Integer, Value>)cache);
        }
        finally {
            cache.destroy();
        }
    }

    private void checkSimpleQueryWithAggr(IgniteCache<Integer, Value> cache) {
        try (QueryCursor qry = cache.query((Query)new SqlFieldsQuery("SELECT count(fst), sum(snd), avg(snd), min(snd), max(snd) FROM Value"));){
            List result = qry.getAll();
            IgniteSqlSplitterSelfTest.assertEquals((int)1, (int)result.size());
            List row = (List)result.get(0);
            IgniteSqlSplitterSelfTest.assertEquals((String)"count", (long)15L, (long)((Number)row.get(0)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"sum", (long)30L, (long)((Number)row.get(1)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"avg", (double)2.0, (double)((Number)row.get(2)).doubleValue(), (double)0.001);
            IgniteSqlSplitterSelfTest.assertEquals((String)"min", (int)1, (int)((Integer)row.get(3)));
            IgniteSqlSplitterSelfTest.assertEquals((String)"max", (int)3, (int)((Integer)row.get(4)));
        }
    }

    private void checkSimpleQueryWithDistinctAggr(IgniteCache<Integer, Value> cache) {
        try (QueryCursor qry = cache.query((Query)new SqlFieldsQuery("SELECT count(distinct fst), sum(distinct snd), avg(distinct snd), min(distinct snd), max(distinct snd) FROM Value"));){
            List result = qry.getAll();
            IgniteSqlSplitterSelfTest.assertEquals((int)1, (int)result.size());
            List row = (List)result.get(0);
            IgniteSqlSplitterSelfTest.assertEquals((String)"count distinct", (long)6L, (long)((Number)row.get(0)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"sum distinct", (long)6L, (long)((Number)row.get(1)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"avg distinct", (double)2.0, (double)((Number)row.get(2)).doubleValue(), (double)0.001);
            IgniteSqlSplitterSelfTest.assertEquals((String)"min distinct", (int)1, (int)((Integer)row.get(3)));
            IgniteSqlSplitterSelfTest.assertEquals((String)"max distinct", (int)3, (int)((Integer)row.get(4)));
        }
    }

    private void checkSimpleQueryWithAggrMixed(IgniteCache<Integer, Value> cache) {
        try (QueryCursor qry = cache.query((Query)new SqlFieldsQuery("SELECT count(fst), sum(snd), avg(snd), min(snd), max(snd),count(distinct fst), sum(distinct snd), avg(distinct snd), min(distinct snd), max(distinct snd)  FROM Value"));){
            List result = qry.getAll();
            IgniteSqlSplitterSelfTest.assertEquals((int)1, (int)result.size());
            List row = (List)result.get(0);
            IgniteSqlSplitterSelfTest.assertEquals((String)"count", (long)15L, (long)((Number)row.get(0)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"sum", (long)30L, (long)((Number)row.get(1)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"avg", (double)2.0, (double)((Number)row.get(2)).doubleValue(), (double)0.001);
            IgniteSqlSplitterSelfTest.assertEquals((String)"min", (int)1, (int)((Integer)row.get(3)));
            IgniteSqlSplitterSelfTest.assertEquals((String)"max", (int)3, (int)((Integer)row.get(4)));
            IgniteSqlSplitterSelfTest.assertEquals((String)"count distinct", (long)6L, (long)((Number)row.get(5)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"sum distinct", (long)6L, (long)((Number)row.get(6)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"avg distinct", (double)2.0, (double)((Number)row.get(7)).doubleValue(), (double)0.001);
            IgniteSqlSplitterSelfTest.assertEquals((String)"min distinct", (int)1, (int)((Integer)row.get(8)));
            IgniteSqlSplitterSelfTest.assertEquals((String)"max distinct", (int)3, (int)((Integer)row.get(9)));
        }
    }

    private void checkQueryWithGroupsAndAggrs(IgniteCache<Integer, Value> cache) {
        try (QueryCursor qry = cache.query((Query)new SqlFieldsQuery("SELECT fst, count(snd), sum(snd), avg(snd), min(snd), max(snd) FROM Value GROUP BY fst ORDER BY fst"));){
            List result = qry.getAll();
            IgniteSqlSplitterSelfTest.assertEquals((int)6, (int)result.size());
            List row = (List)result.get(0);
            IgniteSqlSplitterSelfTest.assertEquals((String)"fst", (int)1, (int)((Number)row.get(0)).intValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"count", (long)3L, (long)((Number)row.get(1)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"sum", (long)9L, (long)((Number)row.get(2)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"avg", (double)3.0, (double)((Number)row.get(3)).doubleValue(), (double)0.001);
            IgniteSqlSplitterSelfTest.assertEquals((String)"min", (int)3, (int)((Integer)row.get(4)));
            IgniteSqlSplitterSelfTest.assertEquals((String)"max", (int)3, (int)((Integer)row.get(5)));
            row = (List)result.get(1);
            IgniteSqlSplitterSelfTest.assertEquals((String)"fst", (int)2, (int)((Number)row.get(0)).intValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"count", (long)3L, (long)((Number)row.get(1)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"sum", (long)6L, (long)((Number)row.get(2)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"avg", (double)2.0, (double)((Number)row.get(3)).doubleValue(), (double)0.001);
            IgniteSqlSplitterSelfTest.assertEquals((String)"min", (int)1, (int)((Integer)row.get(4)));
            IgniteSqlSplitterSelfTest.assertEquals((String)"max", (int)3, (int)((Integer)row.get(5)));
            row = (List)result.get(2);
            IgniteSqlSplitterSelfTest.assertEquals((String)"fst", (int)3, (int)((Number)row.get(0)).intValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"count", (long)6L, (long)((Number)row.get(1)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"sum", (long)9L, (long)((Number)row.get(2)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"avg", (double)1.5, (double)((Number)row.get(3)).doubleValue(), (double)0.001);
            IgniteSqlSplitterSelfTest.assertEquals((String)"min", (int)1, (int)((Integer)row.get(4)));
            IgniteSqlSplitterSelfTest.assertEquals((String)"max", (int)2, (int)((Integer)row.get(5)));
        }
    }

    private void checkQueryWithGroupsAndDistinctAggr(IgniteCache<Integer, Value> cache) {
        try (QueryCursor qry = cache.query((Query)new SqlFieldsQuery("SELECT count(distinct snd), sum(distinct snd), avg(distinct snd), min(distinct snd), max(distinct snd) FROM Value GROUP BY fst"));){
            List result = qry.getAll();
            IgniteSqlSplitterSelfTest.assertEquals((int)6, (int)result.size());
            List row = (List)result.get(0);
            IgniteSqlSplitterSelfTest.assertEquals((String)"count distinct", (long)1L, (long)((Number)row.get(0)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"sum distinct", (long)3L, (long)((Number)row.get(1)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"avg distinct", (double)3.0, (double)((Number)row.get(2)).doubleValue(), (double)0.001);
            IgniteSqlSplitterSelfTest.assertEquals((String)"min distinct", (int)3, (int)((Integer)row.get(3)));
            IgniteSqlSplitterSelfTest.assertEquals((String)"max distinct", (int)3, (int)((Integer)row.get(4)));
            row = (List)result.get(1);
            IgniteSqlSplitterSelfTest.assertEquals((String)"count distinct", (long)3L, (long)((Number)row.get(0)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"sum distinct", (long)6L, (long)((Number)row.get(1)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"avg distinct", (double)2.0, (double)((Number)row.get(2)).doubleValue(), (double)0.001);
            IgniteSqlSplitterSelfTest.assertEquals((String)"min distinct", (int)1, (int)((Integer)row.get(3)));
            IgniteSqlSplitterSelfTest.assertEquals((String)"max distinct", (int)3, (int)((Integer)row.get(4)));
            row = (List)result.get(2);
            IgniteSqlSplitterSelfTest.assertEquals((String)"count distinct", (long)2L, (long)((Number)row.get(0)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"sum distinct", (long)3L, (long)((Number)row.get(1)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"avg distinct", (double)1.5, (double)((Number)row.get(2)).doubleValue(), (double)0.001);
            IgniteSqlSplitterSelfTest.assertEquals((String)"min distinct", (int)1, (int)((Integer)row.get(3)));
            IgniteSqlSplitterSelfTest.assertEquals((String)"max distinct", (int)2, (int)((Integer)row.get(4)));
        }
    }

    private void checkQueryWithGroupsAndAggrMixed(IgniteCache<Integer, Value> cache) {
        try (QueryCursor qry = cache.query((Query)new SqlFieldsQuery("SELECT fst, count(snd), sum(snd), avg(snd), min(snd), max(snd),count(distinct snd), sum(distinct snd), avg(distinct snd), min(distinct snd), max(distinct snd) FROM Value GROUP BY fst"));){
            List result = qry.getAll();
            IgniteSqlSplitterSelfTest.assertEquals((int)6, (int)result.size());
            List row = (List)result.get(0);
            IgniteSqlSplitterSelfTest.assertEquals((String)"fst", (int)1, (int)((Number)row.get(0)).intValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"count", (long)3L, (long)((Number)row.get(1)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"sum", (long)9L, (long)((Number)row.get(2)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"avg", (double)3.0, (double)((Number)row.get(3)).doubleValue(), (double)0.001);
            IgniteSqlSplitterSelfTest.assertEquals((String)"min", (int)3, (int)((Integer)row.get(4)));
            IgniteSqlSplitterSelfTest.assertEquals((String)"max", (int)3, (int)((Integer)row.get(5)));
            IgniteSqlSplitterSelfTest.assertEquals((String)"count distinct", (long)1L, (long)((Number)row.get(6)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"sum distinct", (long)3L, (long)((Number)row.get(7)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"avg distinct", (double)3.0, (double)((Number)row.get(8)).doubleValue(), (double)0.001);
            IgniteSqlSplitterSelfTest.assertEquals((String)"min distinct", (int)3, (int)((Integer)row.get(9)));
            IgniteSqlSplitterSelfTest.assertEquals((String)"max distinct", (int)3, (int)((Integer)row.get(10)));
            row = (List)result.get(1);
            IgniteSqlSplitterSelfTest.assertEquals((String)"fst", (int)2, (int)((Number)row.get(0)).intValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"count", (long)3L, (long)((Number)row.get(1)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"sum", (long)6L, (long)((Number)row.get(2)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"avg", (double)2.0, (double)((Number)row.get(3)).doubleValue(), (double)0.001);
            IgniteSqlSplitterSelfTest.assertEquals((String)"min", (int)1, (int)((Integer)row.get(4)));
            IgniteSqlSplitterSelfTest.assertEquals((String)"max", (int)3, (int)((Integer)row.get(5)));
            IgniteSqlSplitterSelfTest.assertEquals((String)"count distinct", (long)3L, (long)((Number)row.get(6)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"sum distinct", (long)6L, (long)((Number)row.get(7)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"avg distinct", (double)2.0, (double)((Number)row.get(8)).doubleValue(), (double)0.001);
            IgniteSqlSplitterSelfTest.assertEquals((String)"min distinct", (int)1, (int)((Integer)row.get(9)));
            IgniteSqlSplitterSelfTest.assertEquals((String)"max distinct", (int)3, (int)((Integer)row.get(10)));
            row = (List)result.get(2);
            IgniteSqlSplitterSelfTest.assertEquals((String)"fst", (int)3, (int)((Number)row.get(0)).intValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"count", (long)6L, (long)((Number)row.get(1)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"sum", (long)9L, (long)((Number)row.get(2)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"avg", (double)1.5, (double)((Number)row.get(3)).doubleValue(), (double)0.001);
            IgniteSqlSplitterSelfTest.assertEquals((String)"min", (int)1, (int)((Integer)row.get(4)));
            IgniteSqlSplitterSelfTest.assertEquals((String)"max", (int)2, (int)((Integer)row.get(5)));
            IgniteSqlSplitterSelfTest.assertEquals((String)"count distinct", (long)2L, (long)((Number)row.get(6)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"sum distinct", (long)3L, (long)((Number)row.get(7)).longValue());
            IgniteSqlSplitterSelfTest.assertEquals((String)"avg distinct", (double)1.5, (double)((Number)row.get(8)).doubleValue(), (double)0.001);
            IgniteSqlSplitterSelfTest.assertEquals((String)"min distinct", (int)1, (int)((Integer)row.get(9)));
            IgniteSqlSplitterSelfTest.assertEquals((String)"max distinct", (int)2, (int)((Integer)row.get(10)));
        }
    }

    private static class OrderGood
    implements Serializable {
        @QuerySqlField
        private int orderId;
        @QuerySqlField
        private int goodId;

        private OrderGood() {
        }
    }

    private static class UserOrder
    implements Serializable {
        @QuerySqlField
        private int id;
        @QuerySqlField
        private int userId;

        private UserOrder() {
        }
    }

    private static class User
    implements Serializable {
        @QuerySqlField
        private int id;

        private User() {
        }
    }

    private static class Organization
    implements Serializable {
        @QuerySqlField
        String name;

        public Organization() {
        }

        public Organization(String name) {
            this.name = name;
        }
    }

    private static class TestKey
    implements Serializable {
        @QuerySqlField(index=true)
        @AffinityKeyMapped
        int affKey;
        @QuerySqlField
        int id;

        public TestKey(int affKey, int id) {
            this.affKey = affKey;
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestKey personKey = (TestKey)o;
            return this.id == personKey.id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    private static class Person2
    implements Serializable {
        @QuerySqlField(index=true)
        int orgId;
        @QuerySqlField(index=true)
        String name;

        public Person2() {
        }

        public Person2(int orgId, String name) {
            this.orgId = orgId;
            this.name = name;
        }
    }

    private static class GroupIndexTestValue
    implements Serializable {
        @QuerySqlField(orderedGroups={@QuerySqlField.Group(name="grpIdx", order=0)})
        private int a;
        @QuerySqlField(orderedGroups={@QuerySqlField.Group(name="grpIdx", order=1)})
        private int b;

        private GroupIndexTestValue(int a, int b) {
            this.a = a;
            this.b = b;
        }
    }

    public static class Department {
        @QuerySqlField(index=true)
        private int id;
        @QuerySqlField(index=true)
        private int orgId;
        @QuerySqlField
        private String name;
    }

    public static class Org {
        @QuerySqlField(index=true)
        private int id;
        @QuerySqlField
        private String name;
    }

    public static class Person {
        @QuerySqlField
        private int id;
        @QuerySqlField
        private String name;
        @QuerySqlField
        private int depId;
    }

    private static class AffinityKeyGenerator {
        private final Affinity<Integer> affinity;
        private final ClusterNode node;
        private int start = 0;

        AffinityKeyGenerator(Ignite node, String cacheName) {
            this.affinity = node.affinity(cacheName);
            this.node = node.cluster().localNode();
        }

        public Integer next() {
            int key = this.start;
            while (this.start < Integer.MAX_VALUE) {
                if (this.affinity.isPrimary(this.node, (Object)key)) {
                    this.start = key + 1;
                    return key;
                }
                ++key;
            }
            throw new IllegalStateException("Can't find next key");
        }
    }

    private static class Value {
        @QuerySqlField
        private final Integer fst;
        @QuerySqlField
        private final Integer snd;

        public Value(Integer fst, Integer snd) {
            this.fst = fst;
            this.snd = snd;
        }
    }
}

