/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.List;
import java.util.concurrent.Callable;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class IgniteSqlSchemaIndexingTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);

    protected IgniteConfiguration getConfiguration() throws Exception {
        IgniteConfiguration cfg = super.getConfiguration();
        cfg.setPeerClassLoadingEnabled(false);
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        disco.setIpFinder(ipFinder);
        cfg.setDiscoverySpi((DiscoverySpi)disco);
        return cfg;
    }

    private static CacheConfiguration cacheConfig(String name, boolean partitioned, Class<?> ... idxTypes) {
        return new CacheConfiguration("default").setName(name).setCacheMode(partitioned ? CacheMode.PARTITIONED : CacheMode.REPLICATED).setAtomicityMode(CacheAtomicityMode.ATOMIC).setBackups(1).setIndexedTypes((Class[])idxTypes);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    public void testCaseSensitive() throws Exception {
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                CacheConfiguration cfg = IgniteSqlSchemaIndexingTest.cacheConfig("InSensitiveCache", true, new Class[]{Integer.class, Integer.class}).setSqlSchema("InsensitiveCache");
                CacheConfiguration collisionCfg = IgniteSqlSchemaIndexingTest.cacheConfig("InsensitiveCache", true, new Class[]{Integer.class, Integer.class}).setSqlSchema("Insensitivecache");
                IgniteConfiguration icfg = new IgniteConfiguration().setLocalHost("127.0.0.1").setCacheConfiguration(new CacheConfiguration[]{cfg, collisionCfg});
                Ignition.start((IgniteConfiguration)icfg);
                return null;
            }
        }, IgniteException.class, (String)"Cache already registered: ");
    }

    public void testCacheUnregistration() throws Exception {
        this.startGridsMultiThreaded(3, true);
        CacheConfiguration cfg = IgniteSqlSchemaIndexingTest.cacheConfig("Insensitive_Cache", true, Integer.class, Fact.class).setSqlSchema("Insensitive_Cache");
        CacheConfiguration collisionCfg = IgniteSqlSchemaIndexingTest.cacheConfig("InsensitiveCache", true, Integer.class, Fact.class).setSqlSchema("Insensitive_Cache");
        IgniteCache cache = this.ignite(0).createCache(cfg);
        SqlFieldsQuery qry = new SqlFieldsQuery("select f.id, f.name from InSENSitive_Cache.Fact f");
        cache.put((Object)1, (Object)new Fact(1, "cacheInsensitive"));
        for (List row : cache.query((Query)qry)) {
            IgniteSqlSchemaIndexingTest.assertEquals((int)2, (int)row.size());
            IgniteSqlSchemaIndexingTest.assertEquals((Object)1, row.get(0));
            IgniteSqlSchemaIndexingTest.assertEquals((Object)"cacheInsensitive", row.get(1));
        }
        this.ignite(0).destroyCache(cache.getName());
        cache = this.ignite(0).createCache(collisionCfg);
        cache.put((Object)1, (Object)new Fact(1, "cacheInsensitive"));
        cache.put((Object)2, (Object)new Fact(2, "ThisIsANewCache"));
        cache.put((Object)3, (Object)new Fact(3, "With3RecordsAndAnotherName"));
        IgniteSqlSchemaIndexingTest.assertEquals((int)3, (int)cache.query((Query)qry).getAll().size());
        this.ignite(0).destroyCache(cache.getName());
    }

    public void testSchemaEscapeAll() throws Exception {
        this.startGridsMultiThreaded(3, true);
        CacheConfiguration cfg = IgniteSqlSchemaIndexingTest.cacheConfig("simpleSchema", true, Integer.class, Fact.class).setSqlSchema("SchemaName1").setSqlEscapeAll(true);
        CacheConfiguration cfgEsc = IgniteSqlSchemaIndexingTest.cacheConfig("escapedSchema", true, Integer.class, Fact.class).setSqlSchema("\"SchemaName2\"").setSqlEscapeAll(true);
        IgniteSqlSchemaIndexingTest.escapeCheckSchemaName((IgniteCache<Integer, Fact>)this.ignite(0).createCache(cfg), this.log, cfg.getSqlSchema());
        IgniteSqlSchemaIndexingTest.escapeCheckSchemaName((IgniteCache<Integer, Fact>)this.ignite(0).createCache(cfgEsc), this.log, "SchemaName2");
        this.ignite(0).destroyCache(cfg.getName());
        this.ignite(0).destroyCache(cfgEsc.getName());
    }

    private static void escapeCheckSchemaName(final IgniteCache<Integer, Fact> cache, IgniteLogger log, String schemaName) {
        final SqlFieldsQuery qryWrong = new SqlFieldsQuery("select f.id, f.name from " + schemaName.toUpperCase() + ".Fact f");
        cache.put((Object)1, (Object)new Fact(1, "cacheInsensitive"));
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                cache.query((Query)qryWrong);
                return null;
            }
        }, CacheException.class, (String)"Failed to parse query");
        SqlFieldsQuery qryCorrect = new SqlFieldsQuery("select f.\"id\", f.\"name\" from \"" + schemaName + "\".\"Fact\" f");
        for (List row : cache.query((Query)qryCorrect)) {
            IgniteSqlSchemaIndexingTest.assertEquals((int)2, (int)row.size());
            IgniteSqlSchemaIndexingTest.assertEquals((Object)1, row.get(0));
            IgniteSqlSchemaIndexingTest.assertEquals((Object)"cacheInsensitive", row.get(1));
        }
    }

    private static class Fact {
        @QuerySqlField
        private int id;
        @QuerySqlField
        private String name;

        Fact(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

