/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class IgniteSqlDistributedJoinSelfTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);
    private static final int NODES_COUNT = 2;
    private static final int ORG_COUNT = 2;
    private static final int PERSON_PER_ORG_COUNT = 50;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setPeerClassLoadingEnabled(false);
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        disco.setIpFinder(IP_FINDER);
        cfg.setDiscoverySpi((DiscoverySpi)disco);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(2, false);
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
    }

    private static CacheConfiguration cacheConfig(String name, boolean partitioned, Class<?> ... idxTypes) {
        return new CacheConfiguration("default").setName(name).setCacheMode(partitioned ? CacheMode.PARTITIONED : CacheMode.REPLICATED).setAtomicityMode(CacheAtomicityMode.ATOMIC).setBackups(1).setIndexedTypes((Class[])idxTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonCollocatedDistributedJoin() throws Exception {
        CacheConfiguration ccfg1 = IgniteSqlDistributedJoinSelfTest.cacheConfig("pers", true, String.class, Person.class);
        CacheConfiguration ccfg2 = IgniteSqlDistributedJoinSelfTest.cacheConfig("org", true, String.class, Organization.class);
        IgniteCache c1 = this.ignite(0).getOrCreateCache(ccfg1);
        IgniteCache c2 = this.ignite(0).getOrCreateCache(ccfg2);
        try {
            this.awaitPartitionMapExchange();
            this.populateDataIntoCaches((IgniteCache<String, Person>)c1, (IgniteCache<String, Organization>)c2);
            String joinSql = "select * from Person, \"org\".Organization as org where Person.orgId = org.id and lower(org.name) = lower(?)";
            SqlQuery qry = new SqlQuery(Person.class, joinSql).setArgs(new Object[]{"Organization #0"});
            qry.setDistributedJoins(true);
            List prns = c1.query((Query)qry).getAll();
            IgniteSqlDistributedJoinSelfTest.assertEquals((int)50, (int)prns.size());
        }
        finally {
            c1.destroy();
            c2.destroy();
        }
    }

    private void populateDataIntoCaches(IgniteCache<String, Person> c1, IgniteCache<String, Organization> c2) {
        int personId = 0;
        for (int i = 0; i < 2; ++i) {
            Organization org = new Organization();
            org.setId("org" + i);
            org.setName("Organization #" + i);
            c2.put((Object)org.getId(), (Object)org);
            for (int j = 0; j < 50; ++j) {
                Person prsn = new Person();
                prsn.setId("pers" + personId);
                prsn.setOrgId(org.getId());
                prsn.setName("Person name #" + personId);
                c1.put((Object)prsn.getId(), (Object)prsn);
                ++personId;
            }
        }
    }

    private static class Organization {
        @QuerySqlField(index=true)
        private String id;
        @QuerySqlField(index=true)
        private String name;

        private Organization() {
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    private static class Person {
        @QuerySqlField(index=true)
        private String id;
        @QuerySqlField(index=true)
        private String orgId;
        @QuerySqlField(index=true)
        private String name;

        private Person() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getOrgId() {
            return this.orgId;
        }

        public void setOrgId(String orgId) {
            this.orgId = orgId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

