/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SpiQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.processors.cache.CacheEntryImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.apache.ignite.spi.indexing.IndexingSpi;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.Nullable;

public class IgniteQueryDedicatedPoolTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryVmIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);
    private static final String CACHE_NAME = "query_pool_test";

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGrid("server");
    }

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        TcpDiscoverySpi spi = (TcpDiscoverySpi)cfg.getDiscoverySpi();
        spi.setIpFinder((TcpDiscoveryIpFinder)IP_FINDER);
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        ccfg.setIndexedTypes(new Class[]{Byte.class, Byte.class});
        ccfg.setSqlFunctionClasses(new Class[]{IgniteQueryDedicatedPoolTest.class});
        ccfg.setName(CACHE_NAME);
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        if ("client".equals(gridName)) {
            cfg.setClientMode(true);
        }
        cfg.setIndexingSpi((IndexingSpi)new TestIndexingSpi());
        return cfg;
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.stopAllGrids();
    }

    public void testSqlQueryUsesDedicatedThreadPool() throws Exception {
        try (Ignite client = this.startGrid("client");){
            IgniteCache cache = client.cache(CACHE_NAME);
            QueryCursor cursor = cache.query((Query)new SqlFieldsQuery("select currentPolicy()"));
            List result = cursor.getAll();
            cursor.close();
            IgniteQueryDedicatedPoolTest.assertEquals((int)1, (int)result.size());
            Byte plc = (Byte)((List)result.get(0)).get(0);
            assert (plc != null);
            assert (plc == 10);
        }
    }

    public void testScanQueryUsesDedicatedThreadPool() throws Exception {
        try (Ignite client = this.startGrid("client");){
            IgniteCache cache = client.cache(CACHE_NAME);
            cache.put((Object)0, (Object)0);
            QueryCursor cursor = cache.query((Query)new ScanQuery((IgniteBiPredicate)new IgniteBiPredicate<Object, Object>(){

                public boolean apply(Object o, Object o2) {
                    return F.eq((Object)GridIoManager.currentPolicy(), (Object)10);
                }
            }));
            IgniteQueryDedicatedPoolTest.assertEquals((int)1, (int)cursor.getAll().size());
            cursor.close();
        }
    }

    public void testSpiQueryUsesDedicatedThreadPool() throws Exception {
        try (Ignite client = this.startGrid("client");){
            IgniteCache cache = client.cache(CACHE_NAME);
            for (byte b = 0; b < 127; b = (byte)(b + 1)) {
                cache.put((Object)b, (Object)b);
            }
            QueryCursor cursor = cache.query((Query)new SpiQuery());
            List all = cursor.getAll();
            IgniteQueryDedicatedPoolTest.assertEquals((int)1, (int)all.size());
            IgniteQueryDedicatedPoolTest.assertEquals((byte)10, (byte)((Byte)((Cache.Entry)all.get(0)).getValue()));
            cursor.close();
        }
    }

    @QuerySqlFunction(alias="currentPolicy")
    public static Byte currentPolicy() {
        return GridIoManager.currentPolicy();
    }

    private static class TestIndexingSpi
    extends IgniteSpiAdapter
    implements IndexingSpi {
        private final SortedMap<Object, Object> idx = new TreeMap<Object, Object>();

        private TestIndexingSpi() {
        }

        public void spiStart(@Nullable String gridName) {
        }

        public void spiStop() {
        }

        public Iterator<Cache.Entry<?, ?>> query(@Nullable String spaceName, Collection<Object> params, @Nullable IndexingQueryFilter filters) {
            return this.idx.containsKey((byte)10) ? Collections.singletonList(new CacheEntryImpl((Object)10, (Object)10)).iterator() : Collections.emptyList().iterator();
        }

        public void store(@Nullable String spaceName, Object key, Object val, long expirationTime) {
            this.idx.put(key, val);
        }

        public void remove(@Nullable String spaceName, Object key) {
        }
    }
}

