/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.ttl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.TouchedExpiryPolicy;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import javax.cache.integration.CompletionListener;
import javax.cache.integration.CompletionListenerFuture;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.eviction.EvictionPolicy;
import org.apache.ignite.cache.eviction.lru.LruEvictionPolicy;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.store.CacheStoreAdapter;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public abstract class CacheTtlAbstractSelfTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);
    private static final int MAX_CACHE_SIZE = 5;
    private static final int SIZE = 11;
    private static final long DEFAULT_TIME_TO_LIVE = 2000L;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setCacheMode(this.cacheMode());
        ccfg.setAtomicityMode(this.atomicityMode());
        LruEvictionPolicy plc = new LruEvictionPolicy();
        plc.setMaxSize(5);
        ccfg.setEvictionPolicy((EvictionPolicy)plc);
        ccfg.setOnheapCacheEnabled(true);
        ccfg.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        ccfg.setBackups(2);
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setRebalanceMode(CacheRebalanceMode.SYNC);
        ccfg.setCacheStoreFactory(this.singletonFactory(new CacheStoreAdapter(){

            public void loadCache(IgniteBiInClosure clo, Object ... args) {
                for (int i = 0; i < 11; ++i) {
                    clo.apply((Object)i, (Object)i);
                }
            }

            public Object load(Object key) throws CacheLoaderException {
                return key;
            }

            public void write(Cache.Entry entry) throws CacheWriterException {
            }

            public void delete(Object key) throws CacheWriterException {
            }
        }));
        ccfg.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)new TouchedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, 2000L))));
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        ((TcpDiscoverySpi)cfg.getDiscoverySpi()).setIpFinder(IP_FINDER);
        return cfg;
    }

    protected abstract CacheAtomicityMode atomicityMode();

    protected abstract CacheMode cacheMode();

    protected abstract int gridCount();

    protected void beforeTest() throws Exception {
        this.startGrids(this.gridCount());
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    public void testDefaultTimeToLiveLoadCache() throws Exception {
        IgniteCache cache = this.jcache(0);
        cache.loadCache(null, new Object[0]);
        this.checkSizeBeforeLive(11);
        Thread.sleep(2500L);
        this.checkSizeAfterLive();
    }

    public void testDefaultTimeToLiveLoadAll() throws Exception {
        this.defaultTimeToLiveLoadAll(false);
        this.defaultTimeToLiveLoadAll(true);
    }

    private void defaultTimeToLiveLoadAll(boolean replaceExisting) throws Exception {
        IgniteCache cache = this.jcache(0);
        CompletionListenerFuture fut = new CompletionListenerFuture();
        HashSet<Integer> keys = new HashSet<Integer>();
        for (int i = 0; i < 11; ++i) {
            keys.add(i);
        }
        cache.loadAll(keys, replaceExisting, (CompletionListener)fut);
        fut.get();
        this.checkSizeBeforeLive(11);
        Thread.sleep(2500L);
        this.checkSizeAfterLive();
    }

    public void testDefaultTimeToLiveStreamerAdd() throws Exception {
        int i;
        try (IgniteDataStreamer streamer = this.ignite(0).dataStreamer("default");){
            for (i = 0; i < 11; ++i) {
                streamer.addData((Object)i, (Object)i);
            }
        }
        this.checkSizeBeforeLive(11);
        Thread.sleep(2500L);
        this.checkSizeAfterLive();
        streamer = this.ignite(0).dataStreamer("default");
        var2_2 = null;
        try {
            streamer.allowOverwrite(true);
            for (i = 0; i < 11; ++i) {
                streamer.addData((Object)i, (Object)i);
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (streamer != null) {
                if (var2_2 != null) {
                    try {
                        streamer.close();
                    }
                    catch (Throwable x2) {
                        var2_2.addSuppressed(x2);
                    }
                } else {
                    streamer.close();
                }
            }
        }
        this.checkSizeBeforeLive(11);
        Thread.sleep(2500L);
        this.checkSizeAfterLive();
    }

    public void testDefaultTimeToLivePut() throws Exception {
        IgniteCache cache = this.jcache(0);
        Integer key = 0;
        cache.put((Object)key, (Object)1);
        this.checkSizeBeforeLive(1);
        Thread.sleep(2500L);
        this.checkSizeAfterLive();
    }

    public void testDefaultTimeToLivePutAll() throws Exception {
        IgniteCache cache = this.jcache(0);
        HashMap<Integer, Integer> entries = new HashMap<Integer, Integer>();
        for (int i = 0; i < 11; ++i) {
            entries.put(i, i);
        }
        cache.putAll(entries);
        this.checkSizeBeforeLive(11);
        Thread.sleep(2500L);
        this.checkSizeAfterLive();
    }

    public void testDefaultTimeToLivePreload() throws Exception {
        if (this.cacheMode() == CacheMode.LOCAL) {
            return;
        }
        IgniteCache cache = this.jcache(0);
        HashMap<Integer, Integer> entries = new HashMap<Integer, Integer>();
        for (int i = 0; i < 11; ++i) {
            entries.put(i, i);
        }
        cache.putAll(entries);
        this.startGrid(this.gridCount());
        this.checkSizeBeforeLive(11, this.gridCount() + 1);
        Thread.sleep(2500L);
        this.checkSizeAfterLive(this.gridCount() + 1);
    }

    public void testTimeToLiveTtl() throws Exception {
        long time = 4000L;
        IgniteCache cache = this.jcache(0).withExpiryPolicy((ExpiryPolicy)new TouchedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, time)));
        for (int i = 0; i < 11; ++i) {
            cache.put((Object)i, (Object)i);
        }
        this.checkSizeBeforeLive(11);
        Thread.sleep(2500L);
        this.checkSizeBeforeLive(11);
        Thread.sleep(time - 2000L + 500L);
        this.checkSizeAfterLive();
    }

    private void checkSizeBeforeLive(int size) throws Exception {
        this.checkSizeBeforeLive(size, this.gridCount());
    }

    private void checkSizeBeforeLive(int size, int gridCnt) throws Exception {
        for (int i = 0; i < gridCnt; ++i) {
            IgniteCache cache = this.jcache(i);
            this.log.info("Size [node=" + i + ", " + cache.localSize(new CachePeekMode[]{CachePeekMode.PRIMARY, CachePeekMode.BACKUP, CachePeekMode.NEAR}) + ']');
            CacheTtlAbstractSelfTest.assertEquals((String)("Unexpected size, node: " + i), (int)size, (int)cache.localSize(new CachePeekMode[]{CachePeekMode.PRIMARY, CachePeekMode.BACKUP, CachePeekMode.NEAR}));
            for (int key = 0; key < size; ++key) {
                CacheTtlAbstractSelfTest.assertNotNull((Object)cache.localPeek((Object)key, new CachePeekMode[0]));
            }
            CacheTtlAbstractSelfTest.assertFalse((boolean)cache.query((Query)new SqlQuery(Integer.class, "_val >= 0")).getAll().isEmpty());
        }
    }

    private void checkSizeAfterLive() throws Exception {
        this.checkSizeAfterLive(this.gridCount());
    }

    private void checkSizeAfterLive(int gridCnt) throws Exception {
        for (int i = 0; i < gridCnt; ++i) {
            IgniteCache cache = this.jcache(i);
            this.log.info("Size [node=" + i + ", heap=" + cache.localSize(new CachePeekMode[]{CachePeekMode.ONHEAP}) + ", offheap=" + cache.localSize(new CachePeekMode[]{CachePeekMode.OFFHEAP}) + ']');
            CacheTtlAbstractSelfTest.assertEquals((int)0, (int)cache.localSize(new CachePeekMode[0]));
            CacheTtlAbstractSelfTest.assertEquals((int)0, (int)cache.localSize(new CachePeekMode[]{CachePeekMode.OFFHEAP}));
            CacheTtlAbstractSelfTest.assertEquals((int)0, (int)cache.query((Query)new SqlQuery(Integer.class, "_val >= 0")).getAll().size());
            for (int key = 0; key < 11; ++key) {
                CacheTtlAbstractSelfTest.assertNull((Object)cache.localPeek((Object)key, new CachePeekMode[0]));
            }
        }
    }
}

