/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.local;

import java.util.Iterator;
import java.util.List;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.internal.processors.cache.IgniteCacheAbstractQuerySelfTest;

public class IgniteCacheLocalQuerySelfTest
extends IgniteCacheAbstractQuerySelfTest {
    @Override
    protected int gridCount() {
        return 1;
    }

    @Override
    protected CacheMode cacheMode() {
        return CacheMode.LOCAL;
    }

    public void testQueryLocal() throws Exception {
        IgniteCache<Integer, String> cache = this.jcache(Integer.class, String.class);
        cache.put((Object)1, (Object)"value1");
        cache.put((Object)2, (Object)"value2");
        cache.put((Object)3, (Object)"value3");
        cache.put((Object)4, (Object)"value4");
        cache.put((Object)5, (Object)"value5");
        QueryCursor qry = cache.query((Query)new SqlQuery(String.class, "_val='value1'").setLocal(true));
        Iterator iter = qry.iterator();
        Cache.Entry entry = (Cache.Entry)iter.next();
        assert (!iter.hasNext());
        assert (entry != null);
        assert ((Integer)entry.getKey() == 1);
        assert ("value1".equals(entry.getValue()));
        qry = cache.query((Query)new SqlQuery(String.class, "_val like 'value%'").setLocal(true));
        iter = qry.iterator();
        assert (iter.next() != null);
        assert (iter.next() != null);
        assert (iter.next() != null);
        assert (iter.next() != null);
        assert (iter.next() != null);
        assert (!iter.hasNext());
        List res = cache.query((Query)new SqlFieldsQuery("explain select _key from String where _val > 'value1'").setLocal(true)).getAll();
        IgniteCacheLocalQuerySelfTest.assertTrue((String)("__ explain: \n" + res), (boolean)((String)((List)res.get(0)).get(0)).toLowerCase().contains("_val_idx"));
    }
}

