/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class QueryEntityValidationSelfTest
extends GridCommonAbstractTest {
    private static final String CACHE_NAME = "cache";

    protected void beforeTestsStarted() throws Exception {
        this.startGrid(0);
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
    }

    public void testValueTypeNull() throws Exception {
        final CacheConfiguration ccfg = new CacheConfiguration().setName(CACHE_NAME);
        QueryEntity entity = new QueryEntity();
        entity.setKeyType("Key");
        ccfg.setQueryEntities(Collections.singleton(entity));
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                QueryEntityValidationSelfTest.this.grid(0).createCache(ccfg);
                return null;
            }
        }, IgniteCheckedException.class, (String)"Value type cannot be null or empty");
    }

    public void testIndexTypeNull() throws Exception {
        final CacheConfiguration ccfg = new CacheConfiguration().setName(CACHE_NAME);
        QueryEntity entity = new QueryEntity();
        entity.setKeyType("Key");
        entity.setValueType("Value");
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("a", Integer.class.getName());
        entity.setFields(fields);
        LinkedHashMap<String, Boolean> idxFields = new LinkedHashMap<String, Boolean>();
        idxFields.put("a", true);
        QueryIndex idx = new QueryIndex().setName("idx").setFields(idxFields).setIndexType(null);
        ArrayList<QueryIndex> idxs = new ArrayList<QueryIndex>();
        idxs.add(idx);
        entity.setIndexes(idxs);
        ccfg.setQueryEntities(Collections.singleton(entity));
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                QueryEntityValidationSelfTest.this.grid(0).createCache(ccfg);
                return null;
            }
        }, IgniteCheckedException.class, (String)"Index type is not set");
    }

    public void testIndexNameDuplicate() throws Exception {
        final CacheConfiguration ccfg = new CacheConfiguration().setName(CACHE_NAME);
        QueryEntity entity = new QueryEntity();
        entity.setKeyType("Key");
        entity.setValueType("Value");
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("a", Integer.class.getName());
        fields.put("b", Integer.class.getName());
        entity.setFields(fields);
        LinkedHashMap<String, Boolean> idx1Fields = new LinkedHashMap<String, Boolean>();
        LinkedHashMap idx2Fields = new LinkedHashMap();
        idx1Fields.put("a", true);
        idx1Fields.put("b", true);
        QueryIndex idx1 = new QueryIndex().setName("idx").setFields(idx1Fields);
        QueryIndex idx2 = new QueryIndex().setName("idx").setFields(idx2Fields);
        ArrayList<QueryIndex> idxs = new ArrayList<QueryIndex>();
        idxs.add(idx1);
        idxs.add(idx2);
        entity.setIndexes(idxs);
        ccfg.setQueryEntities(Collections.singleton(entity));
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                QueryEntityValidationSelfTest.this.grid(0).createCache(ccfg);
                return null;
            }
        }, IgniteCheckedException.class, (String)"Duplicate index name");
    }
}

