/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.Ignition;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.MemoryConfiguration;
import org.apache.ignite.configuration.MemoryPolicyConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.processors.cache.index.AbstractSchemaSelfTest;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;

public abstract class DynamicIndexAbstractSelfTest
extends AbstractSchemaSelfTest {
    protected static final String ATTR_FILTERED = "FILTERED";
    protected static final int KEY_BEFORE = 100;
    protected static final int KEY_AFTER = 200;
    protected static final String SQL_SIMPLE_FIELD_1 = "SELECT * FROM " + TBL_NAME + " WHERE " + "field1" + " >= ?";
    protected static final String SQL_COMPOSITE = "SELECT * FROM " + TBL_NAME + " WHERE " + "field1" + " >= ? AND " + DynamicIndexAbstractSelfTest.alias("field2") + " >= ?";
    protected static final String SQL_SIMPLE_FIELD_2 = "SELECT * FROM " + TBL_NAME + " WHERE " + DynamicIndexAbstractSelfTest.alias("field2") + " >= ?";
    protected static final int SQL_ARG_1 = 40;
    protected static final int SQL_ARG_2 = 80;

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        super.afterTestsStopped();
    }

    protected IgniteConfiguration serverConfiguration(int idx) throws Exception {
        return this.serverConfiguration(idx, false);
    }

    protected IgniteConfiguration serverConfiguration(int idx, boolean filter) throws Exception {
        IgniteConfiguration cfg = this.commonConfiguration(idx);
        if (filter) {
            cfg.setUserAttributes(Collections.singletonMap(ATTR_FILTERED, true));
        }
        return cfg;
    }

    protected IgniteConfiguration clientConfiguration(int idx) throws Exception {
        return this.commonConfiguration(idx).setClientMode(true);
    }

    protected IgniteConfiguration commonConfiguration(int idx) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(this.getTestIgniteInstanceName(idx));
        cfg.setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi());
        cfg.setMarshaller((Marshaller)new BinaryMarshaller());
        MemoryConfiguration memCfg = new MemoryConfiguration().setDefaultMemoryPolicyName("default").setMemoryPolicies(new MemoryPolicyConfiguration[]{new MemoryPolicyConfiguration().setName("default").setMaxSize(0x2000000L).setInitialSize(0x2000000L)});
        cfg.setMemoryConfiguration(memCfg);
        return this.optimize(cfg);
    }

    protected CacheConfiguration<AbstractSchemaSelfTest.KeyClass, AbstractSchemaSelfTest.ValueClass> cacheConfiguration() {
        CacheConfiguration ccfg = new CacheConfiguration().setName("cache");
        QueryEntity entity = new QueryEntity();
        entity.setKeyType(AbstractSchemaSelfTest.KeyClass.class.getName());
        entity.setValueType(AbstractSchemaSelfTest.ValueClass.class.getName());
        entity.setKeyFieldName("key");
        entity.addQueryField("key", entity.getKeyType(), null);
        entity.addQueryField("id", Long.class.getName(), null);
        entity.addQueryField("field1", Long.class.getName(), null);
        entity.addQueryField("field2", Long.class.getName(), null);
        entity.setKeyFields(Collections.singleton("id"));
        entity.setAliases(Collections.singletonMap("field2", DynamicIndexAbstractSelfTest.alias("field2")));
        ccfg.setQueryEntities(Collections.singletonList(entity));
        ccfg.setNodeFilter((IgnitePredicate)new NodeFilter());
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setBackups(1);
        return ccfg;
    }

    protected static void assertIndexUsed(String idxName, String sql, Object ... args) {
        for (Ignite node : Ignition.allGrids()) {
            DynamicIndexAbstractSelfTest.assertIndexUsed((IgniteEx)node, idxName, sql, args);
        }
    }

    protected static void assertIndexUsed(IgniteEx node, String idxName, String sql, Object ... args) {
        SqlFieldsQuery qry = new SqlFieldsQuery("EXPLAIN " + sql);
        if (args != null && args.length > 0) {
            qry.setArgs(args);
        }
        String plan = (String)((List)node.cache("cache").query((Query)qry).getAll().get(0)).get(0);
        DynamicIndexAbstractSelfTest.assertTrue((String)("Index is not used: " + plan), (boolean)plan.toLowerCase().contains(idxName.toLowerCase()));
    }

    protected static void assertIndexNotUsed(String idxName, String sql, Object ... args) {
        for (Ignite node : Ignition.allGrids()) {
            DynamicIndexAbstractSelfTest.assertIndexNotUsed((IgniteEx)node, idxName, sql, args);
        }
    }

    protected static void assertIndexNotUsed(IgniteEx node, String idxName, String sql, Object ... args) {
        SqlFieldsQuery qry = new SqlFieldsQuery("EXPLAIN " + sql);
        if (args != null && args.length > 0) {
            qry.setArgs(args);
        }
        String plan = (String)((List)node.cache("cache").query((Query)qry).getAll().get(0)).get(0);
        DynamicIndexAbstractSelfTest.assertFalse((String)("Index is used: " + plan), (boolean)plan.contains(idxName));
    }

    protected static BinaryObject key(Ignite ignite, long id) {
        return ignite.binary().builder(AbstractSchemaSelfTest.KeyClass.class.getName()).setField("id", (Object)id).build();
    }

    protected static BinaryObject value(Ignite ignite, long id) {
        return ignite.binary().builder(AbstractSchemaSelfTest.ValueClass.class.getName()).setField("field1", (Object)id).setField("field2", (Object)id).build();
    }

    protected static T2<BinaryObject, BinaryObject> entry(Ignite ignite, long id) {
        return new T2((Object)DynamicIndexAbstractSelfTest.key(ignite, id), (Object)DynamicIndexAbstractSelfTest.value(ignite, id));
    }

    protected static IgniteCache<BinaryObject, BinaryObject> cache(Ignite node) {
        return node.cache("cache").withKeepBinary();
    }

    protected static BinaryObject get(Ignite node, int id) {
        BinaryObject key = DynamicIndexAbstractSelfTest.key(node, id);
        return (BinaryObject)DynamicIndexAbstractSelfTest.cache(node).get((Object)key);
    }

    protected static void put(Ignite node, int from, int to) {
        try (IgniteDataStreamer streamer = node.dataStreamer("cache");){
            streamer.allowOverwrite(true);
            streamer.keepBinary(true);
            for (int i = from; i < to; ++i) {
                BinaryObject key = DynamicIndexAbstractSelfTest.key(node, i);
                BinaryObject val = DynamicIndexAbstractSelfTest.value(node, i);
                streamer.addData((Object)key, (Object)val);
            }
            streamer.flush();
        }
    }

    protected static void put(Ignite node, long id) {
        BinaryObject key = DynamicIndexAbstractSelfTest.key(node, id);
        BinaryObject val = DynamicIndexAbstractSelfTest.value(node, id);
        DynamicIndexAbstractSelfTest.cache(node).put((Object)key, (Object)val);
    }

    protected static void remove(Ignite node, int from, int to) {
        for (int i = from; i < to; ++i) {
            DynamicIndexAbstractSelfTest.remove(node, i);
        }
    }

    protected static void remove(Ignite node, long id) {
        BinaryObject key = DynamicIndexAbstractSelfTest.key(node, id);
        DynamicIndexAbstractSelfTest.cache(node).remove((Object)key);
    }

    protected static String randomString() {
        return "random" + UUID.randomUUID().toString().replace("-", "");
    }

    protected static void assertSqlSimpleData(String sql, int expSize) {
        for (Ignite node : Ignition.allGrids()) {
            DynamicIndexAbstractSelfTest.assertSqlSimpleData(node, sql, expSize);
        }
    }

    protected static void assertSqlSimpleData(Ignite node, String sql, int expSize) {
        SqlQuery qry = new SqlQuery(DynamicIndexAbstractSelfTest.tableName(AbstractSchemaSelfTest.ValueClass.class), sql).setArgs(new Object[]{40});
        List res = node.cache("cache").withKeepBinary().query((Query)qry).getAll();
        HashSet<Long> ids = new HashSet<Long>();
        for (Cache.Entry entry : res) {
            long id = (Long)((BinaryObject)entry.getKey()).field("id");
            long field1 = (Long)((BinaryObject)entry.getValue()).field("field1");
            long field2 = (Long)((BinaryObject)entry.getValue()).field("field2");
            DynamicIndexAbstractSelfTest.assertTrue((field1 >= 40L ? 1 : 0) != 0);
            DynamicIndexAbstractSelfTest.assertEquals((long)id, (long)field1);
            DynamicIndexAbstractSelfTest.assertEquals((long)id, (long)field2);
            DynamicIndexAbstractSelfTest.assertTrue((boolean)ids.add(id));
        }
        DynamicIndexAbstractSelfTest.assertEquals((String)("Size mismatch [node=" + node.name() + ", exp=" + expSize + ", actual=" + res.size() + ", ids=" + ids + ']'), (int)expSize, (int)res.size());
    }

    protected static void assertSqlCompositeData(Ignite node, String sql, int expSize) {
        SqlQuery qry = new SqlQuery(DynamicIndexAbstractSelfTest.tableName(AbstractSchemaSelfTest.ValueClass.class), sql).setArgs(new Object[]{40, 80});
        List res = node.cache("cache").withKeepBinary().query((Query)qry).getAll();
        HashSet<Long> ids = new HashSet<Long>();
        for (Cache.Entry entry : res) {
            long id = (Long)((BinaryObject)entry.getKey()).field("id");
            long field1 = (Long)((BinaryObject)entry.getValue()).field("field1");
            long field2 = (Long)((BinaryObject)entry.getValue()).field("field2");
            DynamicIndexAbstractSelfTest.assertTrue((field1 >= 80L ? 1 : 0) != 0);
            DynamicIndexAbstractSelfTest.assertEquals((long)id, (long)field1);
            DynamicIndexAbstractSelfTest.assertEquals((long)id, (long)field2);
            DynamicIndexAbstractSelfTest.assertTrue((boolean)ids.add(id));
        }
        DynamicIndexAbstractSelfTest.assertEquals((String)("Size mismatch [exp=" + expSize + ", actual=" + res.size() + ", ids=" + ids + ']'), (int)expSize, (int)res.size());
    }

    protected static class NodeFilter
    implements IgnitePredicate<ClusterNode>,
    Serializable {
        private static final long serialVersionUID = 0L;

        protected NodeFilter() {
        }

        public boolean apply(ClusterNode node) {
            return node.attribute(DynamicIndexAbstractSelfTest.ATTR_FILTERED) == null;
        }
    }
}

