/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.Cache;
import junit.framework.TestCase;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteClientReconnectAbstractTest;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.index.AbstractSchemaSelfTest;
import org.apache.ignite.internal.processors.cache.index.DynamicIndexAbstractSelfTest;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.QueryIndexDescriptorImpl;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitor;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationException;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.jetbrains.annotations.NotNull;

public abstract class DynamicIndexAbstractConcurrentSelfTest
extends DynamicIndexAbstractSelfTest {
    private static final long TEST_DUR = 10000L;
    private static final int LARGE_CACHE_SIZE = 100000;
    private static final ConcurrentHashMap<UUID, T2<CountDownLatch, AtomicBoolean>> BLOCKS = new ConcurrentHashMap();
    private final CacheMode cacheMode;
    private final CacheAtomicityMode atomicityMode;

    protected DynamicIndexAbstractConcurrentSelfTest(CacheMode cacheMode, CacheAtomicityMode atomicityMode) {
        this.cacheMode = cacheMode;
        this.atomicityMode = atomicityMode;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        GridQueryProcessor.idxCls = BlockingIndexing.class;
    }

    protected void afterTest() throws Exception {
        GridQueryProcessor.idxCls = null;
        for (T2<CountDownLatch, AtomicBoolean> block : BLOCKS.values()) {
            ((CountDownLatch)block.get1()).countDown();
        }
        BLOCKS.clear();
        this.stopAllGrids();
        super.afterTest();
    }

    protected long getTestTimeout() {
        return 300000L;
    }

    @Override
    protected CacheConfiguration<AbstractSchemaSelfTest.KeyClass, AbstractSchemaSelfTest.ValueClass> cacheConfiguration() {
        CacheConfiguration<AbstractSchemaSelfTest.KeyClass, AbstractSchemaSelfTest.ValueClass> ccfg = super.cacheConfiguration();
        return ccfg.setCacheMode(this.cacheMode).setAtomicityMode(this.atomicityMode);
    }

    @Override
    protected IgniteConfiguration commonConfiguration(int idx) throws Exception {
        return super.commonConfiguration(idx).setDiscoverySpi((DiscoverySpi)new IgniteClientReconnectAbstractTest.TestTcpDiscoverySpi());
    }

    public void testCoordinatorChange() throws Exception {
        Ignite srv1 = Ignition.start((IgniteConfiguration)this.serverConfiguration(1));
        Ignite srv2 = Ignition.start((IgniteConfiguration)this.serverConfiguration(2));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(3, true));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(4));
        UUID srv1Id = srv1.cluster().localNode().id();
        UUID srv2Id = srv2.cluster().localNode().id();
        Ignite cli = Ignition.start((IgniteConfiguration)this.clientConfiguration(5));
        cli.getOrCreateCache(this.cacheConfiguration());
        DynamicIndexAbstractConcurrentSelfTest.put(srv1, 0, 200);
        DynamicIndexAbstractConcurrentSelfTest.blockIndexing(srv1Id);
        QueryIndex idx1 = DynamicIndexAbstractConcurrentSelfTest.index("idx_1", DynamicIndexAbstractConcurrentSelfTest.field("field1"));
        IgniteInternalFuture idxFut1 = DynamicIndexAbstractConcurrentSelfTest.queryProcessor(cli).dynamicIndexCreate("cache", TBL_NAME, idx1, false);
        Thread.sleep(100L);
        Ignition.stop((String)srv1.name(), (boolean)true);
        DynamicIndexAbstractConcurrentSelfTest.unblockIndexing(srv1Id);
        idxFut1.get();
        DynamicIndexAbstractConcurrentSelfTest.assertIndex("cache", TBL_NAME, "idx_1", DynamicIndexAbstractConcurrentSelfTest.field("field1"));
        DynamicIndexAbstractConcurrentSelfTest.assertIndexUsed("idx_1", SQL_SIMPLE_FIELD_1, 40);
        DynamicIndexAbstractConcurrentSelfTest.assertSqlSimpleData(SQL_SIMPLE_FIELD_1, 160);
        DynamicIndexAbstractConcurrentSelfTest.blockIndexing(srv2Id);
        QueryIndex idx2 = DynamicIndexAbstractConcurrentSelfTest.index("idx_2", DynamicIndexAbstractConcurrentSelfTest.field(DynamicIndexAbstractConcurrentSelfTest.alias("field2")));
        IgniteInternalFuture idxFut2 = DynamicIndexAbstractConcurrentSelfTest.queryProcessor(cli).dynamicIndexCreate("cache", TBL_NAME, idx2, false);
        Thread.sleep(100L);
        Ignition.stop((String)srv2.name(), (boolean)true);
        DynamicIndexAbstractConcurrentSelfTest.unblockIndexing(srv2Id);
        idxFut2.get();
        DynamicIndexAbstractConcurrentSelfTest.assertIndex("cache", TBL_NAME, "idx_2", DynamicIndexAbstractConcurrentSelfTest.field(DynamicIndexAbstractConcurrentSelfTest.alias("field2")));
        DynamicIndexAbstractConcurrentSelfTest.assertIndexUsed("idx_2", SQL_SIMPLE_FIELD_2, 40);
        DynamicIndexAbstractConcurrentSelfTest.assertSqlSimpleData(SQL_SIMPLE_FIELD_2, 160);
    }

    public void testOperationChaining() throws Exception {
        Ignite srv1 = Ignition.start((IgniteConfiguration)this.serverConfiguration(1));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(2));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(3, true));
        Ignition.start((IgniteConfiguration)this.clientConfiguration(4));
        srv1.getOrCreateCache(this.cacheConfiguration());
        DynamicIndexAbstractConcurrentSelfTest.blockIndexing(srv1);
        QueryIndex idx1 = DynamicIndexAbstractConcurrentSelfTest.index("idx_1", DynamicIndexAbstractConcurrentSelfTest.field("field1"));
        QueryIndex idx2 = DynamicIndexAbstractConcurrentSelfTest.index("idx_2", DynamicIndexAbstractConcurrentSelfTest.field(DynamicIndexAbstractConcurrentSelfTest.alias("field2")));
        IgniteInternalFuture idxFut1 = DynamicIndexAbstractConcurrentSelfTest.queryProcessor(srv1).dynamicIndexCreate("cache", TBL_NAME, idx1, false);
        IgniteInternalFuture idxFut2 = DynamicIndexAbstractConcurrentSelfTest.queryProcessor(srv1).dynamicIndexCreate("cache", TBL_NAME, idx2, false);
        Ignition.start((IgniteConfiguration)this.serverConfiguration(5));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(6, true));
        Ignition.start((IgniteConfiguration)this.clientConfiguration(7));
        assert (!idxFut1.isDone());
        assert (!idxFut2.isDone());
        DynamicIndexAbstractConcurrentSelfTest.unblockIndexing(srv1);
        idxFut1.get();
        idxFut2.get();
        DynamicIndexAbstractConcurrentSelfTest.assertIndex("cache", TBL_NAME, "idx_1", DynamicIndexAbstractConcurrentSelfTest.field("field1"));
        DynamicIndexAbstractConcurrentSelfTest.assertIndex("cache", TBL_NAME, "idx_2", DynamicIndexAbstractConcurrentSelfTest.field(DynamicIndexAbstractConcurrentSelfTest.alias("field2")));
        Thread.sleep(100L);
        DynamicIndexAbstractConcurrentSelfTest.put(srv1, 0, 200);
        DynamicIndexAbstractConcurrentSelfTest.assertIndexUsed("idx_1", SQL_SIMPLE_FIELD_1, 40);
        DynamicIndexAbstractConcurrentSelfTest.assertIndexUsed("idx_2", SQL_SIMPLE_FIELD_2, 40);
        DynamicIndexAbstractConcurrentSelfTest.assertSqlSimpleData(SQL_SIMPLE_FIELD_1, 160);
        DynamicIndexAbstractConcurrentSelfTest.assertSqlSimpleData(SQL_SIMPLE_FIELD_2, 160);
    }

    public void testNodeJoinOnPendingOperation() throws Exception {
        Ignite srv1 = Ignition.start((IgniteConfiguration)this.serverConfiguration(1));
        srv1.getOrCreateCache(this.cacheConfiguration());
        DynamicIndexAbstractConcurrentSelfTest.blockIndexing(srv1);
        QueryIndex idx = DynamicIndexAbstractConcurrentSelfTest.index("idx_1", DynamicIndexAbstractConcurrentSelfTest.field("field1"));
        IgniteInternalFuture idxFut = DynamicIndexAbstractConcurrentSelfTest.queryProcessor(srv1).dynamicIndexCreate("cache", TBL_NAME, idx, false);
        Ignition.start((IgniteConfiguration)this.serverConfiguration(2));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(3, true));
        Ignition.start((IgniteConfiguration)this.clientConfiguration(4));
        assert (!idxFut.isDone());
        DynamicIndexAbstractConcurrentSelfTest.unblockIndexing(srv1);
        idxFut.get();
        Thread.sleep(100L);
        DynamicIndexAbstractConcurrentSelfTest.assertIndex("cache", TBL_NAME, "idx_1", DynamicIndexAbstractConcurrentSelfTest.field("field1"));
        DynamicIndexAbstractConcurrentSelfTest.put(srv1, 0, 200);
        DynamicIndexAbstractConcurrentSelfTest.assertIndexUsed("idx_1", SQL_SIMPLE_FIELD_1, 40);
        DynamicIndexAbstractConcurrentSelfTest.assertSqlSimpleData(SQL_SIMPLE_FIELD_1, 160);
    }

    public void testConcurrentPutRemove() throws Exception {
        Ignite srv1 = Ignition.start((IgniteConfiguration)this.serverConfiguration(1));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(2));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(3));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(4));
        this.awaitPartitionMapExchange();
        IgniteCache cache = srv1.createCache(this.cacheConfiguration()).withKeepBinary();
        final AtomicBoolean stopped = new AtomicBoolean();
        IgniteInternalFuture updateFut = this.multithreadedAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                while (!stopped.get()) {
                    IgniteEx node = DynamicIndexAbstractConcurrentSelfTest.this.grid(ThreadLocalRandom.current().nextInt(1, 5));
                    int key = ThreadLocalRandom.current().nextInt(0, 100000);
                    int val = ThreadLocalRandom.current().nextInt();
                    BinaryObject keyObj = DynamicIndexAbstractSelfTest.key((Ignite)node, key);
                    if (ThreadLocalRandom.current().nextBoolean()) {
                        BinaryObject valObj = DynamicIndexAbstractSelfTest.value((Ignite)node, val);
                        node.cache("cache").put((Object)keyObj, (Object)valObj);
                        continue;
                    }
                    node.cache("cache").remove((Object)keyObj);
                }
                return null;
            }
        }, 4);
        Thread.sleep(500L);
        QueryIndex idx = DynamicIndexAbstractConcurrentSelfTest.index("idx_1", DynamicIndexAbstractConcurrentSelfTest.field("field1"));
        DynamicIndexAbstractConcurrentSelfTest.queryProcessor(srv1).dynamicIndexCreate("cache", TBL_NAME, idx, false).get();
        stopped.set(true);
        updateFut.get();
        DynamicIndexAbstractConcurrentSelfTest.assertIndex("cache", TBL_NAME, "idx_1", DynamicIndexAbstractConcurrentSelfTest.field("field1"));
        DynamicIndexAbstractConcurrentSelfTest.assertIndexUsed("idx_1", SQL_SIMPLE_FIELD_1, 40);
        HashMap<Long, Long> expKeys = new HashMap<Long, Long>();
        for (int i = 0; i < 100000; ++i) {
            long fieldVal;
            BinaryObject val = (BinaryObject)cache.get((Object)DynamicIndexAbstractConcurrentSelfTest.key(srv1, i));
            if (val == null || (fieldVal = ((Long)val.field("field1")).longValue()) < 40L) continue;
            expKeys.put(Long.valueOf(i), fieldVal);
        }
        for (Ignite node : Ignition.allGrids()) {
            IgniteCache nodeCache = node.cache("cache").withKeepBinary();
            SqlQuery qry = new SqlQuery(DynamicIndexAbstractConcurrentSelfTest.tableName(AbstractSchemaSelfTest.ValueClass.class), SQL_SIMPLE_FIELD_1).setArgs(new Object[]{40});
            List res = nodeCache.query((Query)qry).getAll();
            DynamicIndexAbstractConcurrentSelfTest.assertEquals((String)("Cache size mismatch [exp=" + expKeys.size() + ", actual=" + res.size() + ']'), (int)expKeys.size(), (int)res.size());
            for (Cache.Entry entry : res) {
                long key = (Long)((BinaryObject)entry.getKey()).field("id");
                Long fieldVal = (Long)((BinaryObject)entry.getValue()).field("field1");
                DynamicIndexAbstractConcurrentSelfTest.assertTrue((String)("Expected key is not in result set: " + key), (boolean)expKeys.containsKey(key));
                DynamicIndexAbstractConcurrentSelfTest.assertEquals((String)("Unexpected value [key=" + key + ", expVal=" + expKeys.get(key) + ", actualVal=" + fieldVal + ']'), expKeys.get(key), (Object)fieldVal);
            }
        }
    }

    public void testConcurrentRebalance() throws Exception {
        Ignite srv1 = Ignition.start((IgniteConfiguration)this.serverConfiguration(1));
        Ignite srv2 = Ignition.start((IgniteConfiguration)this.serverConfiguration(2));
        srv1.createCache(this.cacheConfiguration());
        this.awaitPartitionMapExchange();
        DynamicIndexAbstractConcurrentSelfTest.put(srv1, 0, 100000);
        DynamicIndexAbstractConcurrentSelfTest.blockIndexing(srv1);
        DynamicIndexAbstractConcurrentSelfTest.blockIndexing(srv2);
        QueryIndex idx = DynamicIndexAbstractConcurrentSelfTest.index("idx_1", DynamicIndexAbstractConcurrentSelfTest.field("field1"));
        IgniteInternalFuture idxFut = DynamicIndexAbstractConcurrentSelfTest.queryProcessor(srv1).dynamicIndexCreate("cache", TBL_NAME, idx, false);
        Thread.sleep(100L);
        Ignition.start((IgniteConfiguration)this.serverConfiguration(3));
        DynamicIndexAbstractConcurrentSelfTest.unblockIndexing(srv1);
        DynamicIndexAbstractConcurrentSelfTest.unblockIndexing(srv2);
        Ignition.start((IgniteConfiguration)this.serverConfiguration(4));
        this.awaitPartitionMapExchange();
        idxFut.get();
        DynamicIndexAbstractConcurrentSelfTest.assertIndex("cache", TBL_NAME, "idx_1", DynamicIndexAbstractConcurrentSelfTest.field("field1"));
        DynamicIndexAbstractConcurrentSelfTest.assertIndexUsed("idx_1", SQL_SIMPLE_FIELD_1, 40);
        DynamicIndexAbstractConcurrentSelfTest.assertSqlSimpleData(SQL_SIMPLE_FIELD_1, 99960);
    }

    public void testConcurrentCacheDestroy() throws Exception {
        Ignite srv1 = Ignition.start((IgniteConfiguration)this.serverConfiguration(1));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(2));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(3, true));
        Ignite cli = Ignition.start((IgniteConfiguration)this.clientConfiguration(4));
        IgniteCache cache = cli.getOrCreateCache(this.cacheConfiguration());
        DynamicIndexAbstractConcurrentSelfTest.put(cli, 200L);
        DynamicIndexAbstractConcurrentSelfTest.blockIndexing(srv1);
        QueryIndex idx = DynamicIndexAbstractConcurrentSelfTest.index("idx_1", DynamicIndexAbstractConcurrentSelfTest.field("field1"));
        IgniteInternalFuture idxFut = DynamicIndexAbstractConcurrentSelfTest.queryProcessor(srv1).dynamicIndexCreate("cache", TBL_NAME, idx, false);
        Thread.sleep(100L);
        cache.destroy();
        DynamicIndexAbstractConcurrentSelfTest.unblockIndexing(srv1);
        try {
            idxFut.get();
            DynamicIndexAbstractConcurrentSelfTest.fail((String)"Exception has not been thrown.");
        }
        catch (SchemaOperationException schemaOperationException) {
            // empty catch block
        }
    }

    public void testConcurrentOperationsMultithreaded() throws Exception {
        Ignition.start((IgniteConfiguration)this.serverConfiguration(1));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(2));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(3, true));
        Ignite cli = Ignition.start((IgniteConfiguration)this.clientConfiguration(4));
        cli.createCache(this.cacheConfiguration());
        final AtomicBoolean stopped = new AtomicBoolean();
        final QueryIndex idx = DynamicIndexAbstractConcurrentSelfTest.index("idx_1", DynamicIndexAbstractConcurrentSelfTest.field("field1"));
        IgniteInternalFuture idxFut = this.multithreadedAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                boolean exists = false;
                while (!stopped.get()) {
                    IgniteInternalFuture fut;
                    IgniteEx node = DynamicIndexAbstractConcurrentSelfTest.this.grid(ThreadLocalRandom.current().nextInt(1, 5));
                    if (exists) {
                        fut = AbstractSchemaSelfTest.queryProcessor((Ignite)node).dynamicIndexDrop("cache", "idx_1", true);
                        exists = false;
                    } else {
                        fut = AbstractSchemaSelfTest.queryProcessor((Ignite)node).dynamicIndexCreate("cache", AbstractSchemaSelfTest.TBL_NAME, idx, true);
                        exists = true;
                    }
                    try {
                        fut.get();
                    }
                    catch (SchemaOperationException schemaOperationException) {
                    }
                    catch (Exception e) {
                        TestCase.fail((String)("Unexpected exception: " + e));
                    }
                }
                return null;
            }
        }, 8);
        Thread.sleep(10000L);
        stopped.set(true);
        idxFut.get();
        DynamicIndexAbstractConcurrentSelfTest.queryProcessor(cli).dynamicIndexDrop("cache", "idx_1", true).get();
        DynamicIndexAbstractConcurrentSelfTest.queryProcessor(cli).dynamicIndexCreate("cache", TBL_NAME, idx, true).get();
        DynamicIndexAbstractConcurrentSelfTest.assertIndex("cache", TBL_NAME, "idx_1", DynamicIndexAbstractConcurrentSelfTest.field("field1"));
        DynamicIndexAbstractConcurrentSelfTest.put(cli, 0, 200);
        DynamicIndexAbstractConcurrentSelfTest.assertIndexUsed("idx_1", SQL_SIMPLE_FIELD_1, 40);
        DynamicIndexAbstractConcurrentSelfTest.assertSqlSimpleData(SQL_SIMPLE_FIELD_1, 160);
    }

    public void testQueryConsistencyMultithreaded() throws Exception {
        Ignition.start((IgniteConfiguration)this.serverConfiguration(1));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(2));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(3, true));
        Ignite cli = Ignition.start((IgniteConfiguration)this.clientConfiguration(4));
        cli.createCache(this.cacheConfiguration());
        DynamicIndexAbstractConcurrentSelfTest.put(cli, 0, 200);
        final AtomicBoolean stopped = new AtomicBoolean();
        final QueryIndex idx = DynamicIndexAbstractConcurrentSelfTest.index("idx_1", DynamicIndexAbstractConcurrentSelfTest.field("field1"));
        IgniteInternalFuture idxFut = this.multithreadedAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                boolean exists = false;
                while (!stopped.get()) {
                    IgniteInternalFuture fut;
                    IgniteEx node = DynamicIndexAbstractConcurrentSelfTest.this.grid(ThreadLocalRandom.current().nextInt(1, 5));
                    if (exists) {
                        fut = AbstractSchemaSelfTest.queryProcessor((Ignite)node).dynamicIndexDrop("cache", "idx_1", true);
                        exists = false;
                    } else {
                        fut = AbstractSchemaSelfTest.queryProcessor((Ignite)node).dynamicIndexCreate("cache", AbstractSchemaSelfTest.TBL_NAME, idx, true);
                        exists = true;
                    }
                    try {
                        fut.get();
                    }
                    catch (SchemaOperationException schemaOperationException) {
                    }
                    catch (Exception e) {
                        TestCase.fail((String)("Unexpected exception: " + e));
                    }
                }
                return null;
            }
        }, 1);
        IgniteInternalFuture qryFut = this.multithreadedAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                while (!stopped.get()) {
                    IgniteEx node = DynamicIndexAbstractConcurrentSelfTest.this.grid(ThreadLocalRandom.current().nextInt(1, 5));
                    DynamicIndexAbstractSelfTest.assertSqlSimpleData((Ignite)node, DynamicIndexAbstractSelfTest.SQL_SIMPLE_FIELD_1, 160);
                }
                return null;
            }
        }, 8);
        Thread.sleep(10000L);
        stopped.set(true);
        idxFut.get();
        qryFut.get();
    }

    public void testClientReconnect() throws Exception {
        this.checkClientReconnect(false);
    }

    public void testClientReconnectWithCacheRestart() throws Exception {
        this.checkClientReconnect(true);
    }

    private void checkClientReconnect(final boolean restartCache) throws Exception {
        final Ignite srv = Ignition.start((IgniteConfiguration)this.serverConfiguration(1));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(2));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(3, true));
        Ignite cli = Ignition.start((IgniteConfiguration)this.clientConfiguration(4));
        cli.createCache(this.cacheConfiguration());
        this.reconnectClientNode(srv, cli, restartCache, new AbstractSchemaSelfTest.RunnableX(){

            @Override
            public void run() throws Exception {
                QueryIndex idx = AbstractSchemaSelfTest.index("idx_1", AbstractSchemaSelfTest.field("field1"));
                AbstractSchemaSelfTest.queryProcessor(srv).dynamicIndexCreate("cache", AbstractSchemaSelfTest.TBL_NAME, idx, false).get();
            }
        });
        DynamicIndexAbstractConcurrentSelfTest.assertIndex(cli, true, "cache", TBL_NAME, "idx_1", DynamicIndexAbstractConcurrentSelfTest.field("field1"));
        DynamicIndexAbstractConcurrentSelfTest.assertIndexUsed("idx_1", SQL_SIMPLE_FIELD_1, 40);
        this.reconnectClientNode(srv, cli, restartCache, new AbstractSchemaSelfTest.RunnableX(){

            @Override
            public void run() throws Exception {
                if (!restartCache) {
                    AbstractSchemaSelfTest.queryProcessor(srv).dynamicIndexDrop("cache", "idx_1", false).get();
                }
            }
        });
        DynamicIndexAbstractConcurrentSelfTest.assertNoIndex(cli, "cache", TBL_NAME, "idx_1");
        DynamicIndexAbstractConcurrentSelfTest.assertIndexNotUsed("idx_1", SQL_SIMPLE_FIELD_1, 40);
        QueryIndex idx = DynamicIndexAbstractConcurrentSelfTest.index("idx_2", DynamicIndexAbstractConcurrentSelfTest.field(DynamicIndexAbstractConcurrentSelfTest.alias("field2")));
        DynamicIndexAbstractConcurrentSelfTest.queryProcessor(srv).dynamicIndexCreate("cache", TBL_NAME, idx, false).get();
        DynamicIndexAbstractConcurrentSelfTest.assertIndex(cli, true, "cache", TBL_NAME, "idx_2", DynamicIndexAbstractConcurrentSelfTest.field(DynamicIndexAbstractConcurrentSelfTest.alias("field2")));
        DynamicIndexAbstractConcurrentSelfTest.assertIndexUsed("idx_2", SQL_SIMPLE_FIELD_2, 80);
        this.reconnectClientNode(srv, cli, restartCache, new AbstractSchemaSelfTest.RunnableX(){

            @Override
            public void run() throws Exception {
                if (!restartCache) {
                    AbstractSchemaSelfTest.queryProcessor(srv).dynamicIndexDrop("cache", "idx_2", false).get();
                }
                QueryIndex idx = AbstractSchemaSelfTest.index("idx_2", AbstractSchemaSelfTest.field("field1"), AbstractSchemaSelfTest.field(AbstractSchemaSelfTest.alias("field2")));
                AbstractSchemaSelfTest.queryProcessor(srv).dynamicIndexCreate("cache", AbstractSchemaSelfTest.TBL_NAME, idx, false);
            }
        });
        DynamicIndexAbstractConcurrentSelfTest.assertIndex("cache", TBL_NAME, "idx_2", DynamicIndexAbstractConcurrentSelfTest.field("field1"), DynamicIndexAbstractConcurrentSelfTest.field(DynamicIndexAbstractConcurrentSelfTest.alias("field2")));
        DynamicIndexAbstractConcurrentSelfTest.assertIndexUsed("idx_2", SQL_COMPOSITE, 40, 80);
    }

    private void reconnectClientNode(final Ignite srvNode, Ignite cliNode, final boolean restart, final AbstractSchemaSelfTest.RunnableX clo) throws Exception {
        IgniteClientReconnectAbstractTest.reconnectClientNode((IgniteLogger)this.log, (Ignite)cliNode, (Ignite)srvNode, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (restart) {
                    srvNode.destroyCache("cache");
                    srvNode.getOrCreateCache(DynamicIndexAbstractConcurrentSelfTest.this.cacheConfiguration().setName("cache"));
                }
                try {
                    clo.run();
                }
                catch (Exception e) {
                    throw new IgniteException("Test reconnect runnable failed.", (Throwable)e);
                }
            }
        });
        if (restart) {
            cliNode.cache("cache");
        }
    }

    public void testConcurrentOperationsAndNodeStartStopMultithreaded() throws Exception {
        Ignition.start((IgniteConfiguration)this.serverConfiguration(1));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(2));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(3, true));
        Ignite cli = Ignition.start((IgniteConfiguration)this.clientConfiguration(4));
        cli.createCache(this.cacheConfiguration());
        final AtomicBoolean stopped = new AtomicBoolean();
        final AtomicInteger nodeIdx = new AtomicInteger(4);
        IgniteInternalFuture startStopFut = this.multithreadedAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                boolean exists = false;
                int lastIdx = 0;
                while (!stopped.get()) {
                    if (exists) {
                        DynamicIndexAbstractConcurrentSelfTest.this.stopGrid(lastIdx);
                        exists = false;
                    } else {
                        IgniteConfiguration cfg;
                        lastIdx = nodeIdx.incrementAndGet();
                        switch (ThreadLocalRandom.current().nextInt(0, 3)) {
                            case 1: {
                                cfg = DynamicIndexAbstractConcurrentSelfTest.this.serverConfiguration(lastIdx, false);
                                break;
                            }
                            case 2: {
                                cfg = DynamicIndexAbstractConcurrentSelfTest.this.serverConfiguration(lastIdx, true);
                                break;
                            }
                            default: {
                                cfg = DynamicIndexAbstractConcurrentSelfTest.this.clientConfiguration(lastIdx);
                            }
                        }
                        Ignition.start((IgniteConfiguration)cfg);
                        exists = true;
                    }
                    Thread.sleep(ThreadLocalRandom.current().nextLong(500L, 1500L));
                }
                return null;
            }
        }, 1);
        final QueryIndex idx = DynamicIndexAbstractConcurrentSelfTest.index("idx_1", DynamicIndexAbstractConcurrentSelfTest.field("field1"));
        IgniteInternalFuture idxFut = this.multithreadedAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                boolean exists = false;
                while (!stopped.get()) {
                    IgniteInternalFuture fut;
                    IgniteEx node = DynamicIndexAbstractConcurrentSelfTest.this.grid(ThreadLocalRandom.current().nextInt(1, 5));
                    if (exists) {
                        fut = AbstractSchemaSelfTest.queryProcessor((Ignite)node).dynamicIndexDrop("cache", "idx_1", true);
                        exists = false;
                    } else {
                        fut = AbstractSchemaSelfTest.queryProcessor((Ignite)node).dynamicIndexCreate("cache", AbstractSchemaSelfTest.TBL_NAME, idx, true);
                        exists = true;
                    }
                    try {
                        fut.get();
                    }
                    catch (SchemaOperationException schemaOperationException) {
                    }
                    catch (Exception e) {
                        TestCase.fail((String)("Unexpected exception: " + e));
                    }
                }
                return null;
            }
        }, 1);
        Thread.sleep(10000L);
        stopped.set(true);
        startStopFut.get();
        idxFut.get();
        cli.getOrCreateCache(this.cacheConfiguration());
        DynamicIndexAbstractConcurrentSelfTest.queryProcessor(cli).dynamicIndexDrop("cache", "idx_1", true).get();
        DynamicIndexAbstractConcurrentSelfTest.queryProcessor(cli).dynamicIndexCreate("cache", TBL_NAME, idx, true).get();
        DynamicIndexAbstractConcurrentSelfTest.assertIndex("cache", TBL_NAME, "idx_1", DynamicIndexAbstractConcurrentSelfTest.field("field1"));
        DynamicIndexAbstractConcurrentSelfTest.put(cli, 0, 200);
        DynamicIndexAbstractConcurrentSelfTest.assertIndexUsed("idx_1", SQL_SIMPLE_FIELD_1, 40);
        DynamicIndexAbstractConcurrentSelfTest.assertSqlSimpleData(SQL_SIMPLE_FIELD_1, 160);
    }

    public void testConcurrentOperationsAndCacheStartStopMultithreaded() throws Exception {
        Ignition.start((IgniteConfiguration)this.serverConfiguration(1));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(2));
        Ignition.start((IgniteConfiguration)this.serverConfiguration(3, true));
        Ignite cli = Ignition.start((IgniteConfiguration)this.clientConfiguration(4));
        final AtomicBoolean stopped = new AtomicBoolean();
        IgniteInternalFuture startStopFut = this.multithreadedAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                boolean exists = false;
                while (!stopped.get()) {
                    IgniteEx node = DynamicIndexAbstractConcurrentSelfTest.this.grid(ThreadLocalRandom.current().nextInt(1, 5));
                    if (exists) {
                        node.destroyCache("cache");
                        exists = false;
                    } else {
                        node.createCache(DynamicIndexAbstractConcurrentSelfTest.this.cacheConfiguration());
                        exists = true;
                    }
                    Thread.sleep(ThreadLocalRandom.current().nextLong(200L, 400L));
                }
                return null;
            }
        }, 1);
        final QueryIndex idx = DynamicIndexAbstractConcurrentSelfTest.index("idx_1", DynamicIndexAbstractConcurrentSelfTest.field("field1"));
        IgniteInternalFuture idxFut = this.multithreadedAsync(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                boolean exists = false;
                while (!stopped.get()) {
                    IgniteInternalFuture fut;
                    IgniteEx node = DynamicIndexAbstractConcurrentSelfTest.this.grid(ThreadLocalRandom.current().nextInt(1, 5));
                    if (exists) {
                        fut = AbstractSchemaSelfTest.queryProcessor((Ignite)node).dynamicIndexDrop("cache", "idx_1", true);
                        exists = false;
                    } else {
                        fut = AbstractSchemaSelfTest.queryProcessor((Ignite)node).dynamicIndexCreate("cache", AbstractSchemaSelfTest.TBL_NAME, idx, true);
                        exists = true;
                    }
                    try {
                        fut.get();
                    }
                    catch (SchemaOperationException schemaOperationException) {
                    }
                    catch (Exception e) {
                        TestCase.fail((String)("Unexpected exception: " + e));
                    }
                }
                return null;
            }
        }, 8);
        Thread.sleep(10000L);
        stopped.set(true);
        startStopFut.get();
        idxFut.get();
        cli.getOrCreateCache(this.cacheConfiguration());
        DynamicIndexAbstractConcurrentSelfTest.queryProcessor(cli).dynamicIndexDrop("cache", "idx_1", true).get();
        DynamicIndexAbstractConcurrentSelfTest.queryProcessor(cli).dynamicIndexCreate("cache", TBL_NAME, idx, true).get();
        DynamicIndexAbstractConcurrentSelfTest.assertIndex("cache", TBL_NAME, "idx_1", DynamicIndexAbstractConcurrentSelfTest.field("field1"));
        DynamicIndexAbstractConcurrentSelfTest.put(cli, 0, 200);
        DynamicIndexAbstractConcurrentSelfTest.assertIndexUsed("idx_1", SQL_SIMPLE_FIELD_1, 40);
        DynamicIndexAbstractConcurrentSelfTest.assertSqlSimpleData(SQL_SIMPLE_FIELD_1, 160);
    }

    private static void blockIndexing(Ignite node) {
        UUID nodeId = ((IgniteEx)node).localNode().id();
        DynamicIndexAbstractConcurrentSelfTest.blockIndexing(nodeId);
    }

    private static void blockIndexing(UUID nodeId) {
        DynamicIndexAbstractConcurrentSelfTest.assertFalse((boolean)BLOCKS.contains(nodeId));
        BLOCKS.put(nodeId, (T2<CountDownLatch, AtomicBoolean>)new T2((Object)new CountDownLatch(1), (Object)new AtomicBoolean()));
    }

    private static void unblockIndexing(Ignite node) {
        UUID nodeId = ((IgniteEx)node).localNode().id();
        DynamicIndexAbstractConcurrentSelfTest.unblockIndexing(nodeId);
    }

    private static void unblockIndexing(UUID nodeId) {
        T2<CountDownLatch, AtomicBoolean> blocker = BLOCKS.remove(nodeId);
        DynamicIndexAbstractConcurrentSelfTest.assertNotNull(blocker);
        ((CountDownLatch)blocker.get1()).countDown();
    }

    private static void awaitIndexing(UUID nodeId) {
        T2<CountDownLatch, AtomicBoolean> blocker = BLOCKS.get(nodeId);
        if (blocker != null) {
            DynamicIndexAbstractConcurrentSelfTest.assertTrue((boolean)((AtomicBoolean)blocker.get2()).compareAndSet(false, true));
            while (true) {
                try {
                    ((CountDownLatch)blocker.get1()).await();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private static class BlockingIndexing
    extends IgniteH2Indexing {
        private BlockingIndexing() {
        }

        public void dynamicIndexCreate(@NotNull String spaceName, String tblName, QueryIndexDescriptorImpl idxDesc, boolean ifNotExists, SchemaIndexCacheVisitor cacheVisitor) throws IgniteCheckedException {
            DynamicIndexAbstractConcurrentSelfTest.awaitIndexing(this.ctx.localNodeId());
            super.dynamicIndexCreate(spaceName, tblName, idxDesc, ifNotExists, cacheVisitor);
        }

        public void dynamicIndexDrop(@NotNull String spaceName, String idxName, boolean ifExists) throws IgniteCheckedException {
            DynamicIndexAbstractConcurrentSelfTest.awaitIndexing(this.ctx.localNodeId());
            super.dynamicIndexDrop(spaceName, idxName, ifExists);
        }
    }
}

