/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractSchemaSelfTest;
import org.apache.ignite.internal.processors.cache.index.DynamicIndexAbstractSelfTest;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationException;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.typedef.internal.SB;

public abstract class DynamicIndexAbstractBasicSelfTest
extends DynamicIndexAbstractSelfTest {
    protected static final int IDX_SRV_CRD = 0;
    protected static final int IDX_SRV_NON_CRD = 1;
    protected static final int IDX_CLI = 2;
    protected static final int IDX_SRV_FILTERED = 3;
    protected static final int IDX_CLI_NEAR_ONLY = 4;

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        for (IgniteConfiguration cfg : this.configurations()) {
            Ignition.start((IgniteConfiguration)cfg);
        }
    }

    protected void afterTest() throws Exception {
        this.node().destroyCache("cache");
        super.afterTest();
    }

    private void initialize(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) {
        this.node().getOrCreateCache(this.cacheConfiguration(mode, atomicityMode, near));
        this.grid(4).getOrCreateNearCache("cache", new NearCacheConfiguration());
        DynamicIndexAbstractBasicSelfTest.assertNoIndex("cache", TBL_NAME, "idx_1");
        this.loadInitialData();
    }

    private CacheConfiguration<AbstractSchemaSelfTest.KeyClass, AbstractSchemaSelfTest.ValueClass> cacheConfiguration(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) {
        CacheConfiguration<AbstractSchemaSelfTest.KeyClass, AbstractSchemaSelfTest.ValueClass> ccfg = this.cacheConfiguration();
        ccfg.setCacheMode(mode);
        ccfg.setAtomicityMode(atomicityMode);
        if (near) {
            ccfg.setNearConfiguration(new NearCacheConfiguration());
        }
        return ccfg;
    }

    private void loadInitialData() {
        DynamicIndexAbstractBasicSelfTest.put((Ignite)this.node(), 0, 100);
    }

    public void testCreatePartitionedAtomic() throws Exception {
        this.checkCreate(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false);
    }

    public void testCreatePartitionedAtomicNear() throws Exception {
        this.checkCreate(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true);
    }

    public void testCreatePartitionedTransactional() throws Exception {
        this.checkCreate(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    public void testCreatePartitionedTransactionalNear() throws Exception {
        this.checkCreate(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true);
    }

    public void testCreateReplicatedAtomic() throws Exception {
        this.checkCreate(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false);
    }

    public void testCreateReplicatedTransactional() throws Exception {
        this.checkCreate(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    private void checkCreate(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) throws Exception {
        this.initialize(mode, atomicityMode, near);
        final QueryIndex idx = DynamicIndexAbstractBasicSelfTest.index("idx_1", DynamicIndexAbstractBasicSelfTest.field("field1"));
        this.dynamicIndexCreate("cache", TBL_NAME, idx, false);
        DynamicIndexAbstractBasicSelfTest.assertIndex("cache", TBL_NAME, "idx_1", DynamicIndexAbstractBasicSelfTest.field("field1"));
        DynamicIndexAbstractBasicSelfTest.assertSchemaException(new AbstractSchemaSelfTest.RunnableX(){

            @Override
            public void run() throws Exception {
                DynamicIndexAbstractBasicSelfTest.this.dynamicIndexCreate("cache", AbstractSchemaSelfTest.TBL_NAME, idx, false);
            }
        }, 3005);
        this.dynamicIndexCreate("cache", TBL_NAME, idx, true);
        DynamicIndexAbstractBasicSelfTest.assertIndex("cache", TBL_NAME, "idx_1", DynamicIndexAbstractBasicSelfTest.field("field1"));
        this.assertSimpleIndexOperations(SQL_SIMPLE_FIELD_1);
        DynamicIndexAbstractBasicSelfTest.assertIndexUsed("idx_1", SQL_SIMPLE_FIELD_1, 40);
    }

    public void testCreateCompositePartitionedAtomic() throws Exception {
        this.checkCreateComposite(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false);
    }

    public void testCreateCompositePartitionedAtomicNear() throws Exception {
        this.checkCreateComposite(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true);
    }

    public void testCreateCompositePartitionedTransactional() throws Exception {
        this.checkCreateComposite(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    public void testCreateCompositePartitionedTransactionalNear() throws Exception {
        this.checkCreateComposite(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true);
    }

    public void testCreateCompositeReplicatedAtomic() throws Exception {
        this.checkCreateComposite(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false);
    }

    public void testCreateCompositeReplicatedTransactional() throws Exception {
        this.checkCreateComposite(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    private void checkCreateComposite(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) throws Exception {
        this.initialize(mode, atomicityMode, near);
        QueryIndex idx = DynamicIndexAbstractBasicSelfTest.index("idx_1", DynamicIndexAbstractBasicSelfTest.field("field1"), DynamicIndexAbstractBasicSelfTest.field(DynamicIndexAbstractBasicSelfTest.alias("field2")));
        this.dynamicIndexCreate("cache", TBL_NAME, idx, false);
        DynamicIndexAbstractBasicSelfTest.assertIndex("cache", TBL_NAME, "idx_1", DynamicIndexAbstractBasicSelfTest.field("field1"), DynamicIndexAbstractBasicSelfTest.field(DynamicIndexAbstractBasicSelfTest.alias("field2")));
        this.assertCompositeIndexOperations(SQL_COMPOSITE);
        DynamicIndexAbstractBasicSelfTest.assertIndexUsed("idx_1", SQL_COMPOSITE, 40, 80);
    }

    public void testCreateNoCachePartitionedAtomic() throws Exception {
        this.checkCreateNotCache(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false);
    }

    public void testCreateNoCachePartitionedAtomicNear() throws Exception {
        this.checkCreateNotCache(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true);
    }

    public void testCreateNoCachePartitionedTransactional() throws Exception {
        this.checkCreateNotCache(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    public void testCreateNoCachePartitionedTransactionalNear() throws Exception {
        this.checkCreateNotCache(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true);
    }

    public void testCreateNoCacheReplicatedAtomic() throws Exception {
        this.checkCreateNotCache(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false);
    }

    public void testCreateNoCacheReplicatedTransactional() throws Exception {
        this.checkCreateNotCache(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    private void checkCreateNotCache(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) throws Exception {
        this.initialize(mode, atomicityMode, near);
        QueryIndex idx = DynamicIndexAbstractBasicSelfTest.index("idx_1", DynamicIndexAbstractBasicSelfTest.field("field1"));
        try {
            DynamicIndexAbstractBasicSelfTest.queryProcessor((Ignite)this.node()).dynamicIndexCreate(DynamicIndexAbstractBasicSelfTest.randomString(), TBL_NAME, idx, false).get();
        }
        catch (SchemaOperationException e) {
            DynamicIndexAbstractBasicSelfTest.assertEquals((int)1, (int)e.code());
            DynamicIndexAbstractBasicSelfTest.assertNoIndex("cache", TBL_NAME, "idx_1");
            return;
        }
        catch (Exception e) {
            DynamicIndexAbstractBasicSelfTest.fail((String)("Unexpected exception: " + e));
        }
        DynamicIndexAbstractBasicSelfTest.fail((String)(SchemaOperationException.class.getSimpleName() + " is not thrown."));
    }

    public void testCreateNoTablePartitionedAtomic() throws Exception {
        this.checkCreateNoTable(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false);
    }

    public void testCreateNoTablePartitionedAtomicNear() throws Exception {
        this.checkCreateNoTable(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true);
    }

    public void testCreateNoTablePartitionedTransactional() throws Exception {
        this.checkCreateNoTable(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    public void testCreateNoTablePartitionedTransactionalNear() throws Exception {
        this.checkCreateNoTable(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true);
    }

    public void testCreateNoTableReplicatedAtomic() throws Exception {
        this.checkCreateNoTable(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false);
    }

    public void testCreateNoTableReplicatedTransactional() throws Exception {
        this.checkCreateNoTable(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    private void checkCreateNoTable(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) throws Exception {
        this.initialize(mode, atomicityMode, near);
        final QueryIndex idx = DynamicIndexAbstractBasicSelfTest.index("idx_1", DynamicIndexAbstractBasicSelfTest.field("field1"));
        DynamicIndexAbstractBasicSelfTest.assertSchemaException(new AbstractSchemaSelfTest.RunnableX(){

            @Override
            public void run() throws Exception {
                DynamicIndexAbstractBasicSelfTest.this.dynamicIndexCreate("cache", DynamicIndexAbstractSelfTest.randomString(), idx, false);
            }
        }, 3001);
        DynamicIndexAbstractBasicSelfTest.assertNoIndex("cache", TBL_NAME, "idx_1");
    }

    public void testCreateNoColumnPartitionedAtomic() throws Exception {
        this.checkCreateNoColumn(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false);
    }

    public void testCreateNoColumnPartitionedAtomicNear() throws Exception {
        this.checkCreateNoColumn(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true);
    }

    public void testCreateNoColumnPartitionedTransactional() throws Exception {
        this.checkCreateNoColumn(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    public void testCreateNoColumnPartitionedTransactionalNear() throws Exception {
        this.checkCreateNoColumn(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true);
    }

    public void testCreateNoColumnReplicatedAtomic() throws Exception {
        this.checkCreateNoColumn(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false);
    }

    public void testCreateNoColumnReplicatedTransactional() throws Exception {
        this.checkCreateNoColumn(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    private void checkCreateNoColumn(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) throws Exception {
        this.initialize(mode, atomicityMode, near);
        final QueryIndex idx = DynamicIndexAbstractBasicSelfTest.index("idx_1", DynamicIndexAbstractBasicSelfTest.field(DynamicIndexAbstractBasicSelfTest.randomString()));
        DynamicIndexAbstractBasicSelfTest.assertSchemaException(new AbstractSchemaSelfTest.RunnableX(){

            @Override
            public void run() throws Exception {
                DynamicIndexAbstractBasicSelfTest.this.dynamicIndexCreate("cache", AbstractSchemaSelfTest.TBL_NAME, idx, false);
            }
        }, 3008);
        DynamicIndexAbstractBasicSelfTest.assertNoIndex("cache", TBL_NAME, "idx_1");
    }

    public void testCreateColumnWithAliasPartitionedAtomic() throws Exception {
        this.checkCreateColumnWithAlias(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false);
    }

    public void testCreateColumnWithAliasPartitionedAtomicNear() throws Exception {
        this.checkCreateColumnWithAlias(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true);
    }

    public void testCreateColumnWithAliasPartitionedTransactional() throws Exception {
        this.checkCreateColumnWithAlias(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    public void testCreateColumnWithAliasPartitionedTransactionalNear() throws Exception {
        this.checkCreateColumnWithAlias(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true);
    }

    public void testCreateColumnWithAliasReplicatedAtomic() throws Exception {
        this.checkCreateColumnWithAlias(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false);
    }

    public void testCreateColumnWithAliasReplicatedTransactional() throws Exception {
        this.checkCreateColumnWithAlias(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    private void checkCreateColumnWithAlias(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) throws Exception {
        this.initialize(mode, atomicityMode, near);
        DynamicIndexAbstractBasicSelfTest.assertSchemaException(new AbstractSchemaSelfTest.RunnableX(){

            @Override
            public void run() throws Exception {
                QueryIndex idx = AbstractSchemaSelfTest.index("idx_1", AbstractSchemaSelfTest.field("field2"));
                DynamicIndexAbstractBasicSelfTest.this.dynamicIndexCreate("cache", AbstractSchemaSelfTest.TBL_NAME, idx, false);
            }
        }, 3008);
        DynamicIndexAbstractBasicSelfTest.assertNoIndex("cache", TBL_NAME, "idx_1");
        QueryIndex idx = DynamicIndexAbstractBasicSelfTest.index("idx_1", DynamicIndexAbstractBasicSelfTest.field(DynamicIndexAbstractBasicSelfTest.alias("field2")));
        this.dynamicIndexCreate("cache", TBL_NAME, idx, false);
        DynamicIndexAbstractBasicSelfTest.assertIndex("cache", TBL_NAME, "idx_1", DynamicIndexAbstractBasicSelfTest.field(DynamicIndexAbstractBasicSelfTest.alias("field2")));
        this.assertSimpleIndexOperations(SQL_SIMPLE_FIELD_2);
        DynamicIndexAbstractBasicSelfTest.assertIndexUsed("idx_1", SQL_SIMPLE_FIELD_2, 40);
    }

    public void testDropPartitionedAtomic() throws Exception {
        this.checkDrop(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false);
    }

    public void testDropPartitionedAtomicNear() throws Exception {
        this.checkDrop(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true);
    }

    public void testDropPartitionedTransactional() throws Exception {
        this.checkDrop(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    public void testDropPartitionedTransactionalNear() throws Exception {
        this.checkDrop(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true);
    }

    public void testDropReplicatedAtomic() throws Exception {
        this.checkDrop(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false);
    }

    public void testDropReplicatedTransactional() throws Exception {
        this.checkDrop(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    public void checkDrop(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) throws Exception {
        this.initialize(mode, atomicityMode, near);
        QueryIndex idx1 = DynamicIndexAbstractBasicSelfTest.index("idx_1", DynamicIndexAbstractBasicSelfTest.field("field1"));
        this.dynamicIndexCreate("cache", TBL_NAME, idx1, false);
        DynamicIndexAbstractBasicSelfTest.assertIndex("cache", TBL_NAME, "idx_1", DynamicIndexAbstractBasicSelfTest.field("field1"));
        DynamicIndexAbstractBasicSelfTest.assertIndexUsed("idx_1", SQL_SIMPLE_FIELD_1, 40);
        this.assertSimpleIndexOperations(SQL_SIMPLE_FIELD_1);
        QueryIndex idx2 = DynamicIndexAbstractBasicSelfTest.index("idx_2", DynamicIndexAbstractBasicSelfTest.field(DynamicIndexAbstractBasicSelfTest.alias("field2")));
        this.dynamicIndexCreate("cache", TBL_NAME, idx2, false);
        DynamicIndexAbstractBasicSelfTest.assertIndex("cache", TBL_NAME, "idx_2", DynamicIndexAbstractBasicSelfTest.field(DynamicIndexAbstractBasicSelfTest.alias("field2")));
        this.loadInitialData();
        this.dynamicIndexDrop("cache", "idx_1", false);
        DynamicIndexAbstractBasicSelfTest.assertNoIndex("cache", TBL_NAME, "idx_1");
        this.assertSimpleIndexOperations(SQL_SIMPLE_FIELD_1);
        DynamicIndexAbstractBasicSelfTest.assertIndexNotUsed("idx_1", SQL_SIMPLE_FIELD_1, 40);
        DynamicIndexAbstractBasicSelfTest.assertIndex("cache", TBL_NAME, "idx_2", DynamicIndexAbstractBasicSelfTest.field(DynamicIndexAbstractBasicSelfTest.alias("field2")));
    }

    public void testDropNoIndexPartitionedAtomic() throws Exception {
        this.checkDropNoIndex(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false);
    }

    public void testDropNoIndexPartitionedAtomicNear() throws Exception {
        this.checkDropNoIndex(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true);
    }

    public void testDropNoIndexPartitionedTransactional() throws Exception {
        this.checkDropNoIndex(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    public void testDropNoIndexPartitionedTransactionalNear() throws Exception {
        this.checkDropNoIndex(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true);
    }

    public void testDropNoIndexReplicatedAtomic() throws Exception {
        this.checkDropNoIndex(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false);
    }

    public void testDropNoIndexReplicatedTransactional() throws Exception {
        this.checkDropNoIndex(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    private void checkDropNoIndex(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) throws Exception {
        this.initialize(mode, atomicityMode, near);
        DynamicIndexAbstractBasicSelfTest.assertSchemaException(new AbstractSchemaSelfTest.RunnableX(){

            @Override
            public void run() throws Exception {
                DynamicIndexAbstractBasicSelfTest.this.dynamicIndexDrop("cache", "idx_1", false);
            }
        }, 3006);
        this.dynamicIndexDrop("cache", "idx_1", true);
        DynamicIndexAbstractBasicSelfTest.assertNoIndex("cache", TBL_NAME, "idx_1");
    }

    public void testDropNoCachePartitionedAtomic() throws Exception {
        this.checkDropNoCache(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, false);
    }

    public void testDropNoCachePartitionedAtomicNear() throws Exception {
        this.checkDropNoCache(CacheMode.PARTITIONED, CacheAtomicityMode.ATOMIC, true);
    }

    public void testDropNoCachePartitionedTransactional() throws Exception {
        this.checkDropNoCache(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    public void testDropNoCachePartitionedTransactionalNear() throws Exception {
        this.checkDropNoCache(CacheMode.PARTITIONED, CacheAtomicityMode.TRANSACTIONAL, true);
    }

    public void testDropNoCacheReplicatedAtomic() throws Exception {
        this.checkDropNoCache(CacheMode.REPLICATED, CacheAtomicityMode.ATOMIC, false);
    }

    public void testDropNoCacheReplicatedTransactional() throws Exception {
        this.checkDropNoCache(CacheMode.REPLICATED, CacheAtomicityMode.TRANSACTIONAL, false);
    }

    private void checkDropNoCache(CacheMode mode, CacheAtomicityMode atomicityMode, boolean near) throws Exception {
        this.initialize(mode, atomicityMode, near);
        try {
            DynamicIndexAbstractBasicSelfTest.queryProcessor((Ignite)this.node()).dynamicIndexDrop(DynamicIndexAbstractBasicSelfTest.randomString(), "my_idx", false).get();
        }
        catch (SchemaOperationException e) {
            DynamicIndexAbstractBasicSelfTest.assertEquals((int)1, (int)e.code());
            DynamicIndexAbstractBasicSelfTest.assertNoIndex("cache", TBL_NAME, "idx_1");
            return;
        }
        catch (Exception e) {
            DynamicIndexAbstractBasicSelfTest.fail((String)("Unexpected exception: " + e));
        }
        DynamicIndexAbstractBasicSelfTest.fail((String)(SchemaOperationException.class.getSimpleName() + " is not thrown."));
    }

    public void testFailOnLocalCache() throws Exception {
        for (Ignite node : Ignition.allGrids()) {
            if (node.configuration().isClientMode().booleanValue()) continue;
            node.getOrCreateCache(this.cacheConfiguration().setCacheMode(CacheMode.LOCAL));
        }
        final QueryIndex idx = DynamicIndexAbstractBasicSelfTest.index("idx_1", DynamicIndexAbstractBasicSelfTest.field("field1"));
        DynamicIndexAbstractBasicSelfTest.assertSchemaException(new AbstractSchemaSelfTest.RunnableX(){

            @Override
            public void run() throws Exception {
                DynamicIndexAbstractBasicSelfTest.this.dynamicIndexCreate("cache", AbstractSchemaSelfTest.TBL_NAME, idx, true);
            }
        }, 1002);
        DynamicIndexAbstractBasicSelfTest.assertNoIndex("cache", TBL_NAME, "idx_1");
        DynamicIndexAbstractBasicSelfTest.assertSchemaException(new AbstractSchemaSelfTest.RunnableX(){

            @Override
            public void run() throws Exception {
                DynamicIndexAbstractBasicSelfTest.this.dynamicIndexDrop("cache", "idx_1", true);
            }
        }, 1002);
    }

    protected IgniteEx node() {
        return this.grid(this.nodeIndex());
    }

    protected abstract int nodeIndex();

    protected List<IgniteConfiguration> configurations() throws Exception {
        return Arrays.asList(this.serverCoordinatorConfiguration(0), this.serverConfiguration(1), this.clientConfiguration(2), this.serverConfiguration(3, true), this.clientConfiguration(4));
    }

    protected IgniteConfiguration serverCoordinatorConfiguration(int idx) throws Exception {
        return this.serverConfiguration(idx);
    }

    private void assertSimpleIndexOperations(String sql) {
        for (Ignite node : Ignition.allGrids()) {
            DynamicIndexAbstractBasicSelfTest.assertSqlSimpleData(node, sql, 60);
        }
        DynamicIndexAbstractBasicSelfTest.put((Ignite)this.node(), 100, 200);
        for (Ignite node : Ignition.allGrids()) {
            DynamicIndexAbstractBasicSelfTest.assertSqlSimpleData(node, sql, 160);
        }
        DynamicIndexAbstractBasicSelfTest.remove((Ignite)this.node(), 0, 100);
        for (Ignite node : Ignition.allGrids()) {
            DynamicIndexAbstractBasicSelfTest.assertSqlSimpleData(node, sql, 100);
        }
        DynamicIndexAbstractBasicSelfTest.remove((Ignite)this.node(), 100, 200);
        for (Ignite node : Ignition.allGrids()) {
            DynamicIndexAbstractBasicSelfTest.assertSqlSimpleData(node, sql, 0);
        }
    }

    private void assertCompositeIndexOperations(String sql) {
        for (Ignite node : Ignition.allGrids()) {
            DynamicIndexAbstractBasicSelfTest.assertSqlCompositeData(node, sql, 20);
        }
        DynamicIndexAbstractBasicSelfTest.put((Ignite)this.node(), 100, 200);
        for (Ignite node : Ignition.allGrids()) {
            DynamicIndexAbstractBasicSelfTest.assertSqlCompositeData(node, sql, 120);
        }
        DynamicIndexAbstractBasicSelfTest.remove((Ignite)this.node(), 0, 100);
        for (Ignite node : Ignition.allGrids()) {
            DynamicIndexAbstractBasicSelfTest.assertSqlCompositeData(node, sql, 100);
        }
        DynamicIndexAbstractBasicSelfTest.remove((Ignite)this.node(), 100, 200);
        for (Ignite node : Ignition.allGrids()) {
            DynamicIndexAbstractBasicSelfTest.assertSqlCompositeData(node, sql, 0);
        }
    }

    protected static void assertSchemaException(AbstractSchemaSelfTest.RunnableX r, int expCode) {
        try {
            r.run();
        }
        catch (CacheException e) {
            Throwable cause = e.getCause();
            DynamicIndexAbstractBasicSelfTest.assertTrue((cause != null ? 1 : 0) != 0);
            DynamicIndexAbstractBasicSelfTest.assertTrue((String)("Unexpected cause: " + cause.getClass().getName()), (boolean)(cause instanceof IgniteSQLException));
            IgniteSQLException cause0 = (IgniteSQLException)cause;
            int code = cause0.statusCode();
            DynamicIndexAbstractBasicSelfTest.assertEquals((String)("Unexpected error code [expected=" + expCode + ", actual=" + code + ", msg=" + cause.getMessage() + ']'), (int)expCode, (int)code);
            return;
        }
        catch (Exception e) {
            DynamicIndexAbstractBasicSelfTest.fail((String)("Unexpected exception: " + e));
        }
        DynamicIndexAbstractBasicSelfTest.fail((String)(IgniteSQLException.class.getSimpleName() + " is not thrown."));
    }

    private void dynamicIndexCreate(String space, String tblName, QueryIndex idx, boolean ifNotExists) throws Exception {
        GridStringBuilder sql = new SB("CREATE INDEX ").a(ifNotExists ? "IF NOT EXISTS " : "").a("\"" + idx.getName() + "\"").a(" ON ").a(tblName).a(" (");
        boolean first = true;
        for (Map.Entry fieldEntry : idx.getFields().entrySet()) {
            if (first) {
                first = false;
            } else {
                sql.a(", ");
            }
            String name = (String)fieldEntry.getKey();
            boolean asc = (Boolean)fieldEntry.getValue();
            sql.a("\"" + name + "\"").a(" ").a(asc ? "ASC" : "DESC");
        }
        sql.a(')');
        this.executeSql(space, sql.toString());
    }

    private void dynamicIndexDrop(String space, String idxName, boolean ifExists) throws Exception {
        String sql = "DROP INDEX " + (ifExists ? "IF EXISTS " : "") + "\"" + idxName + "\"";
        this.executeSql(space, sql);
    }

    private void executeSql(String space, String sql) {
        this.log.info("Executing DDL: " + sql);
        this.node().cache(space).query((Query)new SqlFieldsQuery(sql)).getAll();
    }
}

