/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.QueryIndexDescriptorImpl;
import org.apache.ignite.internal.processors.query.QueryTypeDescriptorImpl;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.Nullable;

public class AbstractSchemaSelfTest
extends GridCommonAbstractTest {
    protected static final String CACHE_NAME = "cache";
    protected static final String TBL_NAME = AbstractSchemaSelfTest.tableName(ValueClass.class);
    protected static final String TBL_NAME_2 = AbstractSchemaSelfTest.tableName(ValueClass2.class);
    protected static final String IDX_NAME_1 = "idx_1";
    protected static final String IDX_NAME_2 = "idx_2";
    protected static final String IDX_NAME_3 = "idx_3";
    protected static final String FIELD_KEY = "id";
    protected static final String FIELD_NAME_1 = "field1";
    protected static final String FIELD_NAME_2 = "field2";
    protected static final String FIELD_NAME_3 = "field3";
    protected static final String FIELD_KEY_ALIAS = "key";

    protected static QueryTypeDescriptorImpl typeExisting(IgniteEx node, String cacheName, String tblName) {
        QueryTypeDescriptorImpl res = AbstractSchemaSelfTest.type(node, cacheName, tblName);
        AbstractSchemaSelfTest.assertNotNull((Object)res);
        return res;
    }

    @Nullable
    protected static QueryTypeDescriptorImpl type(IgniteEx node, String cacheName, String tblName) {
        return AbstractSchemaSelfTest.types(node, cacheName).get(tblName);
    }

    protected static Map<String, QueryTypeDescriptorImpl> types(IgniteEx node, String cacheName) {
        HashMap<String, QueryTypeDescriptorImpl> res = new HashMap<String, QueryTypeDescriptorImpl>();
        Collection descs = node.context().query().types(cacheName);
        for (GridQueryTypeDescriptor desc : descs) {
            QueryTypeDescriptorImpl desc0 = (QueryTypeDescriptorImpl)desc;
            res.put(desc0.tableName(), desc0);
        }
        return res;
    }

    protected static void assertIndex(String cacheName, String tblName, String idxName, IgniteBiTuple<String, Boolean> ... fields) {
        AbstractSchemaSelfTest.assertIndex(cacheName, false, tblName, idxName, fields);
    }

    protected static void assertIndex(String cacheName, boolean checkNonAffinityNodes, String tblName, String idxName, IgniteBiTuple<String, Boolean> ... fields) {
        for (Ignite node : Ignition.allGrids()) {
            AbstractSchemaSelfTest.assertIndex(node, checkNonAffinityNodes, cacheName, tblName, idxName, fields);
        }
    }

    protected static void assertIndex(Ignite node, boolean checkNonAffinityNode, String cacheName, String tblName, String idxName, IgniteBiTuple<String, Boolean> ... fields) {
        IgniteEx node0 = (IgniteEx)node;
        AbstractSchemaSelfTest.assertIndexDescriptor(node0, cacheName, tblName, idxName, fields);
        if (checkNonAffinityNode || AbstractSchemaSelfTest.affinityNode(node0, cacheName)) {
            QueryTypeDescriptorImpl typeDesc = AbstractSchemaSelfTest.typeExisting(node0, cacheName, tblName);
            AbstractSchemaSelfTest.assertIndex(typeDesc, idxName, fields);
        }
    }

    protected static void assertIndexDescriptor(IgniteEx node, String cacheName, String tblName, String idxName, IgniteBiTuple<String, Boolean> ... fields) {
        AbstractSchemaSelfTest.awaitCompletion();
        DynamicCacheDescriptor desc = node.context().cache().cacheDescriptor(cacheName);
        assert (desc != null);
        for (QueryEntity entity : desc.schema().entities()) {
            if (!F.eq((Object)tblName, (Object)QueryUtils.tableName((QueryEntity)entity))) continue;
            for (QueryIndex idx : entity.getIndexes()) {
                if (!F.eq((Object)QueryUtils.indexName((QueryEntity)entity, (QueryIndex)idx), (Object)idxName)) continue;
                LinkedHashMap idxFields = idx.getFields();
                AbstractSchemaSelfTest.assertEquals((int)idxFields.size(), (int)fields.length);
                int i = 0;
                for (String idxField : idxFields.keySet()) {
                    AbstractSchemaSelfTest.assertEquals((String)idxField, (String)((String)fields[i].get1()));
                    AbstractSchemaSelfTest.assertEquals(idxFields.get(idxField), (Object)fields[i].get2());
                    ++i;
                }
                return;
            }
        }
        AbstractSchemaSelfTest.fail((String)("Index not found [node=" + node.name() + ", cacheName=" + cacheName + ", tlbName=" + tblName + ", idxName=" + idxName + ']'));
    }

    protected static void assertIndex(QueryTypeDescriptorImpl typeDesc, String idxName, IgniteBiTuple<String, Boolean> ... fields) {
        QueryIndexDescriptorImpl idxDesc = typeDesc.index(idxName);
        AbstractSchemaSelfTest.assertNotNull((Object)idxDesc);
        AbstractSchemaSelfTest.assertEquals((String)idxName, (String)idxDesc.name());
        AbstractSchemaSelfTest.assertEquals((Object)typeDesc, (Object)idxDesc.typeDescriptor());
        AbstractSchemaSelfTest.assertEquals((Object)QueryIndexType.SORTED, (Object)idxDesc.type());
        ArrayList fieldNames = new ArrayList(idxDesc.fields());
        AbstractSchemaSelfTest.assertEquals((int)fields.length, (int)fieldNames.size());
        for (int i = 0; i < fields.length; ++i) {
            String expFieldName = (String)fields[i].get1();
            boolean expFieldAsc = (Boolean)fields[i].get2();
            AbstractSchemaSelfTest.assertEquals((String)("Index field mismatch [pos=" + i + ", expField=" + expFieldName + ", actualField=" + (String)fieldNames.get(i) + ']'), (String)expFieldName, (String)((String)fieldNames.get(i)));
            boolean fieldAsc = !idxDesc.descending(expFieldName);
            AbstractSchemaSelfTest.assertEquals((String)("Index field sort mismatch [pos=" + i + ", field=" + expFieldName + ", expAsc=" + expFieldAsc + ", actualAsc=" + fieldAsc + ']'), (boolean)expFieldAsc, (boolean)fieldAsc);
        }
    }

    protected static void assertNoIndex(String cacheName, String tblName, String idxName) {
        for (Ignite node : Ignition.allGrids()) {
            AbstractSchemaSelfTest.assertNoIndex((Ignite)((IgniteEx)node), cacheName, tblName, idxName);
        }
    }

    protected static void assertNoIndex(Ignite node, String cacheName, String tblName, String idxName) {
        IgniteEx node0 = (IgniteEx)node;
        AbstractSchemaSelfTest.assertNoIndexDescriptor(node0, cacheName, idxName);
        if (AbstractSchemaSelfTest.affinityNode(node0, cacheName)) {
            QueryTypeDescriptorImpl typeDesc = AbstractSchemaSelfTest.typeExisting(node0, cacheName, tblName);
            AbstractSchemaSelfTest.assertNoIndex(typeDesc, idxName);
        }
    }

    protected static void assertNoIndexDescriptor(IgniteEx node, String cacheName, String idxName) {
        AbstractSchemaSelfTest.awaitCompletion();
        DynamicCacheDescriptor desc = node.context().cache().cacheDescriptor(cacheName);
        if (desc == null) {
            return;
        }
        for (QueryEntity entity : desc.schema().entities()) {
            for (QueryIndex idx : entity.getIndexes()) {
                if (!F.eq((Object)idxName, (Object)QueryUtils.indexName((QueryEntity)entity, (QueryIndex)idx))) continue;
                AbstractSchemaSelfTest.fail((String)("Index exists: " + idxName));
            }
        }
    }

    private static void awaitCompletion() {
        try {
            U.sleep((long)100L);
        }
        catch (IgniteInterruptedCheckedException e) {
            AbstractSchemaSelfTest.fail();
        }
    }

    protected static void assertNoIndex(QueryTypeDescriptorImpl typeDesc, String idxName) {
        AbstractSchemaSelfTest.assertNull((Object)typeDesc.index(idxName));
    }

    private static boolean affinityNode(IgniteEx node, String cacheName) {
        if (node.configuration().isClientMode().booleanValue()) {
            return false;
        }
        DynamicCacheDescriptor cacheDesc = node.context().cache().cacheDescriptor(cacheName);
        IgnitePredicate filter = cacheDesc.cacheConfiguration().getNodeFilter();
        return filter == null || filter.apply((Object)node.localNode());
    }

    protected static String tableName(Class cls) {
        return cls.getSimpleName();
    }

    protected static QueryIndex index(String name, IgniteBiTuple<String, Boolean> ... fields) {
        QueryIndex idx = new QueryIndex();
        idx.setName(name);
        LinkedHashMap<Object, Object> fields0 = new LinkedHashMap<Object, Object>();
        for (IgniteBiTuple<String, Boolean> field : fields) {
            fields0.put(field.getKey(), field.getValue());
        }
        idx.setFields(fields0);
        return idx;
    }

    protected static GridQueryProcessor queryProcessor(Ignite node) {
        return ((IgniteEx)node).context().query();
    }

    protected static IgniteBiTuple<String, Boolean> field(String name) {
        return AbstractSchemaSelfTest.field(name, true);
    }

    protected static IgniteBiTuple<String, Boolean> field(String name, boolean asc) {
        return F.t((Object)name, (Object)asc);
    }

    protected static String alias(String fieldName) {
        return fieldName + "_alias";
    }

    protected static interface RunnableX {
        public void run() throws Exception;
    }

    public static class ValueClass2 {
        @QuerySqlField(name="field1")
        private String field;

        public ValueClass2(String field) {
            this.field = field;
        }

        public String field() {
            return this.field;
        }
    }

    public static class ValueClass {
        @QuerySqlField
        private String field1;

        public ValueClass(String field1) {
            this.field1 = field1;
        }

        public String field1() {
            return this.field1;
        }
    }

    public static class KeyClass {
        @QuerySqlField
        private long id;

        public KeyClass(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyClass keyClass = (KeyClass)o;
            return this.id == keyClass.id;
        }

        public int hashCode() {
            return (int)(this.id ^ this.id >>> 32);
        }
    }
}

