/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import javax.cache.CacheException;
import junit.framework.TestCase;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityKey;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.MemoryConfiguration;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.GridRandom;
import org.apache.ignite.internal.util.typedef.CAX;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class IgniteCacheQueryNodeRestartSelfTest2
extends GridCommonAbstractTest {
    private static final String PARTITIONED_QRY = "select co.id, count(*) cnt\nfrom \"pe\".Person pe, \"pr\".Product pr, \"co\".Company co, \"pu\".Purchase pu\nwhere pe.id = pu.personId and pu.productId = pr.id and pr.companyId = co.id \ngroup by co.id order by cnt desc, co.id";
    private static final String REPLICATED_QRY = "select pr.id, co.id\nfrom \"pr\".Product pr, \"co\".Company co\nwhere pr.companyId = co.id\norder by co.id, pr.id ";
    private static final int GRID_CNT = 6;
    private static final int PERS_CNT = 600;
    private static final int PURCHASE_CNT = 6000;
    private static final int COMPANY_CNT = 25;
    private static final int PRODUCT_CNT = 100;
    private static TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        CacheConfiguration cc;
        IgniteConfiguration c = super.getConfiguration(igniteInstanceName);
        MemoryConfiguration memCfg = new MemoryConfiguration().setDefaultMemoryPolicySize(0x3200000L);
        c.setMemoryConfiguration(memCfg);
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        disco.setIpFinder(ipFinder);
        c.setDiscoverySpi((DiscoverySpi)disco);
        int i = 0;
        CacheConfiguration[] ccs = new CacheConfiguration[4];
        for (String name : F.asList((Object[])new String[]{"pe", "pu"})) {
            cc = IgniteCacheQueryNodeRestartSelfTest2.defaultCacheConfiguration();
            cc.setName(name);
            cc.setCacheMode(CacheMode.PARTITIONED);
            cc.setBackups(2);
            cc.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
            cc.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
            cc.setRebalanceMode(CacheRebalanceMode.SYNC);
            cc.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 60));
            if (name.equals("pe")) {
                cc.setIndexedTypes(new Class[]{Integer.class, Person.class});
            } else if (name.equals("pu")) {
                cc.setIndexedTypes(new Class[]{AffinityKey.class, Purchase.class});
            }
            ccs[i++] = cc;
        }
        for (String name : F.asList((Object[])new String[]{"co", "pr"})) {
            cc = IgniteCacheQueryNodeRestartSelfTest2.defaultCacheConfiguration();
            cc.setName(name);
            cc.setCacheMode(CacheMode.REPLICATED);
            cc.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
            cc.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
            cc.setRebalanceMode(CacheRebalanceMode.SYNC);
            cc.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 50));
            if (name.equals("co")) {
                cc.setIndexedTypes(new Class[]{Integer.class, Company.class});
            } else if (name.equals("pr")) {
                cc.setIndexedTypes(new Class[]{Integer.class, Product.class});
            }
            ccs[i++] = cc;
        }
        c.setCacheConfiguration(ccs);
        return c;
    }

    private void fillCaches() {
        IgniteCache co = this.grid(0).cache("co");
        for (int i = 0; i < 25; ++i) {
            co.put((Object)i, (Object)new Company(i));
        }
        IgniteCache pr = this.grid(0).cache("pr");
        GridRandom rnd = new GridRandom();
        for (int i = 0; i < 100; ++i) {
            pr.put((Object)i, (Object)new Product(i, rnd.nextInt(25)));
        }
        IgniteCache pe = this.grid(0).cache("pe");
        for (int i = 0; i < 600; ++i) {
            pe.put((Object)i, (Object)new Person(i));
        }
        IgniteCache pu = this.grid(0).cache("pu");
        for (int i = 0; i < 6000; ++i) {
            int persId = rnd.nextInt(600);
            int prodId = rnd.nextInt(100);
            pu.put((Object)new AffinityKey((Object)i, (Object)persId), (Object)new Purchase(persId, prodId));
        }
    }

    public void testRestarts() throws Exception {
        int duration = 90000;
        int qryThreadNum = 4;
        int restartThreadsNum = 2;
        int nodeLifeTime = 2000;
        int logFreq = 10;
        this.startGridsMultiThreaded(6);
        final AtomicIntegerArray locks = new AtomicIntegerArray(6);
        this.fillCaches();
        final List pRes = this.grid(0).cache("pu").query((Query)new SqlFieldsQuery(PARTITIONED_QRY)).getAll();
        Thread.sleep(3000L);
        IgniteCacheQueryNodeRestartSelfTest2.assertEquals((Object)pRes, (Object)this.grid(0).cache("pu").query((Query)new SqlFieldsQuery(PARTITIONED_QRY)).getAll());
        final List rRes = this.grid(0).cache("co").query((Query)new SqlFieldsQuery(REPLICATED_QRY)).getAll();
        IgniteCacheQueryNodeRestartSelfTest2.assertFalse((boolean)pRes.isEmpty());
        IgniteCacheQueryNodeRestartSelfTest2.assertFalse((boolean)rRes.isEmpty());
        final AtomicInteger qryCnt = new AtomicInteger();
        final AtomicBoolean qrysDone = new AtomicBoolean();
        IgniteInternalFuture fut1 = this.multithreadedAsync((Runnable)new CAX(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void applyx() throws IgniteCheckedException {
                GridRandom rnd = new GridRandom();
                while (!qrysDone.get()) {
                    IgniteCache cache;
                    int g;
                    while (!locks.compareAndSet(g = rnd.nextInt(locks.length()), 0, 1)) {
                    }
                    if (rnd.nextBoolean()) {
                        cache = IgniteCacheQueryNodeRestartSelfTest2.this.grid(g).cache("pu");
                        SqlFieldsQuery qry = new SqlFieldsQuery(IgniteCacheQueryNodeRestartSelfTest2.PARTITIONED_QRY);
                        boolean smallPageSize = rnd.nextBoolean();
                        if (smallPageSize) {
                            qry.setPageSize(3);
                        }
                        try {
                            TestCase.assertEquals((Object)pRes, (Object)cache.query((Query)qry).getAll());
                        }
                        catch (CacheException e) {
                            if (e.getCause() instanceof IgniteInterruptedCheckedException) {
                                locks.set(g, 0);
                                int c = qryCnt.incrementAndGet();
                                if (c % 10 != 0) continue;
                                IgniteCacheQueryNodeRestartSelfTest2.this.info("Executed queries: " + c);
                                continue;
                            }
                            if (e.getCause() instanceof QueryCancelledException) {
                                TestCase.fail((String)"Retry is expected");
                            }
                            if (!smallPageSize) {
                                e.printStackTrace();
                            }
                            TestCase.assertTrue((String)"On large page size must retry.", (boolean)smallPageSize);
                            boolean failedOnRemoteFetch = false;
                            boolean failedOnInterruption = false;
                            for (Throwable th = e; th != null; th = th.getCause()) {
                                if (th instanceof InterruptedException) {
                                    failedOnInterruption = true;
                                    break;
                                }
                                if (!(th instanceof CacheException) || th.getMessage() == null || !th.getMessage().startsWith("Failed to fetch data from node:")) continue;
                                failedOnRemoteFetch = true;
                                break;
                            }
                            if (failedOnInterruption || failedOnRemoteFetch) continue;
                            e.printStackTrace();
                            TestCase.fail((String)"Must fail inside of GridResultPage.fetchNextPage or subclass.");
                        }
                        continue;
                    }
                    cache = IgniteCacheQueryNodeRestartSelfTest2.this.grid(g).cache("co");
                    TestCase.assertEquals((Object)rRes, (Object)cache.query((Query)new SqlFieldsQuery(IgniteCacheQueryNodeRestartSelfTest2.REPLICATED_QRY)).getAll());
                }
            }
        }, qryThreadNum, "query-thread");
        final AtomicInteger restartCnt = new AtomicInteger();
        final AtomicBoolean restartsDone = new AtomicBoolean();
        IgniteInternalFuture fut2 = this.multithreadedAsync(new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                GridRandom rnd = new GridRandom();
                while (!restartsDone.get()) {
                    int g;
                    while (!locks.compareAndSet(g = rnd.nextInt(locks.length()), 0, -1)) {
                    }
                    try {
                        IgniteCacheQueryNodeRestartSelfTest2.this.log.info("Stop node: " + g);
                        IgniteCacheQueryNodeRestartSelfTest2.this.stopGrid(g);
                        Thread.sleep(rnd.nextInt(2000));
                        IgniteCacheQueryNodeRestartSelfTest2.this.log.info("Start node: " + g);
                        IgniteCacheQueryNodeRestartSelfTest2.this.startGrid(g);
                        Thread.sleep(rnd.nextInt(2000));
                    }
                    finally {
                        locks.set(g, 0);
                        int c = restartCnt.incrementAndGet();
                        if (c % 10 != 0) continue;
                        IgniteCacheQueryNodeRestartSelfTest2.this.info("Node restarts: " + c);
                    }
                }
                return true;
            }
        }, restartThreadsNum, "restart-thread");
        Thread.sleep(duration);
        this.info("Stopping..");
        restartsDone.set(true);
        fut2.get();
        this.info("Restarts stopped.");
        qrysDone.set(true);
        try {
            fut1.get(5000L);
        }
        catch (IgniteFutureTimeoutCheckedException ignored) {
            fut1.cancel();
        }
        this.info("Queries stopped.");
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
    }

    private static class Product
    implements Serializable {
        @QuerySqlField(index=true)
        int id;
        @QuerySqlField(index=true)
        int companyId;

        Product(int id, int companyId) {
            this.id = id;
            this.companyId = companyId;
        }
    }

    private static class Company
    implements Serializable {
        @QuerySqlField(index=true)
        int id;

        Company(int id) {
            this.id = id;
        }
    }

    private static class Purchase
    implements Serializable {
        @QuerySqlField(index=true)
        int personId;
        @QuerySqlField(index=true)
        int productId;

        Purchase(int personId, int productId) {
            this.personId = personId;
            this.productId = productId;
        }
    }

    private static class Person
    implements Serializable {
        @QuerySqlField(index=true)
        int id;

        Person(int id) {
            this.id = id;
        }
    }
}

