/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class IgniteCacheQueryNoRebalanceSelfTest
extends GridCommonAbstractTest {
    private static TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);

    public IgniteCacheQueryNoRebalanceSelfTest() {
        super(true);
    }

    protected IgniteConfiguration getConfiguration() throws Exception {
        IgniteConfiguration cfg = super.getConfiguration();
        ((TcpDiscoverySpi)cfg.getDiscoverySpi()).setIpFinder(ipFinder);
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setBackups(0);
        ccfg.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        ccfg.setRebalanceMode(CacheRebalanceMode.NONE);
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        super.afterTestsStopped();
    }

    public void testQueryNoRebalance() {
        IgniteCache cache = this.grid().cache("default");
        cache.put((Object)1, (Object)1);
        QueryCursor qry = cache.query((Query)new SqlQuery(Integer.class, "_key >= 0"));
        IgniteCacheQueryNoRebalanceSelfTest.assertEquals((String)"Bad results count", (int)1, (int)qry.getAll().size());
    }
}

