/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.io.Serializable;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.GridRandom;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class IgniteCacheQueryAbstractDistributedJoinSelfTest
extends GridCommonAbstractTest {
    protected static final String QRY_0 = "select co._key, count(*) cnt\nfrom \"pe\".Person pe, \"pr\".Product pr, \"co\".Company co, \"pu\".Purchase pu\nwhere pe._key = pu.personId and pu.productId = pr._key and pr.companyId = co._key \ngroup by co._key order by cnt desc, co._key";
    protected static final String QRY_0_BROADCAST = "select co._key, count(*) cnt\nfrom \"co\".Company co, \"pr\".Product pr, \"pu\".Purchase pu, \"pe\".Person pe \nwhere pe._key = pu.personId and pu.productId = pr._key and pr.companyId = co._key \ngroup by co._key order by cnt desc, co._key";
    protected static final String QRY_1 = "select pr._key, co._key\nfrom \"pr\".Product pr, \"co\".Company co\nwhere pr.companyId = co._key\norder by co._key, pr._key ";
    protected static final String QRY_1_BROADCAST = "select pr._key, co._key\nfrom \"co\".Company co, \"pr\".Product pr \nwhere pr.companyId = co._key\norder by co._key, pr._key ";
    protected static final int GRID_CNT = 2;
    private static final int PERS_CNT = 600;
    private static final int PURCHASE_CNT = 6000;
    private static final int COMPANY_CNT = 25;
    private static final int PRODUCT_CNT = 100;
    private static TcpDiscoveryIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(igniteInstanceName);
        if ("client".equals(igniteInstanceName)) {
            c.setClientMode(true);
        }
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        disco.setIpFinder(IP_FINDER);
        c.setDiscoverySpi((DiscoverySpi)disco);
        int i = 0;
        CacheConfiguration[] ccs = new CacheConfiguration[4];
        for (String name : F.asList((Object[])new String[]{"pe", "pu", "co", "pr"})) {
            CacheConfiguration cc = IgniteCacheQueryAbstractDistributedJoinSelfTest.defaultCacheConfiguration();
            cc.setName(name);
            cc.setCacheMode(CacheMode.PARTITIONED);
            cc.setBackups(2);
            cc.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
            cc.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
            cc.setRebalanceMode(CacheRebalanceMode.SYNC);
            cc.setLongQueryWarningTimeout(15000L);
            cc.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 60));
            switch (name) {
                case "pe": {
                    cc.setIndexedTypes(new Class[]{Integer.class, Person.class});
                    break;
                }
                case "pu": {
                    cc.setIndexedTypes(new Class[]{Integer.class, Purchase.class});
                    break;
                }
                case "co": {
                    cc.setIndexedTypes(new Class[]{Integer.class, Company.class});
                    break;
                }
                case "pr": {
                    cc.setIndexedTypes(new Class[]{Integer.class, Product.class});
                }
            }
            ccs[i++] = cc;
        }
        c.setCacheConfiguration(ccs);
        return c;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(2);
        this.fillCaches();
    }

    private void fillCaches() {
        IgniteCache co = this.grid(0).cache("co");
        for (int i = 0; i < 25; ++i) {
            co.put((Object)i, (Object)new Company(i));
        }
        IgniteCache pr = this.grid(0).cache("pr");
        GridRandom rnd = new GridRandom();
        for (int i = 0; i < 100; ++i) {
            pr.put((Object)i, (Object)new Product(i, rnd.nextInt(25)));
        }
        IgniteCache pe = this.grid(0).cache("pe");
        for (int i = 0; i < 600; ++i) {
            pe.put((Object)i, (Object)new Person(i));
        }
        IgniteCache pu = this.grid(0).cache("pu");
        for (int i = 0; i < 6000; ++i) {
            int persId = rnd.nextInt(600);
            int prodId = rnd.nextInt(100);
            pu.put((Object)i, (Object)new Purchase(persId, prodId));
        }
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
    }

    public static class Functions {
        @QuerySqlFunction
        public static int sleep() {
            try {
                U.sleep((long)1000L);
            }
            catch (IgniteInterruptedCheckedException igniteInterruptedCheckedException) {
                // empty catch block
            }
            return 0;
        }
    }

    protected static class Product
    implements Serializable {
        @QuerySqlField(index=true)
        int id;
        @QuerySqlField(index=true)
        int companyId;

        Product(int id, int companyId) {
            this.id = id;
            this.companyId = companyId;
        }
    }

    protected static class Company
    implements Serializable {
        @QuerySqlField(index=true)
        int id;

        Company(int id) {
            this.id = id;
        }
    }

    protected static class Purchase
    implements Serializable {
        @QuerySqlField(index=true)
        int personId;
        @QuerySqlField(index=true)
        int productId;

        Purchase(int personId, int productId) {
            this.personId = personId;
            this.productId = productId;
        }
    }

    protected static class Person
    implements Serializable {
        @QuerySqlField(index=true)
        int id;

        Person(int id) {
            this.id = id;
        }
    }
}

