/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.processors.cache.IgniteCacheAbstractFieldsQuerySelfTest;

public class IgniteCachePartitionedFieldsQuerySelfTest
extends IgniteCacheAbstractFieldsQuerySelfTest {
    @Override
    protected CacheMode cacheMode() {
        return CacheMode.PARTITIONED;
    }

    protected NearCacheConfiguration nearConfiguration() {
        return new NearCacheConfiguration();
    }

    @Override
    protected int gridCount() {
        return 3;
    }

    @Override
    protected CacheConfiguration cacheConfiguration() {
        CacheConfiguration cc = super.cacheConfiguration();
        cc.setNearConfiguration(this.nearConfiguration());
        return cc;
    }

    public void testLocalQuery() throws Exception {
        IgniteCache<Integer, Integer> cache = this.jcache(Integer.class, Integer.class);
        this.awaitPartitionMapExchange(true, true, null);
        int exp = 0;
        for (Cache.Entry e : cache.localEntries(new CachePeekMode[]{CachePeekMode.PRIMARY})) {
            if (!(e.getValue() instanceof Integer)) continue;
            ++exp;
        }
        QueryCursor qry = cache.query((Query)new SqlFieldsQuery("select _key, _val from Integer").setLocal(true));
        IgniteCachePartitionedFieldsQuerySelfTest.assertEquals((int)exp, (int)qry.getAll().size());
    }
}

