/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.GridProcessor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class IgniteCacheDistributedQueryStopOnCancelOrTimeoutSelfTest
extends GridCommonAbstractTest {
    private static final int GRIDS_CNT = 3;
    private static final TcpDiscoveryVmIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);
    public static final int CACHE_SIZE = 10000;
    public static final int VAL_SIZE = 16;
    private static final String QRY_1 = "select a._val, b._val from String a, String b";
    private static final String QRY_2 = "select a._key, count(*) from String a group by a._key";
    private static final String QRY_3 = "select a._val from String a";

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(3);
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        TcpDiscoverySpi spi = (TcpDiscoverySpi)cfg.getDiscoverySpi();
        spi.setIpFinder((TcpDiscoveryIpFinder)IP_FINDER);
        CacheConfiguration ccfg = new CacheConfiguration("default");
        ccfg.setIndexedTypes(new Class[]{Integer.class, String.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        if ("client".equals(igniteInstanceName)) {
            cfg.setClientMode(true);
        }
        return cfg;
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        for (Ignite g : G.allGrids()) {
            g.cache("default").removeAll();
        }
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        super.afterTestsStopped();
    }

    public void testRemoteQueryExecutionTimeout() throws Exception {
        this.testQueryCancel(10000, 16, QRY_1, 500, TimeUnit.MILLISECONDS, true);
    }

    public void testRemoteQueryWithMergeTableTimeout() throws Exception {
        this.testQueryCancel(10000, 16, QRY_2, 500, TimeUnit.MILLISECONDS, true);
    }

    public void testRemoteQueryExecutionCancel0() throws Exception {
        this.testQueryCancel(10000, 16, QRY_1, 1, TimeUnit.MILLISECONDS, false);
    }

    public void testRemoteQueryExecutionCancel1() throws Exception {
        this.testQueryCancel(10000, 16, QRY_1, 500, TimeUnit.MILLISECONDS, false);
    }

    public void testRemoteQueryExecutionCancel2() throws Exception {
        this.testQueryCancel(10000, 16, QRY_1, 1, TimeUnit.SECONDS, false);
    }

    public void testRemoteQueryExecutionCancel3() throws Exception {
        this.testQueryCancel(10000, 16, QRY_1, 3, TimeUnit.SECONDS, false);
    }

    public void testRemoteQueryWithMergeTableCancel0() throws Exception {
        this.testQueryCancel(10000, 16, QRY_2, 1, TimeUnit.MILLISECONDS, false);
    }

    public void testRemoteQueryWithMergeTableCancel1() throws Exception {
        this.testQueryCancel(10000, 16, QRY_2, 500, TimeUnit.MILLISECONDS, false);
    }

    public void testRemoteQueryWithMergeTableCancel2() throws Exception {
        this.testQueryCancel(10000, 16, QRY_2, 1500, TimeUnit.MILLISECONDS, false);
    }

    public void testRemoteQueryWithMergeTableCancel3() throws Exception {
        this.testQueryCancel(10000, 16, QRY_2, 3, TimeUnit.SECONDS, false);
    }

    public void testRemoteQueryWithoutMergeTableCancel0() throws Exception {
        this.testQueryCancel(10000, 16, QRY_3, 1, TimeUnit.MILLISECONDS, false);
    }

    public void testRemoteQueryWithoutMergeTableCancel1() throws Exception {
        this.testQueryCancel(10000, 16, QRY_3, 500, TimeUnit.MILLISECONDS, false);
    }

    public void testRemoteQueryWithoutMergeTableCancel2() throws Exception {
        this.testQueryCancel(10000, 16, QRY_3, 1000, TimeUnit.MILLISECONDS, false);
    }

    public void testRemoteQueryWithoutMergeTableCancel3() throws Exception {
        this.testQueryCancel(10000, 16, QRY_3, 3, TimeUnit.SECONDS, false);
    }

    public void testRemoteQueryAlreadyFinishedStop() throws Exception {
        this.testQueryCancel(100, 16, QRY_3, 3, TimeUnit.SECONDS, false);
    }

    private void testQueryCancel(int keyCnt, int valSize, String sql, int timeoutUnits, TimeUnit timeUnit, boolean timeout) throws Exception {
        try (Ignite client = this.startGrid("client");){
            QueryCursor cursor;
            IgniteCache cache = client.cache("default");
            IgniteCacheDistributedQueryStopOnCancelOrTimeoutSelfTest.assertEquals((int)0, (int)cache.localSize(new CachePeekMode[0]));
            int p = 1;
            for (int i = 1; i <= keyCnt; ++i) {
                char[] tmp = new char[valSize];
                Arrays.fill(tmp, ' ');
                cache.put((Object)i, (Object)new String(tmp));
                if (!((float)i / (float)keyCnt >= (float)p / 10.0f)) continue;
                this.log().info("Loaded " + i + " of " + keyCnt);
                ++p;
            }
            IgniteCacheDistributedQueryStopOnCancelOrTimeoutSelfTest.assertEquals((int)0, (int)cache.localSize(new CachePeekMode[0]));
            SqlFieldsQuery qry = new SqlFieldsQuery(sql);
            if (timeout) {
                qry.setTimeout(timeoutUnits, timeUnit);
                cursor = cache.query((Query)qry);
            } else {
                cursor = cache.query((Query)qry);
                client.scheduler().runLocal(new Runnable(){

                    @Override
                    public void run() {
                        cursor.close();
                    }
                }, (long)timeoutUnits, timeUnit);
            }
            try (QueryCursor ignored = cursor;){
                cursor.iterator();
            }
            catch (CacheException ex) {
                this.log().error("Got expected exception", (Throwable)ex);
                IgniteCacheDistributedQueryStopOnCancelOrTimeoutSelfTest.assertTrue((String)"Must throw correct exception", (boolean)(ex.getCause() instanceof QueryCancelledException));
            }
            Thread.sleep(TimeUnit.MILLISECONDS.convert(timeoutUnits, timeUnit) + 3000L);
            this.checkCleanState();
        }
    }

    private void checkCleanState() throws IgniteCheckedException {
        for (int i = 0; i < 3; ++i) {
            IgniteEx grid = this.grid(i);
            ConcurrentMap map = (ConcurrentMap)U.field((Object)((IgniteH2Indexing)U.field((Object)((GridProcessor)U.field((Object)grid.context(), (String)"qryProc")), (String)"idx")).mapQueryExecutor(), (String)"qryRess");
            String msg = "Map executor state is not cleared";
            for (Object result : map.values()) {
                Map m = (Map)U.field(result, (String)"res");
                IgniteCacheDistributedQueryStopOnCancelOrTimeoutSelfTest.assertEquals((String)msg, (int)0, (int)m.size());
            }
        }
    }
}

