/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import javax.cache.Cache;
import javax.cache.CacheException;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityFunctionContext;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.MemoryConfiguration;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.GridRandom;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.util.AttributeNodeFilter;
import org.jsr166.ThreadLocalRandom8;

public abstract class IgniteCacheDistributedPartitionQueryAbstractSelfTest
extends GridCommonAbstractTest {
    private static final String JOIN_QRY = "select cl._KEY, de.depositId, de.regionId from \"cl\".Client cl, \"de\".Deposit de, \"re\".Region re where cl.clientId=de.clientId and de.regionId=re._KEY";
    private static final String REGION_ATTR_NAME = "reg";
    protected static final int GRIDS_COUNT = 10;
    private static final TcpDiscoveryVmIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);
    protected static final int[] PARTS_PER_REGION = new int[]{10, 20, 30, 40, 24};
    protected static final int UNMAPPED_REGION = PARTS_PER_REGION.length;
    protected static final int CLIENTS_PER_PARTITION = 1;
    private static final int TOTAL_CLIENTS;
    private static final AffinityFunction AFFINITY;
    private static final int PARTS_COUNT;
    protected static final NavigableMap<Integer, List<Integer>> REGION_TO_PART_MAP;
    protected static final int QUERY_THREADS_CNT = 4;
    protected static final int RESTART_THREADS_CNT = 2;
    protected static final int NODE_RESTART_TIME = 1000;
    public static final int DEPOSITS_PER_CLIENT = 10;
    protected GridRandom rnd = new GridRandom();

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        MemoryConfiguration memCfg = new MemoryConfiguration().setDefaultMemoryPolicySize(0x1400000L);
        cfg.setMemoryConfiguration(memCfg);
        TcpDiscoverySpi spi = (TcpDiscoverySpi)cfg.getDiscoverySpi();
        spi.setIpFinder((TcpDiscoveryIpFinder)IP_FINDER);
        cfg.setDiscoverySpi((DiscoverySpi)spi);
        CacheConfiguration clientCfg = new CacheConfiguration();
        clientCfg.setName("cl");
        clientCfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        clientCfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        clientCfg.setRebalanceMode(CacheRebalanceMode.SYNC);
        clientCfg.setBackups(2);
        clientCfg.setAffinity(AFFINITY);
        clientCfg.setIndexedTypes(new Class[]{ClientKey.class, Client.class});
        CacheConfiguration depoCfg = new CacheConfiguration();
        depoCfg.setName("de");
        depoCfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        depoCfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        depoCfg.setRebalanceMode(CacheRebalanceMode.SYNC);
        depoCfg.setBackups(2);
        depoCfg.setAffinity(AFFINITY);
        depoCfg.setIndexedTypes(new Class[]{DepositKey.class, Deposit.class});
        CacheConfiguration regionCfg = new CacheConfiguration();
        regionCfg.setName("re");
        regionCfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        regionCfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        regionCfg.setRebalanceMode(CacheRebalanceMode.SYNC);
        regionCfg.setCacheMode(CacheMode.REPLICATED);
        regionCfg.setIndexedTypes(new Class[]{Integer.class, Region.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{clientCfg, depoCfg, regionCfg});
        if ("client".equals(gridName)) {
            cfg.setClientMode(true);
        } else {
            Integer reg = this.regionForGrid(gridName);
            cfg.setUserAttributes(F.asMap((Object)REGION_ATTR_NAME, (Object)reg));
            this.log().info("Assigned region " + reg + " to grid " + gridName);
        }
        return cfg;
    }

    protected Integer regionForGrid(String gridName) {
        char c = gridName.charAt(gridName.length() - 1);
        switch (c) {
            case '0': {
                return 1;
            }
            case '1': 
            case '2': {
                return 2;
            }
            case '3': 
            case '4': 
            case '5': {
                return 3;
            }
        }
        return 4;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        int sum1 = 0;
        for (List range : REGION_TO_PART_MAP.values()) {
            sum1 += ((Integer)range.get(1)).intValue();
        }
        IgniteCacheDistributedPartitionQueryAbstractSelfTest.assertEquals((String)"Illegal partition per region distribution", (int)PARTS_COUNT, (int)sum1);
        this.startGridsMultiThreaded(10);
        this.startGrid("client");
        int clientId = 1;
        int depositId = 1;
        int regionId = 1;
        int p = 1;
        try (IgniteDataStreamer clStr = this.grid(0).dataStreamer("cl");
             IgniteDataStreamer depStr = this.grid(0).dataStreamer("de");){
            for (int cnt : PARTS_PER_REGION) {
                if (regionId < PARTS_PER_REGION.length) {
                    for (int i = 0; i < cnt * 1; ++i) {
                        ClientKey ck = new ClientKey(clientId, regionId);
                        Client cl = new Client();
                        cl.firstName = "First_Name_" + clientId;
                        cl.lastName = "Last_Name_" + clientId;
                        cl.passport = clientId * 1000;
                        clStr.addData((Object)ck, (Object)cl);
                        for (int j = 0; j < 10; ++j) {
                            DepositKey dk = new DepositKey(depositId++, new ClientKey(clientId, regionId));
                            Deposit depo = new Deposit();
                            depo.amount = ThreadLocalRandom8.current().nextLong(1000001L);
                            depStr.addData((Object)dk, (Object)depo);
                        }
                        if ((float)clientId / (float)TOTAL_CLIENTS >= (float)p / 10.0f) {
                            this.log().info("Loaded " + clientId + " of " + TOTAL_CLIENTS);
                            ++p;
                        }
                        ++clientId;
                    }
                }
                Region region = new Region();
                region.name = "Region_" + regionId;
                region.code = regionId * 10;
                this.grid(0).cache("re").put((Object)regionId, (Object)region);
                ++regionId;
            }
        }
    }

    protected void afterTestsStopped() throws Exception {
        super.afterTestsStopped();
        this.stopAllGrids();
    }

    protected void doTestRegionQuery(Ignite orig) {
        IgniteCache cl = orig.cache("cl");
        for (int regionId = 1; regionId <= PARTS_PER_REGION.length; ++regionId) {
            SqlQuery qry1 = new SqlQuery(Client.class, "regionId=?");
            qry1.setArgs(new Object[]{regionId});
            List clients1 = cl.query((Query)qry1).getAll();
            int expRegionCnt = regionId == 5 ? 0 : PARTS_PER_REGION[regionId - 1] * 1;
            IgniteCacheDistributedPartitionQueryAbstractSelfTest.assertEquals((String)("Region " + regionId + " count"), (int)expRegionCnt, (int)clients1.size());
            this.validateClients(regionId, clients1);
            List range = (List)REGION_TO_PART_MAP.get(regionId);
            SqlQuery qry2 = new SqlQuery(Client.class, "1=1");
            qry2.setPartitions(this.createRange((Integer)range.get(0), (Integer)range.get(1)));
            try {
                List clients2 = cl.query((Query)qry2).getAll();
                IgniteCacheDistributedPartitionQueryAbstractSelfTest.assertEquals((String)("Region " + regionId + " count with partition set"), (int)expRegionCnt, (int)clients2.size());
                this.validateClients(regionId, clients2);
                if (regionId != UNMAPPED_REGION) continue;
                IgniteCacheDistributedPartitionQueryAbstractSelfTest.fail();
                continue;
            }
            catch (CacheException ignored) {
                if (regionId == UNMAPPED_REGION) continue;
                IgniteCacheDistributedPartitionQueryAbstractSelfTest.fail();
            }
        }
    }

    protected int[] createRange(int start, int cnt) {
        int[] vals = new int[cnt];
        for (int i = 0; i < cnt; ++i) {
            vals[i] = start + i;
        }
        return vals;
    }

    protected void doTestPartitionsQuery(Ignite orig) {
        IgniteCache cl = orig.cache("cl");
        for (int regionId = 1; regionId <= PARTS_PER_REGION.length; ++regionId) {
            this.log().info("Running test queries for region " + regionId);
            List range = (List)REGION_TO_PART_MAP.get(regionId);
            int[] parts = this.createRange((Integer)range.get(0), (Integer)range.get(1));
            int off = this.rnd.nextInt(parts.length);
            int p1 = parts[off];
            int p2 = parts[(off + (1 + this.rnd.nextInt(parts.length - 1))) % parts.length];
            this.log().info("Parts: " + p1 + " " + p2);
            SqlQuery qry = new SqlQuery(Client.class, "1=1");
            qry.setPartitions(new int[]{p1, p2});
            try {
                List clients = cl.query((Query)qry).getAll();
                for (Cache.Entry client : clients) {
                    int p = orig.affinity("cl").partition(client.getKey());
                    IgniteCacheDistributedPartitionQueryAbstractSelfTest.assertTrue((String)"Incorrect partition for key", (p == p1 || p == p2 ? 1 : 0) != 0);
                }
                if (regionId != UNMAPPED_REGION) continue;
                IgniteCacheDistributedPartitionQueryAbstractSelfTest.fail();
                continue;
            }
            catch (CacheException ignored) {
                if (regionId == UNMAPPED_REGION) continue;
                IgniteCacheDistributedPartitionQueryAbstractSelfTest.fail();
            }
        }
    }

    protected void doTestJoinQuery(Ignite orig, int ... regionIds) {
        IgniteCache cl = orig.cache("cl");
        if (regionIds == null) {
            regionIds = new int[PARTS_PER_REGION.length];
            for (int i = 0; i < regionIds.length; ++i) {
                regionIds[i] = i + 1;
            }
        }
        for (int regionId : regionIds) {
            List range = (List)REGION_TO_PART_MAP.get(regionId);
            SqlFieldsQuery qry = new SqlFieldsQuery(JOIN_QRY);
            int[] pSet = this.createRange((Integer)range.get(0), 1 + this.rnd.nextInt((Integer)range.get(1) - 1));
            qry.setPartitions(pSet);
            try {
                List rows = cl.query((Query)qry).getAll();
                for (List row : rows) {
                    ClientKey key = (ClientKey)row.get(0);
                    int p = orig.affinity("cl").partition((Object)key);
                    IgniteCacheDistributedPartitionQueryAbstractSelfTest.assertTrue((Arrays.binarySearch(pSet, p) >= 0 ? 1 : 0) != 0);
                }
                for (List row : rows) {
                    IgniteCacheDistributedPartitionQueryAbstractSelfTest.assertEquals((String)"Region id", (int)regionId, (int)((Integer)row.get(2)));
                }
                if (regionId != UNMAPPED_REGION) continue;
                IgniteCacheDistributedPartitionQueryAbstractSelfTest.fail();
            }
            catch (CacheException ignored) {
                if (X.hasCause((Throwable)ignored, (Class[])new Class[]{InterruptedException.class, IgniteInterruptedCheckedException.class})) {
                    return;
                }
                if (regionId == UNMAPPED_REGION) continue;
                IgniteCacheDistributedPartitionQueryAbstractSelfTest.fail();
            }
        }
    }

    protected void validateClients(int regionId, List<Cache.Entry<ClientKey, Client>> clients) {
        for (Cache.Entry<ClientKey, Client> entry : clients) {
            List range = (List)REGION_TO_PART_MAP.get(regionId);
            int start = (Integer)range.get(0) * 1;
            int end = start + (Integer)range.get(1) * 1;
            int clientId = ((ClientKey)entry.getKey()).clientId;
            IgniteCacheDistributedPartitionQueryAbstractSelfTest.assertTrue((String)"Client id in range", (start < clientId && start <= end ? 1 : 0) != 0);
        }
    }

    static {
        AFFINITY = new RegionAwareAffinityFunction();
        REGION_TO_PART_MAP = new TreeMap<Integer, List<Integer>>();
        int total = 0;
        int parts = 0;
        int p = 0;
        int regionId = 1;
        for (int regCnt : PARTS_PER_REGION) {
            total += regCnt * 1;
            parts += regCnt;
            REGION_TO_PART_MAP.put(regionId++, Arrays.asList(p, regCnt));
            p += regCnt;
        }
        TOTAL_CLIENTS = total - PARTS_PER_REGION[PARTS_PER_REGION.length - 1] * 1;
        PARTS_COUNT = parts;
    }

    protected static class Region {
        @QuerySqlField
        protected String name;
        @QuerySqlField
        protected int code;

        protected Region() {
        }
    }

    protected static class Deposit {
        @QuerySqlField
        protected long amount;

        protected Deposit() {
        }
    }

    protected static class Client {
        @QuerySqlField
        protected String firstName;
        @QuerySqlField
        protected String lastName;
        @QuerySqlField(index=true)
        protected int passport;

        protected Client() {
        }
    }

    protected static class RegionKey
    implements Serializable {
        @QuerySqlField(index=true)
        protected int regionId;

        protected RegionKey() {
        }
    }

    protected static class DepositKey
    extends RegionKey {
        @QuerySqlField(index=true)
        protected int depositId;
        @QuerySqlField(index=true)
        protected int clientId;
        @AffinityKeyMapped
        protected ClientKey clientKey;

        public DepositKey(int depositId, ClientKey clientKey) {
            this.depositId = depositId;
            this.clientId = clientKey.clientId;
            this.regionId = clientKey.regionId;
            this.clientKey = clientKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DepositKey that = (DepositKey)o;
            return this.depositId == that.depositId;
        }

        public int hashCode() {
            return this.depositId;
        }
    }

    protected static class ClientKey
    extends RegionKey {
        @QuerySqlField(index=true)
        protected int clientId;

        public ClientKey(int clientId, int regionId) {
            this.clientId = clientId;
            this.regionId = regionId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientKey clientKey = (ClientKey)o;
            return this.clientId == clientKey.clientId;
        }

        public int hashCode() {
            return this.clientId;
        }
    }

    private static final class RegionAwareAffinityFunction
    implements AffinityFunction {
        private RegionAwareAffinityFunction() {
        }

        public void reset() {
        }

        public int partitions() {
            return PARTS_COUNT;
        }

        public int partition(Object key) {
            Integer regionId;
            if (key instanceof RegionKey) {
                regionId = ((RegionKey)key).regionId;
            } else if (key instanceof BinaryObject) {
                BinaryObject bo = (BinaryObject)key;
                regionId = (Integer)bo.field("regionId");
            } else {
                throw new IgniteException("Unsupported key for region aware affinity");
            }
            List range = (List)REGION_TO_PART_MAP.get(regionId);
            Integer cnt = (Integer)range.get(1);
            return U.safeAbs((int)(key.hashCode() % cnt)) + (Integer)range.get(0);
        }

        public List<List<ClusterNode>> assignPartitions(AffinityFunctionContext affCtx) {
            List nodes = affCtx.currentTopologySnapshot();
            ArrayList<List<ClusterNode>> assignment = new ArrayList<List<ClusterNode>>(PARTS_COUNT);
            int p = 0;
            while (p < PARTS_COUNT) {
                int regionId = this.regionForPart(p);
                AttributeNodeFilter f = new AttributeNodeFilter(IgniteCacheDistributedPartitionQueryAbstractSelfTest.REGION_ATTR_NAME, (Object)regionId);
                ArrayList<ClusterNode> regionNodes = new ArrayList<ClusterNode>();
                for (ClusterNode node : nodes) {
                    if (!f.apply(node)) continue;
                    regionNodes.add(node);
                }
                final int cp = p++;
                Collections.sort(regionNodes, new Comparator<ClusterNode>(){

                    @Override
                    public int compare(ClusterNode o1, ClusterNode o2) {
                        return Long.compare(RegionAwareAffinityFunction.this.hash(cp, o1), RegionAwareAffinityFunction.this.hash(cp, o2));
                    }
                });
                assignment.add(regionNodes);
            }
            return assignment;
        }

        public void removeNode(UUID nodeId) {
        }

        protected int regionForPart(int part) {
            for (Map.Entry entry : REGION_TO_PART_MAP.entrySet()) {
                List range = (List)entry.getValue();
                if ((Integer)range.get(0) > part || part >= (Integer)range.get(0) + (Integer)range.get(1)) continue;
                return (Integer)entry.getKey();
            }
            throw new IgniteException("Failed to find zone for partition");
        }

        private long hash(int part, Object obj) {
            long x = (long)part << 32 | (long)obj.hashCode();
            x ^= x >>> 12;
            x ^= x << 25;
            x ^= x >>> 27;
            return x * 2685821657736338717L;
        }
    }
}

