/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import javax.cache.CacheException;
import junit.framework.TestCase;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheRebalanceMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityKey;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.util.GridRandom;
import org.apache.ignite.internal.util.typedef.CAX;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class IgniteCacheClientQueryReplicatedNodeRestartSelfTest
extends GridCommonAbstractTest {
    private static final String QRY = "select co.id, count(*) cnt\nfrom \"pe\".Person pe, \"pr\".Product pr, \"co\".Company co, \"pu\".Purchase pu\nwhere pe.id = pu.personId and pu.productId = pr.id and pr.companyId = co.id \ngroup by co.id order by cnt desc, co.id";
    private static final P1<ClusterNode> DATA_NODES_FILTER = new P1<ClusterNode>(){

        public boolean apply(ClusterNode clusterNode) {
            String igniteInstanceName = (String)clusterNode.attribute("org.apache.ignite.ignite.name");
            return !igniteInstanceName.endsWith(String.valueOf(4));
        }
    };
    private static final List<List<?>> FAKE = new LinkedList();
    private static final int GRID_CNT = 5;
    private static final int PERS_CNT = 600;
    private static final int PURCHASE_CNT = 6000;
    private static final int COMPANY_CNT = 25;
    private static final int PRODUCT_CNT = 100;
    private static TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        X.println((String)("Ignite instance name: " + igniteInstanceName), (Object[])new Object[0]);
        IgniteConfiguration c = super.getConfiguration(igniteInstanceName);
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        disco.setIpFinder(ipFinder);
        c.setDiscoverySpi((DiscoverySpi)disco);
        int i = 0;
        CacheConfiguration[] ccs = new CacheConfiguration[4];
        for (String name : F.asList((Object[])new String[]{"co", "pr", "pe", "pu"})) {
            CacheConfiguration cc = IgniteCacheClientQueryReplicatedNodeRestartSelfTest.defaultCacheConfiguration();
            cc.setNodeFilter(DATA_NODES_FILTER);
            cc.setName(name);
            cc.setCacheMode(CacheMode.REPLICATED);
            cc.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
            cc.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
            cc.setRebalanceMode(CacheRebalanceMode.SYNC);
            cc.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 50));
            switch (name) {
                case "co": {
                    cc.setIndexedTypes(new Class[]{Integer.class, Company.class});
                    break;
                }
                case "pr": {
                    cc.setIndexedTypes(new Class[]{Integer.class, Product.class});
                    break;
                }
                case "pe": {
                    cc.setIndexedTypes(new Class[]{Integer.class, Person.class});
                    break;
                }
                case "pu": {
                    cc.setIndexedTypes(new Class[]{AffinityKey.class, Purchase.class});
                }
            }
            ccs[i++] = cc;
        }
        c.setCacheConfiguration(ccs);
        return c;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    private void fillCaches() {
        IgniteCache co = this.grid(0).cache("co");
        for (int i = 0; i < 25; ++i) {
            co.put((Object)i, (Object)new Company(i));
        }
        IgniteCache pr = this.grid(0).cache("pr");
        GridRandom rnd = new GridRandom();
        for (int i = 0; i < 100; ++i) {
            pr.put((Object)i, (Object)new Product(i, rnd.nextInt(25)));
        }
        IgniteCache pe = this.grid(0).cache("pe");
        for (int i = 0; i < 600; ++i) {
            pe.put((Object)i, (Object)new Person(i));
        }
        IgniteCache pu = this.grid(0).cache("pu");
        for (int i = 0; i < 6000; ++i) {
            int persId = rnd.nextInt(600);
            int prodId = rnd.nextInt(100);
            pu.put((Object)new AffinityKey((Object)i, (Object)persId), (Object)new Purchase(persId, prodId));
        }
    }

    private void assertClient(IgniteCache<?, ?> c, boolean client) {
        IgniteCacheClientQueryReplicatedNodeRestartSelfTest.assertTrue((((IgniteCacheProxy)c).context().affinityNode() == !client ? 1 : 0) != 0);
    }

    public void testRestarts() throws Exception {
        int duration = 90000;
        int qryThreadNum = 5;
        int restartThreadsNum = 2;
        int nodeLifeTime = 2000;
        int logFreq = 10;
        this.startGridsMultiThreaded(5);
        final AtomicIntegerArray locks = new AtomicIntegerArray(4);
        this.fillCaches();
        final List pRes = this.grid(0).cache("pu").query((Query)new SqlFieldsQuery(QRY)).getAll();
        Thread.sleep(3000L);
        IgniteCacheClientQueryReplicatedNodeRestartSelfTest.assertEquals((Object)pRes, (Object)this.grid(0).cache("pu").query((Query)new SqlFieldsQuery(QRY)).getAll());
        IgniteCacheClientQueryReplicatedNodeRestartSelfTest.assertFalse((boolean)pRes.isEmpty());
        final AtomicInteger qryCnt = new AtomicInteger();
        final AtomicBoolean qrysDone = new AtomicBoolean();
        final ArrayList<Integer> cacheSize = new ArrayList<Integer>(4);
        for (int i = 0; i < 4; ++i) {
            int j = 0;
            for (String cacheName : F.asList((Object[])new String[]{"co", "pr", "pe", "pu"})) {
                IgniteCache cache = this.grid(i).cache(cacheName);
                this.assertClient(cache, false);
                if (i == 0) {
                    cacheSize.add(cache.size(new CachePeekMode[0]));
                    continue;
                }
                IgniteCacheClientQueryReplicatedNodeRestartSelfTest.assertEquals((int)((Integer)cacheSize.get(j++)), (int)cache.size(new CachePeekMode[0]));
            }
        }
        int j = 0;
        for (String cacheName : F.asList((Object[])new String[]{"co", "pr", "pe", "pu"})) {
            IgniteCache cache = this.grid(4).cache(cacheName);
            this.assertClient(cache, true);
            IgniteCacheClientQueryReplicatedNodeRestartSelfTest.assertEquals((int)((Integer)cacheSize.get(j++)), (int)cache.size(new CachePeekMode[0]));
        }
        final IgniteCache clientCache = this.grid(4).cache("pu");
        IgniteInternalFuture fut1 = this.multithreadedAsync((Runnable)new CAX(){

            public void applyx() throws IgniteCheckedException {
                GridRandom rnd = new GridRandom();
                while (!qrysDone.get()) {
                    int c;
                    List res;
                    SqlFieldsQuery qry = new SqlFieldsQuery(IgniteCacheClientQueryReplicatedNodeRestartSelfTest.QRY);
                    boolean smallPageSize = rnd.nextBoolean();
                    if (smallPageSize) {
                        qry.setPageSize(3);
                    }
                    try {
                        res = clientCache.query((Query)qry).getAll();
                    }
                    catch (CacheException e) {
                        TestCase.assertTrue((String)"On large page size must retry.", (boolean)smallPageSize);
                        boolean failedOnRemoteFetch = false;
                        for (Throwable th = e; th != null; th = th.getCause()) {
                            if (!(th instanceof CacheException) || th.getMessage() == null || !th.getMessage().startsWith("Failed to fetch data from node:")) continue;
                            failedOnRemoteFetch = true;
                            break;
                        }
                        if (!failedOnRemoteFetch) {
                            e.printStackTrace();
                            TestCase.fail((String)"Must fail inside of GridResultPage.fetchNextPage or subclass.");
                        }
                        res = FAKE;
                    }
                    if (res != FAKE && !res.equals(pRes)) {
                        int j = 0;
                        for (String cacheName : F.asList((Object[])new String[]{"co", "pr", "pe", "pu"})) {
                            TestCase.assertEquals((String)cacheName, (int)((Integer)cacheSize.get(j++)), (int)IgniteCacheClientQueryReplicatedNodeRestartSelfTest.this.grid(4).cache(cacheName).size(new CachePeekMode[0]));
                        }
                        TestCase.assertEquals((Object)pRes, (Object)res);
                    }
                    if ((c = qryCnt.incrementAndGet()) % 10 != 0) continue;
                    IgniteCacheClientQueryReplicatedNodeRestartSelfTest.this.info("Executed queries: " + c);
                }
            }
        }, qryThreadNum, "query-thread");
        final AtomicInteger restartCnt = new AtomicInteger();
        final AtomicBoolean restartsDone = new AtomicBoolean();
        IgniteInternalFuture fut2 = this.multithreadedAsync(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                GridRandom rnd = new GridRandom();
                while (!restartsDone.get()) {
                    int g;
                    while (!locks.compareAndSet(g = rnd.nextInt(locks.length()), 0, -1)) {
                    }
                    IgniteCacheClientQueryReplicatedNodeRestartSelfTest.this.log.info("Stop node: " + g);
                    IgniteCacheClientQueryReplicatedNodeRestartSelfTest.this.stopGrid(g);
                    Thread.sleep(rnd.nextInt(2000));
                    IgniteCacheClientQueryReplicatedNodeRestartSelfTest.this.log.info("Start node: " + g);
                    IgniteCacheClientQueryReplicatedNodeRestartSelfTest.this.startGrid(g);
                    Thread.sleep(rnd.nextInt(2000));
                    locks.set(g, 0);
                    int c = restartCnt.incrementAndGet();
                    if (c % 10 != 0) continue;
                    IgniteCacheClientQueryReplicatedNodeRestartSelfTest.this.info("Node restarts: " + c);
                }
                return true;
            }
        }, restartThreadsNum, "restart-thread");
        Thread.sleep(duration);
        this.info("Stopping..");
        restartsDone.set(true);
        fut2.get();
        this.info("Restarts stopped.");
        qrysDone.set(true);
        fut1.get();
        this.info("Queries stopped.");
    }

    private static class Product
    implements Serializable {
        @QuerySqlField(index=true)
        int id;
        @QuerySqlField(index=true)
        int companyId;

        Product(int id, int companyId) {
            this.id = id;
            this.companyId = companyId;
        }
    }

    private static class Company
    implements Serializable {
        @QuerySqlField(index=true)
        int id;

        Company(int id) {
            this.id = id;
        }
    }

    private static class Purchase
    implements Serializable {
        @QuerySqlField(index=true)
        int personId;
        @QuerySqlField(index=true)
        int productId;

        Purchase(int personId, int productId) {
            this.personId = personId;
            this.productId = productId;
        }
    }

    private static class Person
    implements Serializable {
        @QuerySqlField(index=true)
        int id;

        Person(int id) {
            this.id = id;
        }
    }
}

