/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheException;
import junit.framework.TestCase;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteClientReconnectAbstractTest;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageResponse;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.testframework.GridTestUtils;

public class IgniteClientReconnectQueriesTest
extends IgniteClientReconnectAbstractTest {
    public static final String QUERY_CACHE = "query";

    protected int serverCount() {
        return 3;
    }

    protected int clientCount() {
        return 1;
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration ccfg = new CacheConfiguration(QUERY_CACHE).setCacheMode(CacheMode.PARTITIONED).setAtomicityMode(CacheAtomicityMode.ATOMIC).setBackups(1).setIndexedTypes(new Class[]{Integer.class, Person.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{ccfg});
        return cfg;
    }

    protected void afterTest() throws Exception {
        super.afterTest();
        this.grid(0).getOrCreateCache(QUERY_CACHE).removeAll();
    }

    public void testQueryReconnect() throws Exception {
        IgniteEx cln = this.grid(this.serverCount());
        IgniteClientReconnectQueriesTest.assertTrue((boolean)cln.cluster().localNode().isClient());
        Ignite srv = this.clientRouter((Ignite)cln);
        final IgniteCache clnCache = cln.getOrCreateCache(QUERY_CACHE);
        final IgniteCache srvCache = srv.getOrCreateCache(QUERY_CACHE);
        clnCache.put((Object)1, (Object)new Person(1, "name1", "surname1"));
        clnCache.put((Object)2, (Object)new Person(2, "name2", "surname2"));
        clnCache.put((Object)3, (Object)new Person(3, "name3", "surname3"));
        final SqlQuery qry = new SqlQuery(Person.class, "_key <> 0");
        qry.setPageSize(1);
        QueryCursor cur = clnCache.query((Query)qry);
        this.reconnectClientNode((Ignite)cln, srv, new Runnable(){

            @Override
            public void run() {
                srvCache.put((Object)4, (Object)new Person(4, "name4", "surname4"));
                try {
                    clnCache.query((Query)qry);
                    TestCase.fail();
                }
                catch (CacheException e) {
                    IgniteClientReconnectQueriesTest.this.check(e);
                }
            }
        });
        List res = cur.getAll();
        IgniteClientReconnectQueriesTest.assertNotNull((Object)res);
        IgniteClientReconnectQueriesTest.assertEquals((int)4, (int)res.size());
    }

    public void testReconnectQueryInProgress() throws Exception {
        IgniteEx cln = this.grid(this.serverCount());
        IgniteClientReconnectQueriesTest.assertTrue((boolean)cln.cluster().localNode().isClient());
        Ignite srv = this.clientRouter((Ignite)cln);
        IgniteCache clnCache = cln.getOrCreateCache(QUERY_CACHE);
        clnCache.put((Object)1, (Object)new Person(1, "name1", "surname1"));
        clnCache.put((Object)2, (Object)new Person(2, "name2", "surname2"));
        clnCache.put((Object)3, (Object)new Person(3, "name3", "surname3"));
        this.blockMessage(GridQueryNextPageResponse.class);
        SqlQuery qry = new SqlQuery(Person.class, "_key <> 0");
        qry.setPageSize(1);
        final QueryCursor cur1 = clnCache.query((Query)qry);
        final IgniteInternalFuture fut = GridTestUtils.runAsync((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    cur1.getAll();
                }
                catch (CacheException e) {
                    IgniteClientReconnectQueriesTest.this.checkAndWait(e);
                    return true;
                }
                return false;
            }
        });
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return fut.get(200L);
            }
        }, IgniteFutureTimeoutCheckedException.class, null);
        this.assertNotDone(fut);
        this.unblockMessage();
        this.reconnectClientNode((Ignite)cln, srv, null);
        IgniteClientReconnectQueriesTest.assertTrue((boolean)((Boolean)fut.get(2L, TimeUnit.SECONDS)));
        QueryCursor cur2 = clnCache.query((Query)qry);
        IgniteClientReconnectQueriesTest.assertEquals((int)3, (int)cur2.getAll().size());
    }

    public void testScanQueryReconnect() throws Exception {
        IgniteEx cln = this.grid(this.serverCount());
        IgniteClientReconnectQueriesTest.assertTrue((boolean)cln.cluster().localNode().isClient());
        Ignite srv = this.clientRouter((Ignite)cln);
        final IgniteCache clnCache = cln.getOrCreateCache(QUERY_CACHE);
        final IgniteCache srvCache = srv.getOrCreateCache(QUERY_CACHE);
        for (int i = 0; i < 10000; ++i) {
            clnCache.put((Object)i, (Object)new Person(i, "name-" + i, "surname-" + i));
        }
        final ScanQuery scanQry = new ScanQuery();
        scanQry.setPageSize(1);
        scanQry.setFilter((IgniteBiPredicate)new IgniteBiPredicate<Integer, Person>(){

            public boolean apply(Integer integer, Person person) {
                return true;
            }
        });
        QueryCursor qryCursor = clnCache.query((Query)scanQry);
        this.reconnectClientNode((Ignite)cln, srv, new Runnable(){

            @Override
            public void run() {
                srvCache.put((Object)10001, (Object)new Person(10001, "name", "surname"));
                try {
                    clnCache.query((Query)scanQry);
                    TestCase.fail();
                }
                catch (CacheException e) {
                    IgniteClientReconnectQueriesTest.this.check(e);
                }
            }
        });
        try {
            qryCursor.getAll();
            IgniteClientReconnectQueriesTest.fail();
        }
        catch (CacheException e) {
            this.checkAndWait(e);
        }
        qryCursor = clnCache.query((Query)scanQry);
        IgniteClientReconnectQueriesTest.assertEquals((int)10001, (int)qryCursor.getAll().size());
    }

    public void testScanQueryReconnectInProgress1() throws Exception {
        this.scanQueryReconnectInProgress(false);
    }

    public void testScanQueryReconnectInProgress2() throws Exception {
        this.scanQueryReconnectInProgress(true);
    }

    private void scanQueryReconnectInProgress(boolean setPart) throws Exception {
        IgniteEx cln = this.grid(this.serverCount());
        IgniteClientReconnectQueriesTest.assertTrue((boolean)cln.cluster().localNode().isClient());
        Ignite srv = this.clientRouter((Ignite)cln);
        final IgniteCache clnCache = cln.getOrCreateCache(QUERY_CACHE);
        clnCache.put((Object)1, (Object)new Person(1, "name1", "surname1"));
        clnCache.put((Object)2, (Object)new Person(2, "name2", "surname2"));
        clnCache.put((Object)3, (Object)new Person(3, "name3", "surname3"));
        final ScanQuery scanQry = new ScanQuery();
        scanQry.setPageSize(1);
        scanQry.setFilter((IgniteBiPredicate)new IgniteBiPredicate<Integer, Person>(){

            public boolean apply(Integer integer, Person person) {
                return true;
            }
        });
        if (setPart) {
            scanQry.setPartition(Integer.valueOf(1));
        }
        this.blockMessage(GridCacheQueryResponse.class);
        final IgniteInternalFuture fut = GridTestUtils.runAsync((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    QueryCursor qryCursor = clnCache.query((Query)scanQry);
                    qryCursor.getAll();
                }
                catch (CacheException e) {
                    IgniteClientReconnectQueriesTest.this.checkAndWait(e);
                    return true;
                }
                return false;
            }
        });
        GridTestUtils.assertThrows((IgniteLogger)this.log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return fut.get(200L);
            }
        }, IgniteFutureTimeoutCheckedException.class, null);
        this.assertNotDone(fut);
        this.unblockMessage();
        this.reconnectClientNode((Ignite)cln, srv, null);
        IgniteClientReconnectQueriesTest.assertTrue((boolean)((Boolean)fut.get(2L, TimeUnit.SECONDS)));
        QueryCursor qryCursor2 = clnCache.query((Query)scanQry);
        List entries = qryCursor2.getAll();
        IgniteClientReconnectQueriesTest.assertEquals((int)(setPart ? 1 : 3), (int)entries.size());
        for (Cache.Entry entry : entries) {
            IgniteClientReconnectQueriesTest.assertEquals(Integer.class, ((Integer)entry.getKey()).getClass());
            IgniteClientReconnectQueriesTest.assertEquals(Person.class, ((Person)entry.getValue()).getClass());
        }
    }

    private void blockMessage(Class<?> clazz) {
        for (int i = 0; i < this.serverCount(); ++i) {
            IgniteClientReconnectAbstractTest.BlockTcpCommunicationSpi commSpi = this.commSpi((Ignite)this.grid(i));
            commSpi.blockMessage(clazz);
        }
    }

    private void unblockMessage() {
        for (int i = 0; i < this.serverCount(); ++i) {
            IgniteClientReconnectAbstractTest.BlockTcpCommunicationSpi commSpi = this.commSpi((Ignite)this.grid(i));
            commSpi.unblockMessage();
        }
    }

    public static class Person {
        @QuerySqlField
        public int id;
        @QuerySqlField
        public String name;
        @QuerySqlField
        public String surname;

        public Person(int id, String name, String surname) {
            this.id = id;
            this.name = name;
            this.surname = surname;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSurname() {
            return this.surname;
        }

        public void setSurname(String surname) {
            this.surname = surname;
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.id == ((Person)o).id;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return S.toString(Person.class, (Object)this);
        }
    }
}

