/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.query.h2.sql.AbstractH2CompareQueryTest;

public class IgniteCacheUnionDuplicatesTest
extends AbstractH2CompareQueryTest {
    private static IgniteCache<Integer, Organization> pCache;

    @Override
    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration("orgCache", CacheMode.PARTITIONED, Integer.class, Organization.class)});
        return cfg;
    }

    @Override
    protected void createCaches() {
        pCache = ignite.cache("orgCache");
    }

    @Override
    protected void initCacheAndDbData() throws Exception {
        Integer k1 = this.primaryKey(this.ignite(0).cache(pCache.getName()));
        Integer k2 = this.primaryKey(this.ignite(1).cache(pCache.getName()));
        Organization org1 = new Organization(k1, "org", "org1");
        Organization org2 = new Organization(k2, "org", "org2");
        pCache.put((Object)k1, (Object)org1);
        pCache.put((Object)k2, (Object)org2);
        this.insertInDb(org1);
        this.insertInDb(org2);
    }

    @Override
    protected void checkAllDataEquals() throws Exception {
    }

    public void testUnionDuplicateFilter() throws Exception {
        this.compareQueryRes0(pCache, "select name from \"part\".Organization union select name2 from \"part\".Organization", new Object[0]);
    }

    @Override
    protected Statement initializeH2Schema() throws SQLException {
        Statement st = super.initializeH2Schema();
        st.execute("create table \"part\".ORGANIZATION  (_key int not null,  _val other not null,  id int unique,  name varchar(255),  name2 varchar(255))");
        return st;
    }

    private void insertInDb(Organization org) throws SQLException {
        try (PreparedStatement st = conn.prepareStatement("insert into \"part\".ORGANIZATION (_key, _val, id, name, name2) values(?, ?, ?, ?, ?)");){
            st.setObject(1, org.id);
            st.setObject(2, org);
            st.setObject(3, org.id);
            st.setObject(4, org.name);
            st.setObject(5, org.name2);
            st.executeUpdate();
        }
    }

    private static class Organization
    implements Serializable {
        @QuerySqlField(index=true)
        private int id;
        @QuerySqlField(index=true)
        private String name;
        @QuerySqlField(index=true)
        private String name2;

        Organization(int id, String name, String name2) {
            this.id = id;
            this.name = name;
            this.name2 = name2;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Organization && this.id == ((Organization)o).id;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return "Organization [id=" + this.id + ", name=" + this.name + ", name2=" + this.name2 + ']';
        }
    }
}

