/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.typedef.CAX;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class IgniteCacheQueryH2IndexingLeakTest
extends GridCommonAbstractTest {
    private static final long TEST_TIMEOUT = 120000L;
    private static final int THREAD_COUNT = 10;
    private static final long STMT_CACHE_CLEANUP_TIMEOUT = 1000L;
    private static String origCacheCleanupPeriod;
    private static String origCacheThreadUsageTimeout;
    private static final int ITERATIONS = 5;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration()});
        return cfg;
    }

    protected CacheConfiguration cacheConfiguration() {
        CacheConfiguration cacheCfg = IgniteCacheQueryH2IndexingLeakTest.defaultCacheConfiguration();
        cacheCfg.setCacheMode(CacheMode.PARTITIONED);
        cacheCfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        cacheCfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cacheCfg.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        return cacheCfg;
    }

    protected long getTestTimeout() {
        return 180000L;
    }

    protected void beforeTestsStarted() throws Exception {
        origCacheCleanupPeriod = System.getProperty("IGNITE_H2_INDEXING_CACHE_CLEANUP_PERIOD");
        origCacheThreadUsageTimeout = System.getProperty("IGNITE_H2_INDEXING_CACHE_THREAD_USAGE_TIMEOUT");
        System.setProperty("IGNITE_H2_INDEXING_CACHE_CLEANUP_PERIOD", Long.toString(1000L));
        System.setProperty("IGNITE_H2_INDEXING_CACHE_THREAD_USAGE_TIMEOUT", Long.toString(1000L));
        this.startGrid(0);
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        System.setProperty("IGNITE_H2_INDEXING_CACHE_CLEANUP_PERIOD", origCacheCleanupPeriod != null ? origCacheCleanupPeriod : "");
        System.setProperty("IGNITE_H2_INDEXING_CACHE_THREAD_USAGE_TIMEOUT", origCacheThreadUsageTimeout != null ? origCacheThreadUsageTimeout : "");
    }

    private static int getStatementCacheSize(GridQueryProcessor qryProcessor) {
        IgniteH2Indexing h2Idx = (IgniteH2Indexing)GridTestUtils.getFieldValue((Object)qryProcessor, GridQueryProcessor.class, (String)"idx");
        ConcurrentMap stmtCache = (ConcurrentMap)GridTestUtils.getFieldValue((Object)h2Idx, IgniteH2Indexing.class, (String)"stmtCache");
        return stmtCache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLeaksInIgniteH2IndexingOnTerminatedThread() throws Exception {
        final IgniteCache c = this.grid(0).cache("default");
        for (int i = 0; i < 5; ++i) {
            this.info("Iteration #" + i);
            final AtomicBoolean stop = new AtomicBoolean();
            IgniteInternalFuture fut = this.multithreadedAsync((Runnable)new CAX(){

                public void applyx() throws IgniteCheckedException {
                    while (!stop.get()) {
                        c.query((Query)new SqlQuery(Integer.class, "_val >= 0")).getAll();
                        c.query((Query)new SqlQuery(Integer.class, "_val >= 1")).getAll();
                    }
                }
            }, 10);
            final GridQueryProcessor qryProc = this.grid(0).context().query();
            try {
                IgniteCacheQueryH2IndexingLeakTest.assertTrue((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

                    public boolean apply() {
                        return IgniteCacheQueryH2IndexingLeakTest.getStatementCacheSize(qryProc) == 10;
                    }
                }, (long)1000L));
            }
            finally {
                stop.set(true);
            }
            fut.get();
            IgniteCacheQueryH2IndexingLeakTest.assertTrue((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

                public boolean apply() {
                    return IgniteCacheQueryH2IndexingLeakTest.getStatementCacheSize(qryProc) == 0;
                }
            }, (long)2000L));
        }
    }

    public void testLeaksInIgniteH2IndexingOnUnusedThread() throws Exception {
        final IgniteCache c = this.grid(0).cache("default");
        final CountDownLatch latch = new CountDownLatch(1);
        for (int i = 0; i < 5; ++i) {
            this.info("Iteration #" + i);
            IgniteInternalFuture fut = this.multithreadedAsync((Runnable)new CAX(){

                public void applyx() throws IgniteCheckedException {
                    c.query((Query)new SqlQuery(Integer.class, "_val >= 0")).getAll();
                    U.await((CountDownLatch)latch);
                }
            }, 10);
            Thread.sleep(1000L);
            IgniteCacheQueryH2IndexingLeakTest.assertTrue((boolean)GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

                public boolean apply() {
                    return IgniteCacheQueryH2IndexingLeakTest.getStatementCacheSize(IgniteCacheQueryH2IndexingLeakTest.this.grid(0).context().query()) == 0;
                }
            }, (long)2000L));
            latch.countDown();
            fut.get();
        }
    }
}

