/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;

public class IgniteCacheQueriesLoadTest1
extends GridCommonAbstractTest {
    private static final String OPERATION = "Operation";
    private static final String DEPOSIT = "Deposit";
    private static final String TRADER = "Trader";
    private static final String ID = "ID";
    private static final String DEPOSIT_ID = "DEPOSIT_ID";
    private static final String TRADER_ID = "TRADER_ID";
    private static final String FIRSTNAME = "FIRSTNAME";
    private static final String SECONDNAME = "SECONDNAME";
    private static final String EMAIL = "EMAIL";
    private static final String BUSINESS_DAY = "BUSINESS_DAY";
    private static final String TRADER_LINK = "TRADER";
    private static final String BALANCE = "BALANCE";
    private static final String MARGIN_RATE = "MARGIN_RATE";
    private static final String BALANCE_ON_DAY_OPEN = "BALANCEDO";
    private static final String TRADER_CACHE = "TRADER_CACHE";
    private static final String DEPOSIT_CACHE = "DEPOSIT_CACHE";
    private static final String DEPOSIT_HISTORY_CACHE = "DEPOSIT_HISTORY_CACHE";
    private static final String DEPOSIT_OPERATION_COUNT_SQL = "SELECT COUNT(*) FROM \"DEPOSIT_HISTORY_CACHE\".Operation WHERE DEPOSIT_ID=?";
    private static final String LAST_HISTORY_ROW_SQL = "SELECT MAX(BUSINESS_DAY) FROM \"DEPOSIT_HISTORY_CACHE\".Operation WHERE DEPOSIT_ID=?";
    private static final String FIND_DEPOSIT_SQL = "SELECT _key FROM \"DEPOSIT_CACHE\".Deposit WHERE TRADER_ID=?";
    private static final TcpDiscoveryIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);
    private static final int NODES = 5;
    private Map<UUID, List<Integer>> partitionsMap;
    private final int preloadAmount = 10000;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setIncludeEventTypes(new int[0]);
        cfg.setMarshaller(null);
        ((TcpDiscoverySpi)cfg.getDiscoverySpi()).setIpFinder(IP_FINDER);
        RendezvousAffinityFunction aff = new RendezvousAffinityFunction();
        aff.setPartitions(3000);
        CacheConfiguration parentCfg = new CacheConfiguration("default");
        parentCfg.setAffinity((AffinityFunction)aff);
        parentCfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        parentCfg.setCacheMode(CacheMode.PARTITIONED);
        parentCfg.setBackups(2);
        parentCfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cfg.setCacheConfiguration(new CacheConfiguration[]{IgniteCacheQueriesLoadTest1.getTraderCfg((CacheConfiguration<Object, Object>)parentCfg), IgniteCacheQueriesLoadTest1.getDepositCfg((CacheConfiguration<Object, Object>)parentCfg), IgniteCacheQueriesLoadTest1.getDepositHistoryCfg((CacheConfiguration<Object, Object>)parentCfg)});
        return cfg;
    }

    public void testQueries() throws Exception {
        this.runQueries(1, true, 10000L);
        this.runQueries(10, false, 30000L);
    }

    private void runQueries(int threads, final boolean checkBalance, final long time) throws Exception {
        IgniteEx ignite = this.grid(0);
        GridTestUtils.runMultiThreaded((Callable)new Callable<Object>((Ignite)ignite){
            final /* synthetic */ Ignite val$ignite;
            {
                this.val$ignite = ignite;
            }

            @Override
            public Object call() {
                long endTime = System.currentTimeMillis() + time;
                while (System.currentTimeMillis() < endTime) {
                    ScanQueryBroadcastClosure c = new ScanQueryBroadcastClosure(IgniteCacheQueriesLoadTest1.this.partitionsMap, checkBalance);
                    this.val$ignite.compute().broadcast((IgniteRunnable)c);
                }
                return null;
            }
        }, (int)threads, (String)"test-thread");
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(5);
        this.partitionsMap = this.traderCachePartitions(this.ignite(0));
        IgniteCacheQueriesLoadTest1.assertEquals((int)5, (int)this.partitionsMap.size());
        this.preLoading();
    }

    protected void afterTestsStopped() throws Exception {
        this.stopAllGrids();
        assert (G.allGrids().isEmpty());
    }

    private void preLoading() throws Exception {
        Thread preloadAccount = new Thread(){

            @Override
            public void run() {
                this.setName("preloadTraders");
                Ignite ignite = IgniteCacheQueriesLoadTest1.this.ignite(0);
                try (IgniteDataStreamer dataLdr = ignite.dataStreamer(IgniteCacheQueriesLoadTest1.TRADER_CACHE);){
                    for (int i = 0; i < 10000 && !this.isInterrupted(); ++i) {
                        String traderKey = "traderId=" + i;
                        dataLdr.addData((Object)traderKey, (Object)IgniteCacheQueriesLoadTest1.this.createTrader(ignite, traderKey));
                    }
                }
            }
        };
        preloadAccount.start();
        Thread preloadTrade = new Thread(){

            @Override
            public void run() {
                this.setName("preloadDeposits");
                Ignite ignite = IgniteCacheQueriesLoadTest1.this.ignite(0);
                try (IgniteDataStreamer dataLdr = ignite.dataStreamer(IgniteCacheQueriesLoadTest1.DEPOSIT_CACHE);){
                    for (int i = 0; i < 10000 && !this.isInterrupted(); ++i) {
                        int traderId = IgniteCacheQueriesLoadTest1.nextRandom(10000);
                        String traderKey = "traderId=" + traderId;
                        String key = traderKey + "&depositId=" + i;
                        dataLdr.addData((Object)key, (Object)IgniteCacheQueriesLoadTest1.this.createDeposit(ignite, key, traderKey, i));
                    }
                }
            }
        };
        preloadTrade.start();
        preloadTrade.join();
        preloadAccount.join();
    }

    private BinaryObject createTrader(Ignite ignite, String id) {
        return ignite.binary().builder(TRADER).setField(ID, (Object)id).setField(FIRSTNAME, (Object)("First name " + id)).setField(SECONDNAME, (Object)("Second name " + id)).setField(EMAIL, (Object)("trader" + id + "@mail.org")).build();
    }

    private BinaryObject createDeposit(Ignite ignite, String id, String traderId, int num) {
        double startBalance = 100.0 + (double)IgniteCacheQueriesLoadTest1.nextRandom(100) / 1.123;
        return ignite.binary().builder(DEPOSIT).setField(ID, (Object)id).setField(TRADER_ID, (Object)traderId).setField(TRADER_LINK, (Object)num).setField(BALANCE, (Object)new BigDecimal(startBalance)).setField(MARGIN_RATE, (Object)new BigDecimal(0.1)).setField(BALANCE_ON_DAY_OPEN, (Object)new BigDecimal(startBalance)).build();
    }

    private Map<UUID, List<Integer>> traderCachePartitions(Ignite ignite) {
        Affinity affinity = ignite.affinity(TRADER_CACHE);
        ArrayList<Integer> partNumbers = new ArrayList<Integer>(affinity.partitions());
        for (int i = 0; i < affinity.partitions(); ++i) {
            partNumbers.add(i);
        }
        Map partPerNodes = affinity.mapPartitionsToNodes(partNumbers);
        HashMap<UUID, List<Integer>> nodesToPart = new HashMap<UUID, List<Integer>>();
        for (Map.Entry entry : partPerNodes.entrySet()) {
            ArrayList nodeParts = (ArrayList)nodesToPart.get(((ClusterNode)entry.getValue()).id());
            if (nodeParts == null) {
                nodeParts = new ArrayList();
                nodesToPart.put(((ClusterNode)entry.getValue()).id(), nodeParts);
            }
            nodeParts.add(entry.getKey());
        }
        return nodesToPart;
    }

    private static int nextRandom(int max) {
        return ThreadLocalRandom.current().nextInt(max);
    }

    private static CacheConfiguration<Object, Object> getDepositHistoryCfg(CacheConfiguration<Object, Object> parentCfg) {
        CacheConfiguration depositHistCfg = new CacheConfiguration(parentCfg);
        depositHistCfg.setName(DEPOSIT_HISTORY_CACHE);
        String strCls = String.class.getCanonicalName();
        String dblCls = Double.class.getCanonicalName();
        String dtCls = Date.class.getCanonicalName();
        LinkedHashMap<String, String> qryFields = new LinkedHashMap<String, String>();
        qryFields.put(ID, strCls);
        qryFields.put(DEPOSIT_ID, strCls);
        qryFields.put(BUSINESS_DAY, dtCls);
        qryFields.put(BALANCE, dblCls);
        QueryEntity qryEntity = new QueryEntity();
        qryEntity.setValueType(OPERATION);
        qryEntity.setKeyType(strCls);
        qryEntity.setFields(qryFields);
        qryEntity.setIndexes(Arrays.asList(new QueryIndex(ID, true), new QueryIndex(DEPOSIT_ID, true)));
        depositHistCfg.setQueryEntities(Collections.singleton(qryEntity));
        return depositHistCfg;
    }

    private static CacheConfiguration<Object, Object> getDepositCfg(CacheConfiguration<Object, Object> parentCfg) {
        CacheConfiguration depositCfg = new CacheConfiguration(parentCfg);
        depositCfg.setName(DEPOSIT_CACHE);
        String strCls = String.class.getCanonicalName();
        String dblCls = Double.class.getCanonicalName();
        String intCls = Integer.class.getCanonicalName();
        LinkedHashMap<String, String> qryFields = new LinkedHashMap<String, String>();
        qryFields.put(ID, strCls);
        qryFields.put(TRADER_ID, strCls);
        qryFields.put(TRADER_LINK, intCls);
        qryFields.put(BALANCE, dblCls);
        qryFields.put(MARGIN_RATE, dblCls);
        qryFields.put(BALANCE_ON_DAY_OPEN, dblCls);
        QueryEntity qryEntity = new QueryEntity();
        qryEntity.setValueType(DEPOSIT);
        qryEntity.setKeyType(strCls);
        qryEntity.setFields(qryFields);
        qryEntity.setIndexes(Collections.singleton(new QueryIndex(ID, false)));
        depositCfg.setQueryEntities(Collections.singleton(qryEntity));
        return depositCfg;
    }

    private static CacheConfiguration<Object, Object> getTraderCfg(CacheConfiguration<Object, Object> parentCfg) {
        CacheConfiguration traderCfg = new CacheConfiguration(parentCfg);
        traderCfg.setName(TRADER_CACHE);
        String strCls = String.class.getCanonicalName();
        LinkedHashMap<String, String> qryFields = new LinkedHashMap<String, String>();
        qryFields.put(ID, strCls);
        qryFields.put(FIRSTNAME, strCls);
        qryFields.put(SECONDNAME, strCls);
        qryFields.put(EMAIL, strCls);
        QueryEntity qryEntity = new QueryEntity();
        qryEntity.setValueType(TRADER);
        qryEntity.setKeyType(strCls);
        qryEntity.setFields(qryFields);
        LinkedHashMap<String, Boolean> grpIdx = new LinkedHashMap<String, Boolean>();
        grpIdx.put(FIRSTNAME, false);
        grpIdx.put(SECONDNAME, false);
        qryEntity.setIndexes(Arrays.asList(new QueryIndex(ID, true), new QueryIndex(grpIdx, QueryIndexType.FULLTEXT)));
        traderCfg.setQueryEntities(Collections.singleton(qryEntity));
        return traderCfg;
    }

    private static class ScanQueryBroadcastClosure
    implements IgniteRunnable {
        @IgniteInstanceResource
        private Ignite node;
        private final Map<UUID, List<Integer>> cachePart;
        private final boolean checkBalance;

        private ScanQueryBroadcastClosure(Map<UUID, List<Integer>> cachePart, boolean checkBalance) {
            this.cachePart = cachePart;
            this.checkBalance = checkBalance;
        }

        public void run() {
            try {
                IgniteCache traders = this.node.cache(IgniteCacheQueriesLoadTest1.TRADER_CACHE).withKeepBinary();
                IgniteCache depositCache = this.node.cache(IgniteCacheQueriesLoadTest1.DEPOSIT_CACHE).withKeepBinary();
                List<Integer> myPartitions = this.cachePart.get(this.node.cluster().localNode().id());
                for (Integer part : myPartitions) {
                    ScanQuery scanQry = new ScanQuery();
                    scanQry.setPartition(part);
                    QueryCursor cursor = traders.query((Query)scanQry);
                    Throwable throwable = null;
                    try {
                        for (Cache.Entry entry : cursor) {
                            String traderId = (String)entry.getKey();
                            SqlFieldsQuery findDepositQry = new SqlFieldsQuery(IgniteCacheQueriesLoadTest1.FIND_DEPOSIT_SQL).setLocal(true);
                            QueryCursor cursor1 = depositCache.query((Query)findDepositQry.setArgs(new Object[]{traderId}));
                            Throwable throwable2 = null;
                            try {
                                for (Object obj : cursor1) {
                                    List depositIds = (List)obj;
                                    for (String depositId : depositIds) {
                                        this.updateDeposit((IgniteCache<String, BinaryObject>)depositCache, depositId);
                                        this.checkDeposit((IgniteCache<String, BinaryObject>)depositCache, depositId);
                                    }
                                }
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (cursor1 == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        cursor1.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable2.addSuppressed(x2);
                                    }
                                    continue;
                                }
                                cursor1.close();
                            }
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (cursor == null) continue;
                        if (throwable != null) {
                            try {
                                cursor.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        cursor.close();
                    }
                }
            }
            catch (Exception e) {
                throw new IgniteException((Throwable)e);
            }
        }

        private void updateDeposit(final IgniteCache<String, BinaryObject> depositCache, final String depositKey) throws Exception {
            final IgniteCache histCache = this.node.cache(IgniteCacheQueriesLoadTest1.DEPOSIT_HISTORY_CACHE).withKeepBinary();
            IgniteCacheQueriesLoadTest1.doInTransaction((Ignite)this.node, (TransactionConcurrency)TransactionConcurrency.PESSIMISTIC, (TransactionIsolation)TransactionIsolation.REPEATABLE_READ, (Callable)((Callable)new IgniteCallable<Object>(){

                public Object call() throws Exception {
                    BinaryObject deposit = (BinaryObject)depositCache.get((Object)depositKey);
                    BigDecimal amount = (BigDecimal)deposit.field(IgniteCacheQueriesLoadTest1.BALANCE);
                    BigDecimal rate = (BigDecimal)deposit.field(IgniteCacheQueriesLoadTest1.MARGIN_RATE);
                    BigDecimal newBalance = amount.multiply(rate.add(BigDecimal.ONE));
                    deposit = deposit.toBuilder().setField(IgniteCacheQueriesLoadTest1.BALANCE, (Object)newBalance).build();
                    SqlFieldsQuery findDepositHist = new SqlFieldsQuery(IgniteCacheQueriesLoadTest1.LAST_HISTORY_ROW_SQL).setLocal(true);
                    try (QueryCursor cursor1 = histCache.query((Query)findDepositHist.setArgs(new Object[]{depositKey}));){
                        for (Object e : cursor1) {
                        }
                    }
                    String depositHistKey = depositKey + "&histId=" + System.nanoTime();
                    BinaryObject depositHistRow = ScanQueryBroadcastClosure.this.node.binary().builder(IgniteCacheQueriesLoadTest1.OPERATION).setField(IgniteCacheQueriesLoadTest1.ID, (Object)depositHistKey).setField(IgniteCacheQueriesLoadTest1.DEPOSIT_ID, (Object)depositKey).setField(IgniteCacheQueriesLoadTest1.BUSINESS_DAY, (Object)new Date()).setField(IgniteCacheQueriesLoadTest1.BALANCE, (Object)newBalance).build();
                    histCache.put((Object)depositHistKey, (Object)depositHistRow);
                    depositCache.put((Object)depositKey, (Object)deposit);
                    return null;
                }
            }));
        }

        private void checkDeposit(IgniteCache<String, BinaryObject> depositCache, String depositKey) {
            BigDecimal expBalance;
            IgniteCache histCache = this.node.cache(IgniteCacheQueriesLoadTest1.DEPOSIT_HISTORY_CACHE).withKeepBinary();
            BinaryObject deposit = (BinaryObject)depositCache.get((Object)depositKey);
            BigDecimal startBalance = (BigDecimal)deposit.field(IgniteCacheQueriesLoadTest1.BALANCE_ON_DAY_OPEN);
            BigDecimal balance = (BigDecimal)deposit.field(IgniteCacheQueriesLoadTest1.BALANCE);
            BigDecimal rate = (BigDecimal)deposit.field(IgniteCacheQueriesLoadTest1.MARGIN_RATE);
            SqlFieldsQuery findDepositHist = new SqlFieldsQuery(IgniteCacheQueriesLoadTest1.DEPOSIT_OPERATION_COUNT_SQL);
            try (QueryCursor cursor1 = histCache.query((Query)findDepositHist.setArgs(new Object[]{depositKey}));){
                Long cnt = (Long)((ArrayList)cursor1.iterator().next()).get(0);
                expBalance = startBalance.multiply(rate.add(BigDecimal.ONE).pow(cnt.intValue()));
            }
            expBalance = expBalance.setScale(2, 1);
            balance = balance.setScale(2, 1);
            if (this.checkBalance && !expBalance.equals(balance)) {
                this.node.log().error("Deposit " + depositKey + " has incorrect balance " + balance + " when expected " + expBalance, null);
                throw new IgniteException("Deposit " + depositKey + " has incorrect balance " + balance + " when expected " + expBalance);
            }
        }
    }
}

