/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collection;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.CacheException;
import junit.framework.TestCase;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.util.GridRandom;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class IgniteCacheOffheapEvictQueryTest
extends GridCommonAbstractTest {
    private static TcpDiscoveryIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        disco.setIpFinder(ipFinder);
        cfg.setDiscoverySpi((DiscoverySpi)disco);
        CacheConfiguration cacheCfg = IgniteCacheOffheapEvictQueryTest.defaultCacheConfiguration();
        cacheCfg.setCacheMode(CacheMode.PARTITIONED);
        cacheCfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        cacheCfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cacheCfg.setBackups(0);
        cacheCfg.setEvictionPolicy(null);
        cacheCfg.setNearConfiguration(null);
        cacheCfg.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cacheCfg});
        return cfg;
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    public void testEvictAndRemove() throws Exception {
        int KEYS_CNT = 3000;
        int THREADS_CNT = 250;
        final IgniteCache c = this.startGrid().cache("default");
        for (int i = 0; i < 3000; ++i) {
            c.put((Object)i, (Object)i);
            if ((i & 1) != 0) continue;
            c.localEvict((Collection)F.asList((Object)i));
        }
        X.println((String)"___ Cache loaded...", (Object[])new Object[0]);
        final CyclicBarrier b = new CyclicBarrier(250, new Runnable(){

            @Override
            public void run() {
                X.println((String)"___ go!", (Object[])new Object[0]);
            }
        });
        final AtomicInteger keys = new AtomicInteger(3000);
        IgniteInternalFuture fut = this.multithreadedAsync(new Runnable(){

            @Override
            public void run() {
                GridRandom rnd = new GridRandom();
                try {
                    b.await();
                }
                catch (InterruptedException e) {
                    throw new IgniteInterruptedException(e);
                }
                catch (BrokenBarrierException e) {
                    throw new IllegalStateException(e);
                }
                while (keys.get() > 0) {
                    int k = rnd.nextInt(3000);
                    try {
                        switch (rnd.nextInt(4)) {
                            case 0: {
                                c.localEvict((Collection)F.asList((Object)k));
                                break;
                            }
                            case 1: {
                                c.get((Object)k);
                                break;
                            }
                            case 2: {
                                if (!c.remove((Object)k)) break;
                                keys.decrementAndGet();
                                break;
                            }
                            case 3: {
                                c.query((Query)new SqlFieldsQuery("select _val from Integer where _key between ? and ?").setArgs(new Object[]{k, k + 20}).setLocal(true)).getAll();
                            }
                        }
                    }
                    catch (CacheException e) {
                        String msgStart = "Failed to get value for key:";
                        for (Throwable th = e; th != null; th = th.getCause()) {
                            String msg = th.getMessage();
                            if (msg == null || !msg.startsWith(msgStart)) continue;
                            int dot = msg.indexOf(46, msgStart.length());
                            TestCase.assertTrue((dot != -1 ? 1 : 0) != 0);
                            Integer failedKey = Integer.parseInt(msg.substring(msgStart.length(), dot).trim());
                            X.println((String)("___ failed key: " + failedKey), (Object[])new Object[0]);
                            break;
                        }
                        LT.warn((IgniteLogger)IgniteCacheOffheapEvictQueryTest.this.log, (String)e.getMessage());
                        return;
                    }
                }
            }
        }, 250);
        try {
            fut.get(60000L);
            if (c.size(new CachePeekMode[]{CachePeekMode.ALL}) != 0) {
                IgniteCacheOffheapEvictQueryTest.fail((String)"Not all keys removed.");
            }
            X.println((String)"___ all keys removed", (Object[])new Object[0]);
        }
        catch (IgniteFutureTimeoutCheckedException ignored) {
            X.println((String)"___ timeout", (Object[])new Object[0]);
            X.println((String)("___ keys: " + keys.get()), (Object[])new Object[0]);
            keys.set(0);
            fut.get();
        }
    }
}

