/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityFunctionContext;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheAbstractSelfTest;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLocalPartition;
import org.apache.ignite.internal.util.lang.GridAbsPredicate;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.failover.FailoverSpi;
import org.apache.ignite.spi.failover.always.AlwaysFailoverSpi;
import org.apache.ignite.testframework.GridTestUtils;

public class IgniteCacheLockPartitionOnAffinityRunAbstractTest
extends GridCacheAbstractSelfTest {
    protected static final int AFFINITY_THREADS_CNT = 10;
    protected static final int PERS_AT_ORG_CNT = 10000;
    protected static final String OTHER_CACHE_NAME = "otherCache";
    protected static final int GRID_CNT = 4;
    protected static final int RESTARTED_NODE_CNT = 2;
    protected static final int ORGS_COUNT_PER_NODE = 2;
    protected static final long TEST_DURATION = 300000L;
    protected static final long TEST_TIMEOUT = 420000L;
    protected static final long RESTART_TIMEOUT = 3000L;
    protected static final int MAX_FAILOVER_ATTEMPTS = 100;
    protected static List<Integer> orgIds;
    protected static long endTime;
    protected static IgniteInternalFuture<?> nodeRestartFut;
    protected final AtomicBoolean stopRestartThread = new AtomicBoolean();

    protected long getTestTimeout() {
        return 420000L;
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration((CacheConfiguration[])F.concat((Object[])cfg.getCacheConfiguration(), (Object[])new CacheConfiguration[]{this.cacheConfiguration(igniteInstanceName).setName("*")}));
        ((TcpCommunicationSpi)cfg.getCommunicationSpi()).setSharedMemoryPort(-1);
        cfg.setMarshaller((Marshaller)new BinaryMarshaller());
        AlwaysFailoverSpi failSpi = new AlwaysFailoverSpi();
        failSpi.setMaximumFailoverAttempts(100);
        cfg.setFailoverSpi(new FailoverSpi[]{failSpi});
        return cfg;
    }

    protected Class<?>[] indexedTypes() {
        return new Class[]{Integer.class, Organization.class, Person.Key.class, Person.class, Integer.class, Integer.class};
    }

    protected CacheAtomicityMode atomicityMode() {
        return CacheAtomicityMode.ATOMIC;
    }

    protected int gridCount() {
        return 4;
    }

    protected CacheMode cacheMode() {
        return CacheMode.PARTITIONED;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.info("Fill caches begin...");
        this.fillCaches();
        this.info("Caches are filled");
    }

    protected void afterTestsStopped() throws Exception {
        this.grid(0).destroyCache(Organization.class.getSimpleName());
        this.grid(0).destroyCache(Person.class.getSimpleName());
        this.grid(0).destroyCache(OTHER_CACHE_NAME);
        super.afterTestsStopped();
    }

    protected void afterTest() throws Exception {
        this.stopRestartThread.set(true);
        if (nodeRestartFut != null) {
            nodeRestartFut.get();
            nodeRestartFut = null;
        }
        Thread.sleep(3000L);
        this.awaitPartitionMapExchange();
        super.afterTest();
    }

    protected void beforeTest() throws Exception {
        endTime = System.currentTimeMillis() + 300000L;
        super.beforeTest();
    }

    private void createCacheWithAffinity(String cacheName) throws Exception {
        CacheConfiguration ccfg = this.cacheConfiguration(this.grid(0).name());
        ccfg.setName(cacheName);
        ccfg.setAffinity((AffinityFunction)new DummyAffinity());
        this.grid(0).createCache(ccfg);
    }

    private void fillCaches() throws Exception {
        this.grid(0).createCache(Organization.class.getSimpleName());
        this.grid(0).createCache(Person.class.getSimpleName());
        this.createCacheWithAffinity(OTHER_CACHE_NAME);
        this.awaitPartitionMapExchange();
        orgIds = new ArrayList<Integer>(4);
        for (int i = 2; i < 4; ++i) {
            orgIds.addAll(this.primaryKeys(this.grid(i).cache(Organization.class.getSimpleName()), 2));
        }
        try (IgniteDataStreamer orgStreamer = this.grid(0).dataStreamer(Organization.class.getSimpleName());
             IgniteDataStreamer persStreamer = this.grid(0).dataStreamer(Person.class.getSimpleName());){
            int persId = 0;
            for (int orgId : orgIds) {
                Organization org = new Organization(orgId);
                orgStreamer.addData((Object)orgId, (Object)org);
                int persCnt = 0;
                while (persCnt < 10000) {
                    Person pers = new Person(persId, orgId);
                    persStreamer.addData((Object)pers.createKey(), (Object)pers);
                    ++persCnt;
                    ++persId;
                }
            }
        }
        this.awaitPartitionMapExchange();
    }

    protected void beginNodesRestart() {
        this.stopRestartThread.set(false);
        nodeRestartFut = GridTestUtils.runAsync((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int restartGrid = 2;
                while (!IgniteCacheLockPartitionOnAffinityRunAbstractTest.this.stopRestartThread.get() && System.currentTimeMillis() < endTime) {
                    IgniteCacheLockPartitionOnAffinityRunAbstractTest.this.log.info("Restart grid: " + restartGrid);
                    IgniteCacheLockPartitionOnAffinityRunAbstractTest.this.stopGrid(restartGrid);
                    Thread.sleep(500L);
                    IgniteCacheLockPartitionOnAffinityRunAbstractTest.this.startGrid(restartGrid);
                    GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

                        public boolean apply() {
                            return !IgniteCacheLockPartitionOnAffinityRunAbstractTest.this.stopRestartThread.get();
                        }
                    }, (long)3000L);
                    if (++restartGrid >= 4) {
                        restartGrid = 2;
                    }
                    IgniteCacheLockPartitionOnAffinityRunAbstractTest.this.awaitPartitionMapExchange();
                }
                return null;
            }
        }, (String)"restart-node");
    }

    protected static void checkPartitionsReservations(IgniteEx ignite, int orgId, final int expReservations) throws Exception {
        int part = ignite.affinity(Organization.class.getSimpleName()).partition((Object)orgId);
        final GridDhtLocalPartition pPers = ignite.context().cache().internalCache(Person.class.getSimpleName()).context().topology().localPartition(part, AffinityTopologyVersion.NONE, false);
        IgniteCacheLockPartitionOnAffinityRunAbstractTest.assertNotNull((Object)pPers);
        final GridDhtLocalPartition pOrgs = ignite.context().cache().internalCache(Organization.class.getSimpleName()).context().topology().localPartition(part, AffinityTopologyVersion.NONE, false);
        IgniteCacheLockPartitionOnAffinityRunAbstractTest.assertNotNull((Object)pOrgs);
        GridTestUtils.waitForCondition((GridAbsPredicate)new GridAbsPredicate(){

            public boolean apply() {
                return expReservations == pOrgs.reservations() && expReservations == pPers.reservations();
            }
        }, (long)1000L);
        IgniteCacheLockPartitionOnAffinityRunAbstractTest.assertEquals((String)"Unexpected reservations count", (int)expReservations, (int)pOrgs.reservations());
        IgniteCacheLockPartitionOnAffinityRunAbstractTest.assertEquals((String)"Unexpected reservations count", (int)expReservations, (int)pPers.reservations());
    }

    public static class Person
    implements Serializable {
        @QuerySqlField
        private final int id;
        @QuerySqlField(index=true)
        private final int orgId;

        Person(int id, int orgId) {
            this.id = id;
            this.orgId = orgId;
        }

        int getId() {
            return this.id;
        }

        int getOrgId() {
            return this.orgId;
        }

        public Key createKey() {
            return new Key(this.id, this.orgId);
        }

        public String toString() {
            return S.toString(Person.class, (Object)this);
        }

        static class Key
        implements Serializable {
            private final int id;
            @AffinityKeyMapped
            protected final int orgId;

            private Key(int id, int orgId) {
                this.id = id;
                this.orgId = orgId;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Key key = (Key)o;
                return this.id == key.id && this.orgId == key.orgId;
            }

            public int hashCode() {
                int res = this.id;
                res = 31 * res + this.orgId;
                return res;
            }
        }
    }

    public static class Organization
    implements Serializable {
        @QuerySqlField(index=true)
        private final int id;

        Organization(int id) {
            this.id = id;
        }

        int getId() {
            return this.id;
        }

        public String toString() {
            return S.toString(Organization.class, (Object)this);
        }
    }

    private static class DummyAffinity
    extends RendezvousAffinityFunction {
        public List<List<ClusterNode>> assignPartitions(AffinityFunctionContext affCtx) {
            List nodes = affCtx.currentTopologySnapshot();
            ArrayList<List<ClusterNode>> assign = new ArrayList<List<ClusterNode>>(this.partitions());
            for (int i = 0; i < this.partitions(); ++i) {
                assign.add(Collections.singletonList(nodes.get(0)));
            }
            return assign;
        }
    }
}

