/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Arrays;
import java.util.LinkedHashMap;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.cache.affinity.AffinityKey;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.TextQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public class IgniteCacheFullTextQueryNodeJoiningSelfTest
extends GridCommonAbstractTest {
    private static final TcpDiscoveryIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);
    private static final int GRID_CNT = 3;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cache = new CacheConfiguration("default");
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setAtomicityMode(this.atomicityMode());
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setBackups(1);
        QueryEntity qryEntity = new QueryEntity();
        qryEntity.setKeyType(AffinityKey.class.getName());
        qryEntity.setValueType(IndexedEntity.class.getName());
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        fields.put("val", String.class.getName());
        qryEntity.setFields(fields);
        qryEntity.setIndexes(Arrays.asList(new QueryIndex("val", QueryIndexType.FULLTEXT)));
        cache.setQueryEntities(Arrays.asList(qryEntity));
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        disco.setIpFinder(IP_FINDER);
        TcpCommunicationSpi commSpi = new TcpCommunicationSpi();
        commSpi.setSharedMemoryPort(-1);
        cfg.setCommunicationSpi((CommunicationSpi)commSpi);
        cfg.setDiscoverySpi((DiscoverySpi)disco);
        return cfg;
    }

    protected CacheAtomicityMode atomicityMode() {
        return CacheAtomicityMode.TRANSACTIONAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFullTextQueryNodeJoin() throws Exception {
        for (int r = 0; r < 5; ++r) {
            this.startGrids(3);
            try {
                for (int i = 0; i < 1000; ++i) {
                    IndexedEntity entity = new IndexedEntity("indexed " + i);
                    this.grid(0).cache("default").put((Object)new AffinityKey((Object)i, (Object)i), (Object)entity);
                }
                IgniteEx started = this.startGrid(3);
                for (int i = 0; i < 100; ++i) {
                    QueryCursor res = started.cache("default").query((Query)new TextQuery(IndexedEntity.class, "indexed"));
                    IgniteCacheFullTextQueryNodeJoiningSelfTest.assertEquals((int)1000, (int)res.getAll().size());
                }
                continue;
            }
            finally {
                this.stopAllGrids();
            }
        }
    }

    private static class IndexedEntity {
        private String val;

        private IndexedEntity(String val) {
            this.val = val;
        }
    }
}

